/*
# proc: compute_slope - computes the slope of the line between two points.
# proc:
# proc: compute_y - given the x coordinate, slope, and another point on the
# proc:             line, computes the corresponding y coordinate.
*/

/************************************************************/
/*         File Name: LINE.C                                */
/*         Package:   Fundamental Line Utilities            */
/*         Author:    Michael D. Garris                     */
/*         Date:      03/05/91                              */
/*                                                          */
/*         Contents:  compute_slope()                       */
/*                    compute_y()                           */
/************************************************************/
#include <math.h>
#include <values.h>

/************************************************************/
/*         Routine:   compute_slope()                       */
/*                                                          */
/* Compute_slope(), given two coordinate points, returns    */
/* the slope of a line connecting the two points.           */
/* Note: This routine returns the system's MAXFLOAT for     */
/* points vertically aligned.                               */
/************************************************************/
/* x1, y1 - first coordinate point.                         */
/* x2, y2 - second coordinate point.                        */
/************************************************************/
float compute_slope(x1, y1, x2, y2)
float x1, y1, x2, y2;
{
   float f_slope, dx, dy;

   dx = (x2 - x1);
   if(dx == 0.0)
      return(MAXFLOAT);
   dy = (y2 - y1);
   f_slope = dy/dx;
   return(f_slope);
}

/************************************************************/
float compute_y(x, m, x1, y1)
float x, m, x1, y1;
{
   float y;

   y = (m * x) - (m * x1) + y1;
   return(y);
}
