C# proc: pxkth - finds the kth largest of n elements in a list without sorting.
C# proc:      

C Find the |k|${}^{th}$-largest of |N| elements without sorting.
C Algorithm is procedure |find| from p. 84 of Wirth,
C {\em Algorithms + Data Structures = Programs}. In average case,
C takes about $O(N)$ work; worst case takes $O(N^2)$ work.

C Re-arranges data in |x| array. Ends up with |x(k)| the |k|${}^{th}$-
C largest, |x(i) <= x(k)| for |i < k|, and |x(j) >= x(k)| for |j > k|.

C FTANGLE v1.22, tangled with SunOS/UNIX on "Saturday, September 21, 1991 at 12:
C 39." 
C COMMAND LINE: "ftangle -mSUN -v -# pxkth.web"
C RUN TIME: "Wednesday, May 18, 1994 at 9:10."
C WEB FILE:    "pxkth.web"
C CHANGE FILE: ""
      subroutine pxkth(k,x,npts,result)
        
        real x(*)
        
        integer left,right,i,j
        real value,temp
        
        left=1
        right=npts
        
        CONTINUE
C ---  "while(left<right)" ---
90000   IF(left.LT.right)THEN
          value=x(k)
          i=left
          j=right
          CONTINUE
C ---  "repeat" ---
90002     CONTINUE
            CONTINUE
C ---  "while(x(i)<value)" ---
90005       IF(x(i).LT.value)THEN
              i=i+1
              GOTO 90005
            ENDIF
            CONTINUE
C ---  "while(value<x(j))" ---
90007       IF(value.LT.x(j))THEN
              j=j-1
              GOTO 90007
            ENDIF
            CONTINUE
C ---  "if" ---
            IF(i.LE.j)THEN
              temp=x(i)
              x(i)=x(j)
              x(j)=temp
              i=i+1
              j=j-1
            ENDIF
C ---  "until(i>j)" ---
          IF(.NOT.(i.GT.j))GOTO 90002
          
          CONTINUE
C ---  "if" ---
          IF(j.LT.k)THEN
            left=i
          ENDIF
          CONTINUE
C ---  "if" ---
          IF(k.LT.i)THEN
            right=j
          ENDIF
          GOTO 90000
        ENDIF
        result=x(k)
      END
      
      
