/*
# proc: featsclassmedian - make the by-class median vectors of
# proc:                    a feature set.
*/ 

#include <stdio.h>
#include <malloc.h>
#include <math.h>

featsclassmedian(feats, class, nPats, nInps, nOuts, med)
float *feats, **med;
int   *class, nPats, nInps, nOuts;
{
int   i, j, k, n, numi, *cptr;
float *vptr, *fptr, *mptr, *v, x;


   if ((v = (float *)malloc(nPats * sizeof(float))) == NULL)
      syserr("featsclassmedian", "malloc", "space for nPats vector");
   if ((mptr = *med = (float *)malloc(nInps * nOuts * sizeof(float))) == NULL)
      syserr("featsclassmedian", "malloc", "space for median result");

   for ( k = 0 ; k < nOuts ; k++ )
   {
      for ( i = 0 ; i < nInps ; i++ )
      {
         for ( j = 0, numi = 0, cptr = class, vptr = v,
                 fptr = feats + i ; j < nPats ; j++, fptr += nInps )
            if (*cptr++ == k)
               *vptr++ = *fptr, numi++;

         if (numi > 0)
         {
            n = (numi+1)/2;
            pxkth_(&n, v, &numi, &x);
         }
         else
            x = 0;

         *mptr++ = x;
      }
   }

   free(v);
}


