#!/bin/csh

if($#argv < 3) then
   echo Usage\: $0 \<pgrm\|proc\> \<dir\> \<extensions\>
   exit
endif

set key = $1
set dpath = $2
shift argv
shift argv
set ext = ($argv)
set pd = `pwd`
cd $dpath

switch ($key)
case pgrm:
     grep "# ${key}:" /dev/null */*.${ext[1]} | sed 's/^[^:]*://' | awk -F\: '{print $2}' | tee catalog.txt
     shift ext
     foreach e ($ext)
        grep "# ${key}:" /dev/null */*.${e} | sed 's/^[^:]*://' | awk -F\: '{print $2}' | tee -a catalog.txt
     end
     breaksw
case proc:
     grep "# ${key}:" /dev/null *.${ext[1]} | sed 's/^[^:]*://' | awk -F\: '{print $2}' | tee catalog.txt
     shift ext
     foreach e ($ext)
        grep "# ${key}:" /dev/null *.${e} | sed 's/^[^:]*://' | awk -F\: '{print $2}' | tee -a catalog.txt
     end
     breaksw
default:
     echo Illegal option\: $key
     breaksw
endsw
cd $pd
