      SUBROUTINE WRTKEY(KEYWRD)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "SIZES"
      CHARACTER*80 KEYWRD, ALLKEY
***********************************************************************
*
*  WRTKEY CHECKS ALL KEY-WORDS AND PRINTS THOSE IT RECOGNIZES.  IF IT
*  FINDS A WORD IT DOES NOT RECOGNIZE THE PROGRAM WILL BE STOPPED.
*
***********************************************************************
      LOGICAL UHF, TRIP, BIRAD, EXCI, CI, WORD
      LOGICAL AM1, MNDO, MINDO3, PM3
      CHARACTER SPACE*1, DOT*1, ZERO*1, NINE*1, CH*1, CHRONO*7
      DATA SPACE,DOT,ZERO,NINE /' ','.','0','9'/
      DATA AM1, MNDO, MINDO3, PM3 /4*.FALSE./
      ALLKEY=KEYWRD
      IF(WORD(ALLKEY,'AUTHOR')) THEN
         WRITE(6,'(10X,'' MOPAC - A GENERAL MOLECULAR ORBITAL PACKAGE'',
     1/         ,10X,''   ORIGINAL VERSION WRITTEN IN 1983'')')
         WRITE(6,'(10X,''     BY JAMES J. P. STEWART AT THE'',/
     1         ,10X,''     UNIVERSITY OF TEXAS AT AUSTIN'',/
     2         ,10X,''          AUSTIN, TEXAS, 78712'')')
      ENDIF
      IF (WORD(ALLKEY,'VECT') ) WRITE(6,70)
      IF (WORD(ALLKEY,' EXTE') ) THEN
         I=INDEX(KEYWRD,' EXTE')
         J=INDEX(KEYWRD(I:),'=')+I
         I=INDEX(KEYWRD(J:),' ')+J-1
         WRITE(6,80)KEYWRD(J:I)
      ENDIF
      MAXGEO=0
      IF (WORD(ALLKEY,' DENS') ) WRITE(6,90)
      IF (WORD(ALLKEY,'SPIN') ) WRITE(6,100)
      IF (WORD(ALLKEY,' DEPVAR') )
     1WRITE(6,110)READA(KEYWRD,INDEX(KEYWRD,'DEPVAR'))
      IF (WORD(ALLKEY,' DEP ') )WRITE(6,120)
      IF (WORD(ALLKEY,'VELO') )WRITE(6,130)
      IF (WORD(ALLKEY,'TIMES') )WRITE(6,140)
      IF (WORD(ALLKEY,'PARASOK') ) WRITE(6,150)
      IF (WORD(ALLKEY,'FLEPO') ) WRITE(6,160)
      IF (WORD(ALLKEY,'BONDS') ) WRITE(6,170)
      IF (WORD(ALLKEY,'GEO-OK') ) WRITE(6,180)
      IF (WORD(ALLKEY,'FOCK') ) WRITE(6,190)
      IF (WORD(ALLKEY,'LARGE') ) WRITE(6,200)
      IF (WORD(ALLKEY,' S1978') ) WRITE(6,210)
      IF (WORD(ALLKEY,' SI1978') ) WRITE(6,220)
      IF (WORD(ALLKEY,' GRAP') ) WRITE(6,230)
      IF (WORD(ALLKEY,'1ELEC') ) WRITE(6,240)
      IF (WORD(ALLKEY,' NOMM') ) WRITE(6,260)
      IF (WORD(ALLKEY,' MMOK') ) WRITE(6,265)
      IF (WORD(ALLKEY,'INTERP') ) WRITE(6,270)
      IF (WORD(ALLKEY,' ESR') ) WRITE(6,250)
      IF (WORD(ALLKEY,'DFP') ) WRITE(6,280)
      IF (WORD(ALLKEY,'ANALYT') ) WRITE(6,290)
      IF (WORD(ALLKEY,' MECI') ) WRITE(6,300)
      IF (WORD(ALLKEY,'LOCAL') ) WRITE(6,340)
      IF (WORD(ALLKEY,'MULLIK') ) WRITE(6,350)
      IF (WORD(ALLKEY,' XYZ') ) WRITE(6,360)
      IF (WORD(ALLKEY,' PI') ) WRITE(6,370)
      IF (WORD(ALLKEY,'ECHO') ) WRITE(6,380)
      IF (WORD(ALLKEY, 'SING') ) WRITE(6,540)
      IF (WORD(ALLKEY, 'DOUB') ) WRITE(6,550)
      IF (WORD(ALLKEY, 'QUAR') ) WRITE(6,570)
      IF (WORD(ALLKEY, 'QUIN') ) WRITE(6,580)
      IF (WORD(ALLKEY, 'SEXT') ) WRITE(6,590)
      IF (WORD(ALLKEY,'H-PRIO') ) WRITE(6,390)
      IF (WORD(ALLKEY,'X-PRIO') ) WRITE(6,400)
      IF (WORD(ALLKEY,'T-PRIO') ) WRITE(6,410)
      IF (WORD(ALLKEY,'POWSQ') ) WRITE(6,420)
      IF (WORD(ALLKEY,'POLAR') ) WRITE(6,430)
      IF (WORD(ALLKEY,'DEBUG ') ) WRITE(6,440)
      IF (WORD(ALLKEY,'RESTART') ) WRITE(6,450)
      IF (WORD(ALLKEY,'IRC=') ) THEN
         MAXGEO=1
         WRITE(6,460)NINT(READA(KEYWRD,INDEX(KEYWRD,'IRC=')))
      ELSEIF (WORD(ALLKEY,'IRC') ) THEN
         MAXGEO=1
         WRITE(6,470)
      ENDIF
      IF (WORD(ALLKEY,'CHARGE') )
     1 WRITE(6,480)NINT(READA(KEYWRD,INDEX(KEYWRD,'CHARGE')))
      IF (WORD(ALLKEY,'GRAD') ) WRITE(6,490)
      UHF=(WORD(ALLKEY,'UHF') )
      IF(UHF)WRITE(6,500)
      BIRAD=(WORD(ALLKEY,'BIRAD') )
      IF(BIRAD)WRITE(6,520)
      EXCI=(WORD(ALLKEY,'EXCITED') )
      IF(EXCI) WRITE(6,530)
      TRIP=(WORD(ALLKEY,'TRIPLET') )
      IF(TRIP)WRITE(6,560)
      IF (WORD(ALLKEY,'SYMM') ) WRITE(6,600)
      IF(WORD(ALLKEY,'OPEN('))THEN
         I=INDEX(KEYWRD,'OPEN(')
         IELEC=READA(KEYWRD,I)
         ILEVEL=READA(KEYWRD,I+7)
         WRITE(6,620)IELEC,ILEVEL
      ENDIF
      IF(WORD(ALLKEY,'MICROS'))
     1WRITE(6,610)INT(READA(KEYWRD,INDEX(KEYWRD,'MICROS')))
      IF(WORD(ALLKEY,'DRC='))THEN
         MAXGEO=1
         WRITE(6,320)READA(KEYWRD,INDEX(KEYWRD,'DRC='))
      ELSEIF (WORD(ALLKEY,' DRC') ) THEN
         MAXGEO=1
         WRITE(6,310)
      ENDIF
      IF(WORD(ALLKEY,'KINE'))
     1WRITE(6,330)READA(KEYWRD,INDEX(KEYWRD,'KINE'))
      CHRONO='SECONDS'
      IF(WORD(ALLKEY,' T=')) THEN
         I=INDEX(KEYWRD,' T=')
         TIME=READA(KEYWRD,I)
         DO 10 J=I+3,80
            IF( KEYWRD(J+1:J+1).EQ.' ') THEN
               CH=KEYWRD(J:J)
               IF( CH .EQ. 'M') CHRONO='MINUTES'
               IF( CH .EQ. 'H') CHRONO='HOURS'
               IF( CH .EQ. 'D') CHRONO='DAYS'
               GOTO 20
            ENDIF
   10    CONTINUE
   20    CONTINUE
         IF(TIME.LT.99999.9D0)THEN
            WRITE(6,630)TIME,CHRONO
         ELSE
            WRITE(6,640)TIME,CHRONO
         ENDIF
      ELSE
         WRITE(6,630)MAXTIM*1.D0,CHRONO
      ENDIF
               CHRONO='SECONDS'
      IF(WORD(ALLKEY,' DUMP')) THEN
         TDUMP=READA(KEYWRD,INDEX(KEYWRD,' DUMP'))
         DO 30 J=I+6,80
            IF( KEYWRD(J+1:J+1).EQ.' ') THEN
               CH=KEYWRD(J:J)
               IF( CH .EQ. 'M') CHRONO='MINUTES'
               IF( CH .EQ. 'H') CHRONO='HOURS'
               IF( CH .EQ. 'D') CHRONO='DAYS'
               GOTO 40
            ENDIF
   30    CONTINUE
   40    CONTINUE
         IF(TDUMP.LT.99999.9D0)THEN
            WRITE(6,650)TDUMP,CHRONO
         ELSE
            WRITE(6,660)TDUMP,CHRONO
         ENDIF
      ELSE
         WRITE(6,650)MAXDMP*1.D0,CHRONO
      ENDIF
      IF (WORD(ALLKEY,'1SCF') ) THEN
         WRITE(6,670)
         IF(INDEX(KEYWRD,'RESTART').EQ.0)MAXGEO=MAXGEO+1
      ENDIF
      IF(INDEX(ALLKEY,'C.I.').NE.0)
     1WRITE(6,680)INT(READA(KEYWRD,INDEX(KEYWRD,'C.I.')+5))
      CI=WORD(ALLKEY,'C.I.')
      IF (WORD(ALLKEY,'DFORCE') ) THEN
         WRITE(6,690)
         MAXGEO=MAXGEO+1
      ELSEIF (WORD(ALLKEY,'FORCE') ) THEN
         WRITE(6,700)
         MAXGEO=MAXGEO+1
      ENDIF
      METHOD=0
      IF (WORD(ALLKEY,'MINDO') ) THEN
         WRITE(6,710)
         MINDO3=.TRUE.
         METHOD=1
      ENDIF
      IF (WORD(ALLKEY,'AM1') ) THEN
         WRITE(6,720)
         AM1=.TRUE.
         METHOD=METHOD+1
      ENDIF
      IF (WORD(ALLKEY,'PM3') ) THEN
         WRITE(6,730)
         PM3=.TRUE.
         METHOD=METHOD+1
      ENDIF
      IF (WORD(ALLKEY,'MNDO') ) THEN
         MNDO=.TRUE.
         METHOD=METHOD+1
      ENDIF
      IF (WORD(ALLKEY,'PREC') ) WRITE(6,740)
      IF (WORD(ALLKEY,'NOINTER') ) WRITE(6,750)
      IF (WORD(ALLKEY,'ISOTOPE') ) WRITE(6,760)
      IF (WORD(ALLKEY,'DENOUT') ) WRITE(6,770)
      IF (WORD(ALLKEY,'SHIFT') ) WRITE(6,780)
     1 READA(KEYWRD,INDEX(KEYWRD,'SHIFT'))
      IF (WORD(ALLKEY,'OLDENS') ) WRITE(6,790)
      IF (WORD(ALLKEY,'SCFCRT') ) WRITE(6,800)
     1 READA(KEYWRD,INDEX(KEYWRD,'SCFCRT'))
      IF (WORD(ALLKEY,'ENPART') ) WRITE(6,810)
      IF (WORD(ALLKEY,'NOXYZ') ) WRITE(6,820)
      IF (WORD(ALLKEY,'SIGMA') ) THEN
         WRITE(6,830)
         MAXGEO=MAXGEO+1
      ENDIF
      IF (WORD(ALLKEY,'NLLSQ') ) THEN
         WRITE(6,840)
         MAXGEO=MAXGEO+1
      ENDIF
      IF (WORD(ALLKEY,'ROOT') ) WRITE(6,850)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,'ROOT')))
      IF (WORD(ALLKEY,'TRANS=') ) THEN
         WRITE(6,870)NINT(READA(KEYWRD,INDEX(KEYWRD,'TRANS=')))
      ELSEIF (WORD(ALLKEY,'TRANS') ) THEN
         WRITE(6,860)
      ENDIF
      IF (WORD(ALLKEY,'SADDLE') ) THEN
         WRITE(6,880)
         MAXGEO=MAXGEO+1
      ENDIF
      IF (WORD(ALLKEY,' LET') ) WRITE(6,890)
      IF (WORD(ALLKEY,'COMPFG') ) WRITE(6,900)
      IF (WORD(ALLKEY,'DERIV') ) WRITE(6,910)
      IF (WORD(ALLKEY,'FULSCF') ) WRITE(6,920)
      IF (WORD(ALLKEY,'DCART') ) WRITE(6,930)
      IF (WORD(ALLKEY,'GNORM') ) WRITE(6,940)
     1 READA(KEYWRD,INDEX(KEYWRD,'GNORM'))
      IF (WORD(ALLKEY,'FMAT') ) WRITE(6,950)
      IF (WORD(ALLKEY,'HCORE') ) WRITE(6,960)
      IF (WORD(ALLKEY,'ITER') ) WRITE(6,970)
      IF (WORD(ALLKEY,'PULAY') ) WRITE(6,980)
      IF (WORD(ALLKEY,'LINMIN') ) WRITE(6,990)
      IF (WORD(ALLKEY,'LOCMIN') ) THEN
         WRITE(6,1000)
         I=INDEX(KEYWRD,'LOCMIN')
         KEYWRD(I:I+5)='LINMIN'
      ENDIF
      IF (WORD(ALLKEY,' STEP1')  )WRITE(6,1010)
     1 READA(KEYWRD,INDEX(KEYWRD,'STEP1')+6)
      IF (WORD(ALLKEY,' STEP2')  )WRITE(6,1020)
     1 READA(KEYWRD,INDEX(KEYWRD,'STEP2')+6)
      IF (WORD(ALLKEY,'BAR') ) WRITE(6,1030)
     1 READA(KEYWRD,INDEX(KEYWRD,'BAR'))
      IF (WORD(ALLKEY,'DEBUGPULAY') ) WRITE(6,1040)
      IF (WORD(ALLKEY,'CAMP') ) WRITE(6,1050)
      IF (WORD(ALLKEY,'KING') ) WRITE(6,1050)
      IF (WORD(ALLKEY,'EIGS') ) WRITE(6,1060)
      IF (WORD(ALLKEY,'MOLDAT') ) WRITE(6,1070)
      IF (WORD(ALLKEY,'HYPERF') ) WRITE(6,1080)
      IF (WORD(ALLKEY,'OPCI') ) WRITE(6,1090)
      IF (WORD(ALLKEY,' PL') ) WRITE(6,1100)
      IF (WORD(ALLKEY,'SEARCH') ) THEN
         WRITE(6,1110)
         I=INDEX(KEYWRD,'SEARCH')
         KEYWRD(I:I+5)='LINMIN'
      ENDIF
      IF (WORD(ALLKEY,'CYCLES') ) WRITE(6,1130)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,'CYCLES')))
      IF (WORD(ALLKEY,'FILL') ) WRITE(6,1120)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,'FILL')))
      IF (WORD(ALLKEY,'ITRY') ) WRITE(6,1160)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,'ITRY')))
      IF (WORD(ALLKEY,'0SCF') ) WRITE(6,1180)
C
C     KEYWORDS ADDED FOR ESP MOPAC
C
      IF (WORD(ALLKEY,'ESP ') ) WRITE(6,1190)
      IF (WORD(ALLKEY,'NSURF') ) WRITE(6,1200)
      IF (WORD(ALLKEY,'SCALE') ) WRITE(6,1210)
      IF (WORD(ALLKEY,'DEN') ) WRITE(6,1220)
      IF (WORD(ALLKEY,'SCINCR') ) WRITE(6,1230)
      IF (WORD(ALLKEY,'SLOPE') ) WRITE(6,1240)
      IF (WORD(ALLKEY,'DIPOLE') ) WRITE(6,1250)
      IF (WORD(ALLKEY,'DIPX') ) WRITE(6,1260)
      IF (WORD(ALLKEY,'DIPY') ) WRITE(6,1270)
      IF (WORD(ALLKEY,'DIPZ') ) WRITE(6,1280)
      IF (WORD(ALLKEY,'CONNOLLY') ) WRITE(6,1290)
      IF (WORD(ALLKEY,'ESPRST') ) WRITE(6,1300)
      IF (WORD(ALLKEY,' POTWRT') ) WRITE(6,1310)
      IF (WORD(ALLKEY,'WILLIAMS') ) WRITE(6,1320)
      IF (WORD(ALLKEY,'SYMAVG') ) WRITE(6,1330)
      IF (WORD(ALLKEY,'STO3G') ) WRITE(6,1340)
      IF(UHF)THEN
         IF(BIRAD.OR.EXCI.OR.CI)THEN
            WRITE(6,'(//10X,
     1'' UHF USED WITH EITHER BIRAD, EXCITED OR C.I. '')')
            WRITE(6,1170)
            GOTO 60
         ENDIF
      ELSE
         IF(EXCI.AND. TRIP) THEN
            WRITE(6,'(//10X,'' EXCITED USED WITH TRIPLET'')')
            WRITE(6,1170)
            GOTO 60
         ENDIF
      ENDIF
      IF (INDEX(KEYWRD,'T-PRIO').NE.0.AND.
     1INDEX(KEYWRD,'DRC').EQ.0) THEN
         WRITE (6,'(//10X,''T-PRIO AND NO DRC'')')
         WRITE (6,1170)
         GOTO 60
      ENDIF
      IF ( METHOD .GT. 1) THEN
         WRITE(6,'(//10X,
     1'' ONLY ONE OF MINDO, MNDO, AM1 AND PM3 ALLOWED'')')
         WRITE (6,1170)
         GOTO 60
      ENDIF
      IF (WORD(ALLKEY,'THERMO') )THEN
         WRITE(6,1140)
         IF(WORD(ALLKEY,' ROT')) THEN
            WRITE(6,1150)NINT(READA(KEYWRD,INDEX(KEYWRD,' ROT')))
         ELSE
            WRITE(6,'
     1    (//10X,'' YOU MUST SUPPLY THE SYMMETRY NUMBER "ROT"'')')
            STOP
         ENDIF
      ENDIF
      IF(MAXGEO.GT.1)THEN
         WRITE(6,'(//10X,''MORE THAN ONE GEOMETRY OPTION HAS BEEN '',
     1''SPECIFIED'',/10X,
     2''CONFLICT MUST BE RESOLVED BEFORE JOB WILL RUN'')')
         STOP
      ENDIF
      IF(ALLKEY.NE.' ')THEN
C
C  AN UNRECOGNIZED KEY-WORD HAS BEEN USED. FIND IT AND THEN ABANDON THE
C  RUN
         J=0
         DO 50 I=1,79
            IF(ALLKEY(I:I).NE.' '.OR.ALLKEY(I:I+1).NE.'  ')THEN
               J=J+1
               KEYWRD(J:J)=ALLKEY(I:I)
            ENDIF
   50    CONTINUE
         IF(ALLKEY(80:80).NE.' ')THEN
            J=J+1
            KEYWRD(J:J)=ALLKEY(80:80)
         ENDIF
         J=MAX(1,J)
         WRITE(6,'(///10X,''UNRECOGNIZED KEY-WORDS: ('',A,'')'')')
     1KEYWRD(:J)
         WRITE(6,'(///10X,''CALCULATION STOPPED TO AVOID WASTING TIME.''
     1)')
         STOP
      ENDIF
      RETURN
   60 WRITE(6,'(//10X,'' CALCULATION ABANDONED, SORRY!'')')
      STOP
   70 FORMAT(' *  VECTORS  - FINAL EIGENVECTORS TO BE PRINTED')
   80 FORMAT(' *  EXTERNAL - USE ATOMIC PARAMETERS FROM THE FOLLOWING '
     1,'FILE',/15X,A)
   90 FORMAT(' *  DENSITY  - FINAL DENSITY MATRIX TO BE PRINTED')
  100 FORMAT(' *  SPIN     - FINAL UHF SPIN MATRIX TO BE PRINTED')
  110 FORMAT(' *  DEPVAR=N - SPECIFIED DISTANCE IS',F7.4,
     1' TIMES BOND LENGTH')
  120 FORMAT(' *  DEP      - OUTPUT FORTRAN CODE FOR BLOCK-DATA')
  130 FORMAT(' *  VELOCITY - INPUT STARTING VELOCITIES FOR DRC')
  140 FORMAT(' *  TIMES    - TIMES OF VARIOUS STAGES TO BE PRINTED')
  150 FORMAT(' *  PARASOK  - USE SOME MNDO PARAMETERS IN AN AM1 CALCULA'
     1,'TION')
  160 FORMAT(' *  FLEPO    - PRINT DETAILS OF GEOMETRY OPTIMISATION')
  170 FORMAT(' *  BONDS    - FINAL BOND-ORDER MATRIX TO BE PRINTED')
  180 FORMAT(' *  GEO-OK   - OVERRIDE INTERATOMIC DISTANCE CHECK')
  190 FORMAT(' *  FOCK     - LAST FOCK MATRIX TO BE PRINTED')
  200 FORMAT(' *  LARGE    - EXPANDED OUTPUT TO BE PRINTED')
  210 FORMAT(' *  S1978    - 1978 SULFUR PARAMETERS TO BE USED')
  220 FORMAT(' *  SI1978   - 1978 SILICON PARAMETERS TO BE USED')
  230 FORMAT(' *  GRAPH    - GENERATE FILE FOR GRAPHICS')
  240 FORMAT(' *  1ELECTRON- FINAL ONE-ELECTRON MATRIX TO BE PRINTED')
  250 FORMAT(' *  ESR      - RHF SPIN DENSITY CALCULATION REQUESTED')
  260 FORMAT(' *  NOMM     - DO NOT MAKE MM CORRECTION TO CONH BARRIER')
  265 FORMAT(' *  MMOK     - APPLY MM CORRECTION TO CONH BARRIER')
  270 FORMAT(' *  INTERP   - PRINT DETAILS OF CAMP-KING CONVERGER')
  280 FORMAT(' *  DFP      - USE DAVIDON FLETCHER POWELL OPTIMIZER')
  290 FORMAT(' *  ANALYT   - USE ANALYTIC DERIVATIVES ')
  300 FORMAT(' *  MECI     - M.E.C.I. WORKING TO BE PRINTED')
  310 FORMAT(' *  DRC      - DYNAMIC REACTION COORDINATE CALCULATION')
  320 FORMAT(' *  DRC=     - HALF-LIFE FOR KINETIC ENERGY LOSS =',F9.2,
     1' * 10**(-14) SECONDS')
  330 FORMAT(' *  KINETIC= - ',F7.3,' KCAL KINETIC ENERGY ADDED TO DRC')
  340 FORMAT(' *  LOCALIZE - LOCALIZED ORBITALS TO BE PRINTED')
  350 FORMAT(' *  MULLIK   - THE MULLIKEN ANALYSIS TO BE PERFORMED')
  360 FORMAT(' *   XYZ     - CARTESIAN COORDINATE SYSTEM TO BE USED')
  370 FORMAT(' *   PI      - BONDS MATRIX, SPLIT INTO SIGMA-PI-DELL',
     1' COMPONENTS, TO BE PRINTED')
  380 FORMAT(' *  ECHO     - ALL INPUT DATA TO BE ECHOED BEFORE RUN')
  390 FORMAT(' *  H-PRIOR  - HEAT OF FORMATION TAKES PRIORITY IN DRC')
  400 FORMAT(' *  X-PRIOR  - GEOMETRY CHANGES TAKE PRIORITY IN DRC')
  410 FORMAT(' *  T-PRIOR  - TIME TAKES PRIORITY IN DRC')
  420 FORMAT(' *  POWSQ    - PRINT DETAILS OF WORKING IN POWSQ')
  430 FORMAT(' *  POLAR    - CALCULATE FIRST, SECOND AND THIRD-ORDER'
     1,' POLARIZABILITIES')
  440 FORMAT(' *  DEBUG    - DEBUG OPTION TURNED ON')
  450 FORMAT(' *  RESTART  - CALCULATION RESTARTED')
  460 FORMAT(' *  IRC=N    - INTRINSIC REACTION COORDINATE',I3,
     1' DEFINED')
  470 FORMAT(' *  IRC      - INTRINSIC REACTION COORDINATE CALCULATION')
  480 FORMAT(3(' *',/),' *',15X,'  CHARGE ON SYSTEM =',I3,3(/,' *'))
  490 FORMAT(' *  GRADIENTS- ALL GRADIENTS TO BE PRINTED')
  500 FORMAT(' *  UHF      - UNRESTRICTED HARTREE-FOCK CALCULATION')
  510 FORMAT(' *  SINGLET  - STATE REQUIRED MUST BE A SINGLET')
  520 FORMAT(' *  BIRADICAL- SYSTEM HAS TWO UNPAIRED ELECTRONS')
  530 FORMAT(' *  EXCITED  - FIRST EXCITED STATE IS TO BE OPTIMIZED')
  540 FORMAT(' *  SINGLET  - SPIN STATE DEFINED AS A SINGLET')
  550 FORMAT(' *  DOUBLET  - SPIN STATE DEFINED AS A DOUBLET')
  560 FORMAT(' *  TRIPLET  - SPIN STATE DEFINED AS A TRIPLET')
  570 FORMAT(' *  QUARTET  - SPIN STATE DEFINED AS A QUARTET')
  580 FORMAT(' *  QUINTET  - SPIN STATE DEFINED AS A QUINTET')
  590 FORMAT(' *  SEXTET   - SPIN STATE DEFINED AS A SEXTET')
  600 FORMAT(' *  SYMMETRY - SYMMETRY CONDITIONS TO BE IMPOSED')
  610 FORMAT(' *  MICROS=N -',I4,' MICROSTATES TO BE SUPPLIED FOR C.I.')
  620 FORMAT(' *  OPEN(N,N)- THERE ARE',I2,' ELECTRONS IN',I2,' LEVELS')
  630 FORMAT(' *   T=      - A TIME OF',F8.1,' ',A7,' REQUESTED')
  640 FORMAT(' *   T=      - A TIME OF',G11.3,' ',A7,' REQUESTED')
  650 FORMAT(' *  DUMP=N   - RESTART FILE WRITTEN EVERY',F8.1,
     1' ',A7)
  660 FORMAT(' *  DUMP=N   - RESTART FILE WRITTEN EVERY',G11.3,
     1' ',A7)
  670 FORMAT(' *  1SCF     - DO 1 SCF AND THEN STOP ')
  680 FORMAT(' *  C.I.=N   -',I2,' M.O.S TO BE USED IN C.I.')
  690 FORMAT(' *  DFORCE   - PRINT HESSIAN MATRIX IN FORCE')
  700 FORMAT(' *  FORCE    - FORCE CALCULATION SPECIFIED')
  710 FORMAT(' *  MINDO/3  - THE MINDO/3 HAMILTONIAN TO BE USED')
  720 FORMAT(' *  AM1      - THE AM1 HAMILTONIAN TO BE USED')
  730 FORMAT(' *  PM3      - THE PM3 HAMILTONIAN TO BE USED')
  740 FORMAT(' *  PRECISE  - CRITERIA TO BE INCREASED BY 100 TIMES')
  750 FORMAT(' *  NOINTER  - INTERATOMIC DISTANCES NOT TO BE PRINTED')
  760 FORMAT(' *  ISOTOPE  - FORCE MATRIX WRITTEN TO DISK (CHAN. 9 )')
  770 FORMAT(' *  DENOUT   - DENSITY MATRIX OUTPUT ON CHANNEL 10')
  780 FORMAT(' *  SHIFT    - A DAMPING FACTOR OF',F8.2,' DEFINED')
  790 FORMAT(' *  OLDENS   - INITIAL DENSITY MATRIX READ OF DISK')
  800 FORMAT(' *  SCFCRT   - DEFAULT SCF CRITERION REPLACED BY',G12.3)
  810 FORMAT(' *  ENPART   - ENERGY TO BE PARTITIONED INTO COMPONENTS')
  820 FORMAT(' *  NOXYZ    - CARTESIAN COORDINATES NOT TO BE PRINTED')
  830 FORMAT(' *  SIGMA    - GEOMETRY TO BE OPTIMIZED USING SIGMA.')
  840 FORMAT(' *  NLLSQ    - GRADIENTS TO BE MINIMIZED USING NLLSQ.')
  850 FORMAT(' *  ROOT     - IN A C.I. CALCULATION, ROOT',I2,
     1                       ' TO BE OPTIMIZED.')
  860 FORMAT(' *  TRANS    - THE REACTION VIBRATION TO BE DELETED FROM',
     1' THE THERMO CALCULATION')
  870 FORMAT(' *  TRANS=   - ',I4,' VIBRATIONS ARE TO BE DELETED FROM',
     1' THE THERMO CALCULATION')
  880 FORMAT(' *  SADDLE   - TRANSITION STATE TO BE OPTIMIZED')
  890 FORMAT(' *   LET     - OVERRIDE SOME SAFETY CHECKS')
  900 FORMAT(' *  COMPFG   - PRINT HEAT OF FORMATION CALC''D IN COMPFG')
  910 FORMAT(' *  DERIV    - PRINT PART OF WORKING IN SUB. DERIV')
  920 FORMAT(' *  FULSCF   - IN SEARCHES, FULL SCF CALCN''S TO BE DONE')
  930 FORMAT(' *  DCART    - PRINT DETAILS OF WORKING IN DCART')
  940 FORMAT(' *  GNORM=   - EXIT WHEN GRADIENT NORM DROPS BELOW ',G8.3)
  950 FORMAT(' *  FMAT     - PRINT DETAILS OF WORKING IN FMAT')
  960 FORMAT(' *  HCORE    - PRINT DETAILS OF WORKING IN HCORE')
  970 FORMAT(' *  ITER     - PRINT DETAILS OF WORKING IN ITER')
  980 FORMAT(' *  PULAY    - PULAY''S METHOD TO BE USED IN SCF')
  990 FORMAT(' *  LINMIN   - PRINT DETAILS OF LINE MINIMIZATION')
 1000 FORMAT(' *  LOCMIN   - USE LINMIN INSTEAD OF THIS KEYWORD')
 1010 FORMAT(' *  STEP1    - FIRST  STEP-SIZE IN GRID =',F7.2)
 1020 FORMAT(' *  STEP2    - SECOND STEP-SIZE IN GRID =',F7.2)
 1030 FORMAT(' *  BAR=     - REDUCE BAR LENGTH BY A MAX. OF',F7.2)
 1040 FORMAT(' *  DEBUGPULAY-PRINT DETAILS OF WORKING IN PULAY')
 1050 FORMAT(' *  CAMP,KING- THE CAMP-KING CONVERGER TO BE USED')
 1060 FORMAT(' *  EIGS     - PRINT ALL EIGENVALUES IN ITER')
 1070 FORMAT(' *  MOLDAT   - PRINT DETAILS OF WORKING IN MOLDAT')
 1080 FORMAT(' *  HYPERFINE- HYPERFINE COUPLING CONSTANTS TO BE'
     1,' PRINTED')
 1090 FORMAT(' *  OPCI     - PRINT DETAILS OF WORKING IN OPCI')
 1100 FORMAT(' *   PL      - MONITOR CONVERGANCE IN DENSITY MATRIX')
 1110 FORMAT(' *  SEARCH   - USE LINMIN INSTEAD OF THIS KEYWORD')
 1120 FORMAT(' *  FILL=    - IN RHF CLOSED SHELL, FORCE M.O.',I3,' TO BE
     1 FILLED')
 1130 FORMAT(' *  CYCLES=  - DO A MAXIMUM OF ',I4,' CYCLES IN NLLSQ')
 1140 FORMAT(' *  THERMO   - THERMODYNAMIC QUANTITIES TO BE CALCULATED')
 1150 FORMAT(' *  ROT      - SYMMETRY NUMBER OF',I3,' SPECIFIED')
 1160 FORMAT(' *  ITRY=    - DO A MAXIMUM OF',I6,' ITERATIONS FOR SCF')
 1170 FORMAT( //10X,' IMPOSSIBLE OPTION REQUESTED,')
 1180 FORMAT(' *  0SCF     - AFTER READING AND PRINTING DATA, STOP')
C
C     KEYWORDS ADDED FOR ESP MOPAC
C
 1190 FORMAT(' *  ESP      - ELECTROSTATIC POTENTIAL CALCULATION')      
 1200 FORMAT(' *  NSURF    - NUMBER OF LAYERS')                         
 1210 FORMAT(' *  SCALE    - SCALING FACTOR FOR VAN DER WAALS DISTANCE')
 1220 FORMAT(' *  DEN      - DENSITY OF POINTS')                        
 1230 FORMAT(' *  SCINCR   - INCREMENT BETWEEN LAYERS')                 
 1240 FORMAT(' *  SLOPE    - SLOPE - USED TO SCALE MNDO ESP CHARGES') 
 1250 FORMAT(' *  DIPOLE   - FIT THE ESP TO THE CALCULATED DIPOLE')
 1260 FORMAT(' *  DIPX     - X COMPONENT OF DIPOLE TO BE FIT')
 1270 FORMAT(' *  DIPY     - Y COMPONENT OF DIPOLE TO BE FIT') 
 1280 FORMAT(' *  DIPZ     - Z COMPONENT OF DIPOLE TO BE FIT') 
 1290 FORMAT(' *  CONNOLLY - USE CONNOLLY SURFACE')
 1300 FORMAT(' *  ESPRST   - RESTART OF ELECTRIC POTENTIAL CALCUTATION')
 1310 FORMAT(' *  POTWRT   - WRITE OUT ELECTRIC POT. DATA TO FILE 21')
 1320 FORMAT(' *  WILLIAMS - USE WILLIAMS SURFACE')
 1330 FORMAT(' *  SYMAVG   - AVERAGE SYMMETRY EQUIVALENT ESP CHARGES')
 1340 FORMAT(' *  STO3G  - DEORTHOGONALIZE ORBITALS IN STO3G BASIS')
      END                                                               
