C**************************************************************************
      SUBROUTINE SURFAC(SCALE,DENS,IPT)                                 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                               
#include "SIZES"                                                   
C**************************************************************************  
C
C      THIS SUBROUTINE CALCULATES THE MOLECULAR SURFACE OF A MOLECULE        
C      GIVEN THE COORDINATES OF ITS ATOMS.  VAN DER WAALS RADII FOR          
C      THE ATOMS AND THE PROBE RADIUS MUST ALSO BE SPECIFIED.                
C                                                                       
C      ON INPUT    SCALE = INITIAL VAN DER WAAL SCALE FACTOR                 
C                  DENS  = DENSITY OF POINTS PER UNIT AREA                   
C                                                                       
C      THIS SUBROUTINE WAS LIFTED FROM MICHAEL CONNOLLY'S SURFACE            
C      PROGRAM FOR UCSF GRAPHICS SYSTEM BY U.CHANDRA SINGH AND               
C      P.A.KOLLMAN AND MODIFIED FOR USE IN QUEST. K.M.MERZ                
C      ADAPTED AND CLEANED UP THIS PROGRAM FOR USE IN AMPAC/MOPAC
C      IN FEB. 1989 AT UCSF.                 
C
C**************************************************************************
      COMMON /GEOM/   GEO(3,NUMATM)                                     
      COMMON /GEOKST/ NATOMS,LABELS(NUMATM),                            
     1                NA(NUMATM),NB(NUMATM),NC(NUMATM)                  
      COMMON /KEYWRD/ KEYWRD                                            
C                                                                       
      COMMON /ABC/    CO(3,NUMATM),IAN(NUMATM),NATOM                    
      COMMON /PTS/    POTPT(3,MESP)
      COMMON /POTESP/ XC,YC,ZC,ESPNUC,ESPELE,NESP
C                                                                       
      CHARACTER*80 KEYWRD                                               
C                                                                       
C     CARTESIAN COORDINATE AND ATOM LABELS                              
C                                                                       
      DIMENSION COORD(3,NUMATM),VANDER(100),RAD(MESP)                  
      DIMENSION IAS(MESP),CON(3,1000),ROT(3,3)                         
C                                                                       
C     NEIGHBOR ARRAYS                                                   
C                                                                       
C     THIS SAME DIMENSION FOR THE MAXIMUM NUMBER OF NEIGHBORS           
C     IS USED TO DIMENSION ARRAYS IN THE LOGICAL FUNCTION COLLID        
C                                                                       
      DIMENSION INBR(200),CNBR(3,200),RNBR(200)                         
      LOGICAL SNBR(200),MNBR(200)                                       
C                                                                       
C     ARRAYS FOR ALL ATOMS                                              
C                                                                       
C     IATOM, JATOM AND KATOM COORDINATES                                
C                                                                       
      DIMENSION CI(3), IELDAT(56), TEMP0(3)                             
C                                                                       
C     GEOMETRIC CONSTRUCTION VECTORS                                    
C                                                                       
      DIMENSION CW(3,2)                                                 
C                                                                       
C     LOGICAL VARIABLES                                                 
C                                                                       
      LOGICAL SI                                                        
C                                                                       
C     LOGICAL FUNCTIONS                                                 
C                                                                       
      LOGICAL COLLID                                                    
C                                                                       
C     DATA FOR VANDER VALL RADII                                        
C                                                                       
      DATA VANDER/1.20,1.20,1.37,1.45,1.45,1.50,1.50,1.40,1.35,1.30     
     *           ,1.57,1.36,1.24,1.17,1.80,1.75,1.70,17*0.0,2.3,65*0.0/ 
      DATA MARKER/3HA   /,MARKSS/3HSS0/,MYNAM/3HUC /                    
C                                                                       
      DATA IELDAT/4H  BQ,4H  H ,4H  HE,4H  LI,4H  BE,4H  B ,            
     *            4H  C ,4H  N ,4H  O ,4H  F ,4H  NE,4H  NA,            
     *            4H  MG,4H  AL,4H  SI,4H  P ,4H  S ,4H  CL,            
     *            4H  AR,4H  K ,4H  CA,4H  SC,4H  TI,4H  V ,            
     *            4H  CR,4H  MN,4H  FE,4H  CO,4H  NI,4H  CU,            
     *            4H  ZN,4H  GA,4H  GE,4H  AS,4H  SE,4H  BR,            
     *            4H  KR,4H  RB,4H  SR,4H   Y,4H  ZR,4H  NB,            
     *            4H  MO,4H  TC,4H  RU,4H  RH,4H  PD,4H  AG,            
     *            4H  CD,4H  IN,4H  SN,4H  SB,4H  TE,4H   I,            
     *            4H   X,4H  CS/                                        
      PI=4.D0*ATAN(1.D0)                                                
C     INSERT VAN DER WAAL RADII FOR ZINC                                
      VANDER(30)=1.00D0                                                 
C                                                                       
C     CONVERT INTERNAL TO CARTESIAN COORDINATES                         
C                                                                       
      CALL GMETRY(GEO,COORD)                                            
C                                                                       
C     STRIP COORDINATES AND ATOM LABEL FOR DUMMIES (I.E. 99)            
C                                                                       
      ICNTR = 0                                                         
      DO 10 I=1,NATOMS                                                 
             DO 20 J=1,3                                               
  20         CO(J,I) = COORD(J,I)                                       
             IF(LABELS(I) .EQ. 99) GOTO 10                             
                ICNTR = ICNTR + 1                                       
                IAN(ICNTR) = LABELS(I)                                  
  10  CONTINUE                                                          
C                                                                       
C     ONLY VANDER VAAL TYPE SURFACE IS GENERATED                        
C                                                                       
      IOP = 1                                                           
      RW =0.0                                                           
      NATOM = ICNTR                                                     
      DEN = DENS                                                        
      DO 30 I=1,NATOM                                                  
      IPOINT = IAN(I)                                                   
      RAD(I) = VANDER(IPOINT)*SCALE                                     
      IF (RAD(I) .LT. 0.01) THEN                                        
         WRITE(6,'(T2,''VAN DER WAALS RADIUS FOR ATOM '',I3,            
     +         '' IS ZERO, SUPPLY A VALUE IN SUBROUTINE SURFAC)''       
     +         )')                                                      
      ENDIF                                                             
      IAS(I) = 2                                                        
 30   CONTINUE                                                          
C                                                                       
C     BIG LOOP FOR EACH ATOM                                            
C                                                                       
      DO 40 IATOM = 1, NATOM                                           
         IF (IAS(IATOM) .EQ. 0) GO TO 40                               
C                                                                       
C     TRANSFER VALUES FROM LARGE ARRAYS TO IATOM VARIABLES              
C                                                                       
         NAMATM =IELDAT(IAN(IATOM)+1)                                   
         RI = RAD(IATOM)                                                
         SI = IAS(IATOM) .EQ. 2                                         
         DO 50 K = 1,3                                                 
            CI(K) = CO(K,IATOM)                                         
 50      CONTINUE                                                       
C                                                                       
C     GATHER THE NEIGHBORING ATOMS OF IATOM                             
C                                                                       
         NNBR = 0                                                       
         DO 60 JATOM = 1, NATOM                                        
            IF (IATOM .EQ. JATOM .OR. IAS(JATOM) .EQ. 0) GO TO 60      
            D2 = DIST2(CI,CO(1,JATOM))                                  
            IF (D2 .GE. (2*RW+RI+RAD(JATOM)) ** 2) GO TO 60            
C                                                                       
C     WE HAVE A NEW NEIGHBOR                                            
C     TRANSFER ATOM COORDINATES, RADIUS AND SURFACE REQUEST NUMBER      
C                                                                       
            NNBR = NNBR + 1                                             
            IF (NNBR .GT. 200)THEN                                      
               WRITE (6,'(''ERROR'',2X,''TOO MANY NEIGHBORS:'',I5)')NNBR
               STOP                                                     
            ENDIF                                                       
            INBR(NNBR) = JATOM                                          
            DO 70 K = 1,3                                              
               CNBR(K,NNBR) = CO(K,JATOM)                               
 70         CONTINUE                                                    
            RNBR(NNBR) = RAD(JATOM)                                     
            SNBR(NNBR) = IAS(JATOM) .EQ. 2                              
 60      CONTINUE                                                       
C                                                                       
C     CONTACT SURFACE                                                   
C                                                                       
         IF (.NOT. SI) GO TO 40                                        
         NCON = (4 * PI * RI ** 2) * DEN                                
         IF (NCON .GT. 1000) NCON = 1000                                
C                                                                       
C     THIS CALL MAY DECREASE NCON SOMEWHAT                              
C                                                                       
         IF ( NCON .EQ. 0) THEN                                         
             WRITE(6,'(T2,''VECTOR LENGTH OF ZERO IN SURFAC'')')        
             STOP                                                       
         ENDIF                                                          
         CALL GENUN(CON,NCON)                                           
         AREA = (4 * PI * RI ** 2) / NCON                               
C                                                                       
C     CONTACT PROBE PLACEMENT LOOP                                      
C                                                                       
         DO 80 I = 1,NCON                                              
            DO 90 K = 1,3                                              
               CW(K,1) = CI(K) + (RI + RW) * CON(K,I)                   
 90         CONTINUE                                                    
C                                                                       
C     CHECK FOR COLLISION WITH NEIGHBORING ATOMS                        
C                                                                       
            IF (COLLID(CW(1,1),RW,CNBR,RNBR,MNBR,NNBR,1,                
     *      JNBR,KNBR)) GO TO 80                                       
            DO 100 KK=1,3                                               
               TEMP0(KK) =CI(KK)+RI*CON(KK,I)                           
100         CONTINUE                                                    
C                                                                       
C     STORE POINT IN POTPT AND INCREMENT NESP                    
C                                                                       
            NESP = NESP + 1
            IF (NESP .GT. MESP) THEN
            WRITE(6,9000)
 9000 FORMAT(/'ERROR - TO MANY POINTS GENERATED IN SURFAC')
              WRITE(6,'(''    REDUCE NSURF, SCALE, DEN, OR SCINCR'')')
              STOP
            ENDIF
            POTPT(1,NESP) = TEMP0(1)
            POTPT(2,NESP) = TEMP0(2)
            POTPT(3,NESP) = TEMP0(3)
 80      CONTINUE                                                       
 40   CONTINUE                                                          
      RETURN                                                            
      END                                                               
C****************************************************************       
      FUNCTION DIST2(A,B)                                               
C
C     DETERMINE DISTANCES BETWEEN NEIGHBORING ATOMS
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                               
      DIMENSION A(3)                                                    
      DIMENSION B(3)                                                    
      DIST2 = (A(1)-B(1))**2 + (A(2)-B(2))**2 + (A(3)-B(3))**2          
      RETURN                                                            
      END                                                               
C****************************************************************       
      LOGICAL FUNCTION COLLID(CW,RW,CNBR,RNBR,MNBR,NNBR,ISHAPE,         
     1JNBR,KNBR)                                                        
C****************************************************************
C
C     COLLISION CHECK OF PROBE WITH NEIGHBORING ATOMS                   
C     USED BY SURFAC ONLY.
C
C****************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                               
      DIMENSION CW(3)                                                   
      DIMENSION CNBR(3,200)                                             
      DIMENSION RNBR(200)                                               
      LOGICAL MNBR(200)                                                 
      IF (NNBR .LE. 0) GO TO 20                                        
C                                                                       
C     CHECK WHETHER PROBE IS TOO CLOSE TO ANY NEIGHBOR                  
C                                                                       
      DO 10 I = 1, NNBR                                                
         IF (ISHAPE .GT. 1 .AND. I .EQ. JNBR) GO TO 10                    
         IF (ISHAPE .EQ. 3 .AND. (I .EQ. KNBR .OR. .NOT. MNBR(I)))         
     1   GO TO 10                                                         
         SUMRAD = RW + RNBR(I)                                             
         VECT1 = DABS(CW(1) - CNBR(1,I))                                   
         IF (VECT1 .GE. SUMRAD) GO TO 10                                  
         VECT2 = DABS(CW(2) - CNBR(2,I))                                   
         IF (VECT2 .GE. SUMRAD) GO TO 10                                  
         VECT3 = DABS(CW(3) - CNBR(3,I))                                   
         IF (VECT3 .GE. SUMRAD) GO TO 10                                  
         SR2 = SUMRAD ** 2                                                 
         DD2 = VECT1 ** 2 + VECT2 ** 2 + VECT3 ** 2                        
         IF (DD2 .LT. SR2) GO TO 30                                       
 10   CONTINUE                                                          
 20   CONTINUE                                                          
      COLLID = .FALSE.                                                  
      GO TO 40                                                         
 30   CONTINUE                                                          
      COLLID = .TRUE.                                                   
 40   CONTINUE                                                          
      RETURN                                                            
      END                                                               
C****************************************************************       
      SUBROUTINE GENUN(U,N)                                             
C****************************************************************
C
C     GENERATE UNIT VECTORS OVER SPHERE. USED BY SURFAC ONLY.
C
C****************************************************************
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                               
      DIMENSION U(3,N)                                                  
      PI=4.D0*ATAN(1.D0)                                                
      NEQUAT = SQRT(N * PI)                                             
      NVERT = 0.5 * NEQUAT                                              
      NU = 0                                                            
      DO 10 I = 1,NVERT+1                                              
         FI = (PI * (I-1)) / NVERT                                         
         Z = COS(FI)                                                       
         XY = SIN(FI)                                                      
         NHOR = NEQUAT * XY                                                
         IF (NHOR .LT. 1) NHOR = 1                                         
         DO 20 J = 1,NHOR                                                 
            FJ = (2.D0 * PI * (J-1)) / NHOR                                   
            X = DCOS(FJ) * XY                                                 
            Y = DSIN(FJ) * XY                                                 
            IF (NU .GE. N) GO TO 30                                          
            NU = NU + 1                                                       
            U(1,NU) = X                                                       
            U(2,NU) = Y                                                       
            U(3,NU) = Z                                                       
 20      CONTINUE                                                          
 10   CONTINUE                                                          
 30   CONTINUE                                                          
      N = NU                                                            
      RETURN                                                            
      END                                                               
