      SUBROUTINE RSP(A,N,MATZ,W,Z) 
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
      INCLUDE 'SIZES'
      INTEGER I,J,N,NM,NV,IERR,MATZ 
      DIMENSION A(*),W(N),Z(N,N)
      DIMENSION FV(MAXORB,10)
C 
C     THIS SUBROUTINE CALLS a possible faster SEQUENCE OF 
C     SUBROUTINES FROM THE EIGENSYSTEM SUBROUTINE PACKAGE (EISPACK) 
C     TO FIND THE EIGENVALUES AND EIGENVECTORS (IF DESIRED) 
C     OF A REAL SYMMETRIC PACKED MATRIX. 
C 
C     ON INPUT 
C 
C        NM  MUST BE SET TO THE ROW DIMENSION OF THE TWO-DIMENSIONAL 
C        ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM 
C        DIMENSION STATEMENT. 
C 
C        N  IS THE ORDER OF THE MATRIX  A. 
C 
C        NV  IS AN INTEGER VARIABLE SET EQUAL TO THE 
C        DIMENSION OF THE ARRAY  A  AS SPECIFIED FOR 
C        A  IN THE CALLING PROGRAM.  NV  MUST NOT BE 
C        LESS THAN  N*(N+1)/2. 
C 
C        A  CONTAINS THE LOWER TRIANGLE OF THE REAL SYMMETRIC 
C        PACKED MATRIX STORED ROW-WISE. 
C 
C        MATZ  IS AN INTEGER VARIABLE SET EQUAL TO ZERO IF 
C        ONLY EIGENVALUES ARE DESIRED.  OTHERWISE IT IS SET TO 
C        ANY NON-ZERO INTEGER FOR BOTH EIGENVALUES AND EIGENVECTORS. 
C 
C     ON OUTPUT 
C 
C        W  CONTAINS THE EIGENVALUES IN ASCENDING ORDER. 
C 
C        Z  CONTAINS THE EIGENVECTORS IF MATZ IS NOT ZERO. 
C 
C        IERR  IS AN INTEGER OUTPUT VARIABLE SET EQUAL TO AN ERROR 
C           COMPLETION CODE DESCRIBED IN THE DOCUMENTATION FOR TQLRAT 
C           AND TQL2.  THE NORMAL COMPLETION CODE IS ZERO. 
C 
C        FV is a TEMPORARY STORAGE ARRAY with at least 6 columns.
C 
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW, 
C     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY 
C 
C     THIS VERSION DATED July, 1989
C 
C     ------------------------------------------------------------------ 
C 
      LOGICAL FIRST
      DATA FIRST /.TRUE./
      IF (FIRST) THEN
         FIRST = .FALSE.
         CALL EPSETA(EPS,ETA)
         NV = (MAXORB*(MAXORB+1))/2
      ENDIF
      NM = N
      IF (N .gt. NM) then
         IERR = 10 * N 
         return
      endif
      IF (NV .LT. (N*(N+1))/2) THEN
         IERR = 20 * N
      ENDIF
C 
      call tred3(n,nv,a,fv(1,1),fv(1,2),fv(1,3)) 
      call imtqlv(n,fv(1,1),fv(1,2),fv(1,3),w,fv(1,10),ierr,fv(1,4))
      if (matz .eq. 0) return
      call tinvit(nm,n,fv(1,1),fv(1,2),fv(1,3),n,w,fv(1,10),z,ierr,
     >            fv(1,5),fv(1,6),fv(1,7),fv(1,8),fv(1,9))
      call trbak3(nm,n,nv,a,n,z) 
      RETURN 
      END 
      SUBROUTINE TRED3(N,NV,A,D,E,E2) 
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z) 
      INTEGER I,J,K,L,N,II,IZ,JK,NV,JM1 
      DOUBLE PRECISION A(NV),D(N),E(N),E2(N) 
      DOUBLE PRECISION F,G,H,HH,SCALE 
C 
C     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE TRED3, 
C     NUM. MATH. 11, 181-195(1968) BY MARTIN, REINSCH, AND WILKINSON. 
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 212-226(1971). 
C 
C     THIS SUBROUTINE REDUCES A REAL SYMMETRIC MATRIX, STORED AS 
C     A ONE-DIMENSIONAL ARRAY, TO A SYMMETRIC TRIDIAGONAL MATRIX 
C     USING ORTHOGONAL SIMILARITY TRANSFORMATIONS. 
C 
C     ON INPUT 
C 
C        N IS THE ORDER OF THE MATRIX. 
C 
C        NV MUST BE SET TO THE DIMENSION OF THE ARRAY PARAMETER A 
C          AS DECLARED IN THE CALLING PROGRAM DIMENSION STATEMENT. 
C 
C        A CONTAINS THE LOWER TRIANGLE OF THE REAL SYMMETRIC 
C          INPUT MATRIX, STORED ROW-WISE AS A ONE-DIMENSIONAL 
C          ARRAY, IN ITS FIRST N*(N+1)/2 POSITIONS. 
C 
C     ON OUTPUT 
C 
C        A CONTAINS INFORMATION ABOUT THE ORTHOGONAL 
C          TRANSFORMATIONS USED IN THE REDUCTION. 
C 
C        D CONTAINS THE DIAGONAL ELEMENTS OF THE TRIDIAGONAL MATRIX. 
C 
C        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE TRIDIAGONAL 
C          MATRIX IN ITS LAST N-1 POSITIONS.  E(1) IS SET TO ZERO. 
C 
C        E2 CONTAINS THE SQUARES OF THE CORRESPONDING ELEMENTS OF E. 
C          E2 MAY COINCIDE WITH E IF THE SQUARES ARE NOT NEEDED. 
C 
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW, 
C     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY 
C 
C     THIS VERSION DATED APRIL 1983. 
C 
C     ------------------------------------------------------------------ 
C 
C     .......... FOR I=N STEP -1 UNTIL 1 DO -- .......... 
      DO 300 II = 1, N 
         I = N + 1 - II 
         L = I - 1 
         IZ = (I * L) / 2 
         H = 0.0D0 
         SCALE = 0.0D0 
         IF (L .LT. 1) GO TO 130 
C     .......... SCALE ROW (ALGOL TOL THEN NOT NEEDED) .......... 
         DO 120 K = 1, L 
            IZ = IZ + 1 
            D(K) = A(IZ) 
            SCALE = SCALE + DABS(D(K)) 
  120    CONTINUE 
C 
         IF (SCALE .NE. 0.0D0) GO TO 140 
  130    E(I) = 0.0D0 
         E2(I) = 0.0D0 
         GO TO 290 
C 
  140    DO 150 K = 1, L 
            D(K) = D(K) / SCALE 
            H = H + D(K) * D(K) 
  150    CONTINUE 
C 
         E2(I) = SCALE * SCALE * H 
         F = D(L) 
         G = -DSIGN(DSQRT(H),F) 
         E(I) = SCALE * G 
         H = H - F * G 
         D(L) = F - G 
         A(IZ) = SCALE * D(L) 
         IF (L .EQ. 1) GO TO 290 
         JK = 1 
C 
         DO 240 J = 1, L 
            F = D(J) 
            G = 0.0D0 
            JM1 = J - 1 
            IF (JM1 .LT. 1) GO TO 220 
C 
            DO 200 K = 1, JM1 
               G = G + A(JK) * D(K) 
               E(K) = E(K) + A(JK) * F 
               JK = JK + 1 
  200       CONTINUE 
C 
  220       E(J) = G + A(JK) * F 
            JK = JK + 1 
  240    CONTINUE 
C     .......... FORM P .......... 
         F = 0.0D0 
C 
         DO 245 J = 1, L 
            E(J) = E(J) / H 
            F = F + E(J) * D(J) 
  245    CONTINUE 
C 
         HH = F / (H + H) 
C     .......... FORM Q .......... 
         DO 250 J = 1, L 
  250    E(J) = E(J) - HH * D(J) 
C 
         JK = 1 
C     .......... FORM REDUCED A .......... 
         DO 280 J = 1, L 
            F = D(J) 
            G = E(J) 
C 
            DO 260 K = 1, J 
               A(JK) = A(JK) - F * E(K) - G * D(K) 
               JK = JK + 1 
  260       CONTINUE 
C 
  280    CONTINUE 
C 
  290    D(I) = A(IZ+1) 
         A(IZ+1) = SCALE * DSQRT(H) 
  300 CONTINUE 
C 
      RETURN 
      END 
      SUBROUTINE TRBAK3(NM,N,NV,A,M,Z) 
C 
      INTEGER I,J,K,L,M,N,IK,IZ,NM,NV 
      DOUBLE PRECISION A(NV),Z(NM,M) 
      DOUBLE PRECISION H,S 
C 
C     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE TRBAK3, 
C     NUM. MATH. 11, 181-195(1968) BY MARTIN, REINSCH, AND WILKINSON. 
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 212-226(1971). 
C 
C     THIS SUBROUTINE FORMS THE EIGENVECTORS OF A REAL SYMMETRIC 
C     MATRIX BY BACK TRANSFORMING THOSE OF THE CORRESPONDING 
C     SYMMETRIC TRIDIAGONAL MATRIX DETERMINED BY  TRED3. 
C 
C     ON INPUT 
C 
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL 
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM 
C          DIMENSION STATEMENT. 
C 
C        N IS THE ORDER OF THE MATRIX. 
C 
C        NV MUST BE SET TO THE DIMENSION OF THE ARRAY PARAMETER A 
C          AS DECLARED IN THE CALLING PROGRAM DIMENSION STATEMENT. 
C 
C        A CONTAINS INFORMATION ABOUT THE ORTHOGONAL TRANSFORMATIONS 
C          USED IN THE REDUCTION BY  TRED3  IN ITS FIRST 
C          N*(N+1)/2 POSITIONS. 
C 
C        M IS THE NUMBER OF EIGENVECTORS TO BE BACK TRANSFORMED. 
C 
C        Z CONTAINS THE EIGENVECTORS TO BE BACK TRANSFORMED 
C          IN ITS FIRST M COLUMNS. 
C 
C     ON OUTPUT 
C 
C        Z CONTAINS THE TRANSFORMED EIGENVECTORS 
C          IN ITS FIRST M COLUMNS. 
C 
C     NOTE THAT TRBAK3 PRESERVES VECTOR EUCLIDEAN NORMS. 
C 
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW, 
C     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY 
C 
C     THIS VERSION DATED APRIL 1983. 
C 
C     ------------------------------------------------------------------ 
C 
      IF (M .EQ. 0) GO TO 200 
      IF (N .EQ. 1) GO TO 200 
C 
      DO 140 I = 2, N 
         L = I - 1 
         IZ = (I * L) / 2 
         IK = IZ + I 
         H = A(IK) 
         IF (H .EQ. 0.0D0) GO TO 140 
C 
         DO 130 J = 1, M 
            S = 0.0D0 
            IK = IZ 
C 
            DO 110 K = 1, L 
               IK = IK + 1 
               S = S + A(IK) * Z(K,J) 
  110       CONTINUE 
C     .......... DOUBLE DIVISION AVOIDS POSSIBLE UNDERFLOW .......... 
            S = (S / H) / H 
            IK = IZ 
C 
            DO 120 K = 1, L 
               IK = IK + 1 
               Z(K,J) = Z(K,J) - S * A(IK) 
  120       CONTINUE 
C 
  130    CONTINUE 
C 
  140 CONTINUE 
C 
  200 RETURN 
      END 
      SUBROUTINE IMTQLV(N,D,E,E2,W,IND,IERR,RV1) 
C 
      INTEGER I,J,K,L,M,N,II,MML,TAG,IERR 
      DOUBLE PRECISION D(N),E(N),E2(N),W(N),RV1(N) 
      DOUBLE PRECISION B,C,F,G,P,R,S,TST1,TST2,PYTHAG 
      INTEGER IND(N) 
C 
C     THIS SUBROUTINE IS A VARIANT OF  IMTQL1  WHICH IS A TRANSLATION OF 
C     ALGOL PROCEDURE IMTQL1, NUM. MATH. 12, 377-383(1968) BY MARTIN AND 
C     WILKINSON, AS MODIFIED IN NUM. MATH. 15, 450(1970) BY DUBRULLE. 
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 241-248(1971). 
C 
C     THIS SUBROUTINE FINDS THE EIGENVALUES OF A SYMMETRIC TRIDIAGONAL 
C     MATRIX BY THE IMPLICIT QL METHOD AND ASSOCIATES WITH THEM 
C     THEIR CORRESPONDING SUBMATRIX INDICES. 
C 
C     ON INPUT 
C 
C        N IS THE ORDER OF THE MATRIX. 
C 
C        D CONTAINS THE DIAGONAL ELEMENTS OF THE INPUT MATRIX. 
C 
C        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE INPUT MATRIX 
C          IN ITS LAST N-1 POSITIONS.  E(1) IS ARBITRARY. 
C 
C        E2 CONTAINS THE SQUARES OF THE CORRESPONDING ELEMENTS OF E. 
C          E2(1) IS ARBITRARY. 
C 
C     ON OUTPUT 
C 
C        D AND E ARE UNALTERED. 
C 
C        ELEMENTS OF E2, CORRESPONDING TO ELEMENTS OF E REGARDED 
C          AS NEGLIGIBLE, HAVE BEEN REPLACED BY ZERO CAUSING THE 
C          MATRIX TO SPLIT INTO A DIRECT SUM OF SUBMATRICES. 
C          E2(1) IS ALSO SET TO ZERO. 
C 
C        W CONTAINS THE EIGENVALUES IN ASCENDING ORDER.  IF AN 
C          ERROR EXIT IS MADE, THE EIGENVALUES ARE CORRECT AND 
C          ORDERED FOR INDICES 1,2,...IERR-1, BUT MAY NOT BE 
C          THE SMALLEST EIGENVALUES. 
C 
C        IND CONTAINS THE SUBMATRIX INDICES ASSOCIATED WITH THE 
C          CORRESPONDING EIGENVALUES IN W -- 1 FOR EIGENVALUES 
C          BELONGING TO THE FIRST SUBMATRIX FROM THE TOP, 
C          2 FOR THOSE BELONGING TO THE SECOND SUBMATRIX, ETC.. 
C 
C        IERR IS SET TO 
C          ZERO       FOR NORMAL RETURN, 
C          J          IF THE J-TH EIGENVALUE HAS NOT BEEN 
C                     DETERMINED AFTER 30 ITERATIONS. 
C 
C        RV1 IS A TEMPORARY STORAGE ARRAY. 
C 
      PYTHAG(TST1,TST2) = DSQRT(TST1*TST1 + TST2*TST2)
C 
      IERR = 0 
      K = 0 
      TAG = 0 
C 
      DO 100 I = 1, N 
         W(I) = D(I) 
         IF (I .NE. 1) RV1(I-1) = E(I) 
  100 CONTINUE 
C 
      E2(1) = 0.0D0 
      RV1(N) = 0.0D0 
C 
      DO 290 L = 1, N 
         J = 0 
C     .......... LOOK FOR SMALL SUB-DIAGONAL ELEMENT .......... 
  105    DO 110 M = L, N 
            IF (M .EQ. N) GO TO 120 
            TST1 = DABS(W(M)) + DABS(W(M+1)) 
            TST2 = TST1 + DABS(RV1(M)) 
            IF (TST2 .EQ. TST1) GO TO 120 
C     .......... GUARD AGAINST UNDERFLOWED ELEMENT OF E2 .......... 
            IF (E2(M+1) .EQ. 0.0D0) GO TO 125 
  110    CONTINUE 
C 
  120    IF (M .LE. K) GO TO 130 
         IF (M .NE. N) E2(M+1) = 0.0D0 
  125    K = M 
         TAG = TAG + 1 
  130    P = W(L) 
         IF (M .EQ. L) GO TO 215 
         IF (J .EQ. 30) GO TO 1000 
         J = J + 1 
C     .......... FORM SHIFT .......... 
         G = (W(L+1) - P) / (2.0D0 * RV1(L)) 
         R = PYTHAG(G,1.0D0) 
         G = W(M) - P + RV1(L) / (G + DSIGN(R,G)) 
         S = 1.0D0 
         C = 1.0D0 
         P = 0.0D0 
         MML = M - L 
C     .......... FOR I=M-1 STEP -1 UNTIL L DO -- .......... 
         DO 200 II = 1, MML 
            I = M - II 
            F = S * RV1(I) 
            B = C * RV1(I) 
            R = PYTHAG(F,G) 
            RV1(I+1) = R 
            S = F / R 
            C = G / R 
            G = W(I+1) - P 
            R = (W(I) - G) * S + 2.0D0 * C * B 
            P = S * R 
            W(I+1) = G + P 
            G = C * R - B 
  200    CONTINUE 
C 
         W(L) = W(L) - P 
         RV1(L) = G 
         RV1(M) = 0.0D0 
         GO TO 105 
C     .......... ORDER EIGENVALUES .......... 
  215    IF (L .EQ. 1) GO TO 250 
C     .......... FOR I=L STEP -1 UNTIL 2 DO -- .......... 
         DO 230 II = 2, L 
            I = L + 2 - II 
            IF (P .GE. W(I-1)) GO TO 270 
            W(I) = W(I-1) 
            IND(I) = IND(I-1) 
  230    CONTINUE 
C 
  250    I = 1 
  270    W(I) = P 
         IND(I) = TAG 
  290 CONTINUE 
C 
      GO TO 1001 
C     .......... SET ERROR -- NO CONVERGENCE TO AN 
C                EIGENVALUE AFTER 30 ITERATIONS .......... 
 1000 IERR = L 
 1001 RETURN 
      END 
      SUBROUTINE TINVIT(NM,N,D,E,E2,M,W,IND,Z, 
     X                  IERR,RV1,RV2,RV3,RV4,RV6) 
C 
      INTEGER I,J,M,N,P,Q,R,S,II,IP,JJ,NM,ITS,TAG,IERR,GROUP 
      DOUBLE PRECISION D(N),E(N),E2(N),W(M),Z(NM,M), 
     X       RV1(N),RV2(N),RV3(N),RV4(N),RV6(N) 
      DOUBLE PRECISION U,V,UK,XU,X0,X1,EPS2,EPS3,EPS4,NORM,ORDER,EPSLON, 
     X       DNRM2
      INTEGER IND(M) 
C 
C     THIS SUBROUTINE IS A TRANSLATION OF THE INVERSE ITERATION TECH- 
C     NIQUE IN THE ALGOL PROCEDURE TRISTURM BY PETERS AND WILKINSON. 
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 418-439(1971). 
C 
C     THIS SUBROUTINE FINDS THOSE EIGENVECTORS OF A TRIDIAGONAL 
C     SYMMETRIC MATRIX CORRESPONDING TO SPECIFIED EIGENVALUES, 
C     USING INVERSE ITERATION. 
C 
C     ON INPUT 
C 
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL 
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM 
C          DIMENSION STATEMENT. 
C 
C        N IS THE ORDER OF THE MATRIX. 
C 
C        D CONTAINS THE DIAGONAL ELEMENTS OF THE INPUT MATRIX. 
C 
C        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE INPUT MATRIX 
C          IN ITS LAST N-1 POSITIONS.  E(1) IS ARBITRARY. 
C 
C        E2 CONTAINS THE SQUARES OF THE CORRESPONDING ELEMENTS OF E, 
C          WITH ZEROS CORRESPONDING TO NEGLIGIBLE ELEMENTS OF E. 
C          E(I) IS CONSIDERED NEGLIGIBLE IF IT IS NOT LARGER THAN 
C          THE PRODUCT OF THE RELATIVE MACHINE PRECISION AND THE SUM 
C          OF THE MAGNITUDES OF D(I) AND D(I-1).  E2(1) MUST CONTAIN 
C          0.0D0 IF THE EIGENVALUES ARE IN ASCENDING ORDER, OR 2.0D0 
C          IF THE EIGENVALUES ARE IN DESCENDING ORDER.  IF  BISECT, 
C          TRIDIB, OR  IMTQLV  HAS BEEN USED TO FIND THE EIGENVALUES, 
C          THEIR OUTPUT E2 ARRAY IS EXACTLY WHAT IS EXPECTED HERE. 
C 
C        M IS THE NUMBER OF SPECIFIED EIGENVALUES. 
C 
C        W CONTAINS THE M EIGENVALUES IN ASCENDING OR DESCENDING ORDER. 
C 
C        IND CONTAINS IN ITS FIRST M POSITIONS THE SUBMATRIX INDICES 
C          ASSOCIATED WITH THE CORRESPONDING EIGENVALUES IN W -- 
C          1 FOR EIGENVALUES BELONGING TO THE FIRST SUBMATRIX FROM 
C          THE TOP, 2 FOR THOSE BELONGING TO THE SECOND SUBMATRIX, ETC. 
C 
C     ON OUTPUT 
C 
C        ALL INPUT ARRAYS ARE UNALTERED. 
C 
C        Z CONTAINS THE ASSOCIATED SET OF ORTHONORMAL EIGENVECTORS. 
C          ANY VECTOR WHICH FAILS TO CONVERGE IS SET TO ZERO. 
C 
C        IERR IS SET TO 
C          ZERO       FOR NORMAL RETURN, 
C          -R         IF THE EIGENVECTOR CORRESPONDING TO THE R-TH 
C                     EIGENVALUE FAILS TO CONVERGE IN 5 ITERATIONS. 
C 
C        RV1, RV2, RV3, RV4, AND RV6 ARE TEMPORARY STORAGE ARRAYS. 
C 
C     CALLS DNRM2
C 
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW, 
C     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY 
C 
C     THIS VERSION DATED APRIL 1983. 
C 
C     ------------------------------------------------------------------ 
C 
      IERR = 0 
      IF (M .EQ. 0) GO TO 1001 
      TAG = 0 
      ORDER = 1.0D0 - E2(1) 
      Q = 0 
C     .......... ESTABLISH AND PROCESS NEXT SUBMATRIX .......... 
  100 P = Q + 1 
C 
      DO 120 Q = P, N 
         IF (Q .EQ. N) GO TO 140 
         IF (E2(Q+1) .EQ. 0.0D0) GO TO 140 
  120 CONTINUE 
C     .......... FIND VECTORS BY INVERSE ITERATION .......... 
  140 TAG = TAG + 1 
      S = 0 
C 
      DO 920 R = 1, M 
         IF (IND(R) .NE. TAG) GO TO 920 
         ITS = 1 
         X1 = W(R) 
         IF (S .NE. 0) GO TO 510 
C     .......... CHECK FOR ISOLATED ROOT .......... 
         XU = 1.0D0 
         IF (P .NE. Q) GO TO 490 
         RV6(P) = 1.0D0 
         GO TO 870 
  490    NORM = DABS(D(P)) 
         IP = P + 1 
C 
         DO 500 I = IP, Q 
  500    NORM = DMAX1(NORM, DABS(D(I))+DABS(E(I))) 
C     .......... EPS2 IS THE CRITERION FOR GROUPING, 
C                EPS3 REPLACES ZERO PIVOTS AND EQUAL 
C                ROOTS ARE MODIFIED BY EPS3, 
C                EPS4 IS TAKEN VERY SMALL TO AVOID OVERFLOW .......... 
         EPS2 = 1.0D-3 * NORM 
         EPS3 = EPSLON(NORM) 
         UK = Q - P + 1 
         EPS4 = UK * EPS3 
         UK = EPS4 / DSQRT(UK) 
         S = P 
  505    GROUP = 0 
         GO TO 520 
C     .......... LOOK FOR CLOSE OR COINCIDENT ROOTS .......... 
  510    IF (DABS(X1-X0) .GE. EPS2) GO TO 505 
         GROUP = GROUP + 1 
         IF (ORDER * (X1 - X0) .LE. 0.0D0) X1 = X0 + ORDER * EPS3 
C     .......... ELIMINATION WITH INTERCHANGES AND 
C                INITIALIZATION OF VECTOR .......... 
  520    V = 0.0D0 
C 
         DO 580 I = P, Q 
            RV6(I) = UK 
            IF (I .EQ. P) GO TO 560 
            IF (DABS(E(I)) .LT. DABS(U)) GO TO 540 
C     .......... WARNING -- A DIVIDE CHECK MAY OCCUR HERE IF 
C                E2 ARRAY HAS NOT BEEN SPECIFIED CORRECTLY .......... 
            XU = U / E(I) 
            RV4(I) = XU 
            RV1(I-1) = E(I) 
            RV2(I-1) = D(I) - X1 
            RV3(I-1) = 0.0D0 
            IF (I .NE. Q) RV3(I-1) = E(I+1) 
            U = V - XU * RV2(I-1) 
            V = -XU * RV3(I-1) 
            GO TO 580 
  540       XU = E(I) / U 
            RV4(I) = XU 
            RV1(I-1) = U 
            RV2(I-1) = V 
            RV3(I-1) = 0.0D0 
  560       U = D(I) - X1 - XU * V 
            IF (I .NE. Q) V = E(I+1) 
  580    CONTINUE 
C 
         IF (U .EQ. 0.0D0) U = EPS3 
         RV1(Q) = U 
         RV2(Q) = 0.0D0 
         RV3(Q) = 0.0D0 
C     .......... BACK SUBSTITUTION 
C                FOR I=Q STEP -1 UNTIL P DO -- .......... 
  600    DO 620 II = P, Q 
            I = P + Q - II 
            RV6(I) = (RV6(I) - U * RV2(I) - V * RV3(I)) / RV1(I) 
            V = U 
            U = RV6(I) 
  620    CONTINUE 
C     .......... ORTHOGONALIZE WITH RESPECT TO PREVIOUS 
C                MEMBERS OF GROUP .......... 
         IF (GROUP .EQ. 0) GO TO 700 
         J = R 
C 
         DO 680 JJ = 1, GROUP 
  630       J = J - 1 
            IF (IND(J) .NE. TAG) GO TO 630 
            XU = 0.0D0 
C 
            DO 640 I = P, Q 
  640       XU = XU + RV6(I) * Z(I,J) 
C 
            DO 660 I = P, Q 
  660       RV6(I) = RV6(I) - XU * Z(I,J) 
C 
  680    CONTINUE 
C 
  700    NORM = 0.0D0 
C 
         DO 720 I = P, Q 
  720    NORM = NORM + DABS(RV6(I)) 
C 
         IF (NORM .GE. 1.0D0) GO TO 840 
C     .......... FORWARD SUBSTITUTION .......... 
         IF (ITS .EQ. 5) GO TO 830 
         IF (NORM .NE. 0.0D0) GO TO 740 
         RV6(S) = EPS4 
         S = S + 1 
         IF (S .GT. Q) S = P 
         GO TO 780 
  740    XU = EPS4 / NORM 
C 
         DO 760 I = P, Q 
  760    RV6(I) = RV6(I) * XU 
C     .......... ELIMINATION OPERATIONS ON NEXT VECTOR 
C                ITERATE .......... 
  780    DO 820 I = IP, Q 
            U = RV6(I) 
C     .......... IF RV1(I-1) .EQ. E(I), A ROW INTERCHANGE 
C                WAS PERFORMED EARLIER IN THE 
C                TRIANGULARIZATION PROCESS .......... 
            IF (RV1(I-1) .NE. E(I)) GO TO 800 
            U = RV6(I-1) 
            RV6(I-1) = RV6(I) 
  800       RV6(I) = U - RV4(I) * RV6(I-1) 
  820    CONTINUE 
C 
         ITS = ITS + 1 
         GO TO 600 
C     .......... SET ERROR -- NON-CONVERGED EIGENVECTOR .......... 
  830    IERR = -R 
         XU = 0.0D0 
         GO TO 870 
C     .......... NORMALIZE SO THAT SUM OF SQUARES IS 
C                1 AND EXPAND TO FULL ORDER .......... 
c 840    U = 0.0D0
C 
c        DO 860 I = P, Q 
c 860    U = PYTHAG(U,RV6(I)) 
C 
c        XU = 1.0D0 / U
  840    XU = 1.0D0 / DNRM2(Q-P+1,RV6(P),1)
C 
  870    DO 880 I = 1, N 
  880    Z(I,R) = 0.0D0 
C 
         DO 900 I = P, Q 
  900    Z(I,R) = RV6(I) * XU 
C 
         X0 = X1 
  920 CONTINUE 
C 
      IF (Q .LT. N) GO TO 100 
 1001 RETURN 
      END 
      double precision function dnrm2(n,x,incx)
      integer n,incx,i
      double precision x(1),s,t
c
      s = 0.0d0
      t = 0.0d0
      do 10 i = 1, n*incx, incx
         s = dmax1(s,dabs(x(i)))
   10 continue
      if (s .ne. 0.0d0) then
         do 20 i = 1, n*incx, incx
            t = t + (x(i)/s)**2
   20    continue
         t = s*dsqrt(t)
      endif
      dnrm2 = t
      return
      end
      DOUBLE PRECISION FUNCTION EPSLON (X) 
      DOUBLE PRECISION X 
C 
C     ESTIMATE UNIT ROUNDOFF IN QUANTITIES OF SIZE X. 
C 
      DOUBLE PRECISION A,B,C,EPS 
C 
C     THIS PROGRAM SHOULD FUNCTION PROPERLY ON ALL SYSTEMS 
C     SATISFYING THE FOLLOWING TWO ASSUMPTIONS, 
C        1.  THE BASE USED IN REPRESENTING FLOATING POINT 
C            NUMBERS IS NOT A POWER OF THREE. 
C        2.  THE QUANTITY  A  IN STATEMENT 10 IS REPRESENTED TO 
C            THE ACCURACY USED IN FLOATING POINT VARIABLES 
C            THAT ARE STORED IN MEMORY. 
C     THE STATEMENT NUMBER 10 AND THE GO TO 10 ARE INTENDED TO 
C     FORCE OPTIMIZING COMPILERS TO GENERATE CODE SATISFYING 
C     ASSUMPTION 2. 
C     UNDER THESE ASSUMPTIONS, IT SHOULD BE TRUE THAT, 
C            A  IS NOT EXACTLY EQUAL TO FOUR-THIRDS, 
C            B  HAS A ZERO FOR ITS LAST BIT OR DIGIT, 
C            C  IS NOT EXACTLY EQUAL TO ONE, 
C            EPS  MEASURES THE SEPARATION OF 1.0 FROM 
C                 THE NEXT LARGER FLOATING POINT NUMBER. 
C     THE DEVELOPERS OF EISPACK WOULD APPRECIATE BEING INFORMED 
C     ABOUT ANY SYSTEMS WHERE THESE ASSUMPTIONS DO NOT HOLD. 
C 
C     THIS VERSION DATED 4/6/83. 
C 
      A = 4.0D0/3.0D0 
   10 B = A - 1.0D0 
      C = B + B + B 
      EPS = DABS(C-1.0D0) 
      IF (EPS .EQ. 0.0D0) GO TO 10 
      EPSLON = EPS*DABS(X) 
      RETURN 
      END 
      SUBROUTINE EPSETA(EPS,ETA)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     COMPUTE AND RETURN ETA, THE SMALLEST REPRESENTABLE NUMBER,
C     AND EPS IS THE SMALLEST NUMBER FOR WHICH 1+EPS.NE.1.
C
C
      ETA = 1.D0
   10 IF((ETA/2.D0).EQ.0.D0) GOTO 20
      IF(ETA.LT.1.D-38) GOTO 20
      ETA = ETA / 2.D0
      GOTO 10
   20 EPS = 1.D0
   30 IF((1.D0+(EPS/2.D0)).EQ.1.D0) GOTO 40
      IF(EPS.LT.1.D-17) GOTO 40
      EPS = EPS / 2.D0
      GOTO 30
   40 RETURN
      END
