C************************************************************************
      SUBROUTINE POTCAL                                                 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                               
#include "SIZES"                                                   
C************************************************************************
C
C     THIS SUBROUTINE CALCULATES THE TOTAL ELECTROSTATIC POTENTIAL
C     THE NUCLEAR CONTRIBUTION IS EVALUATED BY NUCPOT
C     THE ELECTRONIC CONTRIBUTION IS EVALUATED BY ELESP      
C     ESPFIT FITS THE QUANTUM POTENTIAL TO A CLASSICAL POINT CHARGE MODEL
C     THIS SUBROUTINE WAS WRITTEN BY B.H.BESLER AND K.M.MERZ IN FEB.
C     1989 AT UCSF
C
C************************************************************************
      COMMON /KEYWRD/ KEYWRD                                            
      COMMON /CORE/ TORE(107)
      COMMON /ELEMTS/ ELEMNT(107)
      COMMON /DENSTY/ P(MPACK),PA(MPACK),PB(MPACK)                      
      COMMON /POTESP/ XC,YC,ZC,ESPNUC,ESPELE,NESP                       
      COMMON /PTS/    POTPT(3,MESP)                        
      COMMON /ABC/    CO(3,NUMATM),IAN(NUMATM),NATOM                    
      COMMON /ESPQ/   ES(MESP),ESP(MESP)
      COMMON /DIPSTO/ UX,UY,UZ,CH(NUMATM)
      COMMON /ESPF/  AL((NUMATM+4)**2),A(NUMATM,NUMATM),B(NUMATM),
     1Q(NUMATM+4),QSC(NUMATM+4),CF
      CHARACTER *80 KEYWRD                                              
      CHARACTER *2  ELEMNT
      LOGICAL DEBUG,WRTESP,CEQUIV(NUMATM,NUMATM)
C     
C     DEBUG PRINTING - RESULTS IN COPIOUS OUTPUT
C                                                                  
      DEBUG = (INDEX(KEYWRD,'DEBUG') .NE. 0)                            
C                                              
C                                                                       
      CALL ELESP                                                        
      BOHR = 0.529167D00                                                
C                                                                       
C     NOW FIT THE ELECTROSTATIC POTENTIAL
C
      WRITE(6,'(//12X,''ELECTROSTATIC POTENTIAL CHARGES'',/)')
      IZ=0                                                              
      IF(INDEX(KEYWRD,'CHARGE') .NE. 0) IZ=READA(KEYWRD,INDEX(KEYWRD,  
     1'CHARGE'))                                                       
C
C     DIPOLAR CONSTRAINTS IF DESIRED
C
      IF(INDEX(KEYWRD,'DIPOLE') .NE. 0) THEN
         IDIP = 1
         IF(IZ .NE. 0)THEN      
           IDIP = 0
           WRITE(6,'(/12X,''  DIPOLE CONSTRAINTS NOT USED'')')
           WRITE(6,'(12X,''        CHARGED MOLECULE'',/)')
         ENDIF
      ELSE
         IDIP = 0
      ENDIF
      IF (IDIP .EQ. 1) THEN
         WRITE(6,'(/12X,''DIPOLE CONSTRAINTS WILL BE USED'',/)')
      ENDIF
C
C     GET X,Y,Z DIPOLE COMPONENTS IF DESIRED
C
      IF(INDEX(KEYWRD,'DIPX=') .NE. 0) THEN
        DX = READA(KEYWRD,INDEX(KEYWRD,'DIPX='))
      ELSE
        DX = UX 
      ENDIF
      IF(INDEX(KEYWRD,'DIPY=') .NE. 0) THEN
        DY = READA(KEYWRD,INDEX(KEYWRD,'DIPY='))
      ELSE
        DY = UY 
      ENDIF
      IF(INDEX(KEYWRD,'DIPZ=') .NE. 0) THEN
        DZ = READA(KEYWRD,INDEX(KEYWRD,'DIPZ='))
      ELSE
        DZ = UZ 
      ENDIF
      CALL ESPFIT(IDIP,NATOM,NESP,IZ,ESP,POTPT,CO,DX,DY,DZ,RMS,RRMS)     
C
C     WRITE OUT OUR RESULTS TO CHANNEL 6
C     THE CHARGES ARE SCALED TO REPRODUCE 6-31G* CHARGES FOR MNDO ONLY
C     AM1 AND MINDO/3 CHARGES ARE NOT SCALED DUE TO THE LOW COORELATION
C     COEFFICIENT. SEE BESLER,MERZ,KOLLMAN IN J. COMPUT. CHEM. (IN PRESS)
C
      IF((INDEX(KEYWRD,'AM1') .NE. 0) .OR. 
     1(INDEX(KEYWRD,'MINDO') .NE. 0) .OR.
     2(INDEX(KEYWRD,'PM3') .NE. 0))THEN  
      WRITE(6,'(15X,''ATOM NO.    TYPE    CHARGE'')')
      DO 10 I=1,NATOM                                                  
         WRITE(6,FMT='(17X,I2,9X,A2,1X,F10.4)')I,ELEMNT(IAN(I)),Q(I) 
   10 CONTINUE
      ELSE 
C
C     MNDO CALCULATION-SCALE THE CHARGES. TEST FOR SLOPE KEYWORD
C
      IF(INDEX(KEYWRD,'SLOPE=') .NE. 0) THEN
        SLOPE = READA(KEYWRD,INDEX(KEYWRD,'SLOPE='))
      ELSE
        SLOPE = 1.422D0
      ENDIF
      DO 20 I=1,NATOM
         QSC(I) = SLOPE*Q(I)
   20 CONTINUE
      WRITE(6,'(7X,''ATOM NO.    TYPE    CHARGE   SCALED CHARGE'')')
      DO 30 I=1,NATOM                                                  
         WRITE(6,FMT='(9X,I2,9X,A2,1X,F10.4,2X,F10.4)')I,ELEMNT(IAN(I)),
     1   Q(I),QSC(I) 
   30 CONTINUE
      ENDIF
      WRITE(6,FMT='(/12X,A,4X,I6)') 'THE NUMBER OF POINTS IS:',NESP
      WRITE(6,FMT='(12X,A,4X,F9.4)') 'THE RMS DEVIATION IS:',RMS               
      WRITE(6,FMT='(12X,A,3X,F9.4)') 'THE RRMS DEVIATION IS:',RRMS 
C
C     CALCULATE DIPOLE MOMENT IF NEUTRAL MOLECULE
C
      IF (IZ .NE. 0) THEN
      GO TO 160
      ELSE
      WRITE(6,9000)
 9000 FORMAT (//5X,'DIPOLE MOMENT EVALUATED FROM ' 
     1,'THE POINT CHARGES',/)
      DO 40 I=1,NATOM                                                  
          DIPX=DIPX+CO(1,I)*Q(I)/BOHR                                       
          DIPY=DIPY+CO(2,I)*Q(I)/BOHR                                       
          DIPZ=DIPZ+CO(3,I)*Q(I)/BOHR                                       
   40 CONTINUE                                                          
      DIP=SQRT(DIPX**2+DIPY**2+DIPZ**2)                                 
      WRITE(6,'(12X,'' X        Y        Z       TOTAL'')')
      WRITE(6,FMT='(8X,4F9.4)')DIPX*CF,DIPY*CF,DIPZ*CF,DIP*CF                    
      ENDIF
  160 CONTINUE
C     DETERMINE WHICH CHARGES SHOULD BE EQUIVALENT BY SYMMETRY AND 
C     AVERAGE THEM IF DESIRED
      IF(INDEX(KEYWRD,'SYMAVG') .NE. 0) THEN
      DO 50 I=1,NATOM
      DO 50 J=1,NATOM 
      CEQUIV(I,J)=.FALSE.
      IF(ABS(ABS(CH(I))-ABS(CH(J))) .LT. 1.D-5)  CEQUIV(I,J)=.TRUE.
   50 CONTINUE
      DO 60 I=1,NATOM
      IEQ=0
      QSC(I)=0.D0
      DO 70 J=1,NATOM 
      IF(CEQUIV(I,J)) THEN 
      QSC(I)=QSC(I)+ABS(Q(J)) 
      IEQ=IEQ+1
      ENDIF
   70 CONTINUE
      CH(I)=Q(I)/ABS(Q(I))*QSC(I)/IEQ
   60 CONTINUE
      WRITE(6,*) ' '
      WRITE(6,*)'   ELECTROSTATIC POTENTIAL CHARGES AVERAGED FOR'
      WRITE(6,*)'   SYMMETRY EQUIVALENT ATOMS'
      WRITE(6,*) ' '
      IF((INDEX(KEYWRD,'AM1') .NE. 0) .OR. 
     1(INDEX(KEYWRD,'MINDO') .NE. 0) .OR.
     2(INDEX(KEYWRD,'PM3') .NE. 0))THEN  
      WRITE(6,'(7X,''ATOM NO.    TYPE    CHARGE'')')
      DO 80 I=1,NATOM                                                  
         WRITE(6,FMT='(9X,I2,9X,A2,1X,F10.4)')I,ELEMNT(IAN(I)),
     1   CH(I)
   80 CONTINUE
      ELSE
      WRITE(6,'(7X,''ATOM NO.    TYPE    CHARGE   SCALED CHARGE'')')
      DO 90 I=1,NATOM                                                  
         WRITE(6,FMT='(9X,I2,9X,A2,1X,F10.4,2X,F10.4)')I,ELEMNT(IAN(I)),
     1   CH(I),CH(I)*SLOPE
   90 CONTINUE
      ENDIF
      ENDIF
      RETURN                                                            
      END                                                               
