      SUBROUTINE PDGRID
C
C     ROUTINE TO CALCULATE WILLIAMS SURFACE
C
      IMPLICIT REAL*8 (A-H,O-Z)
#include "SIZES"
      DIMENSION IZ(100),XYZ(3,100),VDERW(53),DIST(100)                          
      DIMENSION XMIN(3),XMAX(3),COORD(3,NUMATM)
      CHARACTER*40 FILIN,FILOUT,ALINE                                           
      COMMON /GEOM/   GEO(3,NUMATM)
      COMMON /GEOKST/ NATOMS,LABELS(NUMATM)
      COMMON /KEYWRD/ KEYWRD
C 
      COMMON /ABC/    CO(3,NUMATM),IAN(NUMATM),NATOM
      COMMON /PTS/    POTPT(3,MESP)
      COMMON /POTESP/ XC,YC,ZC,ESPNUC,ESPELE,NESP
C

      DATA VDERW/53*0.0/                                                        
      VDERW(1)=2.4                                                              
      VDERW(5)=3.0                                                              
      VDERW(6)=2.9                                                              
      VDERW(7)=2.7                                                              
      VDERW(8)=2.6                                                              
      VDERW(9)=2.55                                                             
      VDERW(15)=3.1                                                             
      VDERW(16)=3.05                                                            
      VDERW(17)=3.0                                                             
      VDERW(35)=3.15                                                            
      VDERW(53)=3.35                                                            
      SHELL=1.2                                               
      NESP=0
      GRID=0.8                                                
      CLOSER=0.D0
C     CHECK IF VDERW IS DEFINED FOR ALL ATOMS
C
C     CONVERT INTERNAL TO CARTESIAN COORDINATES
C
      CALL GMETRY(GEO,COORD)
C
C     STRIP COORDINATES AND ATOM LABEL FOR DUMMIES (I.E. 99)
C
      ICNTR = 0
      DO 10 I=1,NATOMS
      DO 20 J=1,3
  20        CO(J,I) = COORD(J,I)
      IF(LABELS(I) .EQ. 99) GOTO 10
      ICNTR = ICNTR + 1
      IAN(ICNTR) = LABELS(I)
   10 CONTINUE
      NATOM=ICNTR
C

      DO 30 I=1,NATOM                                                             
      J=IAN(I)                                                                   
      IF (VDERW(J).EQ.0.0) GO TO 302                                            
   30 CONTINUE                                                                  
      GO TO 303                                                                 
  302 CONTINUE
      WRITE(6,*) 'VAN DER WAAL RADIUS NOT DEFINED FOR ATOM',I
      WRITE(6,*) 'IN WILLIAMS SURFACE ROUTINE PDGRID!'
      STOP                                                                      
C     NOW CREATE LIMITS FOR A BOX                                                   
  303 DO 40 IX = 1,3                                                            
      XMIN(IX)= 100000.0                                                        
      XMAX(IX)=-100000.0                                                        
      DO 50 IA = 1,NATOM                                                           
      IF (CO(IX,IA)-XMIN(IX))4,5,5                                             
    4 XMIN(IX)=CO(IX,IA)                                                       
    5 IF (CO(IX,IA)-XMAX(IX))50,50,6                                             
    6 XMAX(IX)=CO(IX,IA)                                                       
   50 CONTINUE                                                                  
   40 CONTINUE                                                                  
C     ADD (OR SUBTRACT) THE MAXIMUM VDERW PLUS SHELL                                
      VDMAX=0.0                                                                 
      DO 60 I=1,53                                                             
      IF (VDERW(I).GT.VDMAX) VDMAX=VDERW(I)                                     
   60 CONTINUE                                                                  
      DO 70 I=1,3                                                              
      XMIN(I)=XMIN(I)-VDMAX-SHELL                                               
  70  XMAX(I)=XMAX(I)+VDMAX+SHELL                                               
C STEP GRID BACK FROM ZERO TO FIND STARTING POINTS                              
      XSTART=0.0                                                                
  701 XSTART=XSTART-GRID                                                        
      IF (XSTART.GT.XMIN(1)) GO TO 701                                          
      YSTART=0.0                                                                
  702 YSTART=YSTART-GRID                                                        
      IF (YSTART.GT.XMIN(2)) GO TO 702                                          
      ZSTART=0.0                                                                
  703 ZSTART=ZSTART-GRID                                                        
      IF (ZSTART.GT.XMIN(3)) GO TO 703                                          
      NPNT=0                                                                    
      ZGRID=ZSTART                                                              
   93 YGRID=YSTART                                                              
   92 XGRID=XSTART                                                              
   91 DO 80 L=1,NATOM
      JZ=IAN(L)                                                                  
      DIST(L)=SQRT((CO(1,L)-XGRID)**2+(CO(2,L)-YGRID)**2+                     
     1 (CO(3,L)-ZGRID)**2)                                                     
C     REJECT GRID POINT IF ANY ATOM IS TOO CLOSE                                    
      IF(DIST(L).LT.(VDERW(JZ)-CLOSER)) GO TO 81                                
  80  CONTINUE                                                                  
C BUT AT LEAST ONE ATOM MUST BE CLOSE ENOUGH                                    
      DO 90 L=1,NATOM
      JZ=IAN(L)                                                                  
      IF(DIST(L).GT.(VDERW(JZ)+SHELL)) GO TO 90                                 
      GO TO 83                                                                  
  90  CONTINUE                                                                  
      GO TO 81                                                                  
 83   NPNT=NPNT+1                                                               
      NESP=NESP+1                                     
      POTPT(1,NESP)=XGRID
      POTPT(2,NESP)=YGRID
      POTPT(3,NESP)=ZGRID  
 81   XGRID=XGRID+GRID                                                          
      IF (XGRID.LE.XMAX(1)) GO TO 91                                            
      YGRID=YGRID+GRID                                                          
      IF (YGRID.LE.XMAX(2)) GO TO 92                                            
      ZGRID=ZGRID+GRID                                                          
      IF (ZGRID.LE.XMAX(3)) GO TO 93                                            
      RETURN
      END                                                                       
