      SUBROUTINE OVLP(IC,IESP,IS,IP,NPR,NC,ICD)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C*****************************************************************************
C
C     OVLP CALCULATES THE OVERLAP INTEGRALS FOR A STO-6G BASIS SET.
C     THE RESULTING INTEGRALS ARE USED IN THE DEORTHOGONALIZATION PROCESS.
C     THE CODE WAS WRITTEN BY B.H.BESLER AND K.M.MERZ IN FEB. 1989 AT UCSF.
C
C     ON INPUT:  IC = LOOP INDEX 
C                IESP = LOOP INDEX
C                IS = NUMBER OF S ORBITALS
C                IP = NUMBER OF P ORBITALS
C                NPR = NUMBER OF PRIMITIVES
C                NC = NUMBER OF CONTRACTED FUNCTIONS
C
C     ON OUTPUT: OVL IS FILLED WITH THE OVERLAP INTEGRAL VALUE
C
C     FOR FURTHER INFO SEE: OBARA & SAIKA J.CHEM.PHYS. 1986,84,3963
C*****************************************************************************
      LOGICAL CALLED                                                    
      REAL*8 NAI,NAI1,NAI2                                              
#include "SIZES"                                                   
      COMMON /DENSTY/ P(MPACK),PA(MPACK),PB(MPACK)                      
      COMMON /POTESP/ XC,YC,ZC,ESPNUC,ESPELE,NESP                       
      COMMON /PTS/    POTPT(3,MESP)                        
      COMMON /ABC/    CO(3,NUMATM),IAN(NUMATM),NATOM                    
      COMMON /ESPQ/   ES(MESP),ESP(MESP)
      COMMON /EXPONT/ ZS(107),ZP(107),ZD(107)                           
      COMMON /STO6G/  ALLC(6,5,2),ALLZ(6,5,2)                           
      COMMON /ESPC/ CC(MAXPR),CEN(MAXPR,3),IAM(MAXPR,2),IND(MAXPR),    
     1EX(MAXPR),ESPI(MAXC,MAXC),FV(0:8,821),FAC(0:7),DEX(-1:96),TF(0:2),
     2TEMP(MAXPR),ITEMP(MAXPR),OVL(MAXC,MAXC)                           
      COMMON/X/ DX(MAXPR),DY(MAXPR),DZ(MAXPR),F1(MAXPR,6),F2(MAXPR,6),  
     1TD(MAXPR),CE(MAXPR,6),U(MAXPR,6),EXS(MAXPR,6),EXPN(MAXPR,6),      
     2NAI(MAXPR,6),EWCX(MAXPR,6),EWCY(MAXPR,6),EWCZ(MAXPR,6),F0(MAXPR,6)
     3,NAI1(MAXPR,6),NAI2(MAXPR,6)                                      
      DATA BOHR/0.529167D0/                                             
C
C     CALCULATE DISTANCE ARRAYS                                         
C
      PI=4.D0*ATAN(1.D0)                                                
      IPR=IC*ICD-ICD+1                                                        
      ISTART=IPR                                                        
      DO 10 I=ISTART,NPR                                                 
         DX(I)=CEN(IPR,1)-CEN(I,1)                                         
         DY(I)=CEN(IPR,2)-CEN(I,2)                                         
         DZ(I)=CEN(IPR,3)-CEN(I,3)                                         
         TD(I)=DX(I)**2+DY(I)**2+DZ(I)**2                                  
   10 CONTINUE                                                          
C
C     CALCULATE EXPONENT SUM                                            
C
      DO 20 I=ISTART,NPR                                                 
         DO 20 J=1,ICD                                                        
            EXS(I,J)=1.D0/(EX(IPR+J-1)+EX(I))                                 
            CE(I,J)=EX(IPR+J-1)*EX(I)*EXS(I,J)                                
   20 CONTINUE                                                          
C
C     CALCULATE EXPONENT WEIGHTED CENTERS                               
C
      DO 30 I=ISTART,NPR                                                 
         DO 30 J=1,ICD                                                        
          EWCX(I,J)=(EX(I)*CEN(I,1)+EX(IPR+J-1)
     1*CEN(IPR+J-1,1))*EXS(I,J)    
          EWCY(I,J)=(EX(I)*CEN(I,2)+EX(IPR+J-1)
     1*CEN(IPR+J-1,2))*EXS(I,J)    
          EWCZ(I,J)=(EX(I)*CEN(I,3)+EX(IPR+J-1)
     1*CEN(IPR+J-1,3))*EXS(I,J)    
   30 CONTINUE                                                          
      DO 40 I=1,NPR                                                     
         DO 40 J=1,ICD                                                       
            EXPN(I,J)=EXP(-CE(I,J)*TD(I))                                     
            NAI(I,J)=(PI*EXS(I,J))**1.5D0*EXPN(I,J)                           
            EXPN(I,J)=NAI(I,J)                                                
   40 CONTINUE                                                          
C
C     CALCULATE (S||P) ESP INTEGRALS                                    
C
      IF((IAM(IPR,1) .EQ. 0) .AND. (IS .NE. IP)) THEN                   
      NP=IS+1                                                           
      DO 50 I=NP,NPR                                                    
         DO 50 J=1,ICD                                                       
            GO TO (11,12,13),IAM(I,2)                                          
   11       NAI(I,J)=(EWCX(I,J)-CEN(I,1))*EXPN(I,J)                           
            go TO 50                                                           
   12       NAI(I,J)=(EWCY(I,J)-CEN(I,2))*EXPN(I,J)                           
            GO TO 50                                                           
   13       NAI(I,J)=(EWCZ(I,J)-CEN(I,3))*EXPN(I,J)                           
   50 CONTINUE                                                          
      ENDIF                                                             
C
C     CALCULATE (P||S) ESP INTEGRALS                                    
C
      IF((IAM(IPR,1) .EQ. 1) .AND. (IS .NE. IP)) THEN                   
      NP=IS+1                                                           
      DO 60 I=	ISTART,NPR                                                    
         DO 60 J=1,ICD                                                       
            GO TO (14,15,16),IAM(IPR+J-1,2)                                    
   14       NAI(I,J)=(EWCX(I,J)-CEN(IPR+J-1,1))*EXPN(I,J)                     
            GO TO 60                                                           
   15       NAI(I,J)=(EWCY(I,J)-CEN(IPR+J-1,2))*EXPN(I,J)                     
            GO TO 60                                                           
   16       NAI(I,J)=(EWCZ(I,J)-CEN(IPR+J-1,3))*EXPN(I,J)                     
   60 CONTINUE                                                          
      ENDIF                                                             
C
C     CALCULATE (P||P) ESP INTEGRALS                                    
C
      IF((IAM(IPR,1) .EQ. 1) .AND. (IS .NE. IP)) THEN                   
      DO 70 I=ISTART,NPR                                                
         DO 70 J=1,ICD                                                       
            GO TO (17,18,19),IAM(I,2)                                          
   17       NAI(I,J)=(EWCX(I,J)-CEN(I,1))*NAI(I,J)                            
            IF(IAM(IPR+J-1,2) .EQ. IAM(I,2)) 
     $NAI(I,J)=NAI(I,J)+EXS(I,J)*0.5D0 
     1      *EXPN(I,J)                                                        
            GO TO 70                                                          
   18       NAI(I,J)=(EWCY(I,J)-CEN(I,2))*NAI(I,J)                            
            IF(IAM(IPR+J-1,2) .EQ. IAM(I,2)) 
     $NAI(I,J)=NAI(I,J)+EXS(I,J)*0.5D0 
     1      *EXPN(I,J)                                                        
            GO TO 70                                                           
   19       NAI(I,J)=(EWCZ(I,J)-CEN(I,3))*NAI(I,J)                            
            IF(IAM(IPR+J-1,2) .EQ. IAM(I,2)) 
     $NAI(I,J)=NAI(I,J)+EXS(I,J)*0.5D0 
     1      *EXPN(I,J)                                                        
   70 CONTINUE                                                          
      ENDIF                                                             
      IPS=IC*ICD-ICD+1                                                        
      DO 80 I=IC,NC                                                    
         JPS=I*ICD-ICD+1                                                         
         OVL(IC,I)=0.D0                                                    
         DO 90 J=JPS,JPS+ICD-1                                                 
            DO 90 K=IPS,IPS+ICD-1                                                 
               OVL(IC,I)=OVL(IC,I)+CC(J)*CC(K)*NAI(J,K-IPS+1)  
   90    CONTINUE                                                          
         OVL(I,IC)=OVL(IC,I)
   80 CONTINUE
      RETURN                                                            
      END                                                               
