      SUBROUTINE NAICAS(ISC,IS,IP,NPR,NC,IPE,IPX,ICD)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C**************************************************************************
C
C     THIS SUBROUTINE EVALUATES (S|S) , (S|P) TYPE NUCLEAR ATTRACTION
C     INTEGRALS FOR A STO-NG BASIS SET
C     WRITTEN BY B.H. BESLER AT FORD SCIENTIFIC RESEARCH LABS IN
C     SDEPTEMBER 1989.
C
C     ON INPUT:  IC = LOOP INDEX OF THE GAUSSIAN
C                IESP = LOOP INDEX OF THE ESP POINT
C                IPE = INDEX OF LAST Px PRIMITIVE
C                IPX = NUMBER OF Px PRIMITIVES
C                IS = NUMBER OS S ORBITALS
C                ISC = NUMBER OF CONTRACTED S ORBITALS
C                IP = NUMBER OF P ORBITALS
C                NPR = NUMBER OF PRIMITIVES
C                NC = NUMBER OF CONTRACTED FUNCTIONS
C
C
C     FOR MORE INFO SEE: OBARA&SAIKA J.CHEM.PHYS. 1986,84,3963.
C**************************************************************************
#include "SIZES"                                                   
      REAL*8 NAI,NAI1,NAI2                                              
      CHARACTER*80 KEYWRD
      COMMON/KEYWRD/ KEYWRD
      COMMON/ESPF/ AL((NUMATM+4)**2),A(NUMATM,NUMATM),B(NUMATM),
     1Q(NUMATM+4),CESPM(MAXC,MAXC)
      COMMON /INDX/ INDC(MAXC)
      COMMON /DENSTY/ P(MPACK),PA(MPACK),PB(MPACK)                      
      COMMON /POTESP/ XC,YC,ZC,ESPNUC,ESPELE,NESP                       
      COMMON /PTS/    POTPT(3,MESP)                        
      COMMON /ABC/    CO(3,NUMATM),IAN(NUMATM),NATOM                    
      COMMON /ESPQ/   ES(MESP),ESP(MESP)
      COMMON /EXPONT/ ZS(107),ZP(107),ZD(107)                           
      COMMON /STO6G/  ALLC(6,5,2),ALLZ(6,5,2)                           
      COMMON /ESPC/ CC(MAXPR),CEN(MAXPR,3),IAM(MAXPR,2),IND(MAXPR),    
     1EX(MAXPR),ESPI(MAXC,MAXC),FV(0:8,821),FAC(0:7),DEX(-1:96),TF(0:2),
     2TEMP(MAXPR),ITEMP(MAXPR),OVL(MAXC,MAXC),EXSR(MAXPR,6)             
      COMMON/X/ DX(MAXPR),DY(MAXPR),DZ(MAXPR),F1(MAXPR,6),F2(MAXPR,6),  
     1TD(MAXPR),CE(MAXPR,6),U(MAXPR,6),EXS(MAXPR,6),EXPN(MAXPR,6),      
     2NAI(MAXPR,6),EWCX(MAXPR,6),EWCY(MAXPR,6),EWCZ(MAXPR,6),F0(MAXPR,6)
     3,NAI1(MAXPR,6),NAI2(MAXPR,6)                                      
      DATA BOHR/0.529167D0/                                             
C
C     CALCULATE DISTANCE ARRAYS                                         
C
      WRITE(6,*)
      PI=4.D0*ATAN(1.D0)                                                
      IPX2=2*IPX
C     IF THIS IS A RESTART RUN, READ IN RESTART INFO
      IF(INDEX(KEYWRD,'ESPRST') .NE. 0) THEN
      OPEN(UNIT=15,FILE='ESP.DUMP',STATUS='OLD',FORM='UNFORMATTED')
      READ(15) JSTART,IESPS
      IF(JSTART .EQ. ISC*2) THEN
      CLOSE(15)
      RETURN
      ENDIF
      DO 10 I=1,NESP
      READ(15) ES(I)
   10 CONTINUE
      CLOSE(15)
C
      JSTART=JSTART+1
      ELSE
      JSTART=1
      ENDIF
      NP=IS+1                                                           
      DO 20 IC=JSTART,ISC
      IPR=IC*ICD-ICD+1
      ISTART=IPR                                                        
      DO 30 I=ISTART,IPE
         DX(I)=CEN(IPR,1)-CEN(I,1)
         DY(I)=CEN(IPR,2)-CEN(I,2)
         DZ(I)=CEN(IPR,3)-CEN(I,3)
         TD(I)=DX(I)**2+DY(I)**2+DZ(I)**2
   30 CONTINUE                                                          
C
C     CALCULATE EXPONENT SUM                                            
C
      DO 40 I=ISTART,IPE
         DO 40 J=1,ICD
            EXSR(I,J)=EX(IPR+J-1)+EX(I)
            EXS(I,J)=1.D0/EXSR(I,J)
            CE(I,J)=EX(IPR+J-1)*EX(I)*EXS(I,J)
            EXPN(I,J)=EXP(-CE(I,J)*TD(I))
   40 CONTINUE
C
C     CALCULATE EXPONENT WEIGHTED CENTERS                               
C
      DO 50 I=ISTART,IPE
         DO 50 J=1,ICD
            EWCX(I,J)=(EX(I)*CEN(I,1)+EX(IPR+J-1)
     1*CEN(IPR+J-1,1))*EXS(I,J)    
            EWCY(I,J)=(EX(I)*CEN(I,2)+EX(IPR+J-1)
     1*CEN(IPR+J-1,2))*EXS(I,J)    
            EWCZ(I,J)=(EX(I)*CEN(I,3)+EX(IPR+J-1)
     1*CEN(IPR+J-1,3))*EXS(I,J)    
   50 CONTINUE                                                          
C
C     BEGIN LOOP OVER ESP POINTS
C
      DO 60 IESP=1,NESP
      POTP1=POTPT(1,IESP)/BOHR
      POTP2=POTPT(2,IESP)/BOHR
      POTP3=POTPT(3,IESP)/BOHR
C  
C     BEGIN LOOP OVER COMPONENTS OF CONTRACTED FUNCTION IC
C
      DO 70 J=1,ICD
C
C     CALCULATE DISTANCE BETWEEN EXPONENT WEIGHTED AND PROBE POINT      
C
      DO 80 I=ISTART,IPE                                                 
            U(I,J)=((EWCX(I,J)-POTP1)**2+(EWCY(I,J)-POTP2)**2+                
     1      (EWCZ(I,J)-POTP3)**2)*EXSR(I,J)                                   
            NAI(I,J)=SQRT(PI/U(I,J))                                          
   80 CONTINUE                                                          
C
C     CALCULATE ESP INTEGRALS                                           
C
      DO 110 I=ISTART,IPE                                                 
            IF(U(I,J) .LE. TF(0)) THEN                                        
            IREF=DNINT(U(I,J)*20.D0)                                          
             REF=0.05D0*IREF                                                   
             RES=U(I,J)-REF                                                    
             TERM=1.D0                                                         
             F0(I,J)=0.D0                                                      
             DO 120 K=0,6                                                       
                F=FV(K,IREF+1) 
                TS=F*TERM*FAC(K) 
                TERM=-TERM*RES    
                F0(I,J)=F0(I,J)+TS 
  120        CONTINUE                                                          
              ELSE
              F0(I,J)=NAI(I,J)*0.5D0

             ENDIF
  110        CONTINUE
             DO 130 I=NP,IPE
             IF(U(I,J) .LE. TF(1)) THEN                                        
             IREF=DNINT(U(I,J)*20.D0)                                          
             REF=0.05D0*IREF                                                   
             RES=U(I,J)-REF                                                    
             TERM1=1.D0                                                        
             F1(I,J)=0.D0                                                      
             DO 140 K=0,6                                                      
                 FI=FV(K+1,IREF+1)  
                 TS1=FI*TERM1*FAC(K) 
                 TERM1=-TERM1*RES  
                 F1(I,J)=F1(I,J)+TS1
  140        CONTINUE                                                          
      ELSE
      F1(I,J)=NAI(I,J)*0.25D0/U(I,J)
      ENDIF
  130 CONTINUE                                                          
      DO 150 I=ISTART,IS
  150 U(I,J)=2.D0*PI*EXS(I,J)*EXPN(I,J)*F0(I,J)
      NP=IS+1                                                           
      DO 160 I=NP,IPE                                                
         NAI(I,J)=2.D0*PI*EXS(I,J)*EXPN(I,J)*F0(I,J)                       
         NAI1(I,J)=2.D0*PI*EXS(I,J)*EXPN(I,J)*F1(I,J)                      
  160 CONTINUE                                                          
C
C     CALCULATE (S||P) ESP INTEGRALS                                    
C
      IF((IAM(IPR,1) .EQ. 0) .AND. (IS .NE. IP)) THEN                   
         DO 170 I=NP,IPE                                                    
  170       U(I,J)=(EWCX(I,J)-CEN(I,1))*NAI(I,J)
     1-(EWCX(I,J)-POTP1)*NAI1(I,J)
         DO 180 I=IPE+1,IPE+1+IPX
  180       U(I,J)=(EWCY(I-IPX,J)-CEN(I-IPX,2))*NAI(I-IPX,J)
     1-(EWCY(I-IPX,J)-POTP2)*NAI1(I-IPX,J)
         DO 190 I=IPE+1+IPX,NPR
  190       U(I,J)=(EWCZ(I-IPX2,J)-CEN(I-IPX2,3))*NAI(I-IPX2,J)
     1-(EWCZ(I-IPX2,J)-POTP3)*NAI1(I-IPX2,J)
      ENDIF                                                             
   70 CONTINUE
      IPS=IC*ICD-ICD+1                                                        
      DO 200 I=IC,NC                                                    
         JPS=I*ICD-ICD+1
         ESPI(I,IC)=0.D0
         DO 210 J=JPS,JPS+ICD-1
            DO 210 K=IPS,IPS+ICD-1
               ESPI(I,IC)=ESPI(I,IC)+CC(J)*CC(K)*U(J,K-IPS+1) 
  210       CONTINUE                                        
      ES(IESP)=ES(IESP)+2.D0*CESPM(INDC(I),INDC(IC))*ESPI(I,IC)
  200 CONTINUE
      ES(IESP)=ES(IESP)-CESPM(INDC(IC),INDC(IC))*ESPI(IC,IC)
   60 CONTINUE
C     WRITE OUT RESTART INFORMATION
      OPEN(UNIT=15,FILE='ESP.DUMP',FORM='UNFORMATTED')
      IESPS=0
      WRITE(15) IC,IESPS
      DO 220 I=1,NESP 
      WRITE(15) ES(I)
  220 CONTINUE
      CLOSE(15)
C
      WRITE(6,fmt='(a,f6.2,a)')
     1'NAICAS DUMPED: ',100.D0/ISC*IC,' PERCENT COMPLETE' 
   20 CONTINUE
      RETURN                                                            
      END                                                               
