      SUBROUTINE NAICAP(ISC,IS,IP,NPR,NC,IPE,IPX,ICD)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C**************************************************************************
C     THIS ROUTINE EVALUATES (P|P) NUCLEAR ATTRACTION INTEGRALS OVER
C
C     A STO-NG BASIS SET. 
C     WRITTEN BY B.H. BESLER AT FORD SCIENTIFIC RESEARCH LABS IN
C     SEPT. 1989
C
C     ON INPUT:  IC = LOOP INDEX OF THE GAUSSIAN
C                ICD = CONTRACTION DEPTH OF BASIS SET
C                IESP = LOOP INDEX OF THE ESP POINT
C                IS = NUMBER OS S PRIMITIVES
C                IPE = INDEX OF LAST PX PRIMITIVE
C                IPX = NUMBER OF PX PRIMITIVES
C                IS = NUMBER OS S PRIMITIVES
C                ISC = NUMBER OF CONTRACTED
C                NPR = NUMBER OF PRIMITIVES
C                NC = NUMBER OF CONTRACTED FUNCTIONS
C
C
C     FOR MORE INFO SEE: OBARA&SAIKA J.CHEM.PHYS. 1986,84,3963.
C**************************************************************************
#include "SIZES"                                                   
      REAL*8 NAI,NAI1,NAI2                                              
      CHARACTER*80 KEYWRD
      COMMON /KEYWRD/ KEYWRD
      COMMON/ESPF/ AL((NUMATM+4)**2),A(NUMATM,NUMATM),B(NUMATM),
     1Q(NUMATM+4),CESPM(MAXC,MAXC)
      COMMON /INDX/ INDC(MAXC)
      COMMON /DENSTY/ P(MPACK),PA(MPACK),PB(MPACK)                      
      COMMON /POTESP/ XC,YC,ZC,ESPNUC,ESPELE,NESP                       
      COMMON /PTS/    POTPT(3,MESP)                        
      COMMON /ABC/    CO(3,NUMATM),IAN(NUMATM),NATOM                    
      COMMON /ESPQ/   ES(MESP),ESP(MESP)
      COMMON /EXPONT/ ZS(107),ZP(107),ZD(107)                           
      COMMON /STO6G/  ALLC(6,5,2),ALLZ(6,5,2)                           
      COMMON /ESPC/ CC(MAXPR),CEN(MAXPR,3),IAM(MAXPR,2),IND(MAXPR),    
     1EX(MAXPR),ESPI(MAXC,MAXC),FV(0:8,821),FAC(0:7),DEX(-1:96),TF(0:2),
     2TEMP(MAXPR),ITEMP(MAXPR),OVL(MAXC,MAXC),EXSR(MAXPR,6)             
      COMMON/X/ DX(MAXPR),DY(MAXPR),DZ(MAXPR),F1(MAXPR,6),F2(MAXPR,6),  
     1TD(MAXPR),CE(MAXPR,6),U(MAXPR,6),EXS(MAXPR,6),EXPN(MAXPR,6),      
     2NAI(MAXPR,6),EWCX(MAXPR,6),EWCY(MAXPR,6),EWCZ(MAXPR,6),F0(MAXPR,6)
     3,NAI1(MAXPR,6),NAI2(MAXPR,6)                                      
      COMMON/FP/ PF0(MPAUX2),PF1(MPAUX2),PF2(MPAUX2),ID(MPAUX),   
     1PEXS(MPAUX2),PCE(MPAUX2),PEXPN(MPAUX2),PTD(MPAUX2),
     2PEWCX(MPAUX2),PEWCY(MPAUX2),PEWCZ(MPAUX2),IRD(MPAUX2)
      DATA BOHR/0.529167D0/                                             
C     SET NUMBER OF EQUALLY SPACED DUMPS
      IDN=10
C
      IDC=0
      WRITE(6,*)
      IPX2=2*IPX
      PI=4.D0*ATAN(1.D0)                                                
      NP=IS+1
C     SETUP INDEX ARRAY
      DO 10 I=NP,IPE
      IRD(I)=I-IS
      IRD(I+IPX)=I-IS
      IRD(I+IPX2)=I-IS
   10 CONTINUE
C
C     CALCULATE QUANTITIES INVARIANT WITH ESP POINT FOR
C     (P|P) ESP INTEGRALS
C
      IL=L
      L=0
      DO 20 I=NP,IPE
      DO 30 J=I,IPE
      L=L+1
      PTD(L)=(CEN(I,1)-CEN(J,1))**2+(CEN(I,2)-CEN(J,2))**2+
     1(CEN(I,3)-CEN(J,3))**2 
      PEXS(L)=1.d0/(EX(I)+EX(J))
      PCE(L)=EX(I)*EX(J)*PEXS(L)
      PEXPN(L)=EXP(-PCE(L)*PTD(L)) 
      PEWCX(L)=(EX(I)*CEN(I,1)+EX(J)*CEN(J,1))*PEXS(L) 
      PEWCY(L)=(EX(I)*CEN(I,2)+EX(J)*CEN(J,2))*PEXS(L) 
      PEWCZ(L)=(EX(I)*CEN(I,3)+EX(J)*CEN(J,3))*PEXS(L) 
   30 CONTINUE
C
C     SET UP OTHER INDEX ARRAY FOR PACKED SYMMETRIC ARRAY
C     STORAGE
C
      ID(I-IS)=L-IPX
   20 CONTINUE
C
C     READ IN RESTART INFORMATION IF THIS IS A RESTART
C
      IF(INDEX(KEYWRD,'ESPRST') .NE. 0) THEN
      OPEN(UNIT=15,FILE='ESP.DUMP',FORM='UNFORMATTED')
      READ(15) JSTART,IESPS
      IF(JSTART .NE. ISC*2) THEN
      IESPS=0
      CLOSE(15)
      GOTO 5
      ENDIF
      DO 40 I=1,NESP
      READ(15) ES(I)
   40 CONTINUE
      CLOSE(15)
      IDC=FLOAT(IESPS)/FLOAT(NESP)*10
      ELSE
      IESPS=0
      ENDIF
    5 CONTINUE
C
C     LOOP OVER ESP PROBE POINTS
C
      DO 50 IESP=IESPS+1,NESP
      POTP1=POTPT(1,IESP)/BOHR
      POTP2=POTPT(2,IESP)/BOHR
      POTP3=POTPT(3,IESP)/BOHR
C     CALCULATE QUANTITY U 
C
      L=0
      DO 60 I=NP,IPE
      DO 60 J=I,IPE
      L=L+1
      PTD(L)=((PEWCX(L)-POTP1)**2+(PEWCY(L)-POTP2)**2+                
     1      (PEWCZ(L)-POTP3)**2)/PEXS(L)                                   
            PCE(L)=SQRT(PI/PTD(L))                                          
   60 CONTINUE
C
C     CALCULATE F0, F1, AND F2(U) USING TAYLOR SERIES
C     OR ASYMPTOTIC EXPANSION
C
      IL=L
      L=0
      DO 70 I=1,IL
      IF(PTD(I) .LE. TF(0)) THEN
      IREF=DNINT(PTD(I)*20.D0)
      REF=0.05D0*IREF
      RES=PTD(I)-REF
      TERM=1.D0
      PF0(I)=0.D0 
      DO 80 K=0,6
      F=FV(K,IREF+1)
      TS=F*TERM*FAC(K)
      TERM=-TERM*RES
      PF0(I)=PF0(I)+TS
   80 CONTINUE 
      ELSE
      PF0(I)=PCE(I)*0.5D0
      ENDIF
      IF(PTD(I) .LE. TF(1)) THEN
      IREF=DNINT(PTD(I)*20.D0)
      REF=0.05D0*IREF
      RES=PTD(I)-REF
      TERM1=1.D0
      PF1(I)=0.D0 
      DO 90 K=0,6
      FI=FV(K+1,IREF+1)
      TS1=FI*TERM1*FAC(K)
      TERM1=-TERM1*RES
      PF1(I)=PF1(I)+TS1
   90 CONTINUE 
      ELSE
      PF1(I)=PCE(I)*0.25D0/PTD(I)
      ENDIF
      IF(PTD(I) .LE. TF(2)) THEN
      IREF=DNINT(PTD(I)*20.D0)
      REF=0.05D0*IREF
      RES=PTD(I)-REF
      TERM2=1.D0
      PF2(I)=0.D0 
      DO 100 K=0,6
      FII=FV(K+2,IREF+1)
      TS2=FII*TERM2*FAC(K)
      TERM2=-TERM2*RES
      PF2(I)=PF2(I)+TS2
  100 CONTINUE 
      ELSE
      PF2(I)=PCE(I)*0.375D0/(PTD(I)*PTD(I))   
      ENDIF
   70 CONTINUE
C
C     CALCULATE (S||S) TYPE INTEGRALS
C
      DO 110 I=1,IL
      PF0(I)=2.D0*PI*PEXS(I)*PEXPN(I)*PF0(I)
      PTD(I)=PF0(I)
      PF1(I)=2.D0*PI*PEXS(I)*PEXPN(I)*PF1(I)
      PF2(I)=2.D0*PI*PEXS(I)*PEXPN(I)*PF2(I)
  110 CONTINUE
C
      DO 120 IC=ISC+1,NC
      IPR=IC*ICD-ICD+1                                                        
      ISTART=IPR                                                        
      DO 130 J=1,ICD
C
C     CALCULATE (P||S) ESP INTEGRALS                                    
C
      IF((IAM(IPR,1) .EQ. 1) .AND. (IS .NE. IP)) THEN                   
      DO 140 I=ISTART,NPR                                                
      IN=IPR+J-1
      IR=IRD(I)+ID(IRD(IN))
      IR2=ID(IRD(I))+IRD(IN)
         IF(IR2 .LE. IR ) IR=IR2
            GO TO (14,15,16),IAM(IN,2)                                    
   14       NAI2(I,J)=(PEWCX(IR)-CEN(IN,1))*PF1(IR)-PF2(IR)*         
     1      (PEWCX(IR)-POTP1)                                                 
            NAI(I,J)=(PEWCX(IR)-CEN(IN,1))*PF0(IR)-PF1(IR)*           
     1      (PEWCX(IR)-POTP1)                                                 
            GO TO 140                                                           
   15       NAI2(I,J)=(PEWCY(IR)-CEN(IN,2))*PF1(IR)-PF2(IR)*         
     1      (PEWCY(IR)-POTP2)                                                 
            NAI(I,J)=(PEWCY(IR)-CEN(IN,2))*PF0(IR)-PF1(IR)*           
     1      (PEWCY(IR)-POTP2)                                                 
            GO TO 140                                                           
   16       NAI2(I,J)=(PEWCZ(IR)-CEN(IN,3))*PF1(IR)-PF2(IR)*         
     1      (PEWCZ(IR)-POTP3)                                                 
            NAI(I,J)=(PEWCZ(IR)-CEN(IN,3))*PF0(IR)-PF1(IR)*           
     1      (PEWCZ(IR)-POTP3)                                                 
  140 CONTINUE
      ENDIF                                                             
C
C     CALCULATE (P||P) ESP INTEGRALS                                    
C
      IF((IAM(IPR,1) .EQ. 1) .AND. (IS .NE. IP)) THEN                   
      DO 150 I=ISTART,NPR                                                    
         IN=IPR+J-1
      IR=IRD(I)+ID(IRD(IN))
      IR2=ID(IRD(I))+IRD(IN)
         IF(IR2 .LE. IR ) IR=IR2
            GO TO (17,18,19),IAM(I,2)                                          
   17       NAI(I,J)=(PEWCX(IR)-CEN(I,1))*NAI(I,J)-(PEWCX(IR)-POTP1)*         
     1      NAI2(I,J)                                                         
            IF(IAM(IN,2) .EQ. IAM(I,2)) NAI(I,J)=NAI(I,J)+PEXS(IR)*
     1      0.5D0*(PTD(IR)-PF1(IR))                                          
            GO TO 150                                                           
   18       NAI(I,J)=(PEWCY(IR)-CEN(I,2))*NAI(I,J)-(PEWCY(IR)-POTP2)*         
     1      NAI2(I,J)                                                         
            IF(IAM(IN,2) .EQ. IAM(I,2)) NAI(I,J)=NAI(I,J)+PEXS(IR)*
     1      0.5D0*(PTD(IR)-PF1(IR))                                          

            GO TO 150                                                           
   19       NAI(I,J)=(PEWCZ(IR)-CEN(I,3))*NAI(I,J)-(PEWCZ(IR)-POTP3)*         
     1      NAI2(I,J)                                                         
            IF(IAM(IN,2) .EQ. IAM(I,2)) NAI(I,J)=NAI(I,J)+PEXS(IR)*
     1      0.5D0*(PTD(IR)-PF1(IR))                                          
  150 CONTINUE                                                          
      ENDIF                                                             
  130 CONTINUE
C
C     FORM INTEGRALS OVER CONTRACTED FUNCTIONS
C
      IPS=IC*ICD-ICD+1                                                        
      DO 160 I=IC,NC                                                    
         JPS=I*ICD-ICD+1
         ESPI(I,IC)=0.D0
         DO 170 J=JPS,JPS+ICD-1
            DO 170 K=IPS,IPS+ICD-1
               ESPI(I,IC)=ESPI(I,IC)+CC(J)*CC(K)*NAI(J,K-IPS+1) 
  170       CONTINUE                                        
      ES(IESP)=ES(IESP)+2.D0*CESPM(INDC(I),INDC(IC))*ESPI(I,IC)
  160 CONTINUE
      ES(IESP)=ES(IESP)-CESPM(INDC(IC),INDC(IC))*ESPI(IC,IC)
  120 CONTINUE
C
C     WRITE OUT RESTART INFORMATION EVERY NESP/10 POINTS
C
      IF(MOD(IESP,NESP/IDN) .EQ. 0) THEN
      OPEN(UNIT=15,FILE='ESP.DUMP',FORM='UNFORMATTED')
      JSTART=ISC*2
      WRITE(15) JSTART,IESP
      DO 180 I=1,NESP
      WRITE(15) ES(I)
  180 CONTINUE
      CLOSE(15)
      IDC=IDC+1
      WRITE(6,FMT='(A,F6.2,A)')
     1'NAICAP DUMPED: ',100.D0/IDN*IDC,' PERCENT COMPLETE'
      ENDIF
   50 CONTINUE
      RETURN                                                            
      END                                                              
