C***************************************************************************
      SUBROUTINE FSUB(N,X,FVAL)                                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C***************************************************************************
C
C     CALCULATE THE FM(T). KINDLY SUPPLIED BY RUS PITZER AND CLEANED UP 
C     BY K.M.MERZ IN FEB. 1989 AT UCSF.
C
C     ON INPUT:  N = INDEX
C                X = EXPONENT
C     ON OUTPUT: FVAL = VALUE OF THE FUNCTION
C
C     FOR MORE DETAILS SEE: OBARA AND SAIKA J. CHEM. PHYS. 1986,84,3963
C***************************************************************************
      DIMENSION FF(21),TERM(200),A(10),RT(10)                           
      DATA A0, A1S2, PIE4, A1                                           
     1   /0.0D0,0.5D0,0.7853981633974483096156608D0,1.0D0/              
      DATA XSW /24.0D0/                                                 
      E=A1S2*EXP(-X)                                                    
      FAC0=N                                                            
      FAC0=FAC0+A1S2                                                    
      IF(X.GT.XSW) GO TO 150                                             
C
C     USE POWER SERIES                                      
C
  100 FAC=FAC0                                                          
      TERM0=E/FAC                                                       
      SUM=TERM0                                                         
      KU=(X-FAC0)                                                       
      IF(KU.LT.1) GO TO 130                                              
C
C     SUM INCREASING TERMS FORWARDS                          
C
      DO 120 K=1,KU                                                      
         FAC=FAC+A1                                                        
         TERM0=TERM0*X/FAC                                                 
         SUM=SUM+TERM0                                                     
  120 CONTINUE
  130 I=1                                                               
      FAC=FAC+A1                                                        
      TERM(1)=TERM0*X/FAC                                               
      SUMA=SUM+TERM(1)                                                  
      IF(SUM.EQ.SUMA) GO TO 185                                          
  140 I=I+1                                                             
      FAC=FAC+A1                                                        
      TERM(I)=TERM(I-1)*X/FAC                                           
      SUM1=SUMA                                                         
      SUMA=SUMA+TERM(I)                                                 
      IF(SUM1-SUMA) 140,185,140                                            
C
C     USE ASYMPTOTIC SERIES                                 
C
  150 SUM=SQRT(PIE4/X)                                                  
      IF(N.EQ.0) GO TO 170                                               
      FAC=-A1S2                                                         
      DO 160 K=1,N                                                       
         FAC=FAC+A1                                                        
         SUM=SUM*FAC/X                                                     
  160 CONTINUE
  170 I=1                                                               
      TERM(1)=-E/X                                                      
      SUMA=SUM+TERM(1)                                                  
      IF(SUM.EQ.SUMA) GO TO 185                                          
      FAC=FAC0                                                          
      KU=(X+FAC0-A1)                                                    
      DO 180 I=2,KU                                                      
         FAC=FAC-A1                                                        
         TERM(I)=TERM(I-1)*FAC/X                                           
         SUM1=SUMA                                                         
         SUMA=SUMA+TERM(I)                                                 
         IF(SUM1.EQ.SUMA) GO TO 185                                         
  180 CONTINUE
C
C     XSW SET TOO LOW. USE POWER SERIES.                   
C
      GO TO 100                                                         
C
C     SUM DECREASING TERMS BACKWARDS                        
C
  185 SUM1=A0                                                           
      DO 190 K=1,I                                                       
         SUM1=SUM1+TERM(I+1-K)                                             
  190 CONTINUE
      FF(N+1)=SUM+SUM1                                                  
C
C     USE RECURRENCE RELATION                               
C
      IF(N.EQ.0) GOTO 200                                               
      DO 195 K=1,N                                                       
         FAC0=FAC0-A1                                                      
         FF(N+1-K)=(E+X*FF(N+2-K))/FAC0                                    
  195 CONTINUE
  200 FVAL=FF(N+1)                                                      
      RETURN                                                            
      END                                                               
