C****************************************************************************
      SUBROUTINE ESPFIT(IDIP,NATOM,NESP,IZ,ESP,POTPT,CO,              
     1DX,DY,DZ,RMS,RRMS)                                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                                         
#include "SIZES"
C****************************************************************************
C
C     THIS ROUTINE FITS THE ELECTROSTATIC POTENTIAL TO A MONOPOLE 
C     EXPANSION. FITTING TO THE DIPOLE MONENT CAN ALSO BE DONE.
C     THIS ROUTINE WAS WRITTEN BY B.H.BESLER AND K.M.MERZ
C     IN FEB. 1989 AT UCSF.
C
C     ON INPUT:  IDIP = FLAG TO INDICATE IF THE DIPOLE IS FIT
C                NATOM = NUMBER OF ATOMS
C                NESP = NUMBER OF ESP POINTS
C                IZ = MOLECULAR CHARGE
C                ESP = TOTAL ESP AT THE POINTS
C                POTPT = ESP POINTS
C                CO = COORDINATES
C                DX = X COMPONENT OF THE DIPOLE
C                DY = Y COMPONENT OF THE DIPOLE
C                DZ = Z COMPONENT OF THE DIPOLE
C
C     ON OUTPUT: Q = ESP CHARGES
C                RMS = ROOT MEAN SQUARE FIT
C                RRMS = RELATIVE ROOT MEAN SQUARE FIT
C
C     FOR MORE DETAILS SEE: BESLER,MERZ,KOLLMAN J. COMPUT. CHEM. (IN PRESS)
C****************************************************************************
      COMMON/ESPF/ AL((NUMATM+4)**2),A(NUMATM,NUMATM),B(NUMATM),
     1Q(NUMATM+4),QSC(NUMATM+4),CF
      DIMENSION CO(3,*),ESP(*),POTPT(3,*)
      BOHR = 0.529167D00                                                
C     CONVERSION FACTOR FOR DEBYE TO ATOMIC UNITS
      CF=5.2917715D-11*1.601917D-19/3.33564D-30                                
C
C     THE FOLLOWING SETS UP THE LINEAR EQUATION A*Q=B 
C     SET UP THE A(J,K) ARRAY
C
      DO 10  K=1,NATOM                                                 
         DO 20  J=1,NATOM                                                 
         DO 20  I=1,NESP                                                  
            RIK=SQRT((CO(1,K)-POTPT(1,I))**2+(CO(2,K)-POTPT(2,I))**2          
     1      +(CO(3,K)-POTPT(3,I))**2)/BOHR                                    
            RIJ=SQRT((CO(1,J)-POTPT(1,I))**2+(CO(2,J)-POTPT(2,I))**2          
     1      +(CO(3,J)-POTPT(3,I))**2)/BOHR                                    
            A(J,K)=A(J,K)+1.D0/RIK*1.D0/RIJ                                   
   20    CONTINUE
         A(NATOM+1,K)=1.D0                                                 
         A(K,NATOM+1)=1.D0                                                 
         A(NATOM+1,NATOM+1)=0.D0                                           
         IF(IDIP .EQ. 1) THEN                                              
         A(NATOM+2,K)=CO(1,K)/BOHR                                         
         A(K,NATOM+2)=CO(1,K)/BOHR                                         
         A(NATOM+2,NATOM+2)=0.D0                                           
         A(NATOM+3,K)=CO(2,K)/BOHR                                         
         A(K,NATOM+3)=CO(2,K)/BOHR                                         
         A(NATOM+3,NATOM+3)=0.D0                                           
         A(NATOM+4,K)=CO(3,K)/BOHR                                         
         A(K,NATOM+4)=CO(3,K)/BOHR                                         
         A(NATOM+4,NATOM+4)=0.D0                                           
         ENDIF                                                             
   10 CONTINUE                                                          
      B(NATOM+1)=FLOAT(IZ)                                              
      B(NATOM+2)=DX/CF                                                  
      B(NATOM+3)=DY/CF                                                  
      B(NATOM+4)=DZ/CF                                                  
C
C     INSERT CHARGE AND DIPOLAR (IF DESIRED) CONSTRAINTS
C
      IF(IDIP .EQ. 1) THEN                                              
      L=0                                                               
      DO 30 I=1,NATOM+4                                                
      DO 30 J=1,NATOM+4                                                
         L=L+1                                                             
   30 AL(L)=A(I,J)                                                      
      ELSE                                                              
      L=0                                                               
      DO 40 I=1,NATOM+1                                                
      DO 40 J=1,NATOM+1                                                
         L=L+1                                                             
   40 AL(L)=A(I,J)                                                      
      ENDIF                                                             
      IF (IDIP .EQ. 1) THEN                                             
      CALL OSINV(AL,NATOM+4,DET)                                        
      ELSE                                                              
      CALL OSINV(AL,NATOM+1,DET)                                        
      ENDIF                                                             
      IF(IDIP .EQ. 1) THEN                                              
      L=0                                                               
      DO 50 I=1,NATOM+4                                                
      DO 50 J=1,NATOM+4                                                
         L=L+1                                                             
   50 A(I,J)=AL(L)                                                      
      ELSE                                                              
      L=0                                                               
      DO 60 I=1,NATOM+1                                                
      DO 60 J=1,NATOM+1                                                
         L=L+1                                                             
   60 A(I,J)=AL(L)                                                      
      ENDIF                                                             
C
C     SOLVE FOR THE CHARGES
C
      IF(IDIP .EQ. 1) THEN                                              
      DO 70 I=1,NATOM+4                                                
      DO 70 J=1,NATOM+4                                                
         Q(I)=Q(I)+A(I,J)*B(J)                                             
   70 CONTINUE                                                          
      ELSE                                                              
      DO 80 I=1,NATOM+1                                                
      DO 80 J=1,NATOM+1                                                
         Q(I)=Q(I)+A(I,J)*B(J)                                             
   80 CONTINUE                                                          
      ENDIF                                                             
C
C     CALCULATE ROOT MEAN SQUARE FITS AND RELATIVE ROOT MEAN SQUARE FITS
C
      CTOT=0.0                                                          
      DO 90 I=1,NESP                                                   
         ESPC=0.D0                                                         
         DO 100 J=1,NATOM                                                  
            RIJ=SQRT((CO(1,J)-POTPT(1,I))**2+(CO(2,J)-POTPT(2,I))**2          
     1      +(CO(3,J)-POTPT(3,I))**2)/BOHR                                    
  100    ESPC=ESPC+Q(J)/RIJ                                                
         RMS=RMS+(ESPC-ESP(I))**2                                          
   90 RRMS=RRMS+ESP(I)**2                                               
      RMS=SQRT(RMS/DFLOAT(NESP))                                        
      RRMS=RMS/SQRT(RRMS/DFLOAT(NESP))                                  
      RMS=RMS*627.51                                                    
      RETURN                                                            
      END                                                               
