      SUBROUTINE ESPS
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                               
#include "SIZES"                                                   
C***********************************************************************
C
C     THIS IS A DRIVER ROUTINE FOR ELECTROSTATIC POTENTIAL GENERATION   
C     WRITTEN BY K.M.MERZ FEB. 1989 AT UCSF
C
C***********************************************************************
      COMMON /KEYWRD/ KEYWRD                                            
      COMMON /TIME  /TIME0
      COMMON /ESPTIME  /TIME1
      CHARACTER*80 KEYWRD                                               
C                                                                       
C     SET STANDARD PARAMETERS FOR THE SURFACE GENERATION                
C                                                                       
      IF(INDEX(KEYWRD,'SCALE=') .NE. 0)THEN                             
         SCALE = READA(KEYWRD,INDEX(KEYWRD,'SCALE='))                      
      ELSE                                                              
         SCALE = 1.4                                                       
      ENDIF                                                             
C                                                                       
      IF(INDEX(KEYWRD,'DEN=') .NE. 0)THEN                               
         DEN = READA(KEYWRD,INDEX(KEYWRD,'DEN='))                          
      ELSE                                                              
         DEN = 1.0                                                         
      ENDIF                                                             
C                                                                       
      IF(INDEX(KEYWRD,'SCINCR=') .NE. 0)THEN                            
         SCINCR = READA(KEYWRD,INDEX(KEYWRD,'SCINCR='))                    
      ELSE                                                              
         SCINCR = 0.20                                                     
      ENDIF                                                             
C                                                                       
      IF(INDEX(KEYWRD,'NSURF=') .NE. 0)THEN                             
         N = READA(KEYWRD,INDEX(KEYWRD,'NSURF='))                          
      ELSE                                                              
         N = 4                                                             
      ENDIF                                                             
C                                                                       
      TIME1=SECOND()
C                                                                       
C     NOW CALCULATE THE SURFACE POINTS                                  
C                                                                       
      IF(INDEX(KEYWRD,'WILLIAMS') .NE. 0) THEN
      CALL PDGRID
      ELSE
      DO 10 I = 1,N                                                    
         CALL SURFAC(SCALE,DEN,I)                                          
         SCALE = SCALE + SCINCR                                            
   10 CONTINUE                                                          
      ENDIF
C                                                                       
C     NEXT CALCULATE THE ESP AT THE POINTS CALCULATED BY SURFAC         
C                                                                       
      CALL POTCAL                                                       
C
C     END OF CALCULATION
C
      TIME1=SECOND()-TIME1
      TTIME=SECOND()-TIME0
      WRITE(6,110) 'TIME TO CALCULATE ESP:',TIME1,' SECONDS'
      WRITE(6,120) 'TOTAL EXECUTION TIME:',TTIME,' SECONDS'
  110 FORMAT(/9X,A,F8.2,A)
  120 FORMAT(9X,A,1X,F8.2,A)
      RETURN                                                            
      END         
