      SUBROUTINE ELESP                                                  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                          
C******************************************************************************
C     ELESP LOADS THE STO-6G BASIS SET ONTO THE ATOMS, PERFOMS THE      
C     DEORTHOGONALIZATION OF THE COEFFICIENTS AND EVALUATES THE 
C     ELECTRONIC CONTRIBUTION TO THE ESP. IT WAS WRITTEN BY B.H.BESLER
C     AND K.M.MERZ IN FEB. 1989 AT UCSF.
C
C******************************************************************************
      CHARACTER*80 KEYWRD                                               
      REAL*8 NORM,OVL                                                   
      LOGICAL CALLED,POTWRT,RST,STO3G
#include "SIZES"                                                   
      COMMON/ESPF/ AL((NUMATM+4)**2),A(NUMATM,NUMATM),B(NUMATM),
     1Q(NUMATM+4),CESPM(MAXC,MAXC)
      COMMON /DENSTY/ P(MPACK),PA(MPACK),PB(MPACK)                      
      COMMON /POTESP/ XC,YC,ZC,ESPNUC,ESPELE,NESP                       
      COMMON /PTS/    POTPT(3,MESP)                        
      COMMON /ABC/    CO(3,NUMATM),IAN(NUMATM),NATOM                    
      COMMON /ESPQ/   ES(MESP),ESP(MESP)
      COMMON /STO6G/  ALLC(6,5,2),ALLZ(6,5,2)                           
      COMMON /VECTOR/ C(MORB2)                                          
      COMMON /MOLKST/ NUMAT,NAT(NUMATM),NFIRST(NUMATM),NMIDLE(NUMATM),  
     1                NLAST(NUMATM), NORBS, NELECS,NALPHA,NBETA,        
     2                NCLOSE,NOPEN,NDUMY,FRACT                          
      COMMON /KEYWRD/ KEYWRD                                            
      COMMON /ESPC/  CC(MAXPR),CEN(MAXPR,3),IAM(MAXPR,2),IND(MAXPR),
     1                EX(MAXPR),ESPI(MAXC,MAXC),FV(0:8,821),FAC(0:7),
     2                DEX(-1:96),TF(0:2),TEMP(MAXPR),ITEMP(MAXPR),
     3                OVL(MAXC,MAXC),FC(MAXPR),
     4                IREF(MAXHEV*MAXHEV*36)
      COMMON /NATORB/ NATORB(107)
***********************************************************************
*
*     COMMON BLOCKS FOR AM1
*
***********************************************************************
      COMMON /ELEMTS/ ELEMNT(107)
     1       /ALPHA / ALP(107)
     2       /CORE  / TORE(107)
     3       /MULTIP/ DD(107),QQ(107),AM(107),AD(107),AQ(107)
     4       /EXPONT/ ZS(107),ZP(107),ZD(107)
     5       /ONELEC/ USS(107),UPP(107),UDD(107)
     6       /BETAS / BETAS(107),BETAP(107),BETAD(107)
     7       /TWOELE/ GSS(107),GSP(107),GPP(107),GP2(107),HSP(107),
     8                GSD(107),GPD(107),GDD(107)
     9       /ATOMIC/ EISOL(107),EHEAT(107)
     1       /VSIPS / VS(107),VP(107),VD(107)
     2       /ISTOPE/ AMS(107)
     3       /IDEAS / GUESS1(107,10),GUESS2(107,10),GUESS3(107,10)
     4       /IDEAP / GUESP1(107,10),GUESP2(107,10),GUESP3(107,10)
     5       /GAUSS / FN1(107),FN2(107)
***********************************************************************
*
*     COMMON BLOCKS FOR MNDO
*
***********************************************************************
      COMMON /MNDO/  USSM(107), UPPM(107), UDDM(107), ZSM(107),
     1ZPM(107), ZDM(107), BETASM(107), BETAPM(107), BETADM(107),
     2ALPM(107), EISOLM(107), DDM(107), QQM(107), AMM(107), ADM(107),
     3AQM(107) ,GSSM(107), GSPM(107), GPPM(107), GP2M(107), HSPM(107),
     4POLVOM(107)
      COMMON /PM3 /  USSPM3(107), UPPPM3(107), UDDPM3(107), ZSPM3(107),
     1ZPPM3(107), ZDPM3(107), BETASP(107), BETAPP(107), BETADP(107),
     2ALPPM3(107), EISOLP(107), DDPM3(107), QQPM3(107), AMPM3(107),
     3ADPM3(107), AQPM3(107) ,GSSPM3(107), GSPPM3(107), GPPPM3(107),
     4GP2PM3(107), HSPPM3(107),POLVOP(107)
     5       /REFS/ REFMN(107), REFM3(107), REFAM(107), REFPM3(107)
*
*  COMMON BLOCKS FOR MINDO/3
*
      COMMON /ONELE3 /  USS3(18),UPP3(18)
     1       /TWOEL3 /  F03(107)
     2       /ATOMI3 /  EISOL3(18),EHEAT3(18)
     3       /BETA3  /  BETA3(153)
     4       /ALPHA3 /  ALP3(153)
     5       /EXPON3 /  ZS3(18),ZP3(18)
*
*  END OF MINDO/3 COMMON BLOCKS
*
      COMMON /INDX/   INDC(MAXC)                                          
      DIMENSION CESPM2(MAXC,MAXC),SLA(10)              
      DIMENSION CESPML(MAXC*MAXC),CESP(MAXC*MAXC)                       
      DATA BOHR/0.529167D0/                                             
      PI=4.D0*ATAN(1.D0)                                                
C
C     PUT STO-6G BASIS SET ON ATOM CENTERS
C
      DO 10 I=-1,10                                                      
         DEX(I)=DEX2(I)                                                    
   10 CONTINUE
      DO 20   I=0,7                                                       
         FAC(I)=1.D0/FAC(I)                                                
   20 CONTINUE
      DO 30 M=0,8                                                       
         K=1                                                               
         FV(M,1)=1.D0/(2.D0*M+1.D0)                                        
         DO 30 T=0.05D0,41.D0,0.05D0                                       
            K=K+1                                                             
            CALL FSUB(M,T,FVAL)                                               
            FV(M,K)=FVAL                                                      
   30 CONTINUE
C
C     LOAD BASIS FUNCTIONS INTO ARRAYS
C
      STO3G=(INDEX(KEYWRD,'STO3G') .NE. 0)
      IF(STO3G) THEN
      ICD=3
      CALL SETUP3
      ELSE
      ICD=6
      CALL SETUPG
      ENDIF
      NC=0                                                              
      NPR=0                                                             
      DO 40 I=1,NATOM                                                    
         IF (IAN(I) .LE. 2) THEN                                           
         DO 50 J=1,ICD                                                        
            CC(NPR+J)=ALLC(J,1,1)                                             
            EX(NPR+J)=ALLZ(J,1,1)*ZSM(1)**2                                   
            IF(INDEX(KEYWRD,'AM1') .NE. 0)
     1      EX(NPR+J)=ALLZ(J,1,1)*ZS(1)**2     
            IF(INDEX(KEYWRD,'MINDO/3') .NE. 0)
     1      EX(NPR+J)=ALLZ(J,1,1)*ZS3(1)**2
            IF(INDEX(KEYWRD,'PM3') .NE. 0)
     1      EX(NPR+J)=ALLZ(J,1,1)*ZSPM3(1)**2
            CEN(NPR+J,1)=CO(1,I)/BOHR                                         
            CEN(NPR+J,2)=CO(2,I)/BOHR                                         
            CEN(NPR+J,3)=CO(3,I)/BOHR                                         
            IAM(NPR+J,1)=0                                                    
            IAM(NPR+J,2)=0                                                    
            FC(NPR+J)=I
   50    CONTINUE                                                          
         NC=NC+1                                                           
         NPR=NPR+ICD                                                         
         ELSE                                                              
C        DETERMINE PRINCIPAL QUANTUM NUMBER(NQN)
C        OF ORBITALS TO BE USED
C
         NQN=2
         IF(IAN(I) .GT. 10 .AND. IAN(I) .LE. 18) NQN=3
         IF(IAN(I) .GT. 18 .AND. IAN(I) .LE. 36) NQN=4
         IF(IAN(I) .GT. 36 .AND. IAN(I) .LE. 54) NQN=5
C
         DO 60 J=1,ICD                                                        
            CC(NPR+J)=ALLC(J,NQN,1)                                             
            EX(NPR+J)=ALLZ(J,NQN,1)*ZSM(IAN(I))**2                              
            IF(INDEX(KEYWRD,'AM1') .NE. 0)
     1      EX(NPR+J)=ALLZ(J,NQN,1)*ZS(IAN(I))**2
            IF(INDEX(KEYWRD,'MINDO/3') .NE. 0)                                
     1      EX(NPR+J)=ALLZ(J,NQN,1)*ZS3(IAN(I))**2                              
            IF(INDEX(KEYWRD,'PM3') .NE. 0)                                
     1      EX(NPR+J)=ALLZ(J,NQN,1)*ZSPM3(IAN(I))**2                              
            CEN(NPR+J,1)=CO(1,I)/BOHR                                         
            CEN(NPR+J,2)=CO(2,I)/BOHR                                         
            CEN(NPR+J,3)=CO(3,I)/BOHR                                         
            IAM(NPR+J,1)=0                                                    
            IAM(NPR+J,2)=0                                                    
   60    CONTINUE                                                          
         NC=NC+1                                                           
         NPR=NPR+ICD                                                         
         DO 70 K=1,3                                                        
            DO 80  J=1,ICD                                                        
               CC(NPR+J)=ALLC(J,NQN,2)              
               EX(NPR+J)=ALLZ(J,NQN,2)*ZPM(IAN(I))**2
               IF(INDEX(KEYWRD,'AM1') .NE. 0) 
     1         EX(NPR+J)=ALLZ(J,NQN,2)*ZP(IAN(I))**2
               IF(INDEX(KEYWRD,'PM3') .NE. 0)   
     1         EX(NPR+J)=ALLZ(J,NQN,2)*ZPPM3(IAN(I))**2  
               CEN(NPR+J,1)=CO(1,I)/BOHR             
               CEN(NPR+J,2)=CO(2,I)/BOHR              
               CEN(NPR+J,3)=CO(3,I)/BOHR               
               IAM(NPR+J,1)=1                           
               IAM(NPR+J,2)=K                            
   80       CONTINUE                                                          
            NC=NC+1                                                           
            NPR=NPR+ICD
   70    CONTINUE                                                          
         ENDIF                                                             
   40 CONTINUE                                                          
C
C     CALCULATE NORMALIZATION CONSTANTS OF PRIMITIVES AND INCLUDE       
C     THEM IN THE CONTRACTION COEFFICIENTS                              
C
      DO 90 I=1,NPR                                                     
         NORM=(2.D0*EX(I)/PI)**0.75D0*(4.D0*EX(I))**(IAM(I,1)/2.D0)/       
     1   SQRT(DEX(2*IAM(I,1)-1))                                           
         CC(I)=CC(I)*NORM                                                  
   90 CONTINUE                                                          
      IPR=0                                                             
C
C     PERFORM SORT OF PRIMITIVES BY ANGULAR MOMENTUM                    
C
      IS=0                                                              
      IP=0                                                              
      IPC=0                                                             
      ISC=0                                                             
      J=0                                                               
      DO 100 I=1,NPR                                                     
         IF (IAM(I,1) .EQ. 0) THEN                                         
         IS=IS+1                                                           
         IND(IS)=I                                                         
         ENDIF                                                             
  100 CONTINUE                                                          
      IP=IS                                                             
      DO 110 I=1,NPR                                                     
         IF (IAM(I,1) .EQ. 1 .AND. IAM(I,2) .EQ. 1) THEN                                         
         IP=IP+1                                                           
         IND(IP)=I                                                         
         ENDIF                                                             
  110 CONTINUE                                                          
      DO 120 I=1,NPR                                                     
         IF (IAM(I,1) .EQ. 1 .AND. IAM(I,2) .EQ. 2) THEN                                         
         IP=IP+1                                                           
         IND(IP)=I                                                         
         ENDIF                                                             
  120 CONTINUE                                                          
      DO 130 I=1,NPR                                                     
         IF (IAM(I,1) .EQ. 1 .AND. IAM(I,2) .EQ. 3) THEN                                         
         IP=IP+1                                                           
         IND(IP)=I                                                         
         ENDIF                                                             
  130 CONTINUE                                                          
      DO 140 I=1,NC                                                     
         IN=I*ICD-ICD+1
         IF (IAM(IN,1) .EQ. 0) THEN                                     
         ISC=ISC+1                                                         
         INDC(ISC)=I                                                       
         ENDIF                                                             
  140 CONTINUE                                                          
      IPC=ISC                                                           
      DO 150 I=1,NC                                                     
         IN=I*ICD-ICD+1
         IF (IAM(IN,1) .EQ. 1 .AND. IAM(IN,2) .EQ. 1) THEN                                     
         IPC=IPC+1                                                         
         INDC(IPC)=I                                                       
         ENDIF                                                             
  150 CONTINUE                                                          
      DO 160 I=1,NC                                                     
         IN=I*ICD-ICD+1
         IF (IAM(IN,1) .EQ. 1 .AND. IAM(IN,2) .EQ. 2) THEN                                     
         IPC=IPC+1                                                         
         INDC(IPC)=I                                                       
         ENDIF                                                             
  160 CONTINUE                                                          
      DO 170 I=1,NC                                                     
         IN=I*ICD-ICD+1
         IF (IAM(IN,1) .EQ. 1 .AND. IAM(IN,2) .EQ. 3) THEN                                     
         IPC=IPC+1                                                         
         INDC(IPC)=I                                                       
         ENDIF                                                             
  170 CONTINUE                                                          
      DO 180 I=1,NPR                                                     
         TEMP(I)=CC(IND(I))                                                
  180 CONTINUE                                                          
      DO 190 I=1,NPR                                                     
         CC(I)=TEMP(I)                                                     
  190 CONTINUE                                                          
      DO 200 I=1,NPR                                                     
         TEMP(I)=EX(IND(I)) 
  200 CONTINUE                                               
      DO 210 I=1,NPR                                                     
         EX(I)=TEMP(I)                                                     
  210 CONTINUE
      DO 220 I=1,NPR                                                     
         TEMP(I)=CEN(IND(I),1)                                             
  220 CONTINUE
      DO 230 I=1,NPR                                                     
         CEN(I,1)=TEMP(I)                                                  
  230 CONTINUE
      DO 240 I=1,NPR                                                     
         TEMP(I)=CEN(IND(I),2)                                             
  240 CONTINUE
      DO 250 I=1,NPR                                                     
         CEN(I,2)=TEMP(I)                                                  
  250 CONTINUE
      DO 260 I=1,NPR                                                     
         TEMP(I)=CEN(IND(I),3)                                             
  260 CONTINUE
      DO 270 I=1,NPR                                                     
         CEN(I,3)=TEMP(I)                                                  
  270 CONTINUE
      DO 280 I=1,NPR                                                     
         ITEMP(I)=IAM(IND(I),1)                                            
  280 CONTINUE
      DO 290 I=1,NPR                                                     
         IAM(I,1)=ITEMP(I)                                                 
  290 CONTINUE
      DO 300 I=1,NPR                                                     
         ITEMP(I)=IAM(IND(I),2)                                            
  300 CONTINUE
      DO 310 I=1,NPR                                                     
         IAM(I,2)=ITEMP(I)                                                 
  310 CONTINUE
C     CALCULATE OVERLAP MATRIX OF STO-6G FUNCTIONS
C
      DO 320 J=1,NC                                                     
         CALL OVLP(J,1,IS,IP,NPR,NC,ICD)
  320 CONTINUE
C
      DO 330 J=1,NC                                                     
         DO 330 K=1,NC                                                     
            CESPM2(INDC(J),INDC(K))=OVL(J,K)                                  
  330 CONTINUE                                                          
      DO 340 J=1,NC                                                     
         DO 340 K=1,NC                                                     
            OVL(J,K)=CESPM2(J,K)                                              
  340 CONTINUE                                                          
      L=0                                                               
      DO 350 I=1,NC                                                     
         DO 350 J=1,I                                                      
            L=L+1                                                             
            CESP(L)=OVL(I,J)                                                  
  350 CONTINUE                                                          
C
C     DEORTHOGONALIZE THE COEFFICIENTS AND REFORM THE DENSITY MATRIX
C
      CALL RSP(CESP,NC,1,TEMP,CESPML)                                   
      DO 360 I=1,NC                                                     
         DO 360 J=1,I                                                      
            SUM=0.D0                                                          
            DO 360 K=1,NC                                                     
            SUM=SUM+CESPML(I+(K-1)*NC)/SQRT(TEMP(K))*CESPML(J+(K-1)*NC)
               CESP(I+(J-1)*NC)=SUM
               CESP(J+(I-1)*NC)=SUM
  360 CONTINUE
      CALL MULT(C,CESP,CESPML,NC)                                       
      CALL DENSIT(CESPML,NC,NC,NCLOSE,NOPEN,FRACT,CESP,2)               
C
C     NOW CALCULATE THE ELECTRONIC CONTRIBUTION TO THE ELECTROSTATIC POT
C
      L=0
      DO 370 I=1,NC
      DO 370 J=1,I
      L=L+1
      CESPM(I,J)=CESP(L)
      CESPM(J,I)=CESP(L)
  370 CONTINUE
      IPX=(NPR-IS)/3
      IPE=IS+IPX
      DO 380 I=1,NESP
      ES(I)=0.D0
  380 CONTINUE
      CALL NAICAS(ISC,IS,IP,NPR,NC,IPE,IPX,ICD)
      CALL NAICAP(ISC,IS,IP,NPR,NC,IPE,IPX,ICD)
C     CALCULATE TOTAL ESP AND FORM ARRAYS FOR ESPFIT
      DO 390 I=1,NESP
      ESP(I)=0.D0
      DO 400 J=1,NATOM
      RA=SQRT((CO(1,J)-POTPT(1,I))**2+(CO(2,J)-POTPT(2,I))**2+(CO(3,J)
     1-POTPT(3,I))**2)
      ESP(I)=ESP(I)+TORE(IAN(J))/(RA/BOHR)
  400 CONTINUE
      ESP(I)=ESP(I)-ES(I)
      DO 390  J=1,NATOM
      RIJ=SQRT((CO(1,J)-POTPT(1,I))**2+(CO(2,J)-POTPT(2,I))**2

     1+(CO(3,J)-POTPT(3,I))**2)/BOHR

      B(J)=B(J)+ESP(I)*1.D0/RIJ
 
  390 CONTINUE                                                          
C
C     IF REQUESTED WRITE OUT ELECTRIC POTENTIAL DATA TO
C     UNIT 21
C
      POTWRT=(INDEX(KEYWRD,'POTWRT') .NE. 0)
      IF(POTWRT) THEN
      OPEN(21,STATUS='NEW')
      WRITE(21,FMT='(I5)') NESP
      DO 410 I=1,NESP
  410 WRITE(21,1030) ESP(I),POTPT(1,I)/BOHR,POTPT(2,I)/BOHR,
     &POTPT(3,I)/BOHR
      ENDIF
 1030 FORMAT(1X,4E16.7)
      RETURN                                                            
      END                                                               
      DOUBLE PRECISION FUNCTION DEX2(M)                                 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IF(M .LT. 2) THEN                                                 
      DEX2=1                                                            
      ELSE                                                              
      DEX2=1                                                            
      DO 10 I=1,M,2                                                     
   10 DEX2=DEX2*I                                                       
      ENDIF                                                             
      RETURN                                                            
      END
      BLOCK DATA ESP
      IMPLICIT REAL *8 (A-H, O-Z)
#include "SIZES"      
      COMMON /ESPC/  CC(MAXPR),CEN(MAXPR,3),IAM(MAXPR,2),IND(MAXPR),
     1                EX(MAXPR),ESPI(MAXC,MAXC),FV(0:8,821),FAC(0:7),
     2                DEX(-1:96),TF(0:2),TEMP(MAXPR),ITEMP(MAXPR),
     3                OVL(MAXC,MAXC),FC(MAXPR)
      DATA TF/33.D0,37.D0,41.D0/
      DATA FAC/1.D0,1.D0,2.D0,6.D0,24.D0,120.D0,720.D0,5040.D0/
      END
