C*****************************************************************************
C
C  ROUTINES CALLED BY SR NATHYB, SR CHOOSE:
C
C      SUBROUTINE CORE(DM,T,BORB,POL,Q,HYB,BNDOCC,IBD,DETAIL,LFNPR)
C      FUNCTION IWPRJ(NCTR)
C      SUBROUTINE DEPLET(DM,T,Q,POL,BORB,BNDOCC,NBD)
C      SUBROUTINE LOAD(DM,IAT1,IAT2,IAT3,BLK,NB)
C      SUBROUTINE PRJEXP(BORB,IAT1,IAT2,IAT3,Q,P,PK,HYB,VA,VB,HYBEXP)
C      SUBROUTINE STASH(BORB,IBD,IAT1,IAT2,IAT3,POL,Q,HYB)
C      SUBROUTINE ORTHYB(Q,S,TA,EVAL,C,IALARM,IFLG)
C      SUBROUTINE FRMPRJ(P,IA,Q,NK,PK,VK,PI)
C      SUBROUTINE AUGMNT(P,BLK,C,EVAL,DM,TA,BORB,V,LARC,IA,NOCC,NORB)
C      SUBROUTINE REPOL(DM,Q,POL,BLK,EVAL,C,NBD)
C      SUBROUTINE FORMT(T,Q,POL)
C      SUBROUTINE CYCLES(ITER,THRESH,GUIDE,BNDOCC,TOPO,ICONT)
C
C*****************************************************************************
      SUBROUTINE COR(DM,T,BORB,POL,Q,HYB,BNDOCC,IBD,DETAIL,LFNPR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  Label core, valence, and Rydberg NAO's and deplete DM of the density
C  of the core orbitals
C
      LOGICAL DETAIL,FIRST
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBNAO/NAOCTR(MAXBAS),NAOL(MAXBAS),LTYP(MAXBAS),
     +       IPRIN(MAXBAS)
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),LBL(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),ILL(MAXATM),
     +       IUL(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
C
      DIMENSION DM(NDIM,NDIM),T(NDIM,NDIM),BORB(MXBO),POL(NDIM,3),
     *  Q(MXAO,NDIM),HYB(MXAO),BNDOCC(NDIM),ICORE(4),IVAL(4),IANG(5)
C
      SAVE ZERO,ONE,IBLK,ICOR,IRYD,ICHCOR,ICHVAL,IANG
C
      DATA ZERO,ONE/0.0D0,1.0D0/
      DATA IBLK,ICOR,IRYD/2H  ,2HCR,3HRyd/
      DATA ICHCOR,ICHVAL/3HCor,3HVal/
      DATA IANG/1Hs,1Hp,1Hd,1Hf,1Hg/
C
C  Label NAO's on each center:
C
      DO 10 I = 1,NBAS
        LTYP(I) = IRYD
   10 CONTINUE
      IECP = 0
      DO 110 NCTR = 1,NATOMS
        CALL CORTBL(NCTR,ICORE,IECP)
        CALL VALTBL(NCTR,IVAL)
C
C  Loop over s,p,d,f orbitals:
C
        DO 100 L = 0,3
          ITYP = IANG(L+1)
          LNUM = 2*L + 1
          IF(ICORE(L+1).LE.0) GOTO 50
C
C  Label core orbitals:
C
          DO 40 M = 1,ICORE(L+1)
            DO 30 LA = 1,LNUM
              MORB = 0
              OCC = -1.0
              DO 20 N = 1,NBAS
                LM = NAOL(N)
                NORB = LM/100
                IL = IANG(NORB+1)
                NA = MOD(NAOL(N),50)
                IF(NAOCTR(N).EQ.NCTR.AND.IL.EQ.ITYP.AND.
     +            DM(N,N).GT.OCC.AND.LTYP(N).EQ.IRYD.AND.
     +                                         LA.EQ.NA) THEN
                      MORB = N
                      OCC = DM(N,N)
                END IF
   20         CONTINUE
              IF(MORB.EQ.0) THEN
                WRITE(LFNPR,2500) ITYP,NAMEAT(IATNO(NCTR)),NCTR,
     +                            (ICORE(I),I=1,4),M,LA
                STOP
              END IF
              LTYP(MORB) = ICHCOR
   30       CONTINUE
   40     CONTINUE
   50     CONTINUE
          IF(IVAL(L+1).LE.0) GOTO 90
C
C  Label valence orbitals:
C
          DO 80 M = 1,IVAL(L+1)
            DO 70 LA = 1,LNUM
              MORB = 0
              OCC = -1.0
              DO 60 N = 1,NBAS
                LM = NAOL(N)
                NORB = LM/100
                IL = IANG(NORB+1)
                NA = MOD(NAOL(N),50)
                IF(NAOCTR(N).EQ.NCTR.AND.IL.EQ.ITYP.AND.
     +            DM(N,N).GT.OCC.AND.LTYP(N).EQ.IRYD.AND.
     +                                         LA.EQ.NA) THEN
                      MORB = N
                      OCC = DM(N,N)
                END IF
   60         CONTINUE
              IF(MORB.EQ.0) THEN
                WRITE(LFNPR,2600) ITYP,NAMEAT(IATNO(NCTR)),NCTR,
     +                            (IVAL(I),I=1,4),M,LA
                STOP
              END IF
              LTYP(MORB) = ICHVAL
   70       CONTINUE
   80     CONTINUE
   90     CONTINUE
  100   CONTINUE
  110 CONTINUE
C
C  Isolate core orbitals on all atoms, removing their density from the
C  density matrix:
C
      DO 300 IAT = 1,NATOMS
        NB = IUL(IAT) - ILL(IAT) + 1
        IAC = 0
        FIRST = .TRUE.
        DO 290 N = ILL(IAT),IUL(IAT)
          IF(LTYP(N).EQ.ICHCOR) THEN
            IF(DETAIL.AND.FIRST) THEN
              FIRST = .FALSE.
              WRITE(LFNPR,1000) IAT
            END IF
            IAC = IAC + 1
            IBD = IBD + 1
            DO 280 I = 1,NB
              BORB(I) = ZERO
  280       CONTINUE
            BORB(N-ILL(IAT)+1) = ONE
            CALL STASH(BORB,IBD,IAT,0,0,POL,Q,HYB)
            LABEL(IBD,1) = ICOR
            LABEL(IBD,2) = IBLK
            LABEL(IBD,3) = IAC
            LABEL(IBD,4) = IAT
            BNDOCC(IBD)  = DM(N,N)
            IF(DETAIL) WRITE(LFNPR,1010) IAC,BNDOCC(IBD)
            IF(DETAIL) WRITE(LFNPR,1020) (BORB(I),I=1,NB)
            IF(DETAIL) WRITE(LFNPR,1030) IBD,(LABEL(IBD,I),I=1,3)
          END IF
  290   CONTINUE
  300 CONTINUE
C
C  Deplete the density matrix of CR orbitals:
C
      CALL DEPLET(DM,T,Q,POL,BORB,BNDOCC,IBD)
      RETURN
C
 1000 FORMAT(/,1X,'Search of DM block for core orbitals on atom:',I4)
 1010 FORMAT(6X,'Eigenvector (',I2,') has occupancy ',F9.6,':')
 1020 FORMAT(11X,8F7.4)
 1030 FORMAT(11X,'*** NBO accepted: Number',I3,'.   Label:',A2,A1,
     + '(',I2,')')
 2500 FORMAT(/1X,'Subroutine CORE could not find a ',A1,'-type ',
     + 'core orbital on atom ',A2,I2,'.',/,1X,'ICORE :',4I3,
     + '     M :',I3,'     LA :',I3)
 2600 FORMAT(/1X,'Subroutine CORE could not find a ',A1,'-type ',
     + 'valence orbital on atom ',A2,I2,'.',/,1X,'IVAL :',4I3,
     + '     M :',I3,'     LA :',I3)
      END
C*****************************************************************************
      FUNCTION IWPRJ(NCTR)
C*****************************************************************************
      SAVE NCTR0
      DATA NCTR0/0/
C
C  RETURN 0 (NO PROJECTION WANTED) IF NCTR IS UNCHANGED, 1 OTHERWISE.
C
      IWPRJ=0
      IF(NCTR.EQ.NCTR0) RETURN
       IWPRJ=1
       NCTR0=NCTR
       RETURN
      END
C*****************************************************************************
      SUBROUTINE DEPLET(DM,T,Q,POL,BORB,BNDOCC,NBD)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  DEPLETE DENSITY MATRIX DM OF CONTRIBUTION FROM B.O.'BORB':
C     DM ==> DM - OCC*BORB*BORB(TRANSPOSE).
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),IATHY(MAXBAS,3)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),ILL(MAXATM),
     +       IUL(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      DIMENSION DM(NDIM,NDIM),T(NDIM,NDIM),Q(MXAO,NDIM),POL(NDIM,3),
     *  BORB(MXBO),BNDOCC(NDIM)
      DIMENSION IAT(3)
C  RESTORE DM FROM T
      DO 10 J=1,NBAS
        DO 10 I=1,J
          DM(I,J)=T(I,J)
   10     DM(J,I)=DM(I,J)
C  MAIN LOOP OVER NBD AVAILABLE BOND ORBITALS:
      DO 90 IBD=1,NBD
        OCC=BNDOCC(IBD)
C  FIND ATOMS FOR B.O. #IBD
        NCTR=0
        DO 20 J=1,3
          IAT(J)=LABEL(IBD,J+3)
          IF(IAT(J).LE.0) GO TO 30
          NCTR=NCTR+1
   20     CONTINUE
C  RECONSTRUCT BORB FOR B.O. #IBD
   30   NELM=0
        DO 40 ICTR=1,NCTR
          IA=IAT(ICTR)
          IHYB=IATHY(IBD,ICTR)+ILL(IA)-1
          P=POL(IBD,ICTR)
          NH=NORBS(IA)
          DO 40 IH=1,NH
            NELM=NELM+1
   40       BORB(NELM)=P*Q(IH,IHYB)
C  SUBTRACT OCC*BORB*BORB(T) FROM DM
        NROW=0
        DO 80 ICTR=1,NCTR
          IA=IAT(ICTR)
          IU=IUL(IA)
          IL=ILL(IA)
          DO 70 IROW=IL,IU
            NROW=NROW+1
            NCOL=0
            DO 60 JCTR=1,NCTR
              JA=IAT(JCTR)
              JU=IUL(JA)
              JL=ILL(JA)
              DO 50 ICOL=JL,JU
                NCOL=NCOL+1
   50           DM(IROW,ICOL)=DM(IROW,ICOL)-OCC*BORB(NROW)*BORB(NCOL)
   60         CONTINUE
   70       CONTINUE
   80     CONTINUE
   90   CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE LOAD(DM,IAT1,IAT2,IAT3,BLK,NB)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  ZERO THE MATRIX 'BLK' AND LOAD IN ATOMIC BLOCKS OF DENSITY
C  MATRIX 'DM' FOR THE ATOMS LISTED IN 'IAT'
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),ILL(MAXATM),
     +       IUL(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
C
      DIMENSION BLK(MXBO,MXBO),DM(NDIM,NDIM),IAT(3)
C
      SAVE ZERO
      DATA ZERO/0.0D0/
C
      IAT(1) = IAT1
      IAT(2) = IAT2
      IAT(3) = IAT3
C
C  ZERO 'BLK':
C
      DO 10 J = 1,MXBO
        DO 5 I = 1,MXBO
          BLK(I,J) = ZERO
    5   CONTINUE
   10 CONTINUE
      NROW = 0
      NCOL = 0
      DO 50 I = 1,3
        IA = IAT(I)
        IF(IA.EQ.0) GO TO 50
        IU = IUL(IA)
        IL = ILL(IA)
        DO 40 IROW = IL,IU
          NROW = NROW + 1
          NCOL = 0
          DO 30 J = 1,3
            JA = IAT(J)
            IF(JA.EQ.0) GO TO 30
            JU = IUL(JA)
            JL = ILL(JA)
            DO 20 ICOL = JL,JU
              NCOL = NCOL + 1
              BLK(NROW,NCOL) = DM(IROW,ICOL)
   20       CONTINUE
   30     CONTINUE
   40   CONTINUE
   50 CONTINUE
      NB = NROW
      RETURN
      END
C*****************************************************************************
      SUBROUTINE PRJEXP(BORB,IAT1,IAT2,IAT3,Q,P,PK,HYB,VA,VB,HYBEXP)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  DETERMINE HOW MUCH OF BORB IS COMPOSED OF PREVIOUSLY USED HYBRIDS.
C
C  RETURN HYBEXP(I) = EXPECTATION VALUE OF HYBRID "I" IN BORB OVER THE
C                     PROJECTION OPERATOR P FOR THE ATOM OF THE HYBRID.
C
C  IF NO HYBRID ON ATOM I CONTRIBUTES TO BORB, HYBEXP(I) = ZERO.
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),IATHY(MAXBAS,3)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),ILL(MAXATM),
     +       IUL(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
C
      DIMENSION IAT(3),HYB(MXAO),BORB(MXBO),Q(MXAO,NDIM),P(MXAO,MXAO),
     *  PK(MXAO,MXAO),VA(MXAO),VB(MXAO),HYBEXP(3)
C
      SAVE ZERO,ONE,EPS
      DATA ZERO,ONE,EPS/0.0D0,1.0D0,1.0D-5/
C
C  LOOP OVER ATOMIC HYBRIDS:
C
      IAT(1) = IAT1
      IAT(2) = IAT2
      IAT(3) = IAT3
      KMAX   = 0
      DO 50 I = 1,3
        HYBEXP(I) = ZERO
        IA = IAT(I)
        IF(IA.EQ.0) GO TO 50
C
C  EXTRACT THE ITH ATOMIC HYBRID FROM BORB:
C
        NU = IUL(IA)
        NL = ILL(IA)
        KMIN = KMAX + 1
        KMAX = KMAX + NU - NL + 1
        MJ = 0
        DO 10 K = KMIN,KMAX
          MJ = MJ + 1
          HYB(MJ) = BORB(K)
   10   CONTINUE
C
C  DO HYBRIDS FROM THE ITH ATOM CONTRIBUTE TO BORB?
C
        S = ZERO
        DO 20 J = 1,MJ
          S = S + HYB(J)**2
   20   CONTINUE
        IF(S.LT.EPS) GO TO 50
C
C  DETERMINE THE PROJECTION EXPECTATION FOR THIS HYBRID:
C
        NH = INO(IA)
        IF(NH.EQ.0) THEN
          HYBEXP(I) = ONE
        ELSE
          CALL FRMPRJ(P,IA,Q,NH,PK,VA,VB)
          PAV = ZERO
          DO 40 J = 1,MJ
            DO 30 K = 1,MJ
              PAV = PAV + HYB(K) * P(K,J) * HYB(J)
   30       CONTINUE
   40     CONTINUE
          HYBEXP(I) = ABS(PAV) / S
        END IF
   50 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE STASH(BORB,IBD,IAT1,IAT2,IAT3,POL,Q,HYB)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  DECOMPOSE BOND ORBITAL 'BORB' AND STORE CONSTITUENT HYBRIDS IN Q
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),IATHY(MAXBAS,3)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),ILL(MAXATM),
     +       IUL(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
C
      DIMENSION POL(NDIM,3),Q(MXAO,NDIM),BORB(MXBO),IAT(3),HYB(MXAO)
C
      SAVE ZERO
      DATA ZERO/0.0D0/
C
C  LOOP OVER CENTERS:
C
      IAT(1) = IAT1
      IAT(2) = IAT2
      IAT(3) = IAT3
      KMAX   = 0
      DO 40 I = 1,3
        IA = IAT(I)
        IF(IA.EQ.0) GO TO 40
        NU = IUL(IA)
        NL = ILL(IA)
C
C  EXTRACT HYBRID FROM BOND ORBITAL FOR ATOM IA:
C
        KMIN = KMAX + 1
        KMAX = KMAX + NU - NL + 1
        MJ = 0
        DO 10 K = KMIN,KMAX
          MJ = MJ + 1
          HYB(MJ) = BORB(K)
   10   CONTINUE
C
C  EXTRACT POLARIZATION COEFFICIENT, STORE IN 'POL':
C
        PSQ = ZERO
        DO 20 J = 1,MJ
          PSQ = PSQ + HYB(J)**2
   20   CONTINUE
        P = SQRT(PSQ)
        POL(IBD,I) = P
C
C  ONE MORE HYBRID FOR ATOM IA:
C
        INO(IA) = INO(IA) + 1
        NCOL = ILL(IA) + INO(IA) - 1
C
C  PLACE NORMALIZED HYBRID IN APPROPRIATE BLOCK OF Q:
C
        NH = NU - NL + 1
        DO 30 NROW = 1,NH
          IF(P.EQ.ZERO) THEN
            Q(NROW,NCOL) = ZERO
          ELSE
            Q(NROW,NCOL) = HYB(NROW)/P
          END IF
   30   CONTINUE
        IATHY(IBD,I) = INO(IA)
   40 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE ORTHYB(Q,S,TA,EVAL,C,IALARM,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  SYMMETRIC ORTHOGONALIZATION OF AVAILABLE HYBRIDS IN Q:
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       ILU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
C
      DIMENSION Q(MXAO,NDIM),S(MXBO,MXBO),TA(MXAO,MXAO),
     *                    EVAL(MXBO),C(MXBO,MXBO)
C
      SAVE ZERO,ONE,TOOSML
      DATA ZERO,ONE/0.0D0,1.0D0/
      DATA TOOSML/1.0D-4/
C
C  TOOSML: "TOO SMALL" -- THRESHOLD FOR AN S MATRIX EIGENVALUE THAT IS TOO
C   SMALL AND WILL CAUSE NUMERICAL PROBLEMS AND IS INDICATIVE OF NEAR-LINEAR
C   DEPENDENCY IN THE HYBRIDS:
C
      IALARM = 0
      DO 100 IA = 1,NATOMS
        IL = LL(IA)
        NH = INO(IA)
        IF(NH.GT.MXAO) GO TO 800
        IF(NH.LE.1) GO TO 100
C
C  LOAD IA-BLOCK OF Q INTO TA:
C
        DO 10 J = 1,NH
          DO 5 I = 1,MXAO
            TA(I,J) = Q(I,IL+J-1)
    5     CONTINUE
   10   CONTINUE
C
C  FORM OVERLAP MATRIX S = TA(TRANSP)*TA:
C
        DO 30 J = 1,NH
          DO 25 I = J,NH
            TEMP = ZERO
            DO 20 K = 1,MXAO
              TEMP = TEMP + TA(K,I) * TA(K,J)
   20       CONTINUE
            S(I,J) = TEMP
            S(J,I) = TEMP
   25     CONTINUE
   30   CONTINUE
C
C  DIAGONALIZE OVERLAP MATRIX:
C
        CALL JACOBI(NH,S,EVAL,C,MXBO,MXBO,0)
C
C  FORM INVERSE SQUARE ROOT OF S, STORE IN S: (AVOID NUMERICAL PROBLEMS
C  OF LINEAR DEPENDENCE ("TOO SMALL" EIGENVALUES) BY PRESCREENING THE
C  EIGENVALUES)
C
        DO 40 I = 1,NH
          IF(EVAL(I).LT.TOOSML) GO TO 810
          EVAL(I) = ONE / SQRT(EVAL(I))
   40   CONTINUE
        DO 60 J = 1,NH
          DO 55 I = J,NH
            TEMP = ZERO
            DO 50 K = 1,NH
              TEMP = TEMP + EVAL(K) * C(I,K) * C(J,K)
   50       CONTINUE
            S(I,J) = TEMP
            S(J,I) = TEMP
   55     CONTINUE
   60   CONTINUE
C
C  FORM NEW TAP=TA*S**(-1/2), STORE IN C:
C
        DO 80 J = 1,NH
          DO 75 I = 1,MXAO
            TEMP = ZERO
            DO 70 K = 1,NH
              TEMP = TEMP + TA(I,K) * S(K,J)
   70       CONTINUE
            C(I,J) = TEMP
   75     CONTINUE
   80   CONTINUE
C
C  REPLACE ORTHOGONALIZED TA IN ARRAY Q:
C
        DO 90 J = 1,NH
          DO 85 I = 1,MXAO
            Q(I,IL+J-1) = C(I,J)
   85     CONTINUE
   90   CONTINUE
  100 CONTINUE
C
C  SYMMETRIC ORTHOGONALIZATION COMPLETE:
C
      RETURN
C
C  SOUND THE ALARM THAT TOO MANY HYBRIDS WERE FOUND ON THIS ATOM:
C
  800 CONTINUE
      IALARM = IA
      IF(IFLG.EQ.0) WRITE(LFNPR,900) MXAO,IA,NH
      RETURN
C
C  SOUND THE ALARM THAT THERE ARE TOO MANY HYBRIDS OR THAT THERE IS
C  LINEAR DEPENDENCY IN THE HYBRIDS!!
C
  810 CONTINUE
      IALARM = IA
      IF(IFLG.EQ.0) WRITE(LFNPR,910) IA,EVAL(I),TOOSML
      RETURN
C
  900 FORMAT(/4X,'Only expected to find',I3,' hybrids on atom',I3,
     + ', but found',I3,'.')
  910 FORMAT(/4X,'The hybrids on atom',I3,' are linearly dependent.',
     + '  An eigenvalue (',F10.6,')',/4X,'of the hybrid overlap ',
     + 'matrix is too small (<',F7.5,').')
      END
C*****************************************************************************
      SUBROUTINE FRMPRJ(P,IA,Q,NK,PK,VK,PI)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  FORM PROJECTION MATRIX P TO ANNIHILATE COMPONENTS OF NK OCCUPIED
C  HYBRIDS FOR ATOM IA.
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),ILL(MAXATM),
     +       IUL(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
C
      DIMENSION P(MXAO,MXAO),VK(MXAO),PI(MXAO),Q(MXAO,NDIM),
     *          PK(MXAO,MXAO)
C
      SAVE ZERO,ONE
      DATA ZERO,ONE/0.0D0,1.0D0/
C
C  INITIALIZE P = UNIT MATRIX:
C
      NB = NORBS(IA)
      DO 10 J = 1,NB
        DO 5 I = 1,J
          P(I,J) = ZERO
          P(J,I) = ZERO
          IF(I.EQ.J) P(I,J) = ONE
    5   CONTINUE
   10 CONTINUE
C
C  FORM PROJECTION MATRIX P = P1*P2*...*PK*...*PNK TO ANNIHILATE
C  COMPONENTS OF THE NK OCCUPIED HYBRIDS VK:  PK = I - VK*VK(T).
C  LOOP OVER OCCUPIED HYBRIDS VK, K = 1,...,NK:
C
      IF(NK.LE.0) RETURN
C
C  EXTRACT OCCUPIED HYBRID VK FROM ARRAY Q:
C
      DO 90 K = 1,NK
        ICOL = ILL(IA) + K - 1
        DO 30 I = 1,NB
          VK(I) = Q(I,ICOL)
   30   CONTINUE
C
C  FORM PROJECTION MATRIX PK:
C
        DO 40 J = 1,NB
          DO 35 I = 1,J
            PK(I,J) = -VK(I) * VK(J)
            PK(J,I) = PK(I,J)
            IF(I.EQ.J) PK(I,J) = PK(I,J) + ONE
   35     CONTINUE
   40   CONTINUE
C
C  ACCUMULATE TOTAL PROJECTOR P(K) = P(K-1)*PK:
C
        DO 80 I = 1,NB
          DO 60 J = 1,NB
            PI(J) = ZERO
            DO 50 L = 1,NB
              PI(J) = PI(J) + P(I,L) * PK(L,J)
   50       CONTINUE
   60     CONTINUE
          DO 70 J = 1,NB
            P(I,J) = PI(J)
   70     CONTINUE
   80   CONTINUE
   90 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE AUGMNT(P,BLK,C,EVAL,DM,TA,BORB,V,LARC,IA,NOCC,NORB)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
      DIMENSION P(MXAO,MXAO),TA(MXAO,MXAO),DM(NDIM,NDIM),C(MXBO,MXBO),
     + EVAL(MXBO),BORB(MXBO),V(MXBO),BLK(MXBO,MXBO),LARC(NBAS)
C
      SAVE ZERO,EPS,PT99,ONE
      DATA ZERO,EPS,PT99,ONE/0.0D0,1.0D-5,0.99D0,1.0D0/
C
C  FIRST, FORM SET OF "OPTIMALLY DIAGONAL" UNIT VECTORS TO SPAN RYDBERG SPACE:
C
      NAUG = NORB - NOCC
      DO 10 I = 1,NORB
        LARC(I) = 0
   10 CONTINUE
C
C  SELECT PROJECTED NAO UNIT VECTOR FROM PROJECTOR IN P:
C
      DO 300 IPROJ = 1,NAUG
        IMAX = 0
        PRJMAX = ZERO
        DO 80 IAO = 1,NORB
          IF(LARC(IAO).NE.0) GO TO 80
          PROJ = ABS(P(IAO,IAO))
          IF(PROJ.GT.PT99) GO TO 100
          IF(PROJ.LT.PRJMAX) GO TO 80
          PRJMAX = PROJ
          IMAX = IAO
   80   CONTINUE
        IAO = IMAX
        PROJ = PRJMAX
  100   CONTINUE
C
C  PUT VECTOR IN BORB, NORMALIZE, AND SAVE IN C:
C
        SB = ZERO
        DO 120 J = 1,NORB
          B = P(IAO,J)
          SB = SB + B * B
          BORB(J) = B
  120   CONTINUE
        LARC(IAO) = IPROJ
        RNORM = ONE / SQRT(SB)
        DO 130 J = 1,NORB
          BORB(J) = BORB(J) * RNORM
  130   CONTINUE
        DO 140 J = 1,NORB
          C(J,IPROJ) = BORB(J)
  140   CONTINUE
        IF(IPROJ.EQ.NAUG) GO TO 300
C
C  ADD BORB TO THE PROJECTOR IN P:
C
        DO 150 J = 1,NORB
          DO 145 I = 1,J
            TA(I,J) = -BORB(I) * BORB(J)
            TA(J,I) = TA(I,J)
            IF(I.EQ.J) TA(I,I) = TA(I,I) + ONE
  145     CONTINUE
  150   CONTINUE
        DO 200 I = 1,NORB
          DO 180 J = 1,NORB
            V(J) = ZERO
            DO 170 L = 1,NORB
              V(J) = V(J) + P(I,L) * TA(L,J)
  170       CONTINUE
  180     CONTINUE
          DO 190 J = 1,NORB
            P(I,J) = V(J)
  190     CONTINUE
  200   CONTINUE
  300 CONTINUE
C
C  PUT PROJECTED VECTORS IN TA, ORDERED ACCORDING TO THE NAO PARENT:
C
      IAUG = 0
      DO 350 IAO = 1,NORB
        IF(LARC(IAO).EQ.0) GO TO 350
        IAUG = IAUG + 1
        ITCOL = LARC(IAO)
        DO 330 J = 1,NORB
          TA(J,IAUG) = C(J,ITCOL)
  330   CONTINUE
  350 CONTINUE
C
C  LOAD DM BLOCK FOR ATOM IA IN BLK:
C
      CALL LOAD(DM,IA,0,0,BLK,NORB)
C
C  FORM BLOCK OF DM IN RYDBERG BASIS IN UPPER CORNER OF BLK:
C
      DO 500 IB = 1,NORB
        DO 450 J = 1,NAUG
          SUM = ZERO
          DO 440 K = 1,NORB
            SUM = SUM + BLK(IB,K) * TA(K,J)
  440     CONTINUE
          V(J) = SUM
  450   CONTINUE
        DO 480 J = 1,NAUG
          BLK(IB,J) = V(J)
  480   CONTINUE
  500 CONTINUE
      DO 550 J = 1,NAUG
        DO 520 I = 1,J
          SUM = ZERO
          DO 510 K = 1,NORB
            SUM = SUM + TA(K,I) * BLK(K,J)
  510     CONTINUE
          V(I) = SUM
  520   CONTINUE
        DO 530 I = 1,NAUG
          BLK(I,J) = V(I)
  530   CONTINUE
  550 CONTINUE
      DO 560 J = 1,NAUG
        JJ = J - 1
        DO 555 I = 1,JJ
          BLK(J,I) = BLK(I,J)
  555   CONTINUE
  560 CONTINUE
C
C  DIAGONALIZE DM:
C
      CALL JACOBI(NAUG,BLK,EVAL,C,MXBO,MXBO,1)
C
C  ORDER EIGENVECTORS BY OCCUPANCY (WITHIN EPS), FORM FINAL RYDBERG VECTORS:
C
      DO 570 I = 1,NAUG
        LARC(I) = I
  570 CONTINUE
      NAUG1 = NAUG - 1
      DO 620 I = 1,NAUG1
        I1 = I + 1
        DO 610 J = I1,NAUG
          DIFF = EVAL(J) - EVAL(I)
          IF(DIFF.LT.EPS) GO TO 610
          TEMP = EVAL(I)
          EVAL(I) = EVAL(J)
          EVAL(J) = TEMP
          ITEMP = LARC(I)
          LARC(I) = LARC(J)
          LARC(J) = ITEMP
  610   CONTINUE
  620 CONTINUE
      DO 700 J = 1,NAUG
        LJ = LARC(J)
        DO 680 I = 1,NORB
          SUM = ZERO
          DO 670 K = 1,NAUG
            SUM = SUM + TA(I,K) * C(K,LJ)
  670     CONTINUE
          BLK(I,J) = SUM
  680   CONTINUE
  700 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE REPOL(DM,Q,POL,BLK,EVAL,C,NBD)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL PRINT,FIRST
C
C  DIAGONALIZE DENSITY MATRIX IN BASIS OF ORTHONORMAL HYBRIDS FOR
C  EACH BOND ORBITAL TO FIND NEW POLARIZATION COEFFICIENTS.
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),IATHY(MAXBAS,3)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),ILL(MAXATM),
     +       IUL(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION DM(NDIM,NDIM),Q(MXAO,NDIM),POL(NDIM,3),
     *        BLK(MXBO,MXBO),EVAL(MXBO),C(MXBO,MXBO)
C
      SAVE ZERO,PT1,ONE,TWO,LSTAR
      DATA ZERO,PT1,ONE,TWO/0.0D0,0.1D0,1.0D0,2.0D0/
      DATA LSTAR/1H*/
C
C  FIRST, COUNT NUMBER OF BONDS AND 3C BONDS:
C
      NBOND = 0
      N3CB  = 0
      DO 20 IB = 1,NBAS
        IF(LABEL(IB,2).EQ.LSTAR) GO TO 20
        IF(LABEL(IB,5).EQ.0) GO TO 20
        NBOND = NBOND + 1
        IF(LABEL(IB,6).EQ.0) GO TO 20
        N3CB = N3CB + 1
   20 CONTINUE
C
C  IAB+1 IS THE NUMBER OF THE FIRST ANTIBOND IN THE NBO LIST:
C
      IAB = NBAS - NBOND - N3CB
C
      PRINT = JPRINT(5).EQ.1
      FIRST = .TRUE.
      APCOEF = ONE / SQRT(TWO)
      DO 200 IB = 1,NBD
        IF(LABEL(IB,2).EQ.LSTAR) GO TO 200
        NCTR = 1
        IF(LABEL(IB,5).GT.0) NCTR = 2
        IF(LABEL(IB,6).GT.0) NCTR = 3
        IF(NCTR.EQ.1) GO TO 200
        IF(IWAPOL.EQ.0.OR.NCTR.EQ.3) THEN
          DO 120 I = 1,NCTR
            IA  = LABEL(IB,I+3)
            NHI = NORBS(IA)
            DO 115 J = 1,I
              JA  = LABEL(IB,J+3)
              NHJ = NORBS(JA)
              DIJ = ZERO
              DO 110 IR = 1,NHI
                IRP = ILL(IA)+IR-1
                CRI = Q(IR,ILL(IA)+IATHY(IB,I)-1)
                DO 105 JS = 1,NHJ
                  JSP = ILL(JA) + JS - 1
                  CSJ = Q(JS,ILL(JA)+IATHY(IB,J)-1)
                  DIJ = DIJ+CRI*CSJ*DM(IRP,JSP)
  105           CONTINUE
  110         CONTINUE
              BLK(I,J) = DIJ
              BLK(J,I) = DIJ
  115       CONTINUE
  120     CONTINUE
C
C  DIAGONALIZE 'BLK' AND EXTRACT NEW POLARIZATION COEFFICIENTS
C
          CALL JACOBI(NCTR,BLK,EVAL,C,MXBO,MXBO,0)
          CALL RANK(EVAL,NCTR,MXBO,LARC)
C
C  MAKE SURE REPOLARIZATION IS NOT TOO DRASTIC (TAKE A LOOK AT THE BOND
C  ORBITAL ONLY):
C
          S = ZERO
          DO 125 I = 1,NCTR
            S = S + POL(IB,I) * C(I,LARC(1))
  125     CONTINUE
          IF(S.LT.PT1.AND.NCTR.EQ.2) THEN
            IF(FIRST.AND.PRINT) WRITE(LFNPR,*)
            FIRST = .FALSE.
            IF(PRINT) WRITE(LFNPR,900) IB,S
            IAB = IAB + 1
            POL(IAB,1) =  POL(IB,2)
            POL(IAB,2) = -POL(IB,1)
          ELSE
C
C  STORE THE NEW POLARIZATION COEFFICIENTS IN POL:
C
            DO 130 I = 1,NCTR
              POL(IB,I) = C(I,LARC(1))
  130       CONTINUE
            IAB = IAB + 1
            DO 150 I = 1,NCTR
              POL(IAB,I) = C(I,LARC(2))
  150       CONTINUE
            IF(NCTR.NE.3) GO TO 200
            IAB = IAB + 1
            DO 160 I = 1,NCTR
              POL(IAB,I) = C(I,LARC(3))
  160       CONTINUE
          END IF
C
C  CONSTRAIN BONDS TO BE APOLAR, IF REQUESTED (NOT SET UP TO WORK WITH
C  3-CENTER BONDS):
C
        ELSE
          POL(IB,1) = APCOEF
          POL(IB,2) = APCOEF
          IAB = IAB + 1
          POL(IAB,1) = APCOEF
          POL(IAB,2) = -APCOEF
        END IF
  200 CONTINUE
      RETURN
C
  900 FORMAT(1X,'WARNING: significant repolarization of NBO ',I3,' (S=',
     + F7.4,'); REPOL disabled.')
      END
C*****************************************************************************
      SUBROUTINE FORMT(T,Q,POL)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER UL
C
C  CONSTRUCTION OF FINAL TRANSFORMATION  MATRIX T FROM ORTHONORMAL
C  HYBRIDS; ROWS OF T LABELLED BY NAOS, COLUMNS BY NBOS.
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOC(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),IBX(MAXBAS),IATHY(MAXBAS,3)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       UL(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBNAO/NAOCTR(MAXBAS),NAOA(MAXBAS),LTYP(MAXBAS),
     +       IPRIN(MAXBAS)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
      DIMENSION T(NDIM,NDIM),Q(MXAO,NDIM),POL(NDIM,3)
C
      SAVE LCR,LLP,LBD,LSTAR,LRY,ZERO
      DATA LCR,LLP,LBD,LSTAR,LRY/2HCR,2HLP,2HBD,1H*,2HRY/
      DATA ZERO/0.0D0/
C
C  REORDER OCCUPIED NBOS TO PUT LONE AND CORE PAIRS LAST:
C
      NCR = 0
      NLP = 0
      NBDS = 0
      DO 10 NSCAN = 1,NBAS
        IF(LABEL(NSCAN,2).EQ.LSTAR) GO TO 10
        NBDS = NBDS + 1
        IF(LABEL(NSCAN,1).EQ.LLP) NLP = NLP + 1
        IF(LABEL(NSCAN,1).EQ.LCR) NCR = NCR + 1
   10 CONTINUE
      ICR = 0
      ILP = 0
      IBO = 0
      IAB = 0
      DO 40 IBD = 1,NBAS
        IF(LABEL(IBD,2).EQ.LSTAR) GO TO 30
        IF(LABEL(IBD,1).EQ.LCR) GO TO 15
        IF(LABEL(IBD,1).EQ.LLP) GO TO 20
C
C  PAIR BONDS:
C
        IBO = IBO + 1
        IBX(IBD) = IBO
        GO TO 40
C
C  CORE PAIRS:
C
   15   ICR = ICR + 1
        IBX(IBD) = ICR + NBDS - NCR - NLP
        GO TO 40
C
C  LONE PAIRS AND CORE PAIRS:
C
   20   ILP = ILP + 1
        IBX(IBD) = ILP + NBDS - NLP
        GO TO 40
C
C  ANTIBONDS:
C
   30   IAB = IAB + 1
        IBX(IBD) = NBDS + IAB
   40 CONTINUE
C
C  ZERO TRANSFORMATION ARRAY:
C
      DO 60 I = 1,NBAS
        DO 50 J = 1,NBAS
          T(I,J) = ZERO
   50   CONTINUE
   60 CONTINUE
C
C  DEPOSIT FINAL BOND ORBITALS IN MATRIX T:
C
      NBO = 0
      DO 130 IBD = 1,NBAS
        KBD = IBD
        IF(LABEL(IBD,2).NE.LSTAR) GO TO 100
        IF(LABEL(IBD,1).EQ.LRY) GO TO 100
        IF(LABEL(IBD,1).EQ.LLP) GO TO 100
C
C  ANTIBOND ORBITALS: SEARCH OCCUPIED ORB. LIST TO GET PROPER HYBRIDS.
C  SEARCH OCCUPIED BOND ORBS. FOR MATCH WITH ANTIBOND ATOMS:
C
        DO 90 K = 1,NBO
          DO 70 I = 4,6
            IF(LABEL(K,I).NE.LABEL(IBD,I)) GO TO 90
            IF((LABEL(K,3).LE.0).AND.(LABEL(K,1).EQ.LBD)) GO TO 90
   70     CONTINUE
C
C  NEGATIVE IRNK = LABEL(K,3) MEANS BOND ORBITAL WAS ALREADY USED:
C
C  FOUND MATCH; SET LABEL(K,3)<0:
C
          KBD = K
          LABEL(KBD,3) = -LABEL(KBD,3)
          GO TO 100
   90   CONTINUE
C
C  COULDN'T FIND MATCH...EXIT:
C
        WRITE(LFNPR,9000) IBD,(LABEL(IBD,JJ),JJ=1,6)
        STOP
C
C  DEPOSIT BOND ORBITALS IN T MATRIX:
C
  100   CONTINUE
        DO 120 I = 1,3
          IA = LABEL(IBD,I+3)
          IF(IA.EQ.0) GO TO 120
          JL = LL(IA)
          JU = UL(IA)
          IROW = 0
          ICOL = JL + IATHY(KBD,I) - 1
          DO 110 J = JL,JU
            IROW = IROW + 1
            JB = IBX(IBD)
  110       T(J,JB) = POL(IBD,I) * Q(IROW,ICOL)
  120     CONTINUE
        IF(IBD.EQ.KBD) NBO = IBD
  130   CONTINUE
C
C  RESTORE LABEL(I,3) > 0:
C
      DO 140 I = 1,NBAS
        IF(LABEL(I,3).LT.0) LABEL(I,3) = -LABEL(I,3)
  140   CONTINUE
C
C  SET ARRAY IBXM: IBXM(IB) IS THE CURRENT LOCATION OF B.O. # IB:
C
      DO 150 IB = 1,NBAS
        I = IBX(IB)
  150   IBXM(I) = IB
C
C  SET PHASE OF 1-CENTER ORBITALS SUCH THAT THE LARGEST S-TYPE NAO CONTRIBUTION
C  IS POSITIVE:
C
      DO 200 IB = 1,NBAS
        NCTR = 1
        DO 160 IL = 5,6
          IF(LABEL(IBXM(IB),IL).NE.0) NCTR = NCTR + 1
  160   CONTINUE
        IF(NCTR.EQ.1) THEN
          JMAX = 0
          TMAX = -1.0D0
          DO 170 IN = 1,NBAS
            IF(NAOA(IN).LT.100) THEN
              IF(ABS(T(IN,IB)).GT.TMAX) THEN
                JMAX = IN
                TMAX = ABS(T(IN,IB))
              END IF
            END IF
  170     CONTINUE
          IF(JMAX.NE.0) THEN
            IF(T(JMAX,IB).LT.-1.0D-4) THEN
              DO 180 IN = 1,NBAS
                T(IN,IB) = -T(IN,IB)
  180         CONTINUE
            END IF
          END IF
        END IF
  200 CONTINUE
      RETURN
C
 9000 FORMAT(/,1X,'Can''t find bond/antibond match for NBO ',
     + I3,2X,A2,A1,'(',I2,')',3I4)
      END
C*****************************************************************************
      SUBROUTINE CYCLES(ITER,THRESH,GUIDE,BNDOCC,TOPO,ICONT)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),IATHY(MAXBAS,3)
      COMMON/NBTHR/THRSET,PRJSET,ACCTHR,CRTSET,E2THR,ATHR,PTHR,ETHR,
     +             DTHR,DLTHR,CHSTHR
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBTOPO/IORDER(MAXATM),JORDER(MAXATM),NTOPO(MAXATM,MAXATM),
     +            N3CTR,I3CTR(10,3)
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION GUIDE(NATOMS,NATOMS),BNDOCC(NDIM),TOPO(NATOMS,NATOMS)
C
      SAVE JTER,DEVMIN,RHOMIN,BEST,RHO,JBADL
      SAVE LCR,LBD,L3C,LLP,LSTAR,DEVTHR,JTERMX
      SAVE SMALL,ZERO,TENTH,ONE,ONEPT5,THREE,HUNDRD
C
      DATA LCR,LBD,L3C,LLP,LSTAR/2HCR,2HBD,2H3C,2HLP,1H*/
      DATA SMALL,ZERO,TENTH,ONE,ONEPT5,THREE,HUNDRD
     +              /1.0D-4,0.0D0,0.1D0,1.0D0,1.5D0,3.0D0,1.0D2/
      DATA DEVTHR/0.1D0/
      DATA JTERMX/9/
C
C  Subroutine CYCLES controls the search for an acceptable resonance
C  structure:
C
C  Arguments:
C        ITER   : iteration counter incremented by the calling routine
C        THRESH : occupancy threshold used in search for NBOs
C        GUIDE  : Wiberg bond index
C        BNDOCC : array containing the NBO occupancies
C        TOPO   : bond index matrix to be compared with the Wiberg indices
C        ICONT  : control flag (see below)
C
C  ITER, GUIDE, and BNDOCC are unaltered by this routine
C  THRESH is modified by this routine, if the RESONANCE keyword is selected
C  The TOPO matrix is constructed by this routine
C
C  Control flag : (set by this routine)
C    ICONT =  2 : an acceptable Lewis structure has been found, continue
C          =  1 : an acceptable Lewis structure has been found, recompute the
C                 NBOs for this structure
C          =  0 : bogus Lewis structure, terminate search for NBOs
C          = -1 : occupancy threshold and/or atom ordering have been
C                 changed.  Repeat the search for NBOs.
C
C  Set atom permuting counter and minimum deviation in GUIDE-TOPO:
C
      IF(ITER.EQ.1) THEN
        JTER  =  0
        ICONT = -1
      END IF
      JTER = JTER + 1
      IF(JTER.EQ.1) DEVMIN = HUNDRD
C
C  The minimum occupancy threshold is 1.5e (0.5e for open shell):
C
      THRMIN = ONEPT5
      IF(ISPIN.NE.0) THRMIN = THRMIN - ONE
C
C  Determine the number of low occupancy orbitals in the Lewis structure:
C
      IBADL  = 0
      IBADNL = 0
      SUMLEW = ZERO
      TOTELE = ZERO
      DO 10 I = 1,NBAS
        TOTELE = TOTELE + BNDOCC(I)
        IF(LABEL(IBXM(I),2).NE.LSTAR) THEN
          SUMLEW = SUMLEW + BNDOCC(I)
          IF(BNDOCC(I).LT.THRESH) IBADL = IBADL + 1
        ELSE
          IF(BNDOCC(I).GT.ABS(ACCTHR)) IBADNL = IBADNL + 1
        END IF
   10 CONTINUE
      NEL    = TOTELE + TENTH
      TOTELE = NEL
      SUM    = TOTELE - SUMLEW
C
C  Count the ECP electrons in the Lewis structure:
C
      IF(IPSEUD.NE.0) THEN
        MECP = 0
        DO 20 IAT = 1,NATOMS
          MECP = MECP + IATNO(IAT) - IZNUC(IAT)
   20   CONTINUE
        IF(ISPIN.NE.0) MECP = MECP/2
        SUMLEW = SUMLEW + FLOAT(MECP)
      END IF
C
C  Keep track of the best Lewis structure found so far:
C
      IF(JTER.EQ.1) RHOMIN = HUNDRD
      IF(ITER.EQ.1.OR.SUM.LT.RHO) THEN
        BEST  = THRESH
        RHO   = SUM
        JBADL = IBADL
        DO 25 I = 1,NATOMS
          JORDER(I) = IORDER(I)
   25   CONTINUE
      END IF
C
C  Count the number of core, lone pair, and bonding orbitals in this
C  resonance structure:
C
      MCR = 0
      MBD = 0
      M3C = 0
      MLP = 0
      DO 30 I = 1,NBAS
        IF(LABEL(I,1).EQ.LCR.AND.LABEL(I,2).NE.LSTAR) MCR = MCR + 1
        IF(LABEL(I,1).EQ.LBD.AND.LABEL(I,2).NE.LSTAR) MBD = MBD + 1
        IF(LABEL(I,1).EQ.L3C.AND.LABEL(I,2).NE.LSTAR) M3C = M3C + 1
        IF(LABEL(I,1).EQ.LLP.AND.LABEL(I,2).NE.LSTAR) MLP = MLP + 1
   30 CONTINUE
C
C  Build the TOPO matrix from lone pairs and 2- and 3-center bonds:
C
      DO 50 I = 1,NATOMS
        DO 40 J = 1,NATOMS
          TOPO(I,J) = ZERO
   40   CONTINUE
   50 CONTINUE
C
      DO 60 I = 1,NBAS
        IB   = IBXM(I)
        IF(LABEL(IB,1).NE.LCR.AND.LABEL(IB,2).NE.LSTAR) THEN
          IAT1 = LABEL(IB,4)
          NCTR = 1
          IAT2 = LABEL(IB,5)
          IF(IAT2.NE.0) NCTR = 2
          IAT3 = LABEL(IB,6)
          IF(IAT3.NE.0) NCTR = 3
          IF(NCTR.EQ.1) THEN
            TOPO(IAT1,IAT1) = TOPO(IAT1,IAT1) + ONE
          ELSE IF(NCTR.EQ.2) THEN
            TOPO(IAT1,IAT2) = TOPO(IAT1,IAT2) + ONE
            TOPO(IAT2,IAT1) = TOPO(IAT2,IAT1) + ONE
          ELSE
            TOPO(IAT1,IAT2) = TOPO(IAT1,IAT2) + ONE/THREE
            TOPO(IAT2,IAT1) = TOPO(IAT2,IAT1) + ONE/THREE
            TOPO(IAT1,IAT3) = TOPO(IAT1,IAT3) + ONE/THREE
            TOPO(IAT3,IAT1) = TOPO(IAT3,IAT1) + ONE/THREE
            TOPO(IAT2,IAT3) = TOPO(IAT2,IAT3) + ONE/THREE
            TOPO(IAT3,IAT2) = TOPO(IAT3,IAT2) + ONE/THREE
          END IF
        END IF
   60 CONTINUE
C
C  Determine the largest off-diagonal element of GUIDE-TOPO:
C
      DEV = ZERO
      DO 80 J = 2,NATOMS
        DO 70 I = 1,J-1
          IF(GUIDE(I,J)-TOPO(I,J).GT.DEV) THEN
            DEV = GUIDE(I,J) - TOPO(I,J)
            IAT = I
            JAT = J
          END IF
   70   CONTINUE
   80 CONTINUE
C
C  Write info about this resonance structure:
C
      IF(JPRINT(5).EQ.1) THEN
        IF(ITER.EQ.1) WRITE(LFNPR,1000)
        WRITE(LFNPR,1010) ITER,JTER,ABS(THRESH),SUMLEW,SUM,MCR,MBD,
     +                    M3C,MLP,IBADL,IBADNL,DEV
      END IF
C
C  Decide if this structure is acceptable:
C
C   *  Accept the structure if CHOOSE was employed.
C   *  Accept the structure if there is only one atom.
C   *  Accept the structure if there are no low occupancy Lewis orbitals
C      and DEV is less than DEVTHR.
C   *  Accept the structure if the NOBOND option was selected.
C
C  Good resonance structure:
C
      IF(IBADL.EQ.0.AND.DEV.LT.DEVTHR) THEN
        IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
        IF(JPRINT(5).EQ.1) WRITE(LFNPR,1030)
        ICONT = 2
        RETURN
C
C  Only one atom:
C
      ELSE IF(NATOMS.EQ.1) THEN
        IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
        IF(JPRINT(5).EQ.1) WRITE(LFNPR,1035)
        ICONT = 2
        RETURN
C
C  Directed NBO search:
C
      ELSE IF(ICHOOS.EQ.1) THEN
        IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
        IF(JPRINT(5).EQ.1) WRITE(LFNPR,1040)
        ICONT = 2
        RETURN
C
C  NOBOND option selected:
C
      ELSE IF(JPRINT(10).NE.0) THEN
        IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
        IF(JPRINT(5).EQ.1) WRITE(LFNPR,1050)
        ICONT = 2
        RETURN
      END IF
C
C  Structure accepted due to the specification of the RESONANCE keyword
C  or the occupancy threshold.  Otherwise, accept the structure only if
C  there are no high occupancy Lewis orbitals:
C
      IF(ICONT.EQ.1) THEN
        IF(THRSET.GE.ZERO) THEN
          IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
          IF(JPRINT(5).EQ.1) WRITE(LFNPR,1060)
          ICONT = 2
        ELSE IF(JPRINT(14).NE.0) THEN
          IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
          IF(JPRINT(5).EQ.1) WRITE(LFNPR,1070)
          ICONT = 2
        ELSE IF(IBADL.NE.0) THEN
          IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
          IF(JPRINT(5).EQ.1) WRITE(LFNPR,1030)
          ICONT = 2
        END IF
        RETURN
      END IF
C
C  If DEV.EQ.DEVMIN.AND.SUM.EQ.RHOMIN or too many atoms permutations,
C  stop atom permutations:
C
      IF((ABS(DEV-DEVMIN).LT.SMALL.AND.ABS(SUM-RHOMIN).LT.SMALL).OR.
     +                                 JTER.GE.JTERMX) THEN
C
C  If the occupancy threshold was set by the user, accept the best
C  structure:
C
        IF(THRSET.GE.ZERO) THEN
          IF(ABS(SUM-RHO).LT.SMALL) THEN
            IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
            IF(JPRINT(5).EQ.1) WRITE(LFNPR,1060)
            ICONT = 2
          ELSE
            DO 90 I = 1,NATOMS
              IORDER(I) = JORDER(I)
   90       CONTINUE
            JTER  = 0
            ICONT = 1
          END IF
C
C  If the RESONANCE keyword was specified, pick the best resonance structure
C  for this occupancy threshold, and possibly decrement the threshold and
C  continue the search:
C
        ELSE IF(JPRINT(14).NE.0) THEN
          THRESH = THRESH - TENTH
          IF(THRMIN-THRESH.GT.SMALL) THEN
            THRESH = THRESH + TENTH
            IF(ABS(THRESH-BEST).LT.SMALL.AND.ABS(SUM-RHO).LT.SMALL) THEN
              IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
              IF(JPRINT(5).EQ.1) WRITE(LFNPR,1070)
              ICONT = 2
            ELSE
              DO 100 I = 1,NATOMS
                IORDER(I) = JORDER(I)
  100         CONTINUE
              THRESH = BEST
              JTER  = 0
              ICONT = 1
            END IF
          ELSE
            DO 110 I = 1,NATOMS
              IORDER(I) = JORDER(I)
  110       CONTINUE
            JTER  =  0
            ICONT = -1
          END IF
C
C  Otherwise, accept the best structure, but only if it had no Lewis
C  orbitals with occupancy less than the occupancy threshold:
C
        ELSE
          IF(ABS(SUM-RHO).LT.SMALL.AND.IBADL.EQ.0) THEN
            IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
            IF(JPRINT(5).EQ.1) WRITE(LFNPR,1030)
            ICONT = 2
          ELSE IF(JBADL.EQ.0) THEN
            DO 115 I = 1,NATOMS
              IORDER(I) = JORDER(I)
  115       CONTINUE
            JTER  = 0
            ICONT = 1
          ELSE
            IF(JPRINT(5).EQ.1) WRITE(LFNPR,1020)
            IF(JPRINT(5).EQ.1) WRITE(LFNPR,1080)
            ICONT = 0
          END IF
        END IF
        RETURN
C
C  Loop through atom ordering to find alternative resonance structures:
C
      ELSE
        IF(DEV.LT.DEVMIN) DEVMIN = DEV
        IF(SUM.LT.RHOMIN) RHOMIN = SUM
        IF(IAT.EQ.IORDER(1).AND.JAT.EQ.IORDER(2)) THEN
          DEV1 = ZERO
          DO 130 J = 2,NATOMS
            DO 120 I = 1,J-1
              IF(GUIDE(I,J)-TOPO(I,J).GT.DEV1) THEN
                IF((I.NE.IORDER(1).AND.J.NE.IORDER(2)).AND.
     +             (J.NE.IORDER(1).AND.I.NE.IORDER(2))) THEN
                  DEV1 = GUIDE(I,J) - TOPO(I,J)
                  IAT  = I
                  JAT  = J
                END IF
              END IF
  120       CONTINUE
  130     CONTINUE
        END IF
C
        JFLG = 0
        DO 140 I = NATOMS,2,-1
          IF(IORDER(I).EQ.JAT) JFLG = 1
          IF(JFLG.EQ.1) IORDER(I) = IORDER(I-1)
  140   CONTINUE
        IORDER(1) = JAT
        IFLG = 0
        DO 150 I = NATOMS,2,-1
          IF(IORDER(I).EQ.IAT) IFLG = 1
          IF(IFLG.EQ.1) IORDER(I) = IORDER(I-1)
  150   CONTINUE
        IORDER(1) = IAT
        ICONT = -1
      END IF
      RETURN
C
 1000 FORMAT(/1X,'                      Occupancies       Lewis ',
     + 'Structure    Low   High',/1X,'          Occ.    --------',
     + '-----------  -----------------   occ   occ',/1X,' Cycle ',
     + '  Thresh.   Lewis   Non-Lewis     CR  BD  3C  LP    (L) ',
     + '  (NL)   Dev',/1X,77('='))
 1010 FORMAT(1X,I3,'(',I1,')',3X,F5.2,F12.5,F10.5,3X,4I4,2X,I4,3X,I4,
     + 3X,F5.2)
 1020 FORMAT(1X,77('-'))
 1030 FORMAT(/1X,'Structure accepted: No low occupancy Lewis orbitals')
 1035 FORMAT(/1X,'Structure accepted: Only a single atom')
 1040 FORMAT(/1X,'Structure accepted: NBOs selected via the $CHOOSE ',
     + 'keylist')
 1050 FORMAT(/1X,'Structure accepted: Search for bonds prevented ',
     + 'by NOBOND keyword')
 1060 FORMAT(/1X,'Structure accepted: Occupancy threshold (THRESH) ',
     + 'set by user')
 1070 FORMAT(/1X,'Structure accepted: RESONANCE keyword permits ',
     + 'strongly delocalized structure')
 1080 FORMAT(/1X,'Only strongly delocalized resonance structures can',
     + ' be found.',/1X,'The default procedure is to abort the NBO ',
     + 'search.  Include',/1X,'the RESONANCE keyword in the $NBO ',
     + 'keylist to override this test.')
      END
C*****************************************************************************
C
C  ROUTINES CALLED BY SR NLMO:
C
C      SUBROUTINE SYMUNI(TSYM,A,COS,SIN,OVLP,BLK,EVAL,NROT,
C     +           NIUNIQ,NJUNIQ,ILIST,JLIST,NOFF,IOFF,JOFF,NDIM)
C      SUBROUTINE SYMORT(S,T,BLK,NDIM,N,EVAL)
C
C*****************************************************************************
      SUBROUTINE SYMUNI(TSYM,A,COS,SIN,OVLP,BLK,EVAL,NROT,
     *           NIUNIQ,NJUNIQ,ILIST,JLIST,NOFF,IOFF,JOFF,NDIM)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
      DIMENSION TSYM(NROT,NROT),A(NDIM,NDIM),BLK(NROT,NROT),
     *  OVLP(NROT,NROT),EVAL(NROT)
      DIMENSION IOFF(NOFF),JOFF(NOFF),ILIST(NOFF),JLIST(NOFF)
C
      SAVE ZERO,ONE,EPS
      DATA ZERO,ONE/0.0D0,1.0D0/
      DATA EPS/1.0D-6/
C
      DO 40 I=1,NROT
        DO 30 J=1,NROT
   30     TSYM(I,J)=ZERO
   40     TSYM(I,I)=ONE
      DO 60 MOFF=1,NOFF
        IOCC=ILIST(MOFF)
        JEMT=JLIST(MOFF)
        DO 60 I=1,NROT
          T=TSYM(I,IOCC)
          U=TSYM(I,JEMT)
          TSYM(I,IOCC)=COS*T-SIN*U
   60     TSYM(I,JEMT)=SIN*T+COS*U
C
C   AVERAGE GROUPS OF THE ELEMENTS OF THE TRANSFORMATION MATRIX TSYM
C    SO THAT THE SYMMETRY INHERENT IN THE DENSITY MATRIX A IS PRESERVED,
C    MAKING SURE THAT THE RESULTING "AVERAGED" TRANSFORMATION IS UNITARY
C
C
      JST=NIUNIQ+1
      NROT=JST-1+NJUNIQ
C
C   AVE. DIAG. ELEM OF OCC ORBS
      IF(NIUNIQ.EQ.1) GO TO 140
      TOT=ZERO
      DO 100 I=1,NIUNIQ
  100   TOT=TOT+TSYM(I,I)
      AVE=TOT/NIUNIQ
      DO 110 I=1,NIUNIQ
  110   TSYM(I,I)=AVE
C
C   AVE. DIAG. ELEM OF EMPTY ORBS
  140 IF(NJUNIQ.EQ.1) GO TO 180
      TOT=ZERO
      DO 150 J=JST,NROT
  150   TOT=TOT+TSYM(J,J)
      AVE=TOT/NJUNIQ
      DO 160 J=JST,NROT
  160   TSYM(J,J)=AVE
C
C  ZERO OFFDIAG ELEM BETW OCC ORBS:
  180 IF(NIUNIQ.EQ.1) GO TO 240
      DO 220 I=2,NIUNIQ
        DO 220 J=1,I
          IF(I.EQ.J) GO TO 220
          TSYM(I,J)=ZERO
          TSYM(J,I)=ZERO
  220     CONTINUE
C
C  ZERO OFFDIAG ELEM BETW EMPTY ORBS:
  240 IF(NJUNIQ.EQ.1) GO TO 280
      JST2=JST+1
      DO 270 I=JST2,NROT
        DO 270 J=JST,I
          IF(I.EQ.J) GO TO 270
          TSYM(I,J)=ZERO
          TSYM(J,I)=ZERO
  270     CONTINUE
C
C  AVE. OFFDIAG ELEM BETW OCC AND EMPTY ORBS (PIVOTED ELEMENTS ONLY):
  280 CONTINUE
      TOT=ZERO
      DO 310 MOFF=1,NOFF
        II=ILIST(MOFF)
        JJ=JLIST(MOFF)
  310   TOT=TOT+ABS(TSYM(II,JJ))+ABS(TSYM(JJ,II))
      NOFF2=NOFF*2
      AVE=TOT/NOFF2
      DO 330 MOFF=1,NOFF
        II=ILIST(MOFF)
        JJ=JLIST(MOFF)
        TSYM(II,JJ)=-AVE
  330   TSYM(JJ,II)= AVE
C
C  NOW ZERO THE NON-PIVOTED ELEMENTS:
      DO 450 I=1,NIUNIQ
        DO 440 J=JST,NROT
          DO 420 MOFF=1,NOFF
            IF(I.EQ.ILIST(MOFF).AND.J.EQ.JLIST(MOFF)) GO TO 440
  420       CONTINUE
          TSYM(I,J)= ZERO
          TSYM(J,I)= ZERO
  440     CONTINUE
  450   CONTINUE
C
C  RENORMALIZE VECTORS:
      DO 700 J=1,NROT
        TOT=ZERO
        DO 650 I=1,NROT
  650     TOT=TOT+TSYM(I,J)*TSYM(I,J)
        RNORM=SQRT(TOT)
        IF(RNORM.GT.EPS) GO TO 680
          WRITE(LFNPR,2880) NROT,TOT,EPS,RNORM
 2880     FORMAT('NROT,TOT,EPS,RNORM:',I3,3F14.9)
          CALL ALTOUT(TSYM,NROT,NROT,NROT,NROT)
          STOP
  680   CONTINUE
        DO 690 I=1,NROT
  690     TSYM(I,J)=TSYM(I,J)/RNORM
  700   CONTINUE
C
C  NOW, MAKE SURE THE SIGNS ARE CORRECT:
      DO 800 MOFF=1,NOFF
        I=IOFF(MOFF)
        J=JOFF(MOFF)
        IF(A(I,J).GT.ZERO) GO TO 800
          II=ILIST(MOFF)
          JJ=JLIST(MOFF)
          TSYM(II,JJ)=-TSYM(II,JJ)
          TSYM(JJ,II)=-TSYM(JJ,II)
  800   CONTINUE
C
C  FINALLY, THE CRUCIAL STEP OF SYMMETRICALLY ORTHOGONALIZING THE VECTORS
C   SO THAT THE TRANSFORMATION IS UNITARY:
      CALL SYMORT(OVLP,TSYM,BLK,NROT,NROT,EVAL)
      RETURN
C
      END
C*****************************************************************************
      SUBROUTINE SYMORT(S,T,BLK,NDIM,N,EVAL)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C******************************************************************
C
C   SYMORT: SYMMETRIC ORTHOGONALIZATION SUBROUTINE
C
C   S:           FULL OVERLAP MATRIX               (DESTROYED!)
C   T:           VECTORS TO BE ORTHOGED.
C   N:           NUMBER OF VECTORS
C
C   NOTE:    BLK AND BIGBLK SHARE THE SAME STORAGE BUT ARE
C               DIMENSIONED DIFFERENTLY.
C            THE SAME APPLIES FOR S AND SBLK.
C
C******************************************************************
      DIMENSION S(N,N),T(NDIM,NDIM),BLK(N,N),EVAL(N)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      SAVE ZERO,ONE
      DATA ZERO,ONE/0.0D0,1.0D0/
C
C  IMPORTANT CONSTANTS:
C           DIAGTH          THRESHOLD FOR MATRIX DIAGONALIZATION USED IN
C                            SUBROUTINE JACOBI.  IN JACOBI, THIS CONSTANT
C                            IS CALLED "DONETH".
C           DANGER          CRITERION FOR DECIDING THAT THE JOB SHOULD BE
C                            ABORTED DUE TO NUMERICAL PROBLEMS CAUSED BY NEAR
C                            LINEAR DEPENDENCIES IN THE BASIS SET.  ALL
C                            EIGENVALUES OF THE WEIGHTED OVERLAP MATRIX MUST
C                            BE GREATER THAN DIAGTH*DANGER.
C
      SAVE DIAGTH,DANGER
      DATA DIAGTH,DANGER/1.0D-12,1.0D3/
C
C  FORM THE INVERSE SQRT OF THE OVERLAP MATRIX OF THE VECTORS:
      DO 70 I=1,N
        DO 70 J=1,N
          SIJ=ZERO
          DO 40 K=1,N
   40       SIJ=SIJ+T(K,I)*T(K,J)
   70     S(I,J)=SIJ
      CALL JACOBI(N,S,EVAL,BLK,N,N,0)
      SMLEST=ONE
      TOOSML=DIAGTH*DANGER
      DO 150 I=1,N
        EIGENV=EVAL(I)
        IF(EIGENV.LT.TOOSML) GO TO 900
        EVAL(I)=ONE/SQRT(EIGENV)
        IF(EIGENV.LT.SMLEST) SMLEST=EIGENV
  150  CONTINUE
      DO 170 I=1,N
        DO 170 J=1,I
          SIJ=ZERO
          DO 160 K=1,N
  160       SIJ=SIJ+EVAL(K)*BLK(I,K)*BLK(J,K)
          S(I,J)=SIJ
  170     S(J,I)=SIJ
C
C  S NOW CONTAINS THE -0.5 POWER OF THE OVERLAP MATRIX,
C   AND IS THE ORTHOG. TRANSFORM THAT WE WANT.
C   NOW, FORM THE TOTAL TRANSFORMATION:
      DO 210 I=1,N
        DO 200 J=1,N
          EVAL(J)=ZERO
          DO 200 K=1,N
  200       EVAL(J)=EVAL(J)+T(I,K)*S(K,J)
      DO 210 J=1,N
  210   T(I,J)=EVAL(J)
      RETURN
C
  900 WRITE(LFNPR,910) EIGENV,TOOSML
  910 FORMAT(/1X,'An eigenvalue of the overlap matrix of the ',
     *   'symmetrized Jacobi transf. ',
     *   'matrix of ',E13.5,' has been found.'/1X,
     *   'This is lower than the allowed threshold of ',E13.5)
      STOP
      END
C*****************************************************************************
C
C  NBO ENERGETIC ANALYSIS ROUTINES:
C
C      SUBROUTINE NBOEAN(A,MEMORY,NBOOPT,IDONE)
C      SUBROUTINE NBODEL(A,MEMORY,IDONE)
C      SUBROUTINE DELETE(F,TRF,NDIM,IDEL,LEN,ITYPE,NDEL,NTRUNC,DONE,
C     +                  ISPIN)
C      SUBROUTINE NEWDM(DM,U,EIG,NDIM,IDEL,LEN,NDEL,ITYPE,NMOOCC,ISPIN)
C      SUBROUTINE RNKEIG(RANK,EIG,N,NDIM,ARCRNK)
C      SUBROUTINE SIMLTR(N,NDIM,F,U,R,S,KNTROL)
C
C*****************************************************************************
      SUBROUTINE NBOEAN(A,MEMORY,NBOOPT,IDONE)
C*****************************************************************************
C
C     NBOEAN: CONTROLLER SUBROUTINE TO DO NBO ENERGETIC ANALYSIS
C               BY FOCK MATRIX DELETION METHOD
C
C       A(MEMORY) IS SCRATCH STORAGE
C
C       NBOOPT(1) = 2       READ IN NEXT DELETION AND FORM NEW DM
C                 = 3       COMPUTE ENERGY CHANGE FOR THIS DELETION
C
C       SET IDONE TO 1 IF NO DELETIONS ARE FOUND:
C
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ERROR,NEW,SEQ
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION A(MEMORY),NBOOPT(10)
C
      SAVE THRNEG,ONE,AUKCAL,EVKCAL
      DATA THRNEG/-1.0D-3/
      DATA ONE,AUKCAL,EVKCAL/1.0D0,627.52791,23.061/
C
C  OPEN THE OLD NBO DAF:
C
      NEW = .FALSE.
      CALL NBOPEN(NEW,ERROR)
      IF(ERROR) THEN
        IDONE = 1
        RETURN
      END IF
      CALL FEINFO(A,ISWEAN)
C
C  IF NBOOPT(1) = 3,  COMPUTE THE ENERGY OF DELETION:
C
      IF(NBOOPT(1).EQ.3) THEN
        CALL FEE0(EDEL,ETOT)
        ECHANG = EDEL - ETOT
        IF(MUNIT.EQ.0) THEN
          CONV = AUKCAL
        ELSE IF(MUNIT.EQ.1) THEN
          CONV = EVKCAL
        ELSE
          CONV = ONE
        END IF
        EKCAL = ECHANG * CONV
        IF(EKCAL.LT.THRNEG) WRITE(LFNPR,2130)
        IF(MUNIT.EQ.0) THEN
          WRITE(LFNPR,2100) EDEL,ETOT,ECHANG,EKCAL
        ELSE IF(MUNIT.EQ.1) THEN
          WRITE(LFNPR,2110) EDEL,ETOT,ECHANG,EKCAL
        ELSE
          WRITE(LFNPR,2120) EDEL,ETOT,ECHANG,EKCAL
        END IF
        IDONE = 0
        SEQ = .FALSE.
        CALL NBCLOS(SEQ)
        RETURN
      END IF
C
C  PERFORM THE NBO ENERGETIC ANALYSIS:
C
C  IF ISWEAN IS SET TO 1, SEARCH FOR THE $DEL KEYLIST:
C
      IF(ISWEAN.EQ.1) THEN
        CALL DELINP(NBOOPT,IDONE)
        IF(IDONE.EQ.1) GOTO 900
      ELSE IF(NBOOPT(10).GT.80) THEN
        CALL STRTIN(LFNIN)
      END IF
C
C  ROHF, MCSCF, CI, AND AUHF WAVE FUNCTIONS ARE NOT ACCEPTABLE:
C
      IF(ROHF.OR.MCSCF.OR.CI.OR.AUHF) THEN
        IDONE = 1
        GOTO 900
      END IF
C
      ISPIN = 0
      IF(UHF) ISPIN = 2
      ALPHA = .FALSE.
      BETA  = .FALSE.
      IF(UHF) ALPHA = .TRUE.
      CALL NBODEL(A,MEMORY,IDONE)
      IF(IDONE.EQ.1) GOTO 900
C
      IF(UHF) THEN
        ISPIN = -2
        ALPHA = .FALSE.
        BETA  = .TRUE.
        CALL NBODEL(A,MEMORY,IDONE)
      END IF
C
      WRITE(LFNPR,3000)
      SEQ = .FALSE.
      CALL NBCLOS(SEQ)
      RETURN
C
  900 CONTINUE
      SEQ = .FALSE.
      CALL NBCLOS(SEQ)
      RETURN
C
 2100 FORMAT(1X,78('-'),/,3X,
     +'Energy of deletion : ',F20.9,/,3X,
     +'  Total SCF energy : ',F20.9,/,3X,
     +'                       -------------------',/,3X,
     +'     Energy change : ',F17.6,' a.u.,   ',F13.3,' kcal/mol'/
     +1X,78('-'))
 2110 FORMAT(1X,78('-'),/,3X,
     +'Energy of deletion : ',F20.9,/,3X,
     +'  Total SCF energy : ',F20.9,/,3X,
     +'                       -------------------',/,3X,
     +'     Energy change : ',F17.6,' e.V.,   ',F13.3,' kcal/mol'/
     +1X,78('-'))
 2120 FORMAT(1X,78('-'),/,3X,
     +'Energy of deletion : ',F13.3,/,3X,
     +'  Total SCF energy : ',F13.3,/,3X,
     +'                       -------------------',/,3X,
     +'     Energy change : ',F13.3,' kcal/mol,   ',F13.3,' kcal/mol'/
     +1X,78('-'))
 2130 FORMAT(/,6X,
     +'***** WARNING *****  The variational principle has been',/,5X,
     +'  violated and the above deletion energy is invalid!!',//,5X,
     +'Probable cause:  A deletion was attempted that did not ',/,5X,
     +'have as high symmetry as was employed in the integral',/,5X,
     +'and SCF computation.  REMEDY:  Redo computation without',/,5X,
     +'symmetry if this non-symmetry-conserving deletion is still',/,5X,
     +'desired.')
 3000 FORMAT(/1X,
     +'NEXT STEP:  Evaluate the energy of the new density matrix',/,1X,
     +'            that has been constructed from the deleted NBO',/,1X,
     +'            Fock matrix by doing one SCF cycle.'/)
      END
C*****************************************************************************
      SUBROUTINE NBODEL(A,MEMORY,IDONE)
C*****************************************************************************
C
C     NBODEL: SUBROUTINE TO DELETE BOND ORBITAL FOCK MATRIX ELEMENTS FOR
C              A PARTICULAR SPIN CASE:
C                ISPIN = 0     CLOSED SHELL
C                        2     ALPHA SPIN
C                       -2     BETA  SPIN
C
C     IDONE IS SET EQUAL TO 1 IF THERE ARE NO MORE DELETIONS,
C                           0 OTHERWISE.
C
C     A(MEMORY) IS SCRATCH STORAGE
C
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL DONE
      DIMENSION A(MEMORY),ICH(3,2),INAM(3),ISP(3)
C
C  NBO Common Blocks:
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       IATNO(MAXBAS),IBXM(MAXBAS),ISCR1(2*MAXBAS),ISCR2(2*MAXBAS)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
      SAVE LBD,L3C,LBLNK2,LBLNK1,LHYP
      DATA LBD/2HBD/,L3C/2H3C/,LBLNK2/2H  /,LBLNK1/1H /,LHYP/1H-/
C
C   FNBO  :  NBO FOCK MATRIX (TRIANGULAR)
C   TRF   :  TRUNCATED FOCK MATRIX (SQUARE)
C   EIGVR :  EIGENVECTORS OF FTRUNC
C   DMNEW :  NEW AO DM (FROM TRUNCATION) -- TRIANGULAR
C   OCC   :  OCCUPATION VECTOR OF BOND ORBITALS
C   OCCNEW:  OCCUPATION VECTOR OF BOND ORBITALS, AFTER DELETION
C   TNBO  :  AO TO NBO TRANSFORMATION MATRIX
C   SCR   :  SCRATCH VECTOR
C
C  SET UP STORAGE SPACE:
C
C   A(N1):  OCC
C   A(N2):  OCCNEW
C   A(N3):  TNBO
C   A(N4):  FNBO, EIGVR
C   A(N5):  SCR, TRF, DMNEW
C   A(N6):  SCR
C   A(N7):  IDEL
C
      NSQ  = NDIM*NDIM
      N1   = 1
      N2   = N1 + NDIM
      N3   = N2 + NDIM
      N4   = N3 + NSQ
      N5   = N4 + NSQ
      N6   = N5 + NSQ
      N7   = N6 + NDIM
      NEND = N7 + NSQ
      IF(NEND.GT.MEMORY) GO TO 950
      CALL FENBO(A(N3),A(N1),A(N5),NELEC)
      CALL FEFNBO(A(N4))
C
C  DELETE REQUESTED FOCK MATRIX ELEMENTS, FORMING TRUNCATED FOCK MATRIX
C             IN TRF
C
C   IDEL  :  LIST OF DELETED ORBITALS, ELEMENTS, OR BLOCKS
C   ITYPE :  TYPE OF DELETION: 1 FOR ORBITALS
C                              2 FOR INDIVIDUAL MATRIX ELEMENTS
C			       3 FOR ZEROING INTERSECTION BETWEEN TWO SETS
C			                                 OF ORBITALS
C                              4 FOR ENTIRE MATRIX BLOCKS
C   NDEL  :  NUMBER OF ORBITALS, ELEMENTS OR BLOCKS TO BE DELETED
C
      CALL DELETE(A(N4),A(N5),NDIM,A(N7),NSQ,ITYPE,NDEL,NTRUNC,DONE,
     +            ISPIN)
C
C  IF NO MORE DELETIONS, EXIT PROGRAM
C
      IF(DONE) GO TO 900
C  DIAGONALIZE TRUNCATED FOCK MATRIX IN TRF
C
      CALL JACOBI(NTRUNC,A(N5),A(N2),A(N4),NDIM,NDIM,0)
C
C  CONSTRUCT NEW DENSITY MATRIX IN DM FROM EIGENVECTORS OF TRF,
C   IN NBO BASIS:
C   A(N2):  EIGENVALUES OF TRF        (ENTERING)
C   A(N2):  NEW NBO ORBITAL OCCUPANCIES  (EXITING)
C
      NMOOCC=NELEC
      IF(ISPIN.EQ.0) NMOOCC=NELEC/2
      CALL NEWDM(A(N5),A(N4),A(N2),NDIM,A(N7),NSQ,NDEL,ITYPE,NMOOCC,
     +           ISPIN)
C
C  TAKE TRANSPOSE OF T SO THAT IT CAN TRANSFORM THE DENSITY MATRIX
C    FROM THE NBO BASIS TO THE UNSYMMETRIZED AO BASIS:
C
      CALL TRANSP(A(N3),NDIM,NDIM)
      CALL SIMLTR(NDIM,NDIM,A(N5),A(N3),A(N4),A(N6),1)
      CALL SVNEWD(A(N5))
C
      WRITE(LFNPR,2200)
      WRITE(LFNPR,2700)
      DO 500 IBAS=1,NDIM
            IB=IBXM(IBAS)
            LBL=LABEL(IB,1)
            NCTR=1
            IF(LBL.EQ.LBD) NCTR=2
            IF(LBL.EQ.L3C) NCTR=3
            DO 350 I=1,3
              IAT=LABEL(IB,I+3)
              CALL CONVRT(IAT,ICH(I,1),ICH(I,2))
              INAM(I)=LBLNK2
              IF(IAT.GT.0) INAM(I)=NAMEAT(IATNO(IAT))
              ISP(I)=LHYP
              IF(I.GE.NCTR) ISP(I)=LBLNK1
  350         CONTINUE
        I=N1-1+IBAS
        II=N2-1+IBAS
        OCCCHG=A(II)-A(I)
        WRITE(LFNPR,2800) IBAS,(LABEL(IB,K),K=1,3),
     *         (INAM(K),ICH(K,1),ICH(K,2),ISP(K),K=1,3),
     *         A(I),A(II),OCCCHG
  500   CONTINUE
      IDONE=0
      RETURN
C
  900 CONTINUE
      IDONE=1
      RETURN
C
  950 CONTINUE
      WRITE(LFNPR,9500) NEND,MEMORY
      IDONE=1
      RETURN
C
 2200 FORMAT(/1X,'Occupations of bond orbitals:')
 2700 FORMAT(/7X,'Orbital',19X,'No deletions   This deletion   Change',
     + /,1X,78('-'))
 2800 FORMAT(1X,I3,'. ',A2,A1,'(',I2,')',3(A2,3A1),
     *       9X,F7.5,8X,F7.5,3X,F8.5)
 9500 FORMAT(/1X,'Insufficient memory in subroutine NBODEL:',
     *      /5X,'Memory needed: ',I10,'   Memory available: ',I10,
     *      /1X,'Deletions halted!')
      END
C*****************************************************************************
      SUBROUTINE DELETE(F,TRF,NDIM,IDEL,LEN,ITYPE,NDEL,NTRUNC,DONE,
     +                  ISPIN)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ERROR,DONE,EQUAL
      LOGICAL DONOR,ACCPTR,LIST1,LIST2
      DIMENSION KEYWD(6),F(1),TRF(NDIM,NDIM),IDEL(LEN)
      DIMENSION LORB(3),LELE(3),LBLO(3),LDEL(3),LZERO(4),LSAME(4),
     *          LEND(3),LDESTR(6),LDELOC(5),LNOSTR(6),LATOM(4),
     *          LNOGEM(5),LNOVIC(5),LALT(4)
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       IATNO(MAXBAS),IBXM(MAXBAS),ISCR1(2*MAXBAS),ISCR2(2*MAXBAS)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      SAVE ZERO,ISTAR,LDEL,LZERO,LEND,LALPHA,LBETA,LSAME,LORB,LELE,LBLO
      SAVE LDESTR,LNOSTR,LDELOC,LATOM,LNOVIC,LNOGEM,LALT,LG,LV
C
      DATA ZERO/0.0D0/,ISTAR/1H*/
      DATA LDEL/1HD,1HE,1HL/,LZERO/1HZ,1HE,1HR,1HO/,LEND/1HE,1HN,1HD/
      DATA LALPHA,LBETA/1HA,1HB/,LSAME/1HS,1HA,1HM,1HE/
      DATA LORB,LELE,LBLO/1HO,1HR,1HB,1HE,1HL,1HE,1HB,1HL,1HO/
      DATA LDESTR/1HD,1HE,1HS,1HT,1HA,1HR/
      DATA LNOSTR/1HN,1HO,1HS,1HT,1HA,1HR/
      DATA LDELOC/1HD,1HE,1HL,1HO,1HC/,LATOM/1HA,1HT,1HO,1HM/
      DATA LNOVIC/1HN,1HO,1HV,1HI,1HC/,LNOGEM/1HN,1HO,1HG,1HE,1HM/
      DATA LALT/1H$,1HE,1HN,1HD/
      DATA LG,LV/1Hg,1Hv/
C
C   THIS SUBROUTINE IS CALLED AT THE START OF EACH DELETION AND READS
C    IN FROM LFNIN THE INSTRUCTIONS FOR THIS DELETION
C
C   NTRUNC= DIMENSION OF FOCK MATRIX AFTER DELETIONS:
      NTRUNC=NDIM
      WRITE(LFNPR,8700)
C  COUNT UP NUMBER OF MOLECULAR UNITS, NCHEMU:
      NCHEMU=0
      DO 1 I=1,NDIM
        NUNIT=NBOUNI(I)
        IF(NUNIT.GT.NCHEMU) NCHEMU=NUNIT
    1   CONTINUE
      IF(ISPIN.EQ.0) GO TO 10
C  IF OPEN SHELL, LOOK FOR FIRST LETTER OF "ALPHA" OR "BETA" KEYWORD:
        LENG=3
        CALL HFLD(KEYWD,LENG,DONE)
        IF(EQUAL(KEYWD,LEND,3)) DONE=.TRUE.
        IF(EQUAL(KEYWD,LALT,3)) DONE=.TRUE.
        IF(DONE) RETURN
        IF((ISPIN.EQ.2).AND.(KEYWD(1).NE.LALPHA)) GO TO 9300
        IF((ISPIN.EQ.-2).AND.(KEYWD(1).NE.LBETA)) GO TO 9400
        IF(ISPIN.EQ.2) WRITE(LFNPR,8100)
        IF(ISPIN.EQ.-2) WRITE(LFNPR,8200)
C  SEARCH FOR FIRST 3 LETTERS OF "DELETE", "ZERO", "SAME", "DESTAR",
C    "NOSTAR", "NOGEM", "NOVIC", OR AN END MARK '**':
   10 CONTINUE
      LENG=3
      CALL HFLD(KEYWD,LENG,DONE)
      IF(EQUAL(KEYWD,LEND,3)) DONE=.TRUE.
      IF(EQUAL(KEYWD,LALT,3)) DONE=.TRUE.
      IF(DONE) RETURN
C  IF BETA DELETIONS ARE THE SAME AS THE ALPHA DELETIONS ALREADY READ IN,
C    SKIP TO 100:
      IF((ISPIN.EQ.-2).AND.EQUAL(KEYWD,LSAME,3)) GO TO 100
      IF(EQUAL(KEYWD,LZERO,3)) GO TO 600
      IF(EQUAL(KEYWD,LNOVIC,3)) GO TO 3000
      IF(EQUAL(KEYWD,LNOGEM,3)) GO TO 3010
      IF(EQUAL(KEYWD,LDESTR,3)) GO TO 5000
      IF(EQUAL(KEYWD,LNOSTR,3)) GO TO 5500
      IF(.NOT.EQUAL(KEYWD,LDEL,3)) GO TO 9000
C  READ IN NUMBER OF ITEMS TO DELETE, NDEL:
      CALL IFLD(NDEL,ERROR)
      IF(ERROR) GO TO 9100
C  READ IN TYPE OF DELETION AND DETERMINE IF IT IS ORBITAL, ELEMENT, OR BLOCK:
C   (ITYPE STORES THE DELETION TYPE)
      CALL HFLD(KEYWD,LENG,DONE)
      IF(LENG.LT.3) GO TO 9200
      IF(.NOT.EQUAL(KEYWD,LORB,3)) GO TO 20
      ITYPE=1
      GO TO 80
  20  IF(.NOT.EQUAL(KEYWD,LELE,3)) GO TO 30
      ITYPE=2
      GO TO 80
  30  IF(.NOT.EQUAL(KEYWD,LBLO,3)) GO TO 9200
      ITYPE=4
  80  CONTINUE
C  NREAD=NUMBER OF NUMBERS THAT MUST BE READ
      NREAD=NDEL*ITYPE
C  READ IN ORBITALS,ELEMENTS, OR BLOCKS:
      DO 90 I=1,NREAD
        CALL IFLD(IDEL(I),ERROR)
        IF(ERROR) GO TO 9500
   90   CONTINUE
C
  100 CONTINUE
      IF(ITYPE.NE.1) GO TO 200
C   DELETE NDEL ORBITALS, ADJUSTING NTRUNC ACCORDINGLY:
        NTRUNC=NDIM-NDEL
C   ORDER THE ORBITAL NUMBERS:
        CALL ORDER(ISCR1,IDEL,NDEL,NDIM,ISCR2)
        WRITE(LFNPR,8610) (IDEL(I),I=1,NDEL)
C   FILL TRF WITH TRUNCATED FOCK MATRIX, DELETING REQUESTED ORBITALS:
        IFF=0
        IOUT=1
        II=0
        DO 140 I=1,NDIM
          IF(IOUT.GT.NDEL) GO TO 110
          IF(I.NE.IDEL(IOUT)) GO TO 110
            IFF=IFF+I
            IOUT=IOUT+1
            GO TO 140
  110     CONTINUE
            II=II+1
            JOUT=1
            JJ=0
            DO 130 J=1,I
              IF(JOUT.GT.NDEL) GO TO 120
              IF(J.NE.IDEL(JOUT)) GO TO 120
                IFF=IFF+1
                JOUT=JOUT+1
                GO TO 130
  120         CONTINUE
                JJ=JJ+1
                IFF=IFF+1
                TRF(II,JJ)=F(IFF)
                TRF(JJ,II)=F(IFF)
  130         CONTINUE
  140     CONTINUE
        RETURN
  200 CONTINUE
C  ELEMENT OR BLOCK DELETIONS: START BY FILLING TRF WITH FULL NBO FOCK MATRIX:
      II=0
      DO 210 I=1,NDIM
        DO 210 J=1,I
          II=II+1
          TRF(I,J)=F(II)
          TRF(J,I)=F(II)
  210     CONTINUE
      IF(ITYPE.NE.2) GO TO 300
C  ZERO REQUESTED MATRIX ELEMENTS:
        NDEL2=NDEL*2
        WRITE(LFNPR,8620) (IDEL(I),I=1,NDEL2)
        DO 240 I=1,NDEL
          I2=2*I
          ID=IDEL(I2-1)
          JD=IDEL(I2)
          TRF(ID,JD)=ZERO
          TRF(JD,ID)=ZERO
  240     CONTINUE
        RETURN
  300 CONTINUE
      IF(ITYPE.NE.4) STOP
C  ZERO REQUESTED MATRIX BLOCKS:
        DO 400 ID=1,NDEL
          IDST=(ID-1)*4
          J1=IDEL(IDST+1)
          J2=IDEL(IDST+2)
          I1=IDEL(IDST+3)
          I2=IDEL(IDST+4)
          IF(J1.LE.J2) GO TO 320
            IDEL(IDST+2)=J1
            IDEL(IDST+1)=J2
            J1=IDEL(IDST+1)
            J2=IDEL(IDST+2)
  320     IF(I1.LE.I2) GO TO 330
            IDEL(IDST+4)=I1
            IDEL(IDST+3)=I2
            I1=IDEL(IDST+3)
            I2=IDEL(IDST+4)
  330     DO 380 I=I1,I2
            DO 380 J=J1,J2
C  SKIP DIAGONAL ELEMENTS:
              IF(I.EQ.J) GO TO 380
              TRF(I,J)=ZERO
              TRF(J,I)=ZERO
  380       CONTINUE
  400     CONTINUE
        NDEL4=NDEL*4
        WRITE(LFNPR,8640) (IDEL(I),I=1,NDEL4)
      RETURN
C  DELETE INTERSECTION IN FOCK MATRIX BETWEEN PAIRS OF SETS OF ORBITALS:
  600 ITYPE=3
C  START BY FILLING TRF WITH FULL NBO FOCK MATRIX:
      II=0
      DO 610 I=1,NDIM
        DO 610 J=1,I
          II=II+1
          TRF(I,J)=F(II)
          TRF(J,I)=F(II)
  610     CONTINUE
C  READ IN NUMBER OF PAIRS OF SETS OF ORBITALS, NDEL:
      CALL IFLD(NDEL,ERROR)
      IF(ERROR) GO TO 9500
      LENG=5
C  CHECK THE NEXT WORD TO SEE IF IT IS "DELOCALIZATION" INSTEAD OF "BLOCK":
C  (IF SO, THE BLOCK WILL BE SPECIFIED BY MOLECULAR UNITS INSTEAD OF BY BLOCKS)
      CALL HFLD(KEYWD,LENG,DONE)
      IF(EQUAL(KEYWD,LDELOC,5)) GO TO 1000
C  CHECK THE WORD TO SEE IF IT IS "ATOM" INSTEAD OF "BLOCK":
C   (IF SO, THE BLOCK WILL BE SPECIFIED BY ORBITALS ON GROUPS OF ATOMS)
      IF(EQUAL(KEYWD,LATOM,4)) GO TO 1200
      NSTART=0
      DO 800 K=1,NDEL
C  READ IN THE NUMBER OF ORBITALS IN EACH SET OF THE PAIR, NSET1 AND NSET2:
C    (SKIP THE 'BY' BETWEEN NSET1 AND NSET2)
        CALL IFLD(NSET1,ERROR)
        IF(ERROR) GO TO 9500
        CALL HFLD(KEYWD,LENG,DONE)
        CALL IFLD(NSET2,ERROR)
        IF(ERROR) GO TO 9500
        NSTART=NSTART+2
        IDEL(NSTART-1)=NSET1
        IDEL(NSTART)=NSET2
C  READ IN THE ORBITALS OF BOTH SETS
        NTOT=NSET1+NSET2
        DO 620 I=1,NTOT
          CALL IFLD(IDEL(NSTART+I),ERROR)
          IF(ERROR) GO TO 9500
  620     CONTINUE
C  NOW, ZERO ALL INTERSECTING ELEMENTS BETWEEN THE TWO SETS:
        NSTRT2=NSTART+NSET1
        DO 700 I=1,NSET1
          ID=IDEL(NSTART+I)
          DO 700 J=1,NSET2
            JD=IDEL(NSTRT2+J)
            IF(ID.EQ.JD) GO TO 700
            TRF(ID,JD)=ZERO
            TRF(JD,ID)=ZERO
  700       CONTINUE
        NSTART=NSTART+NTOT
  800   CONTINUE
      GO TO 4000
C
C  ZEROING OF DELOCALIZATION WITHIN OR BETWEEN MOLECULAR UNITS.
C
C   USE THE NBO MOLECULAR UNIT (NBOUNI) AND NBO TYPE (NBOTYP) LISTS.
 1000 CONTINUE
      NSTART=0
      DO 1100 K=1,NDEL
C  SKIP THE NEXT WORD ("FROM"):
        CALL HFLD(KEYWD,LENG,DONE)
C  READ IN THE NUMBER OF THE FIRST MOLECULAR UNIT, IUNIT1:
        CALL IFLD(IUNIT1,ERROR)
        IF(ERROR) GO TO 9500
C  SKIP THE "TO" AND READ IN IUNIT2:
        CALL HFLD(KEYWD,LENG,DONE)
        CALL IFLD(IUNIT2,ERROR)
        IF(ERROR) GO TO 9500
        WRITE(LFNPR,8300) IUNIT1,IUNIT2
        NSTART=NSTART+2
C  FIND ALL OF THE NONSTAR (CORE/"LONE PAIR"/BOND) NBOS ON UNIT IUNIT1:
        NSET1=0
        DO 1020 IBAS=1,NDIM
          IF(NBOUNI(IBAS).NE.IUNIT1) GO TO 1020
          IF(NBOTYP(IBAS).GT.20) GO TO 1020
          NSET1=NSET1+1
          IDEL(NSTART+NSET1)=IBAS
 1020     CONTINUE
        IDEL(NSTART-1)=NSET1
C  FIND ALL OF THE STAR (RYDBERG/ANTIBOND) NBOS ON UNIT IUNIT2:
        NSET2=0
        NSTRT2=NSTART+NSET1
        DO 1040 IBAS=1,NDIM
          IF(NBOUNI(IBAS).NE.IUNIT2) GO TO 1040
          IF(NBOTYP(IBAS).LT.10) GO TO 1040
          NSET2=NSET2+1
          IDEL(NSTRT2+NSET2)=IBAS
 1040     CONTINUE
        IDEL(NSTART)=NSET2
        NTOT=NSET1+NSET2
C  NOW, ZERO ALL INTERSECTING ELEMENTS BETWEEN THE TWO SETS:
        DO 1060 I=1,NSET1
          ID=IDEL(NSTART+I)
          DO 1060 J=1,NSET2
            JD=IDEL(NSTRT2+J)
            IF(ID.EQ.JD) GO TO 1060
            TRF(ID,JD)=ZERO
            TRF(JD,ID)=ZERO
 1060       CONTINUE
        NSTART=NSTART+NTOT
 1100   CONTINUE
      GO TO 4000
C
C   ZEROING OF DELOCALIZATION BETWEEN GROUPS OF ATOMS
C
C   USE THE NBO TYPE (NBOTYP) AND NBO LABEL (LABEL) LISTS.
 1200 CONTINUE
      MSTART=0
      NSTART=0
C  SKIP THE 'BLOCKS' BEFORE NSET1:
      CALL HFLD(KEYWD,LENG,DONE)
      DO 1400 K=1,NDEL
C  READ IN THE NUMBER OF ATOMS IN EACH SET OF THE PAIR, NSET1 AND NSET2:
C    (SKIP THE 'BY' BETWEEN NSET1 AND NSET2)
        CALL IFLD(MSET1,ERROR)
        IF(ERROR) GO TO 9500
        CALL HFLD(KEYWD,LENG,DONE)
        CALL IFLD(MSET2,ERROR)
        IF(ERROR) GO TO 9500
        MSTART=MSTART+2
        ISCR1(MSTART-1)=MSET1
        ISCR1(MSTART)=MSET2
C  READ IN THE ATOMS OF BOTH SETS:
        MTOT=MSET1+MSET2
        DO 1220 I=1,MTOT
          CALL IFLD(ISCR1(MSTART+I),ERROR)
          IF(ERROR) GO TO 9500
 1220     CONTINUE
        MSTRT2=MSTART+MSET1
        WRITE(LFNPR,8350)
        WRITE(LFNPR,8631) (ISCR1(MSTART+I),I=1,MSET1)
        WRITE(LFNPR,8360)
        WRITE(LFNPR,8631) (ISCR1(MSTRT2+I),I=1,MSET2)
        WRITE(LFNPR,8370)
C  CONSTRUCT THE LIST OF THE TWO SETS OF ORBITALS FROM THE ATOM LISTS,
C    PLACING THE ORBITAL LIST IN IDEL IN THE STANDARD MANNER FOR ITYPE=3:
        NSTART=NSTART+2
        NSET1=0
        NSET2=0
        DO 1300 JBAS=1,NDIM
          DONOR=.FALSE.
          ACCPTR=.FALSE.
          IF(NBOTYP(JBAS).LT.20) DONOR=.TRUE.
          IF(NBOTYP(JBAS).GE.10) ACCPTR=.TRUE.
          LIST1=.FALSE.
          LIST2=.FALSE.
C    REMEMBER TO CONSULT IBXM BEFORE GETTING INFO FROM LABEL!
          JB=IBXM(JBAS)
          DO 1240 J=4,6
            JAT=LABEL(JB,J)
            IF(JAT.EQ.0) GO TO 1240
            DO 1230 I=1,MSET1
              IAT=ISCR1(MSTART+I)
              IF(IAT.NE.JAT) GO TO 1230
              GO TO 1240
 1230         CONTINUE
            GO TO 1250
 1240       CONTINUE
          LIST1=.TRUE.
 1250     CONTINUE
          DO 1270 J=4,6
            JAT=LABEL(JB,J)
            IF(JAT.EQ.0) GO TO 1270
            DO 1260 I=1,MSET2
              IAT=ISCR1(MSTRT2+I)
              IF(IAT.NE.JAT) GO TO 1260
              GO TO 1270
 1260         CONTINUE
            GO TO 1280
 1270       CONTINUE
          LIST2=.TRUE.
 1280     CONTINUE
          IF(LIST1.AND.LIST2) GO TO 1300
          IF(.NOT.LIST1.AND..NOT.LIST2) GO TO 1300
          IF(LIST1.AND..NOT.DONOR) GO TO 1300
          IF(LIST2.AND..NOT.ACCPTR) GO TO 1300
          IF(LIST2) GO TO 1290
C   LIST1.AND.DONOR=.TRUE. CASE:
            NSET1=NSET1+1
            IDEL(NSTART+NSET1)=JBAS
            GO TO 1300
C   LIST2.AND.ACCPTR=.TRUE. CASE:
 1290     CONTINUE
            NSET2=NSET2+1
            ISCR2(NSET2)=JBAS
 1300   CONTINUE
C
        IDEL(NSTART-1)=NSET1
        IDEL(NSTART)=NSET2
        NTOT=NSET1+NSET2
C  PLACE ORBITAL SET 2 IN IDEL:
        NSTRT2=NSTART+NSET1
        DO 1320 I=1,NSET2
 1320     IDEL(NSTRT2+I)=ISCR2(I)
C  NOW, ZERO ALL INTERSECTING ELEMENTS BETWEEN THE TWO SETS OF ORBITALS:
        DO 1340 I=1,NSET1
          ID=IDEL(NSTART+I)
          DO 1340 J=1,NSET2
            JD=IDEL(NSTRT2+J)
            TRF(ID,JD)=ZERO
 1340       TRF(JD,ID)=ZERO
        MSTART=MSTART+NTOT
        NSTART=NSTART+NTOT
 1400   CONTINUE
      GO TO 4000
C
C  DELETE ALL VICINAL OR GEMINAL DELOCALIZATIONS:
C
 3000 IVIC=1
      WRITE(LFNPR,8550)
      GOTO 3020
 3010 IVIC=0
      WRITE(LFNPR,8560)
 3020 CONTINUE
      ITYPE=3
C
C  START BY FILLING TRF WITH FULL NBO FOCK MATRIX:
C
      II=0
      DO 3025 I=1,NDIM
        DO 3025 J=1,I
          II=II+1
          TRF(I,J)=F(II)
          TRF(J,I)=F(II)
 3025 CONTINUE
C
C  FIND THE TOTAL NUMBER OF BLOCKS OF THE FOCK MATRIX TO DELETE:
C
      NDEL=0
      NSTART=0
      DO 3070 IBAS=1,NDIM
        IB=IBXM(IBAS)
        IF(LABEL(IB,2).NE.ISTAR) THEN
          NACC=0
          DO 3060 JBAS=1,NDIM
            JB=IBXM(JBAS)
            IF(LABEL(JB,2).EQ.ISTAR) THEN
              ITMP = IHTYP(IBAS,JBAS)
C
C  VICINAL DELOCALIZATION:
C
              IF(IVIC.EQ.1.AND.ITMP.EQ.LV) THEN
                NACC=NACC+1
                IDEL(NSTART+NACC+3)=JBAS
C
C  GEMINAL DELOCALIZATION:
C
              ELSE IF(IVIC.EQ.0.AND.ITMP.EQ.LG) THEN
                NACC=NACC+1
                IDEL(NSTART+NACC+3)=JBAS
              END IF
            END IF
 3060     CONTINUE
          IF(NACC.GT.0) THEN
            NDEL=NDEL+1
            IDEL(NSTART+1)=1
            IDEL(NSTART+2)=NACC
            IDEL(NSTART+3)=IBAS
            DO 3065 JB=1,NACC
              JBAS=IDEL(NSTART+JB+3)
              IF(JBAS.NE.IBAS) THEN
                TRF(IBAS,JBAS)=ZERO
                TRF(JBAS,IBAS)=ZERO
              END IF
 3065       CONTINUE
            NSTART=NSTART+NACC+3
            IF(NSTART.GT.LEN) STOP 'INCREASE DIMENSION OF ARRAY IDEL'
          END IF
        END IF
 3070 CONTINUE
      GOTO 4000
C
C  WRITE OUT INFORMATION FROM DELETION, FOR ITYPE=3:
 4000 CONTINUE
      INDX=0
      DO 4050 K=1,NDEL
        NSET1=IDEL(INDX+1)
        NSET2=IDEL(INDX+2)
        INDX=INDX+2
        NL=INDX+1
        NU=INDX+NSET1
        WRITE(LFNPR,8630)
        WRITE(LFNPR,8631) (IDEL(I),I=NL,NU)
        WRITE(LFNPR,8632)
        NL=INDX+NSET1+1
        NU=INDX+NSET1+NSET2
        WRITE(LFNPR,8631) (IDEL(I),I=NL,NU)
        INDX=NU
 4050   CONTINUE
      RETURN
C  DELETE ALL THE "STAR" NBOS ON ONE OR MORE MOLECULES:
C   (SET ITYPE=1 FOR ORBITAL DELETIONS)
 5000 CONTINUE
      ITYPE=1
C  READ IN THE NUMBER OF MOLECULAR UNITS TO "DESTAR":
      CALL IFLD(NUNITS,ERROR)
      IF(ERROR) GO TO 9500
C  SKIP THE KEYWORD "UNITS":
      LENG=3
      CALL HFLD(KEYWD,LENG,DONE)
C  READ IN THE NUMBERS OF THE UNITS TO DESTAR, FINDING THE STAR ORBITALS
C   FROM THE LISTS NBOUNI AND NBOTYP:
      NDEL=0
      DO 5100 I=1,NUNITS
        CALL IFLD(IUNIT,ERROR)
        IF(ERROR) GO TO 9500
        WRITE(LFNPR,8400) IUNIT
        DO 5050 IBAS=1,NDIM
          IF(NBOUNI(IBAS).NE.IUNIT) GO TO 5050
          IF(LABEL(IBAS,2).NE.ISTAR) GO TO 5050
          NDEL=NDEL+1
          IDEL(NDEL)=IBAS
 5050     CONTINUE
 5100   CONTINUE
C  GO AND DO THE DELETIONS OF THE NDEL ORBITALS THAT ARE NOW IN IDEL:
      GO TO 100
C
C  DELETE ALL STAR NBOS:
 5500 CONTINUE
      ITYPE=1
      NDEL=0
      WRITE(LFNPR,8500)
      DO 5600 IBAS=1,NDIM
        IF(LABEL(IBAS,2).NE.ISTAR) GO TO 5600
        NDEL=NDEL+1
        IDEL(NDEL)=IBAS
 5600   CONTINUE
C  GO AND DO THE DELETIONS OF THE NDEL ORBITALS THAT ARE NOW IN IDEL:
      GO TO 100
C
 8100 FORMAT(1X,' ----------- Alpha spin NBO deletions ----------- '/)
 8200 FORMAT(1X,' ----------- Beta  spin NBO deletions ----------- '/)
 8300 FORMAT(1X,'Zero delocalization from unit ',I2,' to unit ',I2)
 8350 FORMAT(1X,'Zero delocalization from NBOs localized on atoms:')
 8360 FORMAT(1X,'to NBOs localized on atoms:')
 8370 FORMAT(1X,'    (NBOs in common to the two groups of atoms ',
     *  'left out)')
 8400 FORMAT(1X,'DESTAR unit ',I2,': Delete all Rydberg/antibond',
     * ' NBOs from this unit')
 8500 FORMAT(1X,'NOSTAR: Delete all Rydberg/antibond NBOs')
 8550 FORMAT(1X,'NOVIC: Delete all vicinal delocalizations')
 8560 FORMAT(1X,'NOGEM: Delete all geminal delocalizations')
 8610 FORMAT(1X,'Deletion of the following orbitals ',
     * 'from the NBO Fock matrix:',(/1X,20I4))
 8620 FORMAT(1X,'Deletion of the following NBO Fock matrix ',
     * 'elements:',/(7(2X,'(',I3,',',I3,')')))
 8630 FORMAT(1X,'Deletion of the NBO Fock matrix elements ',
     * 'between orbitals:')
 8631 FORMAT(1X,20I4)
 8632 FORMAT(1X,'and orbitals:')
 8640 FORMAT(1X,'Deletion of the following NBO Fock matrix ',
     * 'blocks:',/(2(2X,'(',I3,'-',I3,'/',I3,'-',I3,')')))
 8700 FORMAT(/)
C
C  ERROR MESSAGES:
 9000 WRITE(LFNPR,9010) (KEYWD(I),I=1,3)
 9010 FORMAT(1X,'First character string does not have the',
     * ' first three letters of DELETE or ZERO:',/1X,3A1)
      STOP
 9100 WRITE(LFNPR,9110)
 9110 FORMAT(1X,'Non-integer was input for number of items to delete.')
      STOP
 9200 WRITE(LFNPR,9210) (KEYWD(I),I=1,3)
 9210 FORMAT(1X,'No match with first three letters of the keywords ',
     * 'for deletion type'/' (ORBITAL,ELEMENT,BLOCK) found:',
     * 3A1)
      STOP
 9300 WRITE(LFNPR,9310)
 9310 FORMAT(1X,'Keyword ALPHA (or A) not found to start alpha NBO',
     *          ' deletion input.')
      STOP
 9400 WRITE(LFNPR,9410)
 9410 FORMAT(1X,'Keyword BETA (or B) not found to start beta NBO',
     *          ' deletion input.')
 9500 WRITE(LFNPR,9510)
 9510 FORMAT(' There is an error in the input of deletions.')
      STOP
      END
C*****************************************************************************
      SUBROUTINE NEWDM(DM,U,EIG,NDIM,IDEL,LEN,NDEL,ITYPE,NMOOCC,ISPIN)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       IATNO(MAXBAS),IBXM(MAXBAS),NRANK(2*MAXBAS),LOCC(2*MAXBAS)
      DIMENSION DM(1),U(NDIM,NDIM),EIG(NDIM),IDEL(LEN)
C
      SAVE ZERO,ONE,TWO
      DATA ZERO/0.0D0/,ONE/1.0D0/,TWO/2.0D0/
C
C  ONETWO: ONE IF OPEN SHELL (ISPIN.NE.0), TWO IF CLOSED SHELL (DOUBLY OCC MOS)
      ONETWO=TWO
      IF(ISPIN.NE.0) ONETWO=ONE
C  NTRUNC: DIMENSION OF TRUNCATED FOCK MATRIX
      NTRUNC=NDIM
      IF(ITYPE.EQ.1) NTRUNC=NDIM-NDEL
C  RANK THE EIGENVALUES 'EIG' FROM THE TRUNCATED FOCK MATRIX FROM LOWEST
C   TO HIGHEST IN 'NRANK':
      CALL RNKEIG(NRANK,EIG,NTRUNC,NDIM,LOCC)
C  PUT IN 'LOCC' THE LOCATIONS OF THE 'NMOOCC' LOWEST EIGENVALUES:
C   (THESE CORRESPOND TO THE DOUBLY OCCUPIED MOS)
      NOCC=0
      DO 20 I=1,NTRUNC
        IF(NRANK(I).GT.NMOOCC) GO TO 20
          NOCC=NOCC+1
          LOCC(NOCC)=I
   20   CONTINUE
C  NDELOR: NUMBER OF DELETED ORBITALS
      NDELOR=NDIM-NTRUNC
C
C  CONSTRUCT THE NEW NBO DENSITY MATRIX:
C
C  LOOP OVER ROWS:
      II=0
      IJ=0
      IOUT=1
      DO 105 I=1,NDIM
        IF(IOUT.GT.NDELOR) GO TO 40
        IF(I.NE.IDEL(IOUT)) GO TO 40
C  ZERO ROWS OF THE NEW NBO DENSITY MATRIX THAT WERE ZEROED
C    IN THE TRUNCATION, ALSO ZEROING THE ORBITAL OCCPANCY, EIG(I):
          IOUT=IOUT+1
          EIG(I)=ZERO
          DO 30 J=1,I
            IJ=IJ+1
   30       DM(IJ)=ZERO
          GO TO 105
   40   CONTINUE
        II=II+1
C  LOOP OVER COLUMNS:
        JOUT=1
        JJ=0
        DO 100 J=1,I
          IF(JOUT.GT.NDELOR) GO TO 50
          IF(J.NE.IDEL(JOUT)) GO TO 50
C  ZERO COLUMNS OF THE NEW NBO DENSITY MATRIX THAT WERE ZEROED
C    IN THE TRUNCATION OF THE NBO FOCK MATRIX:
            JOUT=JOUT+1
            IJ=IJ+1
            DM(IJ)=ZERO
            GO TO 100
   50     CONTINUE
C  FIND DM(IJ) FROM THE EIGENVECTORS OF THE TRUNCATED NBO FOCK MATRIX IN 'U',
C  SUMMING OVER THE OCCUPIED MOS, AND MULTIPLYING BY TWO FOR DOUBLE OCCUPANCY:
          JJ=JJ+1
          SUM=ZERO
          DO 80 K=1,NMOOCC
   80       SUM=SUM+U(II,LOCC(K))*U(JJ,LOCC(K))
          IJ=IJ+1
          DM(IJ)=SUM*ONETWO
          IF(I.EQ.J) EIG(I)=SUM*ONETWO
  100   CONTINUE
  105   CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE RNKEIG(RANK,EIG,N,NDIM,ARCRNK)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  RANK EIGENVALUES IN 'EIG', LOWEST VALUES FIRST, IN 'RANK':
C
      INTEGER RANK,ARCRNK
      DIMENSION RANK(NDIM),EIG(NDIM),ARCRNK(NDIM)
      DO 10 I=1,N
   10   ARCRNK(I)=I
      DO 40 I=1,N
        IF(I.EQ.N) GO TO 30
         I1=I+1
         DO 20 J=I1,N
         IF(EIG(J).GE.EIG(I)) GO TO 20
           TEMP=EIG(I)
           EIG(I)=EIG(J)
           EIG(J)=TEMP
           ITEMP=ARCRNK(I)
           ARCRNK(I)=ARCRNK(J)
           ARCRNK(J)=ITEMP
   20     CONTINUE
   30    RANK(ARCRNK(I))=I
   40   CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SIMLTR(N,NDIM,F,U,R,S,KNTROL)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION F(1),U(NDIM,1),S(1),R(1)
C  TAKE U(TRANSPOSE)*F*U:
C     F    MATRIX TO BE TRANSFORMED (PACKED UPPER TRIANGULAR)
C     U    IS THE TRANSFORMATION MATRIX
C     R    IS THE MATRIX IN WHICH THE RESULT WILL BE RETURNED
C     S    IS A SCRATCH MATRIX OF DIMENSION N
C     KNTROL....=0  RESULT RETURNED ONLY IN  R
C               =1  RESULT COPIED INTO  F
C
      IN=0
      DO 50 I=1,N
        JN=0
        DO 20 J=1,N
          SUM=0.
          KN=0
          DO 10 K=1,N
            JK=JN+K
            IF(J.LT.K) JK=KN+J
            SUM=SUM+F(JK)*U(K,I)
   10       KN=KN+K
          S(J)=SUM
   20     JN=JN+J
        DO 40 J=1,I
          SUM=0.
          DO 30 K=1,N
   30       SUM=SUM+S(K)*U(K,J)
          IJ=IN+J
   40     R(IJ)=SUM
   50   IN=IN+I
      IF(KNTROL.EQ.0) RETURN
      NT=N*(N+1)/2
      DO 60 I=1,NT
   60   F(I)=R(I)
      RETURN
      END
C*****************************************************************************
C
C  NBO DIRECT ACCESS FILE (DAF) ROUTINES:
C
C      SUBROUTINE NBFILE(NEW,ERROR)
C      SUBROUTINE NBOPEN(NEW,ERROR)
C      SUBROUTINE NBWRIT(IX,NX,IDAR)
C      SUBROUTINE NBREAD(IX,NX,IDAR)
C      SUBROUTINE NBCLOS(SEQ)
C      SUBROUTINE NBINQR(IDAR)
C
C      SUBROUTINE FETITL(TITLE)
C      SUBROUTINE FEE0(EDEL,ETOT)
C      SUBROUTINE SVE0(EDEL)
C      SUBROUTINE FECOOR(ATCOOR)
C      SUBROUTINE FESRAW(S)
C      SUBROUTINE FEDRAW(DM,SCR)
C      SUBROUTINE FEFAO(F,IWFOCK)
C      SUBROUTINE FEAOMO(T,IT)
C      SUBROUTINE FEDXYZ(DXYZ,I)
C      SUBROUTINE SVNBO(T,OCC,ISCR)
C      SUBROUTINE FENBO(T,OCC,ISCR,NELEC)
C      SUBROUTINE FETNBO(T)
C      SUBROUTINE SVPNAO(T)
C      SUBROUTINE FEPNAO(T)
C      SUBROUTINE SVSNAO(S)
C      SUBROUTINE FESNAO(S)
C      SUBROUTINE SVTNAB(T)
C      SUBROUTINE FETNAB(T)
C      SUBROUTINE SVTLMO(T)
C      SUBROUTINE FETLMO(T)
C      SUBROUTINE SVTNHO(T)
C      SUBROUTINE FETNHO(T)
C      SUBROUTINE SVPPAO(DM)
C      SUBROUTINE FEPPAO(DM)
C      SUBROUTINE SVTNAO(T)
C      SUBROUTINE FETNAO(T)
C      SUBROUTINE SVNLMO(T)
C      SUBROUTINE FENLMO(T)
C      SUBROUTINE SVDNAO(DM)
C      SUBROUTINE FEDNAO(DM)
C      SUBROUTINE SVFNBO(F)
C      SUBROUTINE FEFNBO(F)
C      SUBROUTINE SVNEWD(DM)
C      SUBROUTINE FENEWD(DM)
C      SUBROUTINE FEINFO(ICORE,ISWEAN)
C      SUBROUTINE FEBAS(NSHELL,NEXP,ISCR)
C
C*****************************************************************************
      SUBROUTINE NBFILE(NEW,ERROR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL NEW,ERROR,NEED,THERE
      CHARACTER*80 TEMP
C
      PARAMETER (MAXFIL = 40)
C
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
      COMMON/NBNAME/FILENM,NFILE,IFILE(MAXFIL)
      CHARACTER*80 FILENM
C
      DATA IWRIT,IREAD/4HWRIT,4HREAD/
C
C  Create a list IFILE of external LFNs.  First find the files that
C  will be written:
C
      ERROR = .FALSE.
      NFILE = 0
      DO 10 I = 1,999
        NEED = .FALSE.
        IF(IWPNAO.EQ.-I)     NEED = .TRUE.
        IF(IWTNAO.EQ.-I)     NEED = .TRUE.
        IF(IWTNAB.EQ.-I)     NEED = .TRUE.
        IF(IWTNBO.EQ.-I)     NEED = .TRUE.
        IF(JPRINT(7).EQ. I)  NEED = .TRUE.
        IF(JPRINT(9).EQ.-I)  NEED = .TRUE.
        IF(JPRINT(13).EQ.-I) NEED = .TRUE.
        IF(JPRINT(15).EQ.-I) NEED = .TRUE.
        IF(JPRINT(16).EQ.-I) NEED = .TRUE.
        IF(JPRINT(17).EQ.-I) NEED = .TRUE.
        IF(JPRINT(18).EQ.-I) NEED = .TRUE.
        IF(JPRINT(19).EQ.-I) NEED = .TRUE.
        IF(JPRINT(20).EQ.-I) NEED = .TRUE.
        IF(JPRINT(21).EQ.-I) NEED = .TRUE.
        IF(JPRINT(22).EQ. I) NEED = .TRUE.
        IF(JPRINT(23).EQ.-I) NEED = .TRUE.
        IF(JPRINT(24).EQ.-I) NEED = .TRUE.
        IF(JPRINT(25).EQ.-I) NEED = .TRUE.
        IF(JPRINT(26).EQ.-I) NEED = .TRUE.
        IF(JPRINT(27).EQ.-I) NEED = .TRUE.
        IF(JPRINT(28).EQ.-I) NEED = .TRUE.
        IF(JPRINT(29).EQ.-I) NEED = .TRUE.
        IF(JPRINT(30).EQ.-I) NEED = .TRUE.
        IF(JPRINT(31).EQ.-I) NEED = .TRUE.
        IF(JPRINT(33).EQ.-I) NEED = .TRUE.
        IF(JPRINT(34).EQ.-I) NEED = .TRUE.
        IF(JPRINT(35).EQ.-I) NEED = .TRUE.
        IF(JPRINT(37).EQ.-I) NEED = .TRUE.
        IF(JPRINT(38).EQ.-I) NEED = .TRUE.
        IF(JPRINT(39).EQ.-I) NEED = .TRUE.
        IF(JPRINT(40).EQ.-I) NEED = .TRUE.
        IF(JPRINT(41).EQ.-I) NEED = .TRUE.
        IF(JPRINT(42).EQ.-I) NEED = .TRUE.
        IF(JPRINT(44).EQ.-I) NEED = .TRUE.
        IF(JPRINT(45).EQ.-I) NEED = .TRUE.
        IF(JPRINT(47).EQ.-I) NEED = .TRUE.
        IF(JPRINT(48).EQ.-I) NEED = .TRUE.
        IF(JPRINT(49).EQ.-I) NEED = .TRUE.
        IF(JPRINT(50).EQ.-I) NEED = .TRUE.
        IF(JPRINT(51).EQ.-I) NEED = .TRUE.
        IF(JPRINT(52).EQ.-I) NEED = .TRUE.
        IF(JPRINT(53).EQ.-I) NEED = .TRUE.
        IF(JPRINT(54).EQ.-I) NEED = .TRUE.
        IF(NEED) THEN
          NFILE = NFILE + 1
          IF(NFILE.GT.MAXFIL) THEN
            WRITE(LFNPR,890) MAXFIL
            ERROR = .TRUE.
            RETURN
          END IF
          IFILE(NFILE) = I
        END IF
   10 CONTINUE
C
C  Add files that may be read:
C
      MFILE = NFILE
      IF(IOINQR(IWPNAO).EQ.IREAD) THEN
        MFILE = MFILE + 1
        IF(MFILE.GT.MAXFIL) THEN
          WRITE(LFNPR,890) MAXFIL
          ERROR = .TRUE.
          RETURN
        END IF
        IFILE(MFILE) = IWPNAO/1000
      END IF
      IF(IOINQR(IWTNAO).EQ.IREAD) THEN
        MFILE = MFILE + 1
        IF(MFILE.GT.MAXFIL) THEN
          WRITE(LFNPR,890) MAXFIL
          ERROR = .TRUE.
          RETURN
        END IF
        IFILE(MFILE) = IWTNAO/1000
      END IF
      IF(IOINQR(IWTNAB).EQ.IREAD) THEN
        MFILE = MFILE + 1
        IF(MFILE.GT.MAXFIL) THEN
          WRITE(LFNPR,890) MAXFIL
          ERROR = .TRUE.
          RETURN
        END IF
        IFILE(MFILE) = IWTNAB/1000
      END IF
C
C  Make sure that no files are both written and read:
C
      DO 30 I = NFILE+1,MFILE
        DO 20 J = 1,NFILE
          IF(ABS(IFILE(I)).EQ.IFILE(J)) THEN
            WRITE(LFNPR,900) IFILE(J)
            ERROR = .TRUE.
            RETURN
          END IF
   20   CONTINUE
   30 CONTINUE
      NFILE = MFILE
C
C  Also check that the NBO DAF has its own LFN:
C
      DO 40 I = 1,NFILE
        IF(ABS(IFILE(I)).EQ.ABS(LFNDAF)) THEN
          WRITE(LFNPR,900) IFILE(I)
          ERROR = .TRUE.
          RETURN
        END IF
   40 CONTINUE
C
C  Select an alternate filename if this one is not acceptable:
C
      TEMP = FILENM
      DO 50 I = 1,80
        IF(TEMP(I:I).EQ.CHAR(32)) THEN
          LENGTH = I - 1
          GO TO 60
        END IF
   50 CONTINUE
      LENGTH = 76
   60 CONTINUE
      IO = IOINQR(IWPNAO)
      JO = IOINQR(IWTNAO)
      KO = IOINQR(IWTNAB)
      IF(NEW.AND.IO.NE.IREAD.AND.JO.NE.IREAD.AND.KO.NE.IREAD) THEN
        DO 100 I = 0,999
          LEN = LENGTH
          IF(I.NE.0) THEN
            II = I
   65       LEN = LEN + 1
            TEMP(LEN:LEN) = CHAR(MOD(II,10) + 48)
            II = II / 10
            IF(II.NE.0) GOTO 65
            IF(LEN.EQ.LENGTH+2) THEN
              TEMP(LEN+1:LEN+1) = TEMP(LEN:LEN)
              TEMP(LEN:LEN) = TEMP(LEN-1:LEN-1)
              TEMP(LEN-1:LEN-1) = TEMP(LEN+1:LEN+1)
            ELSE IF(LEN.EQ.LENGTH+3) THEN
              TEMP(LEN+1:LEN+1) = TEMP(LEN:LEN)
              TEMP(LEN:LEN) = TEMP(LEN-2:LEN-2)
              TEMP(LEN-2:LEN-2) = TEMP(LEN+1:LEN+1)
            END IF
          END IF
          TEMP(LEN+1:LEN+1) = '.'
C
C  First check the DAF:
C
          K = ABS(LFNDAF)
          IF(ABS(LFNDAF).LT.100) K = K * 10
          TEMP(LEN+2:LEN+2) = CHAR(K/100 + 48)
          TEMP(LEN+3:LEN+3) = CHAR(MOD(K/10,10) + 48)
          IF(ABS(LFNDAF).LT.100) THEN
            TEMP(LEN+4:LEN+4) = CHAR(32)
          ELSE
            TEMP(LEN+4:LEN+4) = CHAR(MOD(K,10) + 48)
          END IF
          INQUIRE(FILE=TEMP,EXIST=THERE)
          IF(THERE) GO TO 100
C
C  Now check the rest:
C
          DO 70 J = 1,NFILE
            K = ABS(IFILE(J))
            IF(ABS(IFILE(J)).LT.100) K = K * 10
            TEMP(LEN+2:LEN+2) = CHAR(K/100 + 48)
            TEMP(LEN+3:LEN+3) = CHAR(MOD(K/10,10) + 48)
            IF(ABS(IFILE(J)).LT.100) THEN
              TEMP(LEN+4:LEN+4) = CHAR(32)
            ELSE
              TEMP(LEN+4:LEN+4) = CHAR(MOD(K,10) + 48)
            END IF
            INQUIRE(FILE=TEMP, EXIST=THERE)
            IF(THERE) GO TO 100
   70     CONTINUE
          GO TO 200
  100   CONTINUE
        WRITE(LFNPR,910)
        ERROR = .TRUE.
        RETURN
C
C  This is a good one!!  If the filename has changed, write a warning:
C
  200   CONTINUE
        IF(FILENM(1:LEN).NE.TEMP(1:LEN)) THEN
          FILENM(1:LEN) = TEMP(1:LEN)
          DO 210 I = LEN+1,80
            FILENM(I:I) = CHAR(32)
  210     CONTINUE
          WRITE(LFNPR,920) FILENM(1:52)
        END IF
        LENGTH = LEN
      END IF
C
C  Open external files:
C
      TEMP = FILENM
      TEMP(LENGTH+1:LENGTH+1) = '.'
      DO 300 I = 1,NFILE
        K = ABS(IFILE(I))
        IF(ABS(IFILE(I)).LT.100) K = K * 10
        TEMP(LENGTH+2:LENGTH+2) = CHAR(K/100 + 48)
        TEMP(LENGTH+3:LENGTH+3) = CHAR(MOD(K/10,10) + 48)
        IF(ABS(IFILE(I)).LT.100) THEN
          TEMP(LENGTH+4:LENGTH+4) = CHAR(32)
        ELSE
          TEMP(LENGTH+4:LENGTH+4) = CHAR(MOD(K,10) + 48)
        END IF
        IF(IFILE(I).GT.0) THEN
          OPEN(UNIT=IFILE(I), FILE=TEMP, STATUS='NEW')
        ELSE
          OPEN(UNIT=ABS(IFILE(I)), FILE=TEMP, STATUS='OLD')
        END IF
  300 CONTINUE
      RETURN
C
  890 FORMAT(/1X,'I/O is limited to ',I2,' files.  Program abort.')
  900 FORMAT(/1X,'Illegal request for input and output with LFN',I3)
  910 FORMAT(/1X,'The search for an acceptable filename has failed.')
  920 FORMAT(/1X,'Filename:  Changed to ',A52)
      END
C*****************************************************************************
      SUBROUTINE NBOPEN(NEW,ERROR)
C*****************************************************************************
C
C  The following records of the NBO direct access file (DAF) are used:
C
C          1  ---   NBODAF common block
C          2  ---   Job title
C          3  ---   NATOMS,NDIM,NBAS,MUNIT,wavefunction flags,ISWEAN
C          4  ---   IATNO,IZNUC,LCTR,LANG
C          5  ---   AO basis set information
C          8  ---   Deletion energy, total energy
C          9  ---   Atomic coordinates
C         10  ---   AO overlap matrix
C         11  ---   PNAO overlap matrix
C         20  ---   AO density matrix (alpha)
C         21  ---   AO density matrix (beta)
C         22  ---   Pure AO density matrix
C         23  ---   NAO density matrix (alpha)
C         24  ---   NAO density matrix (beta)
C         25  ---   AO density matrix with NBO deletions (alpha)
C         26  ---   AO density matrix with NBO deletions (beta)
C         27  ---   NBO occupancies (alpha)
C         28  ---   NBO occupancies (beta)
C         30  ---   AO Fock matrix (alpha)
C         31  ---   AO Fock matrix (beta)
C         32  ---   NAO Fock matrix (alpha)
C         33  ---   NAO Fock matrix (beta)
C         34  ---   NBO Fock matrix (alpha)
C         35  ---   NBO Fock matrix (beta)
C         40  ---   AO to MO transformation matrix (alpha)
C         41  ---   AO to MO transformation matrix (beta)
C         42  ---   AO to PNAO transformation matrix
C         43  ---   AO to NAO transformation matrix
C         44  ---   AO to NBO transformation matrix  (alpha)
C         45  ---   AO to NBO transformation matrix  (beta)
C         46  ---   AO to NLMO transformation matrix
C         47  ---   NAO to NHO transformation matrix
C         48  ---   NAO to NBO transformation matrix
C         49  ---   NBO to NLMO transformation matrix
C         50  ---   X dipole integrals
C         51  ---   Y dipole integrals
C         52  ---   Z dipole integrals
C         60  ---   NBO labels (alpha)
C         61  ---   NBO labels (beta)
C-----------------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL NEW,ERROR
      CHARACTER*80 TEMP
C
C  Note that ISINGL is no longer a parameter (6/7/90):
C
      PARAMETER (LENGTH = 256)
      PARAMETER (NBDAR = 100)
      PARAMETER (MAXFIL = 40)
C
      COMMON/NBODAF/INBO,NAV,IONBO(NBDAR)
      COMMON/NBONAV/IXDNBO(LENGTH),NBNAV,ISINGL
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
      COMMON/NBNAME/FILENM,NFILE,IFILE(MAXFIL)
      CHARACTER*80 FILENM
C
      DIMENSION IX(NBDAR+2),IXSNBO(LENGTH/2)
C
      EQUIVALENCE (IXSNBO(1),IXDNBO(1))
      EQUIVALENCE (IX(1),INBO)
C
      SAVE ISW,LENREC
C
      DATA IBLNK/1H /
      DATA ISW/0/
C
C     INBO   :  Fortran file number
C     IONBO  :  Indexing array mapping the logical records of the
C               NBO DAF onto the physical records of the disk file
C     NAV    :  Number of physical records currently on the DAF
C     NBDAR  :  Maximum number of logical records on the DAF
C
      INBO = ABS(LFNDAF)
C
C  Are we working on a 32 (ISINGL=2) or 64 (ISINGL=1) bit machine?
C
      IF(ISW.EQ.0) THEN
        DO 10 I = 1,4
          IBLNK = IBLNK / 256
   10   CONTINUE
        IF(IBLNK.EQ.0) THEN
          ISINGL = 2
        ELSE
          ISINGL = 1
        END IF
C
C  Determine an appropriate record length for the NBO DAF:
C
        LREC   = LENGTH / 4
        LENREC = 0
        DO 30 I = 1,6
          LREC = LREC * 2
          OPEN(UNIT=INBO, FILE='nb$temp.dat', STATUS='NEW',
     +         ACCESS='DIRECT', RECL=LREC, FORM='UNFORMATTED',
     +         ERR=40)
          WRITE(INBO,REC=1,ERR=20) IXDNBO
C
C  If I.EQ.1 at this point, ERR did not work properly in the preceding
C  statement (this appears to be the case for the XL FORTRAN compiler
C  running on an IBM RISC station/6000):
C
          IF(I.EQ.1) LREC = LENGTH * 8 / ISINGL
          IF(ISINGL.EQ.1) LENREC = LREC / 2
          IF(ISINGL.EQ.2) LENREC = LREC
   20     CLOSE(UNIT=INBO, STATUS='DELETE')
          IF(LENREC.NE.0) GO TO 50
   30   CONTINUE
C
C  Problems...
C
   40   CONTINUE
        WRITE(LFNPR,900)
        ERROR = .TRUE.
        RETURN
C
   50   CONTINUE
        ISW = 1
      END IF
C
C  Open the NBO direct access file (DAF) -- typically assigned to LFN48:
C
      TEMP = FILENM
      DO 60 I = 1,80
        IF(TEMP(I:I).EQ.CHAR(32)) THEN
          LEN = I - 1
          GO TO 70
        END IF
   60 CONTINUE
      LEN = 76
   70 CONTINUE
      K = INBO
      IF(INBO.LT.100) K = K * 10
      TEMP(LEN+1:LEN+1) = '.'
      TEMP(LEN+2:LEN+2) = CHAR(K/100 + 48)
      TEMP(LEN+3:LEN+3) = CHAR(MOD(K/10,10) + 48)
      IF(INBO.LT.100) THEN
        TEMP(LEN+4:LEN+4) = CHAR(32)
      ELSE
        TEMP(LEN+4:LEN+4) = CHAR(MOD(K,10) + 48)
      END IF
C
C  If this is a new NBO DAF, write COMMON/NBODAF/ on the first record:
C
      IF(NEW) THEN
        OPEN(UNIT=INBO, FILE=TEMP, STATUS='NEW', ACCESS='DIRECT',
     +       RECL=LENREC, FORM='UNFORMATTED', ERR=110)
        NAV   = 1
        NBNAV = 1
        DO 80 I = 1,NBDAR
          IONBO(I) = 0
   80   CONTINUE
        NF = 1
        NX = (NBDAR + 2) / ISINGL
        CALL NBWRIT(IX,NX,NF)
C
C  Otherwise, open the old file and read in COMMON/NBODAF/ from the
C  first record:
C
      ELSE
        OPEN(UNIT=INBO, FILE=TEMP, STATUS='OLD', ACCESS='DIRECT',
     +       RECL=LENREC, FORM='UNFORMATTED', ERR=110)
        NBNAV = 1
        MAXIX = LENGTH * ISINGL/2
        LDAR  = NBDAR + 2
        MAX = 0
   90   MIN = MAX + 1
        MAX = MAX + MAXIX
        IF(MAX.GT.LDAR) MAX = LDAR
        IF(ISINGL.EQ.1) READ(INBO,REC=NBNAV) IXSNBO
        IF(ISINGL.EQ.2) READ(INBO,REC=NBNAV) IXDNBO
        DO 100 I = MIN,MAX
          IX(I) = IXDNBO(I-MIN+1)
  100   CONTINUE
        NBNAV = NBNAV + 1
        IF(MAX.LT.LDAR) GO TO 90
        INBO = ABS(LFNDAF)
      END IF
      ERROR = .FALSE.
      RETURN
C
C  Error encountered while opening this file:
C
  110 ERROR = .TRUE.
      RETURN
C
  900 FORMAT(/1X,'Routine NBOPEN could not determine an appropriate ',
     + 'record length.')
      END
C*****************************************************************************
      SUBROUTINE NBWRIT(IX,NX,IDAR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER (LENGTH = 256)
      PARAMETER (NBDAR = 100)
C
      COMMON/NBODAF/INBO,NAV,IONBO(NBDAR)
      COMMON/NBONAV/IXDNBO(LENGTH),NBNAV,ISINGL
C
      DIMENSION IX(1),IXSNBO(LENGTH/2)
C
      EQUIVALENCE (IXSNBO(1),IXDNBO(1))
C
      MAXIX = LENGTH * ISINGL / 2
      LDAR  = NX * ISINGL
      IF(IONBO(IDAR).NE.0) GO TO 100
C
C  If this is the first write to the NBO DAF:
C
      IONBO(IDAR) = NAV
      NBNAV = NAV
C
      MAX = 0
   10 MIN = MAX + 1
      MAX = MAX + MAXIX
      IF(MAX.GT.LDAR) MAX = LDAR
      DO 20 I = MIN,MAX
   20 IXDNBO(I-MIN+1) = IX(I)
      IF(ISINGL.EQ.1) WRITE(INBO,REC=NBNAV) IXSNBO
      IF(ISINGL.EQ.2) WRITE(INBO,REC=NBNAV) IXDNBO
      NBNAV = NBNAV + 1
      IF(MAX.LT.LDAR) GO TO 10
      NAV = NBNAV
      RETURN
C
C  Or if this is a rewrite:
C
  100 CONTINUE
      NBNAV = IONBO(IDAR)
      MAX = 0
  110 MIN = MAX + 1
      MAX = MAX + MAXIX
      IF(MAX.GT.LDAR) MAX = LDAR
      DO 120 I = MIN,MAX
  120 IXDNBO(I-MIN+1) = IX(I)
      IF(ISINGL.EQ.1) WRITE(INBO,REC=NBNAV) IXSNBO
      IF(ISINGL.EQ.2) WRITE(INBO,REC=NBNAV) IXDNBO
      NBNAV = NBNAV + 1
      IF(MAX.LT.LDAR) GO TO 110
      RETURN
      END
C*****************************************************************************
      SUBROUTINE NBREAD(IX,NX,IDAR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER (LENGTH = 256)
      PARAMETER (NBDAR = 100)
C
      COMMON/NBODAF/INBO,NAV,IONBO(NBDAR)
      COMMON/NBONAV/IXDNBO(LENGTH),NBNAV,ISINGL
C
      DIMENSION IX(1),IXSNBO(LENGTH/2)
C
      EQUIVALENCE (IXSNBO(1),IXDNBO(1))
C
      NBNAV = IONBO(IDAR)
      MAXIX = LENGTH * ISINGL / 2
      LDAR  = NX * ISINGL
C
      MAX = 0
   10 MIN = MAX + 1
      MAX = MAX + MAXIX
      IF(MAX.GT.LDAR) MAX = LDAR
      IF(ISINGL.EQ.1) READ(INBO,REC=NBNAV) IXSNBO
      IF(ISINGL.EQ.2) READ(INBO,REC=NBNAV) IXDNBO
      DO 20 I = MIN,MAX
   20 IX(I) = IXDNBO(I-MIN+1)
      NBNAV = NBNAV + 1
      IF(MAX.LT.LDAR) GO TO 10
      RETURN
      END
C*****************************************************************************
      SUBROUTINE NBCLOS(SEQ)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL SEQ
C
      PARAMETER (LENGTH = 256)
      PARAMETER (NBDAR = 100)
      PARAMETER (MAXFIL = 40)
C
      COMMON/NBODAF/INBO,NAV,IONBO(NBDAR)
      COMMON/NBONAV/IXDNBO(LENGTH),NBNAV,ISINGL
      COMMON/NBNAME/FILENM,NFILE,IFILE(MAXFIL)
      CHARACTER*80 FILENM
C
      DIMENSION IX(NBDAR+2)
      EQUIVALENCE (IX(1),INBO)
C
C  First close the NBO direct access file, remembering to write
C  COMMON/NBODAF/ to the first logical record:
C
      NF = 1
      NX = (NBDAR + 2) / ISINGL
      CALL NBWRIT(IX,NX,NF)
      CLOSE(UNIT=INBO, STATUS='KEEP')
C
C  Then close the remainder of the files used by the NBO program:
C
      DO 10 I = 1,NFILE
        CLOSE(UNIT=ABS(IFILE(I)), STATUS='KEEP')
   10 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE NBINQR(IDAR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER (NBDAR = 100)
      COMMON/NBODAF/INBO,NAV,IONBO(NBDAR)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      IF(IDAR.LT.1.OR.IDAR.GT.NBDAR) THEN
        WRITE(LFNPR,900) IDAR,NBDAR
        STOP
      END IF
C
      IF(IONBO(IDAR).EQ.0) IDAR = 0
      RETURN
C
  900 FORMAT(/1X,'NBO DAF record out of range: IDAR = ',I4,
     + '  NBDAR = ',I4)
      END
C*****************************************************************************
      SUBROUTINE FETITL(TITLE)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION TITLE(10)
C
C  FETITL:  FETCHES THE JOB TITLE FROM THE NBODAF:
C
      NFILE = 2
      CALL NBREAD(TITLE,10,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEE0(EDEL,ETOT)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(2)
C
C  FEE0:  FETCHES THE DELETION AND TOTAL SCF ENERGY
C
      NFILE = 8
      CALL NBREAD(X,2,NFILE)
      EDEL = X(1)
      ETOT = X(2)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVE0(EDEL)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(2)
C
C  SVE0:  SAVES THE DELETION ENERGY
C
      NFILE = 8
      CALL NBREAD(X,2,NFILE)
      X(1) = EDEL
      CALL NBWRIT(X,2,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FECOOR(ATCOOR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION ATCOOR(3*NATOMS)
C
C  FECOOR:  FETCH THE ATOMIC CARTESIAN COORDINATES IN ANGSTROMS.
C
      NFILE = 9
      CALL NBREAD(ATCOOR,3*NATOMS,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FESRAW(S)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
      DIMENSION S(NDIM,NDIM)
C
C  FESRAW:  FETCHES THE OVERLAP MATRIX (RAW AO. BASIS)
C           INTO S(NDIM,NDIM) A FULL SQUARE MATRIX.
C
      NFILE = 10
      L2 = NDIM*(NDIM+1)/2
      CALL NBREAD(S,L2,NFILE)
      CALL UNPACK(S,NDIM,NBAS,L2)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEDRAW(DM,SCR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION DM(1),SCR(1)
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
      SAVE NFILEA,NFILEB
      DATA NFILEA,NFILEB/20,21/
C
C  FEDRAW:  FETCHES THE DENSITY MATRIX (RAW A.O. BASIS) IN DM(NDIM,NDIM)
C           IF ALPHA =.TRUE.  FETCH ALPHA MATRIX
C           IF BETA  =.TRUE   FETCH BETA MATRIX.
C           IF OPEN .AND. .NOT.(ALPHA .OR. BETA) =.TRUE  FETCH THE TOTAL D.M.
C
      L2 = NDIM*(NDIM+1)/2
      NFILE = NFILEA
      IF(BETA) NFILE = NFILEB
      CALL NBREAD(DM,L2,NFILE)
C
      IF(.NOT.OPEN) GOTO 300
      IF(ALPHA.OR.BETA) GOTO 300
      CALL NBREAD(SCR,L2,NFILEB)
C
C  FORM THE TOTAL DENSITY MATRIX:
C
      DO 100 I = 1,L2
        DM(I) = DM(I) + SCR(I)
  100 CONTINUE
C
  300 CALL UNPACK(DM,NDIM,NBAS,L2)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEFAO(F,IWFOCK)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION F(1)
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
      SAVE NFILEA,NFILEB
      DATA NFILEA,NFILEB/30,31/
C
C  FEFAO:  FETCHES THE AO FOCK MATRIX
C          IF ALPHA .EQ. .TRUE.  WE WANT THE ALPHA FOCK MATRIX
C          IF BETA .EQ. .TRUE.  WE WANT THE BETA FOCK MATRIX.
C          IF THE REQUESTED MATRIX DOES NOT EXIST THEN IWFOCK = 0
C
      L2 = NDIM*(NDIM+1)/2
      NFILE = NFILEA
      IF(BETA) NFILE = NFILEB
      CALL NBINQR(NFILE)
      IF(NFILE.GT.0) THEN
        CALL NBREAD(F,L2,NFILE)
        CALL UNPACK(F,NDIM,NBAS,L2)
      ELSE
        IWFOCK = 0
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEAOMO(T,IT)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION T(1)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
C
      SAVE NFILEA,NFILEB
      DATA NFILEA,NFILEB/40,41/
C
C FEAOMO:  FETCH THE AO TO MO TRANSFORMATION MATRIX:
C          (IT = 1, AO TO MO TRANSFORM IS ON NBO DAF)
C          (IT = 0, AO TO MO TRANSFORM IS NOT ON NBO DAF)
C
      NFILE = NFILEA
      IF (BETA) NFILE = NFILEB
      CALL NBINQR(NFILE)
      IF(NFILE.GT.0) THEN
        IT = 1
        L3 = NDIM*NDIM
        CALL NBREAD(T,L3,NFILE)
      ELSE
        IT = 0
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEDXYZ(DXYZ,I)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION DXYZ(1)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
      SAVE NFILEX,NFILEY,NFILEZ
      DATA NFILEX,NFILEY,NFILEZ/50,51,52/
C
C  FEDXYZ:    FETCH THE AO DIPOLE MOMENT MATRICES (IN ANGSTROMS)
C      I=1:  X       I=2:    Y           I=3:   Z
C
      IF(I.EQ.1) NFILE = NFILEX
      IF(I.EQ.2) NFILE = NFILEY
      IF(I.EQ.3) NFILE = NFILEZ
C
      CALL NBINQR(NFILE)
      IF(NFILE.GT.0) THEN
        L2 = NDIM*(NDIM+1)/2
        CALL NBREAD(DXYZ,L2,NFILE)
        CALL UNPACK(DXYZ,NDIM,NBAS,L2)
      ELSE
        I = 0
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVNBO(T,OCC,ISCR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),LBL(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORB(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
C
      DIMENSION T(NDIM,NDIM),OCC(NDIM),ISCR(1)
C
C  SVNBO:  SAVES NBO INFORMATION (TRANSFORMATION, OCCUPANCIES, LABELS, ETC.)
C          IF ALPHA .EQ. .TRUE.  SAVE THE ALPHA INFORMATION
C          IF BETA .EQ. .TRUE.  SAVE THE BETA INFORMATION.
C
C  SAVE THE AO TO NBO TRANSFORMATION MATRIX:
C
      L1 = NDIM
      L3 = NDIM*NDIM
      L4 = 10*NDIM
      NFILE = 44
      IF (BETA) NFILE = 45
      CALL NBWRIT(T,L3,NFILE)
C
C  SAVE NBO ORBITAL OCCUPANCIES:
C
      NFILE = 27
      IF (BETA) NFILE = 28
      CALL NBWRIT(OCC,L1,NFILE)
C
C  SAVE THE LISTS OF NBO INFORMATION FOR LATER USE IN THE DELETIONS.
C  PACK THE INFORMATION INTO ISCR(10*NDIM):
C
      II = 0
      DO 40 K = 1,6
        DO 30 I = 1,NBAS
          II = II + 1
          ISCR(II) = LABEL(I,K)
   30   CONTINUE
   40 CONTINUE
      DO 50 I = 1,NBAS
        II = II + 1
        ISCR(II) = IBXM(I)
   50 CONTINUE
      DO 60 I = 1,NATOMS
        II = II + 1
        ISCR(II) = IATNO(I)
   60 CONTINUE
      DO 70 I = 1,NBAS
        II = II + 1
        ISCR(II) = NBOUNI(I)
   70 CONTINUE
      DO 80 I = 1,NBAS
        II = II + 1
        ISCR(II) = NBOTYP(I)
   80 CONTINUE
C
      NFILE = 60
      IF (BETA) NFILE = 61
      CALL NBWRIT(ISCR,L4,NFILE)
C
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FENBO(T,OCC,ISCR,NELEC)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       IATNO(MAXBAS),IBXM(MAXBAS),ISCR1(2*MAXBAS),ISCR2(2*MAXBAS)
C
      DIMENSION T(NDIM,NDIM),OCC(NDIM),ISCR(1)
C
      SAVE ZERO,TENTH
      DATA ZERO,TENTH/0.0D0,1.0D-1/
C
C  FENBO:  FETCHES NBO INFORMATION (TRANSFORMATION, OCCUPANCIES, LABELS, ETC.)
C          IF ALPHA .EQ. .TRUE.  FETCH THE ALPHA INFORMATION
C          IF BETA .EQ. .TRUE.  FETCH THE BETA INFORMATION.
C
C  FETCH THE AO TO NBO TRANSFORMATION MATRIX:
C
      L1 = NDIM
      L3 = NDIM*NDIM
      L4 = NDIM*10
      NFILE = 44
      IF (BETA) NFILE = 45
      CALL NBREAD(T,L3,NFILE)
C
C  FETCH NBO ORBITAL OCCUPANCIES:
C
      NFILE = 27
      IF (BETA) NFILE = 28
      CALL NBREAD(OCC,L1,NFILE)
C
C  COUNT UP THE TOTAL NUMBER OF ELECTRONS AS AN INTEGER NELEC:
C
      ELE = ZERO
      DO 10 I = 1,NBAS
        ELE = ELE + OCC(I)
   10 CONTINUE
      ELE = ELE + TENTH
      NELEC = ELE
C
C  FETCH THE VARIOUS LISTS OF NBO INFORMATION FOR USE IN THE DELETIONS.
C  UNPACK THE INFORMATION INTO LABEL(MAXBAS,6),IBXM(MAXBAS),IATNO(MAXBAS),
C  NBOUNI(MAXBAS) AND NBOTYP(MAXBAS) FROM ISCR(10*NDIM):
C
      NFILE = 60
      IF (BETA) NFILE = 61
      CALL NBREAD(ISCR,L4,NFILE)
C
      II = 0
      DO 40 K = 1,6
        DO 30 I = 1,NBAS
          II = II + 1
          LABEL(I,K) = ISCR(II)
   30   CONTINUE
   40 CONTINUE
      DO 50 I = 1,NBAS
        II = II + 1
        IBXM(I) = ISCR(II)
   50 CONTINUE
      DO 60 I = 1,NATOMS
        II = II + 1
        IATNO(I) = ISCR(II)
   60 CONTINUE
      DO 70 I = 1,NBAS
        II = II + 1
        NBOUNI(I) = ISCR(II)
   70 CONTINUE
      DO 80 I = 1,NBAS
        II = II + 1
        NBOTYP(I) = ISCR(II)
   80 CONTINUE
C
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FETNBO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION T(1)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
C  FETNBO: FETCH THE AO TO NBO TRANSFORMATION MATRIX
C
      L3 = NDIM*NDIM
      NFILE = 44
      IF (BETA) NFILE = 45
      CALL NBREAD(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVPNAO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION T(1)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
C  SVPNAO:  SAVES THE AO TO PNAO TRANSFORMATION MATRIX.
C
      NFILE = 42
      L3 = NDIM*NDIM
      CALL NBWRIT(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEPNAO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION T(1)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
C  FEPNAO:  FETCHES THE AO TO PNAO TRANSFORMATION MATRIX.
C
      NFILE = 42
      L3 = NDIM*NDIM
      CALL NBREAD(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVSNAO(S)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION S(NDIM,NDIM)
C
C   SVSNAO:  SAVE THE OVERLAP MATRIX IN THE PNAO OR RPNAO BASIS SET.
C
      NFILE = 11
      L2 = NDIM*(NDIM+1)/2
      CALL PACK(S,NDIM,NBAS,L2)
      CALL NBWRIT(S,L2,NFILE)
      CALL UNPACK(S,NDIM,NBAS,L2)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FESNAO(S)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
      DIMENSION S(NDIM,NDIM)
C
C   FESNAO:   FETCH THE OVERLAP MATRIX IN THE PNAO OR RPNAO BASIS SET.
C
      NFILE = 11
      L2 = NDIM*(NDIM+1)/2
      CALL NBREAD(S,L2,NFILE)
      CALL UNPACK(S,NDIM,NBAS,L2)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVTNAB(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
C  SVTNAB:  SAVE THE NAO TO NBO TRANSFORMATION MATRIX.
C
      NFILE = 48
      L3 = NDIM*NDIM
      CALL NBWRIT(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FETNAB(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
C  FETNAB:  FETCH THE NAO TO NBO TRANSFORMATION MATRIX
C
      NFILE = 48
      L3 = NDIM*NDIM
      CALL NBREAD(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVTLMO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
C  SVTLMO:  SAVE THE NBO TO NLMO TRANSFORMATION MATRIX.
C
      NFILE = 49
      L3 = NDIM*NDIM
      CALL NBWRIT(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FETLMO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
C  FETLMO:  FETCH THE NBO TO NLMO TRANSFORMATION MATRIX
C
      NFILE = 49
      L3 = NDIM*NDIM
      CALL NBREAD(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVTNHO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
C  SVTNHO:   TEMPORARILY SAVE THE NAO TO NHO TRANSFORMATION
C
      NFILE = 47
      L3 = NDIM*NDIM
      CALL NBWRIT(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FETNHO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
C  FETNHO:   FETCH THE NAO TO NHO TRANSFORMATION
C
      NFILE = 47
      L3 = NDIM*NDIM
      CALL NBREAD(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVPPAO(DM)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION DM(NDIM,NDIM)
C
C  SVPPAO:  TEMPORARILY SAVES THE PURE AO (PAO) DENSITY MATRIX.
C           (THIS IS NOT THE RAW AO BASIS, BUT THE BASIS AFTER THE
C           TRANSFORMATION FROM CARTESIAN TO PURE D,F,G FUNCTIONS).
C
      NFILE = 22
      L2 = NDIM*(NDIM+1)/2
      CALL PACK(DM,NDIM,NBAS,L2)
      CALL NBWRIT(DM,L2,NFILE)
      CALL UNPACK(DM,NDIM,NBAS,L2)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEPPAO(DM)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION DM(NDIM,NDIM)
C
C  FEPPAO:  FETCHES THE PURE AO (PAO) DENSITY MATRIX.
C           (THIS IS NOT THE RAW AO BASIS, BUT THE BASIS AFTER THE
C           TRANSFORMATION FROM CARTESIAN TO PURE D,F,G FUNCTIONS).
C
      NFILE = 22
      L2 = NDIM*(NDIM+1)/2
      CALL NBREAD(DM,L2,NFILE)
      CALL UNPACK(DM,NDIM,NBAS,L2)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVTNAO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
C  SVTNAO:  SAVE THE AO TO NAO TRANSFORMATION MATRIX.
C
      IF(.NOT.ORTHO) THEN
        NFILE = 43
        L3 = NDIM*NDIM
        CALL NBWRIT(T,L3,NFILE)
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FETNAO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
      SAVE ZERO,ONE
      DATA ZERO,ONE/0.0D0,1.0D0/
C
C  FETNAO:  FETCHES THE AO TO NAO TRANSFORMATION MATRIX.
C
      IF(ORTHO) THEN
        DO 20 J = 1,NDIM
          DO 10 I = 1,NDIM
            T(I,J) = ZERO
   10     CONTINUE
          T(J,J) = ONE
   20   CONTINUE
      ELSE
        NFILE = 43
        L3 = NDIM*NDIM
        CALL NBREAD(T,L3,NFILE)
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVNLMO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
C  SVNLMO:  SAVE THE AO TO NLMO TRANSFORMATION MATRIX
C
      NFILE = 46
      L3 = NDIM*NDIM
      CALL NBWRIT(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FENLMO(T)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION T(NDIM,NDIM)
C
C  FENLMO:  FETCH THE AO TO NLMO TRANSFORMATION MATRIX
C
      NFILE = 46
      L3 = NDIM*NDIM
      CALL NBREAD(T,L3,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVDNAO(DM)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION DM(NDIM,NDIM)
C
C  SVDNAO:  SAVE THE NAO DENSITY MATRIX
C
      IF(.NOT.ORTHO) THEN
        NFILE = 23
        IF(BETA) NFILE = 24
        L2 = NDIM*(NDIM+1)/2
        CALL PACK(DM,NDIM,NBAS,L2)
        CALL NBWRIT(DM,L2,NFILE)
        CALL UNPACK(DM,NDIM,NBAS,L2)
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEDNAO(DM)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      DIMENSION DM(NDIM,NDIM)
C
C  FEDNAO:  FETCHES THE NAO DENSITY MATRIX (AO DM FOR ORTHOGONAL BASIS SETS)
C
      IF(ORTHO) THEN
        CALL FEDRAW(DM,DM)
      ELSE
        NFILE = 23
        IF(BETA) NFILE = 24
        L2 = NDIM*(NDIM+1)/2
        CALL NBREAD(DM,L2,NFILE)
        CALL UNPACK(DM,NDIM,NBAS,L2)
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVFNBO(F)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      DIMENSION F(NDIM,NDIM)
C
C  SVFNBO:  SAVES THE NBO FOCK MATRIX
C
      NFILE = 34
      IF (BETA) NFILE = 35
      L2 = NDIM*(NDIM+1)/2
      CALL PACK(F,NDIM,NBAS,L2)
      CALL NBWRIT(F,L2,NFILE)
      CALL UNPACK(F,NDIM,NBAS,L2)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEFNBO(F)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      DIMENSION F(1)
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
C  FEFNBO:  FETCHES THE NBO FOCK MATRIX, LEAVING IT IN TRIANGULAR FORM!!
C           IF ALPHA.EQ.TRUE.  WE WANT THE ALPHA FOCK MATRIX
C           IF BETA.EQ.TRUE.   WE WANT THE BETA FOCK MATRIX.
C
      NFILE = 34
      IF (BETA) NFILE = 35
      L2 = NDIM*(NDIM+1)/2
      CALL NBREAD(F,L2,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SVNEWD(DM)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      DIMENSION DM(1)
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
C SVNEWD:  SAVE THE NEW DENSITY MATRIX (RAW AO BASIS) FROM NBO DELETION
C
      NFILE = 25
      IF (BETA) NFILE = 26
      L2 = NDIM*(NDIM+1)/2
      CALL NBWRIT(DM,L2,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FENEWD(DM)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      DIMENSION DM(1)
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
C FENEWD:  FETCH THE NEW DENSITY MATRIX (RAW AO BASIS)
C
      NFILE = 25
      IF (BETA) NFILE = 26
      L2 = NDIM*(NDIM+1)/2
      CALL NBREAD(DM,L2,NFILE)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEINFO(ICORE,ISWEAN)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      DIMENSION ICORE(12)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
      COMMON/NBBAS/LABEL(MAXBAS,6),LVAL(MAXBAS),IMVAL(MAXBAS),
     +       LSTOCC(MAXBAS),LSTEMT(MAXBAS),LARC(MAXBAS),LBL(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBAO/LCTR(MAXBAS),LANG(MAXBAS)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
C  Restore wavefunction information from the NBO DAF:
C
C  Restore NATOMS, NDIM, NBAS, MUNIT, wavefunction flags, ISWEAN:
C
      NFILE = 3
      CALL NBREAD(ICORE,12,NFILE)
      NATOMS = ICORE(1)
      NDIM   = ICORE(2)
      NBAS   = ICORE(3)
      MUNIT  = ICORE(4)
      ROHF   = .FALSE.
      IF(ICORE(5).EQ.1)  ROHF  = .TRUE.
      UHF    = .FALSE.
      IF(ICORE(6).EQ.1)  UHF   = .TRUE.
      CI     = .FALSE.
      IF(ICORE(7).EQ.1)  CI    = .TRUE.
      OPEN   = .FALSE.
      IF(ICORE(8).EQ.1)  OPEN  = .TRUE.
      MCSCF  = .FALSE.
      IF(ICORE(9).EQ.1)  MCSCF = .TRUE.
      AUHF   = .FALSE.
      IF(ICORE(10).EQ.1) AUHF  = .TRUE.
      ORTHO  = .FALSE.
      IF(ICORE(11).EQ.1) ORTHO = .TRUE.
      ISWEAN = ICORE(12)
C
C  IF ISWEAN IS 1, SET ICORE(12) TO 0 AND WRITE TO NBO DAF.  NOTE, ISWEAN IS
C  SET TO 1 BY THE FEAOIN DRIVER ROUTINE.  THIS TELLS THE ENERGETIC ANALYSIS
C  ROUTINES TO SEARCH FOR THE $DEL KEYLIST.  ISWEAN IS RESET TO 0 HERE SO
C  THAT MULTIPLE DELETIONS CAN BE READ FROM A SINGLE $DEL KEYLIST:
C
      IF(ISWEAN.EQ.1) THEN
        ICORE(12) = 0
        CALL NBWRIT(ICORE,12,NFILE)
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FEBAS(NSHELL,NEXP,ISCR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION ISCR(1)
C
C  FEBAS:  FETCHES THE BASIS SET INFO
C
      NFILE = 5
      CALL NBINQR(NFILE)
      IF(NFILE.GT.0) THEN
        CALL NBREAD(ISCR,2,NFILE)
        II = 0
        II = II + 1
        NSHELL = ISCR(II)
        II = II + 1
        NEXP   = ISCR(II)
        LEN    = 2 + 3*NSHELL + 5*NEXP
        CALL NBREAD(ISCR,LEN,NFILE)
      ELSE
        NSHELL = 0
      END IF
      RETURN
      END
C*****************************************************************************
C
C  FREE FORMAT INPUT ROUTINES:
C
C      SUBROUTINE STRTIN(LFNIN)
C      SUBROUTINE NXTCRD
C      SUBROUTINE IFLD(INT,ERROR)
C      SUBROUTINE RFLD(REAL,ERROR)
C      SUBROUTINE HFLD(KEYWD,LENG,ENDD)
C      SUBROUTINE FNDFLD
C      FUNCTION EQUAL(IA,IB,L)
C
C*****************************************************************************
C
C  USER  INSTRUCTIONS:
C
C     1. THE CHARACTER STRING "END" IS THE FIELD TERMINATING MARK:
C
C     2. COMMAS AND EQUAL SIGNS ARE TREATED AS EQUIVALENT TO BLANKS.
C          COMMAS, EQUAL SIGNS, AND BLANKS DELIMIT INPUT ITEMS.
C
C     3. ALL CHARACTERS TO THE RIGHT OF AN EXCLAMATION MARK ! ARE TREATED AS
C          COMMENTS, AND THE NEXT CARD IS READ IN WHEN THESE ARE ENCOUNTERED.
C
C     4. UPPER AND LOWER CASE CHARACTERS CAN BE READ BY THESE ROUTINES.
C          HOWEVER, LOWER CASE CHARACTERS ARE CONVERTED TO UPPER CASE
C          WHEN ENCOUNTERED.
C
C     5. TO READ IN DATA FOR THE FIRST TIME FROM LFN "LFNIN" (PERHAPS
C          AFTER USING THESE SUBROUTINES TO READ IN DATA FROM ANOTHER LFN),
C          OR TO CONTINUE READING IN DATA FROM LFNIN AFTER ENCOUNTERING
C          A FIELD TERMINATING MARK, CALL STRTIN(LFNIN)  (START INPUT)
C
C     6. TO FETCH THE NEXT NON-BLANK STRING OF CHARACTERS FROM LFN LFNIN,
C           CALL HFLD(KEYWD,LENGTH,END),
C            WHERE KEYWD   IS A VECTOR OF DIMENSION "LENGTH"  OR LONGER,
C                  LENGTH  IS THE MAXIMUM NUMBER OF CHARACTERS TO FETCH,
C                  END     MUST BE A DECLARED LOGICAL VARIABLE.
C           UPON RETURN,
C            END=.TRUE. IF A FIELD TERMINATING MARK WAS FOUND TO BE THE NEXT
C                 NON-BLANK CHARACTER STRING.  OTHERWISE, END=.FALSE.
C            END=.TRUE. AND LENGTH=0 MEANS THE END-OF-FILE WAS FOUND.
C            LENGTH IS CHANGED TO THE ACTUAL NUMBER OF CHARACTERS IN STRING
C                 IF THIS IS LESS THAN THE VALUE OF LENGTH SET BY THE CALLING
C                 PROGRAM.
C            KEYWD(1) THROUGH KEYWD(LENGTH) CONTAIN THE CHARACTER STRING,
C                 ONE CHARACTER PER ELEMENT OF KEYWD.
C
C     7. TO FETCH THE INTEGER VALUE OF THE NEXT CHARACTER STRING,
C           CALL IFLD(INT,ERROR),
C            WHERE INT     IS THE VARIABLE TO BE READ,
C                  ERROR   MUST BE A DECLARED LOGICAL VARIABLE.
C            UPON RETURN,
C             IF ERROR=.FALSE., AN INTEGER WAS FOUND AND PLACED IN "INT".
C             IF ERROR=.TRUE. AND INT.GT.0, A FIELD TERMINATING MARK WAS
C                 FOUND AS THE NEXT CHARACTER STRING.
C             IF ERROR=.TRUE. AND INT.LT.0, THE NEXT CHARACTER STRING FOUND
C                 WAS NEITHER AN INTEGER NOR A FIELD TERMINATING MARK.
C
C     8. TO FETCH THE REAL VALUE OF THE NEXT CHARACTER STRING,
C           (AN EXPONENT IS ALLOWED, WITH OR WITHOUT AN "E" OR "F".
C             IF NO LETTER IS PRESENT TO SIGNIFY THE EXPONENT FIELD,
C             A + OR - SIGN MUST START THE EXPONENT.  IF NO MANTISSA IS
C             PRESENT, THE EXPONENT FIELD MUST START WITH A LETTER, AND
C             THE MANTISSA IS SET TO ONE.)
C           CALL RFLD(REAL,ERROR),
C            WHERE REAL    IS THE VARIABLE TO BE READ,
C                  ERROR   MUST BE A DECLARED LOGICAL VARIABLE.
C            UPON RETURN,
C             IF ERROR=.FALSE., A REAL NUMBER WAS FOUND AND PLACED IN "REAL".
C             IF ERROR=.TRUE. AND REAL.GT.1, A FIELD TERMINATING MARK WAS
C                 FOUND AS THE NEXT CHARACTER STRING.
C             IF ERROR=.TRUE. AND REAL.LT.-1, THE NEXT CHARACTER STRING FOUND
C                 WAS NEITHER A REAL NUMBER NOR A FIELD TERMINATING MARK.
C
C     9. TO COMPARE THE CORRESPONDING FIRST L ELEMENTS OF EACH OF TWO VECTORS
C          IA(L) AND IB(L) TO SEE IF THE VECTORS ARE EQUIVALENT,
C           USE THE FUNCTION EQUAL(IA,IB,L).
C           EQUAL MUST BE DECLARED LOGICAL IN THE CALLING PROGRAM,
C            AND THE FUNCTION VALUE (.TRUE. OR .FALSE.) WILL TELL IF THE
C            VECTORS IA AND IB ARE EQUAL UP TO ELEMENT L.
C        NOTE: THIS FUNCTION IS USEFUL FOR DETERMINING IF A CHARACTER STRING
C          READ BY A CALL TO HFLD MATCHES A CERTAIN KEYWORD WHICH IS STORED
C          IN A VECTOR, ONE CHARACTER PER ELEMENT.
C
C
C*****************************************************************************
      SUBROUTINE STRTIN(LFNIN)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBCRD1/ICD(80),LOOK(80),LENGTH,IPT,LFN,NEXP
      COMMON/NBCRD2/POINT,END,NEXT,EXP
      LOGICAL POINT,END,NEXT,EXP
C
C  INITIALIZE INPUT FROM LFN LFNIN:
C
      LFN  = LFNIN
      END  = .FALSE.
      NEXT = .TRUE.
      CALL NXTCRD
C
      RETURN
      END
C*****************************************************************************
      SUBROUTINE NXTCRD
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  SUBROUTINE NAME CHANGED FROM RDCARD, DUE TO CONFLICT WITH GAMESS:
C
      COMMON/NBCRD1/ICD(80),LOOK(80),LENGTH,IPT,LFN,NEXP
      COMMON/NBCRD2/POINT,END,NEXT,EXP
      LOGICAL POINT,END,NEXT,EXP
C
      SAVE IA,ICHARA,ICHARZ,IBLNK,IQ,II
      DATA IA,ICHARA,ICHARZ/1HA,1Ha,1Hz/
      DATA IBLNK,IQ,II/1H ,1H`,1HI/
C
C  READ IN THE NEXT CARD AT LFN:
C
      READ(LFN,1000,END=800,ERR=800) ICD
C
C  CHANGE ALL LOWER CASE CHARACTERS TO UPPER CASE:
C
      DO 10 I = 1,80
        IF(ICD(I).GE.ICHARA.AND.ICD(I).LE.ICHARZ) THEN
          ICD(I) = ICD(I) - ICHARA + IA
        END IF
   10 CONTINUE
C
C  TREAT TABS AS SPACES:
C
      ITAB = IBLNK + II - IQ
      DO 20 I = 1,80
	IF(ICD(I).EQ.ITAB) ICD(I) = IBLNK
   20 CONTINUE
C
C  RESET COLUMN POINTER, IPT:
C
      IPT = 1
      RETURN
C
C  END OF FILE ENCOUNTERED
C
  800 CONTINUE
      END = .TRUE.
      RETURN
C
 1000 FORMAT(80A1)
      END
C*****************************************************************************
      SUBROUTINE IFLD(INT,ERROR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ERROR
C
      COMMON/NBCRD1/ICD(80),LOOK(80),LENGTH,IPT,LFN,NEXP
      COMMON/NBCRD2/POINT,END,NEXT,EXP
      LOGICAL POINT,END,NEXT,EXP
C
      SAVE ZERO,ONE,SMALL
      DATA ZERO,ONE,SMALL/0.0D0,1.0D0,1.0D-3/
C
C  SEARCH LFN FOR THE NEXT STRING OF NON-BLANK CHARACTERS, SEE IF THEY
C  FORM AN INTEGER (IF NOT, ERROR=.TRUE.) AND, IF SO, PLACE ITS NUMERICAL
C  VALUE IN "INT":
C
      INT = 0
      CALL RFLD(REAL,ERROR)
C
C  IF DECIMAL POINT OR AN EXPONENT.LT.0, ERROR = .TRUE.:
C
      IF(EXP) GO TO 100
      IF(POINT) GO TO 100
      IF(NEXP.LT.0) GO TO 100
      IF(LENGTH.EQ.0) GO TO 100
      SIGN = ONE
      IF(REAL.LT.ZERO) SIGN = -ONE
      REAL = REAL + SMALL * SIGN
      INT = REAL
      RETURN
C
  100 ERROR = .TRUE.
      NEXT = .FALSE.
      RETURN
      END
C*****************************************************************************
      SUBROUTINE RFLD(REAL,ERROR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ERROR,EXPSGN,MANTIS
C
      COMMON/NBCRD1/ICD(80),LOOK(80),LENGTH,IPT,LFN,NEXP
      COMMON/NBCRD2/POINT,END,NEXT,EXP
      LOGICAL POINT,END,NEXT,EXP
C
      DIMENSION NCHAR(15)
C
      SAVE NCHAR,ZERO,ONE,TEN
      DATA NCHAR/1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9,1H.,1H+,1H-,
     +  1HD,1HE/
      DATA ZERO,ONE,TEN/0.0D0,1.0D0,10.0D0/
C
C  SEARCH LFN FOR THE NEXT STRING OF NON-BLANK CHARACTERS, SEE IF THEY FORM
C  A REAL NUMBER (EXPONENT IS OPTIONAL) (IF NOT, ERROR=.TRUE.) AND, IF SO,
C  PLACE ITS NUMERICAL VALUE IN "REAL":
C
      REAL   = ZERO
      SIGN   = ONE
      NDEC   = 0
      ISEXP  = 1
      NEXP   = 0
      EXPSGN = .FALSE.
      EXP    = .FALSE.
      POINT  = .FALSE.
      ERROR  = .FALSE.
      MANTIS = .FALSE.
      END    = .FALSE.
C
C  FIND THE NEXT STRING OF NON-BLANK CHARACTERS, "LOOK", OF LENGTH "LENGTH":
C
      IF(NEXT) CALL FNDFLD
      IF(END) GO TO 300
      IF(LENGTH.EQ.0) GO TO 300
C
C  FIND THE NUMERICAL VALUE OF THE CHARACTERS IN "LOOK":
C
      DO 200 J = 1,LENGTH
        LK = LOOK(J)
        DO 20 I = 1,15
          IF(LK.EQ.NCHAR(I)) GO TO 40
   20   CONTINUE
        GO TO 300
   40   K = I - 11
        IF(K) 60,80,100
C
C  THIS CHARACTER IS A NUMBER:
C
   60     CONTINUE
          IF(EXP) GO TO 70
C
C  ADD DIGIT TO MANTISSA:
C
          MANTIS = .TRUE.
          REAL = REAL * TEN + FLOAT(I - 1)
C
C  IF WE ARE TO THE RIGHT OF A DECIMAL POINT, INCREMENT THE DECIMAL COUNTER:
C
          IF(POINT) NDEC = NDEC + 1
          GO TO 200
C
C  ADD DIGIT TO EXPONENT:
C
   70     NEXP = NEXP * 10 + (I - 1)
          GO TO 200
C
C  DECIMAL POINT:
C
   80     IF(POINT) GO TO 300
          POINT = .TRUE.
          GO TO 200
C
C  EXPONENT (+,-,D,E):
C
  100     CONTINUE
          GO TO (110,130,150,150), K
C
C  PLUS SIGN: IF NOT FIRST CHARACTER, COUNT AS PART OF EXPONENT:
C
  110       IF(J.EQ.1) GO TO 200
              IF(EXPSGN) GO TO 200
              EXPSGN = .TRUE.
              EXP = .TRUE.
              GO TO 200
C
C  MINUS SIGN: IF NOT FIRST CHARACTER, COUNT AS PART OF EXPONENT:
C
  130       IF(J.NE.1) GO TO 140
              SIGN = -ONE
              GO TO 200
  140         ISEXP = -1
              IF(EXPSGN) GO TO 200
              EXPSGN = .TRUE.
              EXP = .TRUE.
              GO TO 200
C
C  D OR E: START OF EXPONENT:
C
  150       IF(EXP) GO TO 300
            EXP = .TRUE.
  200  CONTINUE
C
C  SET FINAL VALUE OF REAL (IF NO MANTISSA, BUT EXPONENT PRESENT,
C  SET MANTISSA TO ONE):
C
      IF(EXP.AND..NOT.MANTIS) REAL = ONE
      REAL = REAL * SIGN * (TEN**(-NDEC+ISEXP*NEXP))
      NEXT = .TRUE.
      RETURN
C
C  NO REAL NUMBER FOUND, OR FIELD TERMINATING MARK:
C
  300 CONTINUE
      ERROR = .TRUE.
      REAL  = -TEN
      IF(END) REAL = TEN
      RETURN
      END
C*****************************************************************************
      SUBROUTINE HFLD(KEYWD,LENG,ENDD)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ENDD,EQUAL
C
      COMMON/NBCRD1/ICD(80),LOOK(80),LENGTH,IPT,LFN,NEXP
      COMMON/NBCRD2/POINT,END,NEXT,EXP
      LOGICAL POINT,END,NEXT,EXP
C
      DIMENSION KEYWD(LENG),KEND(3)
C
      SAVE NBLA,KEND
      DATA NBLA/1H /
      DATA KEND/1HE,1HN,1HD/
C
C  SEARCH LFN AND FIND NEXT NON-BLANK STRING OF CHARACTERS AND PLACE
C  IN THE VECTOR "KEYWD".  LENG, FROM THE CALLING PROGRAM, IS MAXIMUM
C  LENGTH OF STRING TO PUT IN THE VECTOR KEYWD.  IF "LENGTH" IS LESS
C  THAN "LENG", LENG IS SET TO LENGTH UPON RETURN:
C
      IF(NEXT) CALL FNDFLD
      ENDD  = END
      LENG1 = LENG
      LENG  = MIN0(LENGTH,LENG)
C
C  PLACE LENG CHARACTERS INTO KEYWD:
C
      DO 10 I = 1,LENG
        KEYWD(I) = LOOK(I)
   10 CONTINUE
C
C  FILL THE REST OF KEYWD WITH BLANKS:
C
      DO 20 I = LENG+1,LENG1
        KEYWD(I) = NBLA
   20 CONTINUE
      NEXT = .TRUE.
C
C  CHECK FOR END OF INPUT:
C
      IF(EQUAL(LOOK,KEND,3)) ENDD = .TRUE.
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FNDFLD
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBCRD1/ICD(80),LOOK(80),LENGTH,IPT,LFN,NEXP
      COMMON/NBCRD2/POINT,END,NEXT,EXP
      LOGICAL POINT,END,NEXT,EXP
C
      SAVE NBLA,NCOM,NEXC,NEQ
      DATA NBLA/1H /,NCOM/1H,/,NEXC/1H!/,NEQ/1H=/
C
C  FIND NEXT NON-BLANK STRING OF CHARACTERS IN LFN.  READ IN ANOTHER LINE
C  OF LFN UNTIL NON-BLANK CHARACTERS ARE FOUND AND PLACE THEM IN "LOOK",
C  OF LENGTH "LENGTH":
C
      IF(END) GO TO 35
      IF(IPT.GE.80) CALL NXTCRD
      IF(END) GO TO 35
C
C  LOOK FOR START OF FIELD.  SKIP TO NEXT CARD IF "!" IS ENCOUNTERED
C  (COMMENT FIELD):
C
   10 CONTINUE
      DO 20 NCOL = IPT,80
        ICARD = ICD(NCOL)
        IF(ICARD.EQ.NEXC) GO TO 30
        IF(ICARD.NE.NBLA.AND.ICARD.NE.NCOM.AND.ICARD.NE.NEQ) GO TO 40
   20 CONTINUE
C
C  NOTHING ADDITIONAL FOUND ON THIS CARD, CONTINUE WITH THE NEXT CARD:
C
   30 CALL NXTCRD
      IF(.NOT.END) GO TO 10
C
C  END OF FILE FOUND:
C
   35 LENGTH = 0
      RETURN
C
C  LOOK FOR THE END OF THIS FIELD, COUNTING CHARACTERS AS WE GO AND
C  STORING THESE CHARACTER IN LOOK:
C
   40 M = 0
      DO 80 MCOL = NCOL,80
        ICHAR = ICD(MCOL)
        IF(ICHAR.EQ.NBLA.OR.ICHAR.EQ.NCOM.OR.ICHAR.EQ.NEQ) GO TO 100
        M = M + 1
        LOOK(M) = ICHAR
   80 CONTINUE
C
C  SET LENGTH TO THE LENGTH OF THE NEW STRING IN LOOK AND RESET IPT TO
C  THE NEXT SPACE AFTER THIS STRING:
C
  100 LENGTH = M
      IPT = MCOL
      NEXT = .FALSE.
      RETURN
      END
C*****************************************************************************
      FUNCTION EQUAL(IA,IB,L)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL EQUAL
C
      DIMENSION IA(L),IB(L)
C
C  TEST IF THE FIRST L ELEMENTS OF VECTORS IA AND IB ARE EQUAL:
C
      EQUAL = .FALSE.
      DO 10 I = 1,L
        IF(IA(I).NE.IB(I)) GO TO 20
   10 CONTINUE
      EQUAL = .TRUE.
   20 RETURN
      END
C*****************************************************************************
C
C  OTHER SYSTEM-INDEPENDENT I/O ROUTINES:
C
C      SUBROUTINE GENINP(NEWDAF)
C      SUBROUTINE NBOINP(NBOOPT,IDONE)
C      SUBROUTINE CORINP(IESS,ICOR)
C      SUBROUTINE CHSINP(IESS,ICHS)
C      SUBROUTINE DELINP(NBOOPT,IDONE)
C
C      SUBROUTINE RDCORE(JCORE)
C      SUBROUTINE WRPPNA(T,OCC,IFLG)
C      SUBROUTINE RDPPNA(T,OCC,IFLG)
C      SUBROUTINE WRTNAO(T,IFLG)
C      SUBROUTINE RDTNAO(DM,T,SCR,IFLG)
C      SUBROUTINE WRTNAB(T,IFLG)
C      SUBROUTINE RDTNAB(T,DM,BNDOCC,SCR,IFLG)
C      SUBROUTINE WRTNBO(T,BNDOCC,IFLG)
C      SUBROUTINE WRNLMO(T,DM,IFLG)
C      SUBROUTINE WRBAS(SCR,ISCR,LFN)
C      SUBROUTINE WRARC(SCR,ISCR,LFN)
C
C      SUBROUTINE AOUT(A,MR,NR,NC,TITLE,INDEX,IFLG)
C      SUBROUTINE APRINT(A,MR,NR,NC,TITLE,INDEX,MCOL)
C      SUBROUTINE AWRITE(A,MR,NR,NC,TITLE,LFN)
C      SUBROUTINE AREAD(A,MR,NR,NC,JOB,LFN,ERROR)
C      SUBROUTINE ALTOUT(A,MR,MC,NR,NC)
C      SUBROUTINE KEYPAR(STRING,LEN,IFLG,LFN,READ,ERROR)
C      FUNCTION IOINQR(IFLG)
C      SUBROUTINE LBLAO
C      SUBROUTINE LBLNAO
C      SUBROUTINE LBLNBO
C      SUBROUTINE LBLNHO(INHO,INBO,ICTR,NCTR)
C
C*****************************************************************************
      SUBROUTINE GENINP(NEWDAF)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL NEWDAF,END,ERROR,EQUAL
C
      DIMENSION KEYWD(6),KGEN(4),KEND(4),KREUSE(5),KNBAS(4),KNATOM(6),
     +      KUPPER(5),KOPEN(4),KORTHO(5),KBOHR(4),KBODM(4),KEV(2),
     +      KCUBF(6)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
      COMMON/NBGEN/REUSE,UPPER,BOHR,DENOP
      LOGICAL REUSE,UPPER,BOHR,DENOP
C
      SAVE KGEN,KEND,KREUSE,KNBAS,KNATOM,KUPPER,KOPEN,KORTHO,KBOHR,
     +  KBODM,KEV,KCUBF
      DATA KGEN/1H$,1HG,1HE,1HN/,KEND/1H$,1HE,1HN,1HD/,
     + KREUSE/1HR,1HE,1HU,1HS,1HE/,KNBAS/1HN,1HB,1HA,1HS/,
     + KNATOM/1HN,1HA,1HT,1HO,1HM,1HS/,KUPPER/1HU,1HP,1HP,1HE,1HR/,
     + KOPEN/1HO,1HP,1HE,1HN/,KORTHO/1HO,1HR,1HT,1HH,1HO/,
     + KBOHR/1HB,1HO,1HH,1HR/,KBODM/1HB,1HO,1HD,1HM/,
     + KEV/1HE,1HV/KCUBF/1HC,1HU,1HB,1HI,1HC,1HF/
C
C  Initialize variables:
C
      NBAS   = 0
      NATOMS = 0
      MUNIT  = 0
      REUSE  = .FALSE.
      UPPER  = .FALSE.
      BOHR   = .FALSE.
      DENOP  = .TRUE.
C
C  Search LFNIN for $GEN:
C
      REWIND(LFNIN)
   10 CALL STRTIN(LFNIN)
      LEN = 6
      CALL HFLD(KEYWD,LEN,END)
      IF(LEN.EQ.0.AND.END) STOP 'No $GEN keylist in the input file'
      IF(.NOT.EQUAL(KEYWD,KGEN,4)) GOTO 10
C
C  $GEN has been found, now read keywords:
C
   20 LEN = 6
      CALL HFLD(KEYWD,LEN,END)
      IF(EQUAL(KEYWD,KEND,4)) GOTO 700
C
C  Keyword REUSE -- reuse data already stored on the NBO DAF:
C
      IF(EQUAL(KEYWD,KREUSE,5)) THEN
        REUSE = .TRUE.
        GOTO 20
      END IF
C
C  Keyword NBAS -- Specify the number of basis functions:
C
      IF(EQUAL(KEYWD,KNBAS,4)) THEN
        CALL IFLD(NBAS,ERROR)
        IF(ERROR) STOP 'Error reading in number of basis functions NBAS'
        GOTO 20
      END IF
C
C  Keyword NATOMS -- Specify the number of atoms:
C
      IF(EQUAL(KEYWD,KNATOM,4)) THEN
        CALL IFLD(NATOMS,ERROR)
        IF(ERROR) STOP 'Error reading in number of atoms NATOMS'
        GOTO 20
      END IF
C
C  Keyword UPPER -- Read only upper triangular portions of matrices:
C
      IF(EQUAL(KEYWD,KUPPER,5)) THEN
        UPPER = .TRUE.
        GOTO 20
      END IF
C
C  Keyword OPEN -- Open shell species (alpha and beta matrices read):
C
      IF(EQUAL(KEYWD,KOPEN,4)) THEN
        OPEN = .TRUE.
        GOTO 20
      END IF
C
C  Keyword ORTHO -- Orthogonal basis set (Skip NAO analysis):
C
      IF(EQUAL(KEYWD,KORTHO,5)) THEN
        ORTHO = .TRUE.
        GOTO 20
      END IF
C
C  Keyword BOHR -- Atomic coordinates, dipole integrals in bohr:
C
      IF(EQUAL(KEYWD,KBOHR,4)) THEN
        BOHR = .TRUE.
        GOTO 20
      END IF
C
C  Keyword BODM -- Input bond order matrix:
C
      IF(EQUAL(KEYWD,KBODM,4)) THEN
        DENOP = .FALSE.
        GOTO 20
      END IF
C
C  Keyword EV -- Expectation values of the Fock operator are in eV:
C
      IF(EQUAL(KEYWD,KEV,2)) THEN
        MUNIT = 1
        GOTO 20
      END IF
C
C  Keyword CUBICF -- Use set of cubic f functions:
C
      IF(EQUAL(KEYWD,KCUBF,6)) THEN
        IWCUBF = 1
        GOTO 20
      END IF
C
C  Unknown keyword -- halt program:
C
      WRITE(LFNPR,900) KEYWD
      STOP
C
C  End of $GEN input encountered, make sure GENNBO has all info needed:
C
  700 CONTINUE
      IF(REUSE) THEN
        NEWDAF = .FALSE.
        RETURN
      ELSE
        NEWDAF = .TRUE.
      ENDIF
C
      NDIM = NBAS
      IF(NBAS.LE.0) STOP 'NBAS must be specified in $GEN keylist'
      IF(NBAS.GT.MAXBAS) STOP 'Increase parameter MAXBAS'
      IF(NATOMS.LE.0) STOP 'NATOMS must be specified in $GEN keylist'
      IF(NATOMS.GT.MAXATM) STOP 'Increase parameter MAXATM'
      RETURN
C
  900 FORMAT(1X,'Unrecognized keyword >',6A1,'<')
      END
C*****************************************************************************
      SUBROUTINE NBOINP(NBOOPT,IDONE)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL END,EQUAL
      DIMENSION NBOOPT(10)
      DIMENSION KEYWD(6),KNBO(4)
C
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      SAVE KNBO
      DATA KNBO/1H$,1HN,1HB,1HO/
C
C  If NBOOPT(1) = 1 or -1, don't search for keywords, just continue with
C  default options:
C
      IF(NBOOPT(1).EQ.1.OR.NBOOPT(1).EQ.-1) THEN
        IDONE = 0
        RETURN
      END IF
C
C  If this is the GAMESS, HONDO, or general version of the NBO program,
C  rewind the input file before searching for $NBO:
C
      IREP = 1
      IF(NBOOPT(10).EQ.0) IREP = 0
      IF(NBOOPT(10).EQ.6) IREP = 0
      IF(NBOOPT(10).EQ.7) IREP = 0
      IF(IREP.EQ.0) REWIND(LFNIN)
C
C  Search input file for $NBO:
C
   10 CALL STRTIN(LFNIN)
      LEN = 6
      CALL HFLD(KEYWD,LEN,END)
      IF(EQUAL(KEYWD,KNBO,4)) GOTO 50
      IF(LEN.EQ.0.AND.END) GOTO 60
      GOTO 10
C
C  $NBO found -- continue with the NBO analysis:
C
   50 CONTINUE
      IDONE = 0
      RETURN
C
C  End of file encountered:
C
   60 CONTINUE
C
C  Rewind and repeat search for $NBO for GAUSSIAN and AMPAC versions:
C
      IF(IREP.EQ.1) THEN
        REWIND(LFNIN)
        IREP = IREP + 1
        GOTO 10
C
C  For GENNBO, continue with default NBO options:
C
      ELSE IF(NBOOPT(10).EQ.0) THEN
        NBOOPT(1) = 1
        IDONE = 0
C
C  Otherwise, halt NBO analysis:
C
      ELSE
        IDONE = 1
        NBOOPT(10) = -NBOOPT(10)
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE CORINP(IESS,ICOR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL END,EQUAL
C
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
C
      DIMENSION KEYWD(6),KCOR(4),KCHS(4),KDEL(4),KNBO(4),KNRT(4)
C
      SAVE KCOR,KCHS,KDEL,KNBO,KNRT
      DATA KCOR/1H$,1HC,1HO,1HR/,KCHS/1H$,1HC,1HH,1HO/,
     +     KDEL/1H$,1HD,1HE,1HL/,KNBO/1H$,1HN,1HB,1HO/,
     +     KNRT/1H$,1HN,1HR,1HT/
C
C  If ICOR is set to -1, do not read in the $CORE keylist:
C
      IF(ICOR.EQ.-1) RETURN
C
C  If this is the GAMESS, HONDO, or general version of the NBO program,
C  rewind the input file before searching for $CORE:
C
      IREP = 1
      IF(IESS.EQ.0) IREP = 0
      IF(IESS.EQ.6) IREP = 0
      IF(IESS.EQ.7) IREP = 0
      IF(IREP.EQ.0) REWIND(LFNIN)
C
C  Search input file for $CORE:
C
   10 CALL STRTIN(LFNIN)
      LEN = 6
      CALL HFLD(KEYWD,LEN,END)
      IF(EQUAL(KEYWD,KCOR,4)) GOTO 50
      IF(EQUAL(KEYWD,KNBO,4)) GOTO 60
      IF(EQUAL(KEYWD,KCHS,4)) GOTO 60
      IF(EQUAL(KEYWD,KDEL,4)) GOTO 60
      IF(EQUAL(KEYWD,KNRT,4)) GOTO 60
      IF(LEN.EQ.0.AND.END) GOTO 70
      GOTO 10
C
C  $CORE found:
C
   50 CONTINUE
      ICOR = 1
      RETURN
C
C  $NBO, $CHOOSE, $DEL -- discontinue the search for $CORE (GAUSSIAN, AMPAC)
C        or $NRT          continue searching for $CORE (GENNBO, GAMESS, HONDO)
C
   60 CONTINUE
      IF(IREP.EQ.0) GOTO 10
      BACKSPACE(LFNIN)
      ICOR = 0
      RETURN
C
C  End of file encountered:
C
   70 CONTINUE
      ICOR = 0
C
C  Turn off the $CHOOSE keylist for GAUSSIAN and AMPAC to avoid reading
C  the EOF a second time:
C
      IF(IREP.EQ.1) ICHOOS = -1
      RETURN
      END
C*****************************************************************************
      SUBROUTINE CHSINP(IESS,ICHS)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL END,EQUAL
C
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION KEYWD(6),KCHS(4),KDEL(4),KNBO(4),KNRT(4)
C
      SAVE KCHS,KDEL,KNBO,KNRT
C
      DATA KCHS/1H$,1HC,1HH,1HO/,KDEL/1H$,1HD,1HE,1HL/,
     +     KNBO/1H$,1HN,1HB,1HO/,KNRT/1H$,1HN,1HR,1HT/
C
C  If ICHS is set to -1, do not search for the $CHOOSE keylist:
C
      IF(ICHS.EQ.-1) RETURN
C
C  If this is the GAMESS, HONDO, or general version of the NBO program,
C  rewind the input file before searching for $CHOOSE:
C
      IREP = 1
      IF(IESS.EQ.0) IREP = 0
      IF(IESS.EQ.6) IREP = 0
      IF(IESS.EQ.7) IREP = 0
      IF(IREP.EQ.0) REWIND(LFNIN)
C
C  Search input file for $CHOOSE:
C
   10 CALL STRTIN(LFNIN)
      LEN = 6
      CALL HFLD(KEYWD,LEN,END)
      IF(EQUAL(KEYWD,KCHS,4)) GOTO 50
      IF(EQUAL(KEYWD,KNBO,4)) GOTO 60
      IF(EQUAL(KEYWD,KDEL,4)) GOTO 60
      IF(EQUAL(KEYWD,KNRT,4)) GOTO 60
      IF(LEN.EQ.0.AND.END) GOTO 70
      GOTO 10
C
C  $CHOOSE found:
C
   50 CONTINUE
      ICHS = 1
      RETURN
C
C  $NBO, $DEL found -- discontinue the search for $CHOOSE (GAUSSIAN, AMPAC)
C      or $NRT         continue searching for $CHOOSE (GENNBO, GAMESS, HONDO)
C
   60 CONTINUE
      IF(IREP.EQ.0) GOTO 10
      BACKSPACE(LFNIN)
      ICHS = 0
      RETURN
C
C  End of file encountered:
C
   70 CONTINUE
      ICHS = 0
      RETURN
      END
C*****************************************************************************
      SUBROUTINE DELINP(NBOOPT,IDONE)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL END,EQUAL
      DIMENSION NBOOPT(10)
      DIMENSION KEYWD(6),KDEL(4),KNBO(4)
C
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      SAVE KDEL,KNBO
      DATA KDEL/1H$,1HD,1HE,1HL/,KNBO/1H$,1HN,1HB,1HO/
C
C  If this is the GAMESS, HONDO, or general version of the NBO program,
C  rewind the input file before searching for $DEL:
C
      IREP = 1
      IF(NBOOPT(10).EQ.0) IREP = 0
      IF(NBOOPT(10).EQ.6) IREP = 0
      IF(NBOOPT(10).EQ.7) IREP = 0
      IF(IREP.EQ.0) REWIND(LFNIN)
C
C  Search input file for $DEL:
C
   10 CALL STRTIN(LFNIN)
      LEN = 6
      CALL HFLD(KEYWD,LEN,END)
      IF(EQUAL(KEYWD,KDEL,4)) GOTO 50
      IF(EQUAL(KEYWD,KNBO,4)) GOTO 60
      IF(LEN.EQ.0.AND.END) GOTO 70
      GOTO 10
C
C  $DEL found -- continue with the NBO energetic analysis:
C
   50 CONTINUE
      IDONE = 0
      RETURN
C
C  $NBO found -- discontinue the search for $DEL (GAUSSIAN, AMPAC)
C                continue searching for $DEL (GENNBO, GAMESS, HONDO)
C
   60 CONTINUE
      IF(IREP.EQ.0) GOTO 10
      BACKSPACE(LFNIN)
      IDONE = 1
      RETURN
C
C  End of file encountered -- Stop NBO energetic analysis
C
   70 CONTINUE
      IF(IREP.EQ.1) THEN
        REWIND(LFNIN)
        IREP = IREP + 1
        GOTO 10
      ELSE
        IDONE = 1
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE RDCORE(JCORE)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL ERROR
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
C  Initialize the atomic core array:
C
      DO 10 I = 1,NATOMS
        IATCR(I) = -1
   10 CONTINUE
C
C  Read in modifications to the nominal core table:
C
      IF(JCORE.EQ.1) THEN
        WRITE(LFNPR,900)
   30   CALL IFLD(II,ERROR)
        IF(ERROR) GOTO 40
        IF(II.LT.1.OR.II.GT.NATOMS) GOTO 810
        CALL IFLD(JJ,ERROR)
        IF(ERROR) GOTO 820
        IF(JJ.LT.0) GOTO 830
        IATCR(II) = JJ
        GOTO 30
      END IF
   40 CONTINUE
      RETURN
C
  810 WRITE(LFNPR,910) II
      STOP
C
  820 WRITE(LFNPR,920) II
      STOP
C
  830 WRITE(LFNPR,930) JJ,II
      STOP
C
  900 FORMAT(/1X,'Modified core list read from the $CORE keylist')
  910 FORMAT(/1X,'ATOM ',I4,' not found on this molecule')
  920 FORMAT(/1X,'No core orbitals selected for atom ',I4)
  930 FORMAT(/1X,I4,' core orbitals on atom ',I4,' does not make sense')
      END
C*****************************************************************************
      SUBROUTINE WRPPNA(T,OCC,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),LSTEMT(MAXBAS),LARC(MAXBAS),LBL(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
C
      DIMENSION T(NDIM,NDIM),OCC(NDIM)
      CHARACTER*80 TITLE
C
C  Write the PNAO information to the external file ABS(IFLG):
C
C  NOTE: This is the pure-AO to PNAO transformation, not the raw AO
C        to PNAO transform.
C
      TITLE = 'PNAOs in the PAO basis:'
      CALL AOUT(T,NDIM,NBAS,NBAS,TITLE,-1,IFLG)
C
C  Write the NAO orbital labels to the external file:
C
      LFN = ABS(IFLG)
      WRITE(LFN,900) (NAOCTR(J),J=1,NBAS)
      WRITE(LFN,900) (NAOL(J),J=1,NBAS)
      WRITE(LFN,900) (LSTOCC(J),J=1,NBAS)
C
C  Write the PNAO orbital occupancies:
C
      WRITE(LFN,910) (OCC(J),J=1,NBAS)
      RETURN
C
  900 FORMAT(1X,20I4)
  910 FORMAT(1X,5F15.9)
      END
C*****************************************************************************
      SUBROUTINE RDPPNA(T,OCC,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),LSTEMT(MAXBAS),LARC(MAXBAS),LBL(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION T(NDIM,NDIM),OCC(NDIM)
      DIMENSION JOB(20)
      LOGICAL ERROR
C
C  Read the PNAO information from the external file ABS(IFLG/1000)
C
C  NOTE: This is the pure-AO to PNAO transformation, not the raw AO
C        to PNAO transform.
C
      LFN = ABS(IFLG/1000)
      WRITE(LFNPR,900)
C
      IF(ISPIN.GE.0) REWIND(LFN)
      CALL AREAD(T,NDIM,NBAS,NBAS,JOB,LFN,ERROR)
      IF(ERROR) GOTO 800
      IF(ISPIN.GE.0) WRITE(LFNPR,910) JOB
      IF(ISPIN.LT.0) WRITE(LFNPR,920)
C
C  Read in orbital labels from LFN:
C
      READ(LFN,1000,END=810) (NAOCTR(J),J=1,NBAS)
      READ(LFN,1000,END=810) (NAOL(J),J=1,NBAS)
      READ(LFN,1000,END=810) (LSTOCC(J),J=1,NBAS)
C
C  Read orbital occupancies:
C
      READ(LFN,1010,END=820) (OCC(J),J=1,NBAS)
      RETURN
C
  800 WRITE(LFNPR,950) LFN
      STOP
C
  810 WRITE(LFNPR,960) LFN
      STOP
C
  820 WRITE(LFNPR,970) LFN
      STOP
C
  900 FORMAT(/1X,'PNAO basis set from a previous calculation used:')
  910 FORMAT(1X,20A4)
  920 FORMAT(/1X,'See alpha NBO output for title of the transformation')
  950 FORMAT(/1X,'Error reading PAO to PNAO transformation from LFN',I3)
  960 FORMAT(/1X,'Error reading PNAO orbital labels from LFN',I3)
  970 FORMAT(/1X,'Error reading PNAO orbital occupancies from LFN',I3)
 1000 FORMAT(1X,20I4)
 1010 FORMAT(1X,5F15.9)
      END
C*****************************************************************************
      SUBROUTINE WRTNAO(T,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),LSTEMT(MAXBAS),LARC(MAXBAS),LBL(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
      DIMENSION T(NDIM,NDIM)
      CHARACTER*80 TITLE
C
C  NOTE: T is the PNAO overlap matrix on return to the calling routine
C
C  Fetch the AO to NAO transformation from the NBO DAF, and write
C  it to the external file ABS(IFLG):
C
      CALL FETNAO(T)
      TITLE = 'NAOs in the AO basis:'
      CALL AOUT(T,NDIM,NBAS,NBAS,TITLE,1,IFLG)
C
C  Write the NAO orbital labels to the external file:
C
      LFN = ABS(IFLG)
      WRITE(LFN,900) (NAOCTR(J),J=1,NBAS)
      WRITE(LFN,900) (NAOL(J),J=1,NBAS)
      WRITE(LFN,900) (LSTOCC(J),J=1,NBAS)
C
C  Fetch the PNAO overlap matrix from the NBO DAF, and store only the
C  upper triangular portion on the external file:
C
      CALL FESNAO(T)
      TITLE = 'PNAO overlap matrix:'
      CALL AOUT(T,NDIM,-NBAS,NBAS,TITLE,2,IFLG)
      RETURN
C
  900 FORMAT(1X,20I4)
      END
C*****************************************************************************
      SUBROUTINE RDTNAO(DM,T,SCR,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),LSTEMT(MAXBAS),LARC(MAXBAS),LBL(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION T(NDIM,NDIM),DM(NDIM,NDIM),SCR(NDIM)
      DIMENSION JOB(20)
      LOGICAL ERROR
C
C  NOTE: T is the PNAO overlap matrix on return to the calling routine
C        DM is the NAO density matrix on return
C
C  Read in AO to NAO transformation from the external file ABS(IFLG/1000),
C  and store it on the NBO DAF:
C
      LFN = ABS(IFLG/1000)
      WRITE(LFNPR,900)
C
      REWIND(LFN)
      CALL AREAD(T,NDIM,NBAS,NBAS,JOB,LFN,ERROR)
      IF(ERROR) GOTO 800
      WRITE(LFNPR,910) JOB
      CALL SVTNAO(T)
C
C  Transform the AO density matrix, presently in DM, to the NAO basis:
C
      CALL SIMTRS(DM,T,SCR,NDIM,NBAS)
C
C  Read in orbital labels from LFN:
C
      READ(LFN,1000,END=810) (NAOCTR(J),J=1,NBAS)
      READ(LFN,1000,END=810) (NAOL(J),J=1,NBAS)
      READ(LFN,1000,END=810) (LSTOCC(J),J=1,NBAS)
C
C  Read the PNAO overlap from LFN, and save this matrix on the NBO DAF:
C
      CALL AREAD(T,NDIM,-NBAS,NBAS,JOB,LFN,ERROR)
      IF(ERROR) GOTO 820
      CALL SVSNAO(T)
      RETURN
C
  800 WRITE(LFNPR,950) LFN
      STOP
C
  810 WRITE(LFNPR,960) LFN
      STOP
C
  820 WRITE(LFNPR,970) LFN
      STOP
C
  900 FORMAT(/1X,'NAO basis set from a previous calculation used:')
  910 FORMAT(1X,20A4)
  950 FORMAT(/1X,'Error reading AO to NAO transformation from LFN',I3)
  960 FORMAT(/1X,'Error reading NAO orbital labels from LFN',I3)
  970 FORMAT(/1X,'Error reading PNAO overlap matrix from LFN',I3)
 1000 FORMAT(1X,20I4)
      END
C*****************************************************************************
      SUBROUTINE WRTNAB(T,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),IATHY(MAXBAS,3)
C
      DIMENSION T(NDIM,NDIM)
      CHARACTER*80 TITLE
C
C  Write the NAO to NBO transformation and NBO info to external file
C  ABS(IFLG):
C
      TITLE = 'NBOs in the NAO basis:'
      CALL AOUT(T,NDIM,NBAS,NBAS,TITLE,2,IFLG)
C
C  Write the NBO labels:
C
      LFN = ABS(IFLG)
      DO 10 I = 1,NBAS
        WRITE(LFN,900) (LABEL(I,J),J=1,6),IBXM(I)
   10 CONTINUE
      RETURN
C
  900 FORMAT(1X,A2,A1,4I3,3X,I3)
      END
C*****************************************************************************
      SUBROUTINE RDTNAB(T,DM,BNDOCC,SCR,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),IATHY(MAXBAS,3)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION T(NDIM,NDIM),DM(NDIM,NDIM),BNDOCC(NDIM),SCR(NDIM)
      DIMENSION JOB(20)
      LOGICAL ERROR
C
C  Read the NAO to NBO transformation matrix from the external file
C  ABS(IFLG/1000).  Also read the NBO labels, the NBO occupancies,
C  and transform the input NAO density matrix to the NBO basis:
C
      LFN = ABS(IFLG/1000)
      WRITE(LFNPR,900)
C
      IF(ISPIN.GE.0) REWIND(LFN)
      CALL AREAD(T,NDIM,NBAS,NBAS,JOB,LFN,ERROR)
      IF(ERROR) GOTO 800
      IF(ISPIN.GE.0) WRITE(LFNPR,910) JOB
      IF(ISPIN.LT.0) WRITE(LFNPR,920)
C
C  Read the NBO labels:
C
      DO 10 I = 1,NBAS
        READ(LFN,1000,END=810) (LABEL(I,J),J=1,6),IBXM(I)
   10 CONTINUE
C
C  Transform the NAO density matrix, DM, to the NBO basis, and store the
C  NBO occupancies in BNDOCC:
C
      CALL SIMTRS(DM,T,SCR,NDIM,NBAS)
      DO 20 I = 1,NBAS
        BNDOCC(I) = DM(I,I)
   20 CONTINUE
      RETURN
C
  800 WRITE(LFNPR,950) LFN
      STOP
C
  810 WRITE(LFNPR,960) LFN
      STOP
C
  900 FORMAT(/1X,'NAO to NBO transformation from a previous ',
     + 'calculation will be used:')
  910 FORMAT(1X,20A4)
  920 FORMAT(/1X,'See alpha NBO output for title of the transformation')
  950 FORMAT(/1X,'Error reading NAO to NBO transformation from LFN',I3)
  960 FORMAT(/1X,'Error reading NBO orbital labels from LFN',I3)
 1000 FORMAT(1X,A2,A1,4I3,3X,I3)
      END
C*****************************************************************************
      SUBROUTINE WRTNBO(T,BNDOCC,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),LBL(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION T(NDIM,NDIM),BNDOCC(1)
      CHARACTER*80 TITLE
C
C  Write the AO to NBO transformation matrix and NBO info to the external
C  file ABS(IFLG):
C
      TITLE = 'NBOs in the AO basis:'
      CALL AOUT(T,NDIM,NBAS,NBAS,TITLE,1,IFLG)
C
C  Write out the NBO occupancies:
C
      LFN = ABS(IFLG)
      WRITE(LFN,900) (BNDOCC(J),J=1,NBAS)
C
C  Write out NBOUNI, NBOTYP, LABEL, IBXM, and IATNO:
C
      WRITE(LFN,910) (NBOUNI(J),J=1,NBAS)
      WRITE(LFN,910) (NBOTYP(J),J=1,NBAS)
      WRITE(LFN,920) (LABEL(J,1),J=1,NBAS)
      WRITE(LFN,920) (LABEL(J,2),J=1,NBAS)
      WRITE(LFN,910) (LABEL(J,3),J=1,NBAS)
      WRITE(LFN,910) (LABEL(J,4),J=1,NBAS)
      WRITE(LFN,910) (LABEL(J,5),J=1,NBAS)
      WRITE(LFN,910) (LABEL(J,6),J=1,NBAS)
      WRITE(LFN,910) (IBXM(J),J=1,NBAS)
      WRITE(LFN,910) (IATNO(J),J=1,NATOMS)
      RETURN
C
  900 FORMAT(1X,5F15.9)
  910 FORMAT(1X,20I3)
  920 FORMAT(1X,20A3)
      END
C*****************************************************************************
      SUBROUTINE WRNLMO(T,DM,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),LBL(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION T(NDIM,NDIM),DM(NDIM,NDIM)
      CHARACTER*80 TITLE
C
C  Write the AO to NLMO transformation matrix and NLMO info to the external
C  file ABS(IFLG):
C
      TITLE = 'NLMOs in the AO basis:'
      CALL AOUT(T,NDIM,NBAS,NBAS,TITLE,1,IFLG)
C
C  Write out the NLMO occupancies:
C
      LFN = ABS(IFLG)
      WRITE(LFN,900) (DM(J,J),J=1,NBAS)
C
C  Write out NBOUNI, NBOTYP, LABEL, IBXM, and IATNO:
C
      WRITE(LFN,910) (NBOUNI(J),J=1,NBAS)
      WRITE(LFN,910) (NBOTYP(J),J=1,NBAS)
      WRITE(LFN,920) (LABEL(J,1),J=1,NBAS)
      WRITE(LFN,920) (LABEL(J,2),J=1,NBAS)
      WRITE(LFN,910) (LABEL(J,3),J=1,NBAS)
      WRITE(LFN,910) (LABEL(J,4),J=1,NBAS)
      WRITE(LFN,910) (LABEL(J,5),J=1,NBAS)
      WRITE(LFN,910) (LABEL(J,6),J=1,NBAS)
      WRITE(LFN,910) (IBXM(J),J=1,NBAS)
      WRITE(LFN,910) (IATNO(J),J=1,NATOMS)
      RETURN
C
  900 FORMAT(1X,5F15.9)
  910 FORMAT(1X,20I3)
  920 FORMAT(1X,20A3)
      END
C*****************************************************************************
      SUBROUTINE WRBAS(SCR,ISCR,LFN)
C*****************************************************************************
C
C  Save the AO basis set information on an external file:
C
C-----------------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBAO/LCTR(MAXBAS),LANG(MAXBAS)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION SCR(1),ISCR(1)
C
C  Fetch the number of shells NSHELL, the number of exponents NEXP,
C  the NCOMP, NPRIM, and NPTR arrays, and the orbital exponents and
C  coefficients from the NBO DAF:
C
      CALL FEBAS(NSHELL,NEXP,ISCR)
C
C  If NSHELL is zero, then no basis set info has been stored in the
C  DAF:
C
      IF(NSHELL.EQ.0) THEN
        WRITE(LFNPR,900)
        RETURN
      END IF
C
C  Partition the scratch arrays:  (Note that SCR and ISCR occupy the same
C  space in memory)
C
C  ISCR: (integer)
C
C   NSHELL  NEXP   NCOMP   NPRIM   NPTR
C  +------+------+-------+-------+-------+-----------------------------------
C                I1      I2      I3
C
C  SCR: (real)
C                                                                     ATCOOR
C                                           EXP   CS   CP   CD   CF   TITLE
C  ---------------------------------------+-----+----+----+----+----+--------
C                                         I4    I5   I6   I7   I8   I9
C
C  ISCR(I1) : NCOMP(1..NSHELL)
C  ISCR(I2) : NPRIM(1..NSHELL)
C  ISCR(I3) : NPTR(1..NSHELL)
C  SCR(I4)  : EXP(1..NEXP)
C  SCR(I5)  : CS(1..NEXP)
C  SCR(I6)  : CP(1..NEXP)
C  SCR(I7)  : CD(1..NEXP)
C  SCR(I8)  : CF(1..NEXP)
C  SCR(I9)  : TITLE(10) or ATCOOR(3*NATOMS)
C
      I1   = 3
      I2   = I1 + NSHELL
      I3   = I2 + NSHELL
      I4   = I3 + NSHELL
      I5   = I4 + NEXP
      I6   = I5 + NEXP
      I7   = I6 + NEXP
      I8   = I7 + NEXP
      I9   = I8 + NEXP
C     IEND = I9 + MAX0(3*NATOMS,10)
C
C  Fetch job title and write it to the AOINFO external file:
C
      CALL FETITL(SCR(I9))
C
C  Begin writing to the AOINFO external file:
C
      WRITE(LFN,910) (SCR(I9+I),I=0,9)
      WRITE(LFN,920) NATOMS,NSHELL,NEXP
C
C  Fetch the atomic coordinates:
C
      CALL FECOOR(SCR(I9))
C
C  Write atomic numbers and coordinates to external file:
C
      J = 0
      DO 10 I = 1,NATOMS
        WRITE(LFN,930) IATNO(I),(SCR(I9+J+K),K=0,2)
        J = J + 3
   10 CONTINUE
      WRITE(LFN,940)
C
C  Write out information about each shell in the basis set:
C
C     NCTR(I)  --  atomic center of the Ith shell
C
C     NCOMP(I) --  number of components in the Ith shell
C
C     NPTR(I)  --  pointer for the Ith shell into the primitive parameters
C                  of EXP, CS, CP, CD, and CF
C
C     NPRIM(I) --  number of primitive functions in the Ith shell
C
C     LABEL(1..NCOMP(I)) -- symmetry labels for the orbitals of this shell
C
      J1 = 1
      J2 = I1
      J3 = I3
      J4 = I2
      DO 20 I = 1,NSHELL
        NCOMP = ISCR(J2)
        NPRIM = ISCR(J3)
        NPTR  = ISCR(J4)
        WRITE(LFN,950) LCTR(J1),NCOMP,NPRIM,NPTR
        WRITE(LFN,950) ((LANG(J1+J)),J=0,NCOMP-1)
        J1 = J1 + NCOMP
        J2 = J2 + 1
        J3 = J3 + 1
        J4 = J4 + 1
   20 CONTINUE
      WRITE(LFN,940)
C
C  Write out the primitive parameters:
C
      WRITE(LFN,960) (SCR(I4+I),I=0,NEXP-1)
      WRITE(LFN,970)
      WRITE(LFN,960) (SCR(I5+I),I=0,NEXP-1)
      WRITE(LFN,970)
      WRITE(LFN,960) (SCR(I6+I),I=0,NEXP-1)
      WRITE(LFN,970)
      WRITE(LFN,960) (SCR(I7+I),I=0,NEXP-1)
      WRITE(LFN,970)
      WRITE(LFN,960) (SCR(I8+I),I=0,NEXP-1)
      RETURN
C
  900 FORMAT(/1X,'No basis set information is stored on the NBO direct',
     + ' access file.',/1X,'Thus, no `AOINFO'' file can be written.')
  910 FORMAT(1X,9A8,A7,/1X,'Basis set information needed for plotting ',
     + 'orbitals',/1X,75('-'))
  920 FORMAT(1X,3I6,/1X,75('-'))
  930 FORMAT(1X,I4,3(2X,F12.9))
  940 FORMAT(1X,75('-'))
  950 FORMAT(1X,10I6)
  960 FORMAT(2X,4E18.9)
  970 FORMAT(1X)
      END
C*****************************************************************************
      SUBROUTINE WRARC(SCR,ISCR,LFN)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER (MAXD = 4)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBAO/LCTR(MAXBAS),LANG(MAXBAS)
C
      DIMENSION SCR(1),ISCR(1),IK(MAXD)
      DIMENSION KGEN(7),KNAT(6),KBAS(4),KOPEN(4),KORTHO(5),KUPPER(5),
     + KBODM(4),KEV(2),KCUBF(6),KEND(4),KCAL(4)
C
      SAVE KGEN,KBAS,KNAT,KOPEN,KORTHO,KUPPER,KBODM,KEV,KEND,KCUBF,KCAL,
     +  KBLNK,KEQ,ABLNKS,ACENTR,ALABEL,ANSHLL,ANEXP,ANCOMP,ANPRIM,
     +  ANPTR,AEXP,ACS,ACP,ACD,ACF,ZERO
C
      DATA KGEN/1H$,1HG,1HE,1HN,1HN,1HB,1HO/,KBAS/1HN,1HB,1HA,1HS/,
     +     KNAT/1HN,1HA,1HT,1HO,1HM,1HS/,KOPEN/1HO,1HP,1HE,1HN/,
     +     KORTHO/1HO,1HR,1HT,1HH,1HO/,KUPPER/1HU,1HP,1HP,1HE,1HR/,
     +     KBODM/1HB,1HO,1HD,1HM/,KEV/1HE,1HV/,KEND/1H$,1HE,1HN,1HD/,
     +     KCUBF/1HC,1HU,1HB,1HI,1HC,1HF/,KCAL/1HK,1HC,1HA,1HL/
      DATA KBLNK,KEQ/1H ,1H=/
      DATA ABLNKS,ACENTR,ALABEL/8H        ,8HCENTER =,8H LABEL =/
      DATA ANSHLL,ANEXP ,ANCOMP/8HNSHELL =,8H  NEXP =,8H NCOMP =/
      DATA ANPRIM,ANPTR ,AEXP  /8H NPRIM =,8H  NPTR =,8H   EXP =/
      DATA ACS,ACP,ACD,ACF/8H    CS =,8H    CP =,8H    CD =,8H    CF =/
      DATA ZERO/0.0D0/
C
C  Write the ARCHIVE file to LFN:
C
C  This routine has been written assuming NBAS = NDIM.  Skip if
C  this condition is not satisfied:
C
      IF(NBAS.NE.NDIM) THEN
        WRITE(LFNPR,890)
        RETURN
      END IF
C
C  Form the $GENNBO keylist in ISCR:
C
      NC = 0
      DO 10 I = 1,7
        NC = NC + 1
        ISCR(NC) = KGEN(I)
   10 CONTINUE
      NC = NC + 1
      ISCR(NC) = KBLNK
      NC = NC + 1
      ISCR(NC) = KBLNK
C
C  Add the number of atoms and basis functions:
C
      DO 20 I = 1,6
        NC = NC + 1
        ISCR(NC) = KNAT(I)
   20 CONTINUE
      NC = NC + 1
      ISCR(NC) = KEQ
      CALL IDIGIT(NATOMS,IK,ND,MAXD)
      DO 30 I = 1,ND
        NC = NC + 1
        ISCR(NC) = IK(I)
   30 CONTINUE
      NC = NC + 1
      ISCR(NC) = KBLNK
      NC = NC + 1
      ISCR(NC) = KBLNK
C
      DO 40 I = 1,4
        NC = NC + 1
        ISCR(NC) = KBAS(I)
   40 CONTINUE
      NC = NC + 1
      ISCR(NC) = KEQ
      CALL IDIGIT(NBAS,IK,ND,MAXD)
      DO 50 I = 1,ND
        NC = NC + 1
        ISCR(NC) = IK(I)
   50 CONTINUE
      NC = NC + 1
      ISCR(NC) = KBLNK
      NC = NC + 1
      ISCR(NC) = KBLNK
C
C  If OPEN shell, add the OPEN keyword:
C
      IF(OPEN) THEN
        DO 60 I = 1,4
          NC = NC + 1
          ISCR(NC) = KOPEN(I)
   60   CONTINUE
        NC = NC + 1
        ISCR(NC) = KBLNK
        NC = NC + 1
        ISCR(NC) = KBLNK
      END IF
C
C  If the AO basis is orthogonal, add the ORTHO keyword:
C
      IF(ORTHO) THEN
        DO 70 I = 1,5
          NC = NC + 1
          ISCR(NC) = KORTHO(I)
   70   CONTINUE
        NC = NC + 1
        ISCR(NC) = KBLNK
        NC = NC + 1
        ISCR(NC) = KBLNK
      END IF
C
C  Only UPPER triangular portions of symmetric matrices will be given:
C
      DO 80 I = 1,5
        NC = NC + 1
        ISCR(NC) = KUPPER(I)
   80 CONTINUE
      NC = NC + 1
      ISCR(NC) = KBLNK
      NC = NC + 1
      ISCR(NC) = KBLNK
C
C  Enter the bond-order matrix, BODM, if possible:
C
      IF(IWDM.EQ.1) THEN
        DO 90 I = 1,4
          NC = NC + 1
          ISCR(NC) = KBODM(I)
   90   CONTINUE
        NC = NC + 1
        ISCR(NC) = KBLNK
        NC = NC + 1
        ISCR(NC) = KBLNK
      END IF
C
C  Add EV if the energy units are in electron volts:
C
      IF(MUNIT.EQ.1) THEN
        NC = NC + 1
        ISCR(NC) = KEV(1)
        NC = NC + 1
        ISCR(NC) = KEV(2)
        NC = NC + 1
        ISCR(NC) = KBLNK
        NC = NC + 1
        ISCR(NC) = KBLNK
      END IF
C
C  Add KCAL if the energy units are in kcal/mol:
C
      IF(MUNIT.EQ.1) THEN
        NC = NC + 1
        ISCR(NC) = KCAL(1)
        NC = NC + 1
        ISCR(NC) = KCAL(2)
        NC = NC + 1
        ISCR(NC) = KCAL(3)
        NC = NC + 1
        ISCR(NC) = KCAL(4)
        NC = NC + 1
        ISCR(NC) = KBLNK
        NC = NC + 1
        ISCR(NC) = KBLNK
      END IF
C
C  Add CUBICF if these types of orbitals are being used:
C
      IF(IWCUBF.NE.0) THEN
        DO 100 I = 1,6
          NC = NC + 1
          ISCR(NC) = KCUBF(I)
  100   CONTINUE
        NC = NC + 1
        ISCR(NC) = KBLNK
        NC = NC + 1
        ISCR(NC) = KBLNK
      END IF
C
C  Add $END:
C
      DO 110 I = 1,4
        NC = NC + 1
        ISCR(NC) = KEND(I)
  110 CONTINUE
C
C  Write the $GENNBO keylist to the archive file:
C
      WRITE(LFN,900) (ISCR(I),I=1,NC)
C
C  Write the $NBO keylist to the archive file:
C
      WRITE(LFN,910)
C
C  Write the $COORD data list to the archive file:
C
      WRITE(LFN,920)
      CALL FETITL(SCR)
      WRITE(LFN,930) (SCR(I),I=1,10)
      CALL FECOOR(SCR)
      J = 1
      DO 120 I = 1,NATOMS
        WRITE(LFN,940) IATNO(I),IZNUC(I),SCR(J),SCR(J+1),SCR(J+2)
        J = J + 3
  120 CONTINUE
      WRITE(LFN,950)
C
C  Write the $BASIS datalist to the archive file (info from /NBAO/):
C
      WRITE(LFN,960)
      NINT = 17
      STR = ACENTR
      DO 130 I = 1,(NBAS-1)/NINT+1
        NL  = (I - 1) * NINT + 1
        NU  = MIN0(NL+NINT-1,NBAS)
        WRITE(LFN,970) STR,(LCTR(J),J=NL,NU)
        STR = ABLNKS
  130 CONTINUE
      STR = ALABEL
      DO 140 I = 1,(NBAS-1)/NINT+1
        NL  = (I - 1) * NINT + 1
        NU  = MIN0(NL+NINT-1,NBAS)
        WRITE(LFN,970) STR,(LANG(J),J=NL,NU)
        STR = ABLNKS
  140 CONTINUE
      WRITE(LFN,950)
C
C  Write the $CONTRACT datalist to the archive file:
C
C  Fetch the basis set info from the NBO DAF:
C
      CALL FEBAS(NSHELL,NEXP,ISCR)
C
C  Partition the scratch vector:
C
C  ISCR(I1) : NCOMP(1..NSHELL)
C  ISCR(I2) : NPRIM(1..NSHELL)
C  ISCR(I3) : NPTR(1..NSHELL)
C  SCR(I4)  : EXP(1..NEXP)
C  SCR(I5)  : CS(1..NEXP)
C  SCR(I6)  : CP(1..NEXP)
C  SCR(I7)  : CD(1..NEXP)
C  SCR(I8)  : CF(1..NEXP)
C
      I1   = 3
      I2   = I1 + NSHELL
      I3   = I2 + NSHELL
      I4   = I3 + NSHELL
      I5   = I4 + NEXP
      I6   = I5 + NEXP
      I7   = I6 + NEXP
      I8   = I7 + NEXP
C     IEND = I8 + NEXP
C
C  If NSHELL is zero, then no basis set info was ever stored on
C  the DAF:
C
      IF(NSHELL.GT.0) THEN
C
C  Write out numbers of shells and orbital exponents:
C
        WRITE(LFN,980)
        WRITE(LFN,970) ANSHLL,NSHELL
        WRITE(LFN,970) ANEXP,NEXP
C
C  Write out the number of components in each shell:
C
        NINT = 17
        STR = ANCOMP
        DO 150 I = 1,(NSHELL-1)/NINT+1
          NL  = (I - 1) * NINT + 1
          NU  = MIN0(NL+NINT-1,NSHELL)
          WRITE(LFN,970) STR,(ISCR(J),J=I1+NL-1,I1+NU-1)
          STR = ABLNKS
  150   CONTINUE
C
C  Write out the number of primitives in each shell:
C
        STR = ANPRIM
        DO 160 I = 1,(NSHELL-1)/NINT+1
          NL  = (I - 1) * NINT + 1
          NU  = MIN0(NL+NINT-1,NSHELL)
          WRITE(LFN,970) STR,(ISCR(J),J=I2+NL-1,I2+NU-1)
          STR = ABLNKS
  160   CONTINUE
C
C  Write out pointer array which maps orbital exponents and coefficients
C  onto each shell:
C
        STR = ANPTR
        DO 170 I = 1,(NSHELL-1)/NINT+1
          NL  = (I - 1) * NINT + 1
          NU  = MIN0(NL+NINT-1,NSHELL)
          WRITE(LFN,970) STR,(ISCR(J),J=I3+NL-1,I3+NU-1)
          STR = ABLNKS
  170   CONTINUE
C
C  Write out orbital exponents:
C
        NREAL = 4
        STR   = AEXP
        DO 180 I = 1,(NEXP-1)/NREAL+1
          NL  = (I - 1) * NREAL + 1
          NU  = MIN0(NL+NREAL-1,NEXP)
          WRITE(LFN,990) STR,(SCR(J),J=I4+NL-1,I4+NU-1)
          STR = ABLNKS
  180   CONTINUE
C
C  Write out the orbital coefficients for each angular symmetry type
C  unless there are no basis functions of that type:
C
        DO 210 I = 1,4
          IF(I.EQ.1) THEN
            STR = ACS
            II  = I5
          ELSE IF(I.EQ.2) THEN
            STR = ACP
            II  = I6
          ELSE IF(I.EQ.3) THEN
            STR = ACD
            II  = I7
          ELSE IF(I.EQ.4) THEN
            STR = ACF
            II  = I8
          END IF
          IFLG = 0
          DO 190 J = II,II+NEXP-1
            IF(SCR(J).NE.ZERO) IFLG = 1
  190     CONTINUE
          IF(IFLG.EQ.1) THEN
            DO 200 J = 1,(NEXP-1)/NREAL+1
              NL  = (J - 1) * NREAL + 1
              NU  = MIN0(NL+NREAL-1,NEXP)
              WRITE(LFN,990) STR,(SCR(K),K=II+NL-1,II+NU-1)
              STR = ABLNKS
  200       CONTINUE
          END IF
  210   CONTINUE
        WRITE(LFN,950)
      END IF
C
C  Write the $OVERLAP datalist unless the AO basis is orthogonal:
C
      L2 = NDIM * (NDIM + 1) / 2
      IF(.NOT.ORTHO) THEN
        WRITE(LFN,1000)
        CALL FESRAW(SCR)
        L2 = NDIM * (NDIM + 1) / 2
        CALL PACK(SCR,NDIM,NBAS,L2)
        WRITE(LFN,1010) (SCR(I),I=1,L2)
        WRITE(LFN,950)
      END IF
C
C  Write the $DENSITY datalist:
C
      WRITE(LFN,1020)
      IF(OPEN) THEN
        ALPHA = .TRUE.
        BETA  = .FALSE.
        CALL FEDRAW(SCR,SCR)
        CALL PACK(SCR,NDIM,NBAS,L2)
        WRITE(LFN,1010) (SCR(I),I=1,L2)
        ALPHA = .FALSE.
        BETA  = .TRUE.
        CALL FEDRAW(SCR,SCR)
        CALL PACK(SCR,NDIM,NBAS,L2)
        WRITE(LFN,1010) (SCR(I),I=1,L2)
      ELSE
        ALPHA = .FALSE.
        BETA  = .FALSE.
        CALL FEDRAW(SCR,SCR)
        CALL PACK(SCR,NDIM,NBAS,L2)
        WRITE(LFN,1010) (SCR(I),I=1,L2)
      END IF
      WRITE(LFN,950)
C
C  Write the $FOCK datalist:
C
      IF(OPEN) THEN
        ALPHA = .TRUE.
        BETA  = .FALSE.
        IWFOCK = 1
        CALL FEFAO(SCR,IWFOCK)
        IF(IWFOCK.NE.0) THEN
          WRITE(LFN,1030)
          CALL PACK(SCR,NDIM,NBAS,L2)
          WRITE(LFN,1010) (SCR(I),I=1,L2)
          ALPHA = .FALSE.
          BETA  = .TRUE.
          CALL FEFAO(SCR,IWFOCK)
          CALL PACK(SCR,NDIM,NBAS,L2)
          WRITE(LFN,1010) (SCR(I),I=1,L2)
          WRITE(LFN,950)
        END IF
      ELSE
        ALPHA = .FALSE.
        BETA  = .FALSE.
        IWFOCK = 1
        CALL FEFAO(SCR,IWFOCK)
        IF(IWFOCK.NE.0) THEN
          WRITE(LFN,1030)
          CALL PACK(SCR,NDIM,NBAS,L2)
          WRITE(LFN,1010) (SCR(I),I=1,L2)
          WRITE(LFN,950)
        END IF
      END IF
C
C  Write the $LCAOMO datalist:
C
      IF(OPEN) THEN
        ALPHA = .TRUE.
        BETA  = .FALSE.
        CALL FEAOMO(SCR,IAOMO)
        IF(IAOMO.EQ.1) THEN
          WRITE(LFN,1040)
          WRITE(LFN,1010) (SCR(I),I=1,NDIM*NDIM)
          ALPHA = .FALSE.
          BETA  = .TRUE.
          CALL FEAOMO(SCR,IAOMO)
          WRITE(LFN,1010) (SCR(I),I=1,NDIM*NDIM)
          WRITE(LFN,950)
        END IF
      ELSE
        ALPHA = .FALSE.
        BETA  = .FALSE.
        CALL FEAOMO(SCR,IAOMO)
        IF(IAOMO.EQ.1) THEN
          WRITE(LFN,1040)
          WRITE(LFN,1010) (SCR(I),I=1,NDIM*NDIM)
          WRITE(LFN,950)
        END IF
      END IF
C
C  Write the $DIPOLE datalist:
C
      IDIP = 1
      CALL FEDXYZ(SCR,IDIP)
      IF(IDIP.NE.0) THEN
        WRITE(LFN,1050)
        CALL PACK(SCR,NDIM,NBAS,L2)
        WRITE(LFN,1010) (SCR(I),I=1,L2)
        IDIP = 2
        CALL FEDXYZ(SCR,IDIP)
        CALL PACK(SCR,NDIM,NBAS,L2)
        WRITE(LFN,1010) (SCR(I),I=1,L2)
        IDIP = 3
        CALL FEDXYZ(SCR,IDIP)
        CALL PACK(SCR,NDIM,NBAS,L2)
        WRITE(LFN,1010) (SCR(I),I=1,L2)
        WRITE(LFN,950)
      END IF
C
C  Reset logicals ALPHA and BETA:
C
      ALPHA = ISPIN.EQ.2
      BETA  = ISPIN.EQ.-2
      RETURN
C
  890 FORMAT(/1X,'The routine which writes the ARCHIVE file assumes ',
     + 'NBAS = NDIM.  Since',/1X,'this condition is not satisfied, ',
     + 'the ARCHIVE file will not be written.')
  900 FORMAT(1X,78A1)
  910 FORMAT(1X,'$NBO  $END')
  920 FORMAT(1X,'$COORD')
  930 FORMAT(1X,9A8,A6)
  940 FORMAT(1X,2I5,3F15.6)
  950 FORMAT(1X,'$END')
  960 FORMAT(1X,'$BASIS')
  970 FORMAT(1X,1X,A8,1X,17(I3,1X))
  980 FORMAT(1X,'$CONTRACT')
  990 FORMAT(1X,1X,A8,1X,4(E15.7,1X))
 1000 FORMAT(1X,'$OVERLAP')
 1010 FORMAT(1X,1X,5E15.7)
 1020 FORMAT(1X,'$DENSITY')
 1030 FORMAT(1X,'$FOCK')
 1040 FORMAT(1X,'$LCAOMO')
 1050 FORMAT(1X,'$DIPOLE')
      END
C*****************************************************************************
      SUBROUTINE AOUT(A,MR,NR,NC,TITLE,INDEX,IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(MR,1)
      CHARACTER*80 TITLE
      DIMENSION ISHELL(4)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBLBL/NLEW,NVAL,LBL(10,MAXBAS,4)
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
C
      SAVE KFULL,KVAL,KLEW
      DATA KFULL,KVAL,KLEW/4HFULL,3HVAL,3HLEW/
C
C  Either write A to an external file, or print it in the output file:
C
C  Input:  A     -- matrix to be printed or written out
C
C          MR    -- row dimension of matrix A in calling routine
C
C          NR    -- ABS(NR) is the actual number of rows to be output
C                   [if NR is negative, IFLG is negative (write), and
C                    ABS(NR).EQ.NC (square matrix), only the upper
C                    triangular portion is written out]
C
C          NC    -- actual number of columns in matrix A
C                   [used to determine if A is square, and as an upper
C                    limit on IFLG]
C
C          TITLE -- CHARACTER*80 variable containing a matrix title
C
C          INDEX -- Index selecting appropriate output labels
C                   0 : Atom labels
C                   1 : AO   labels
C                   2 : NAO  labels
C                   3 : NHO  labels
C                   4 : NBO  labels
C                   5 : NLMO labels
C
C          IFLG  -- print/write flag
C                   negative : write to LFN ABS(IFLG)
C                   positive : print IFLG columns of A
C                   'FULL'   : print the full matrix
C                   'VAL'    : print N columns of A, where N is the
C                              number of core + valence orbitals and
C                              is determined by this routine
C                   'LEW'    : print N columns of A, where N is the
C                              number of occupied orbitals and is
C                              determined by this routine
C
      JFLG = IFLG
      IF(JFLG.EQ.0) RETURN
C
C  If JFLG is FULL, then output the total number of columns:
C
      IF(JFLG.EQ.KFULL) JFLG = ABS(NC)
C
C  If JFLG = VAL, output only the valence orbitals, determined from the
C  core and valence tables:
C
      IF(JFLG.EQ.KVAL) THEN
        IF(NVAL.LT.0) THEN
          IECP = 0
          JFLG = 0
          DO 30 IAT = 1,NATOMS
            CALL CORTBL(IAT,ISHELL,IECP)
            DO 10 I = 1,4
              MULT = 2 * (I-1) + 1
              JFLG = JFLG + ISHELL(I)*MULT
   10       CONTINUE
            CALL VALTBL(IAT,ISHELL)
            DO 20 I = 1,4
              MULT = 2 * (I-1) + 1
              JFLG = JFLG + ISHELL(I)*MULT
   20       CONTINUE
   30     CONTINUE
        ELSE
          JFLG = NVAL
        END IF
      END IF
C
C  If JFLG is LEW, only output the occupied orbitals:
C
      IF(JFLG.EQ.KLEW) JFLG = NLEW
C
C  If JFLG is positive, print the matrix A in the output file:
C
      IF(JFLG.GT.0) CALL APRINT(A,MR,NR,NC,TITLE,INDEX,JFLG)
C
C  If JFLG is negative but greater than -1000, write matrix A to the external
C  file ABS(JFLG):
C
      IF(JFLG.LT.0.AND.JFLG.GT.-1000) CALL AWRITE(A,MR,NR,NC,TITLE,JFLG)
C
      RETURN
      END
C*****************************************************************************
      SUBROUTINE APRINT(A,MR,NR,NC,TITLE,INDEX,MCOL)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(MR,1)
      CHARACTER*80 TITLE
      DIMENSION BASIS(5)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBLBL/NLEW,NVAL,LBL(10,MAXBAS,4)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      SAVE BASIS,ATOM,DASHES,TENTH
      DATA BASIS/4H AO ,4H NAO,4H NHO,4H NBO,4HNLMO/
      DATA ATOM,DASHES/4HAtom,8H--------/
      DATA TENTH/0.1D0/
C
C  Determine the number of columns of matrix A to print in the output file:
C
      NCOL = MCOL
      IF(NCOL.GT.ABS(NC)) NCOL = ABS(NC)
C
      NN = ABS(NR)
      ILABEL = INDEX
      IF(ILABEL.EQ.5) ILABEL = 4
C
      TMAX = ABS(A(1,1))
      DO 20 J = 1,NCOL
        DO 10 I = 1,NN
          IF(ABS(A(I,J)).GT.TMAX) TMAX = ABS(A(I,J))
   10   CONTINUE
   20 CONTINUE
      IF(TMAX.LT.TENTH) THEN
        ND = 1
      ELSE
        ND = INT(LOG10(TMAX)) + 1
      END IF
C
C  Print the matrix title:
C
      WRITE(LFNPR,1000) TITLE(1:78)
C
C  Print the matrix A: (basis function labels)
C
      IF(ILABEL.GE.1.AND.ILABEL.LE.4) THEN
        MAXCOL = MIN(10-ND,8)
        IF(MAXCOL.LT.6) THEN
          CALL ALTOUT(A,MR,NCOL,NN,NCOL)
        ELSE
          NCL = 1
          NCU = MAXCOL
          NLOOPS = (NCOL - 1) / MAXCOL + 1
          DO 60 L = 1,NLOOPS
            IF(NCU.GT.NCOL) NCU = NCOL
            IF(MAXCOL.EQ.8) THEN
              WRITE(LFNPR,900) BASIS(INDEX),(J,J=NCL,NCU)
              WRITE(LFNPR,910) (DASHES,J=NCL,NCU)
              DO 30 I = 1,NN
                WRITE(LFNPR,920) I,(LBL(J,I,ILABEL),J=1,10),
     +                           (A(I,K),K=NCL,NCU)
   30         CONTINUE
            ELSE IF(MAXCOL.EQ.7) THEN
              WRITE(LFNPR,901) BASIS(INDEX),(J,J=NCL,NCU)
              WRITE(LFNPR,911) (DASHES,J=NCL,NCU)
              DO 40 I = 1,NN
                WRITE(LFNPR,921) I,(LBL(J,I,ILABEL),J=1,10),
     +                           (A(I,K),K=NCL,NCU)
   40         CONTINUE
            ELSE
              WRITE(LFNPR,902) BASIS(INDEX),(J,J=NCL,NCU)
              WRITE(LFNPR,912) (DASHES,DASHES,J=NCL,NCU)
              DO 50 I = 1,NN
                WRITE(LFNPR,922) I,(LBL(J,I,ILABEL),J=1,10),
     +                           (A(I,K),K=NCL,NCU)
   50         CONTINUE
            END IF
            NCL = NCU + 1
            NCU = NCU + MAXCOL
   60     CONTINUE
        END IF
C
C  Print the matrix A: (atom labels)
C
      ELSE IF(ILABEL.EQ.0) THEN
        MAXCOL = MIN(10-ND,9)
        IF(MAXCOL.LT.7) THEN
          CALL ALTOUT(A,MR,NCOL,N,NCOL)
        ELSE
          NCL = 1
          NCU = MAXCOL
          NLOOPS = (NCOL - 1) / MAXCOL + 1
          DO 160 L = 1,NLOOPS
            IF(NCU.GT.NCOL) NCU = NCOL
            IF(MAXCOL.EQ.9) THEN
              WRITE(LFNPR,1900) ATOM,(J,J=NCL,NCU)
              WRITE(LFNPR,1910) (DASHES,J=NCL,NCU)
              DO 130 I = 1,NN
                WRITE(LFNPR,1920) I,NAMEAT(IATNO(I)),
     +                            (A(I,K),K=NCL,NCU)
  130         CONTINUE
            ELSE IF(MAXCOL.EQ.8) THEN
              WRITE(LFNPR,1901) ATOM,(J,J=NCL,NCU)
              WRITE(LFNPR,1911) (DASHES,J=NCL,NCU)
              DO 140 I = 1,NN
                WRITE(LFNPR,1921) I,NAMEAT(IATNO(I)),
     +                            (A(I,K),K=NCL,NCU)
  140         CONTINUE
            ELSE
              WRITE(LFNPR,1902) ATOM,(J,J=NCL,NCU)
              WRITE(LFNPR,1912) (DASHES,J=NCL,NCU)
              DO 150 I = 1,NN
                WRITE(LFNPR,1922) I,NAMEAT(IATNO(I)),
     +                            (A(I,K),K=NCL,NCU)
  150         CONTINUE
            END IF
            NCL = NCU + 1
            NCU = NCU + MAXCOL
  160     CONTINUE
        END IF
C
C  Print the matrix A: (no labels)
C
      ELSE
        CALL ALTOUT(A,MR,NCOL,NN,NCOL)
      END IF
      RETURN
C
  900 FORMAT(/9X,A4,3X,8(3X,I3,2X))
  901 FORMAT(/9X,A4,3X,7(4X,I3,2X))
  902 FORMAT(/9X,A4,3X,6(4X,I3,3X))
  910 FORMAT(6X,'----------',8(1X,A7))
  911 FORMAT(6X,'----------',7(1X,A8))
  912 FORMAT(6X,'----------',6(1X,A8,A1))
  920 FORMAT(1X,I3,'. ',10A1,8F8.4)
  921 FORMAT(1X,I3,'. ',10A1,7F9.4)
  922 FORMAT(1X,I3,'. ',10A1,6F10.4)
 1000 FORMAT(//1X,A78)
 1900 FORMAT(/5X,A4,9(2X,I3,3X))
 1901 FORMAT(/5X,A4,8(3X,I3,3X))
 1902 FORMAT(/5X,A4,7(3X,I3,4X))
 1910 FORMAT(5X,'----',1X,9(A6,2X))
 1911 FORMAT(5X,'----',1X,8(A7,2X))
 1912 FORMAT(5X,'----',1X,7(A8,2X))
 1920 FORMAT(1X,I3,'. ',A2,9F8.4)
 1921 FORMAT(1X,I3,'. ',A2,8F9.4)
 1922 FORMAT(1X,I3,'. ',A2,7F10.4)
      END
C*****************************************************************************
      SUBROUTINE AWRITE(A,MR,NR,NC,TITLE,LFN)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(MR,1)
      CHARACTER*80 TITLE
      DIMENSION XJOB(10)
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
C  Write the matrix A to the external file ABS(LFN).  Include job title,
C  matrix title, and specify the spin in needed:
C
      LFNOUT = ABS(LFN)
      IF(LFNOUT.EQ.LFNPR) WRITE(LFNOUT,890)
      IF(ALPHA.OR..NOT.OPEN.OR.LFNOUT.EQ.LFNPR) THEN
        CALL FETITL(XJOB)
        WRITE(LFNOUT,900) XJOB
        WRITE(LFNOUT,910) TITLE(1:79)
      END IF
      IF(ALPHA) WRITE(LFNOUT,920)
      IF(BETA)  WRITE(LFNOUT,930)
C
C  If this is a square matrix and NR is negative, only write the upper
C  triangular portion.  Otherwise, write out the full matrix:
C
      IF(ABS(NR).EQ.ABS(NC).AND.NR.LT.0) THEN
        WRITE(LFNOUT,1000) ((A(I,J),I=1,J),J=1,ABS(NR))
      ELSE
        DO 10 J = 1,ABS(NC)
          WRITE(LFNOUT,1000) (A(I,J),I=1,ABS(NR))
   10   CONTINUE
      END IF
      RETURN
C
  890 FORMAT(/1X)
  900 FORMAT(1X,9A8,A7)
  910 FORMAT(1X,A79,/1X,79('-'))
  920 FORMAT(1X,'ALPHA SPIN')
  930 FORMAT(1X,'BETA  SPIN')
 1000 FORMAT(1X,5F15.9)
      END
C*****************************************************************************
      SUBROUTINE AREAD(A,MR,NR,NC,JOB,LFN,ERROR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(MR,1),JOB(20)
      DIMENSION ITEMP(20)
      LOGICAL ERROR
C
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
C
      SAVE IDASH,IALFA,IBETA
      DATA IDASH,IALFA,IBETA/4H----,4HALPH,4HBETA/
C
C  Read the matrix A to the external file LFN:
C
C  Input:  MR    -- row dimension of matrix A in calling routine
C
C          NR    -- ABS(NR) is the actual number of rows to be read
C                   [if NR is negative and ABS(NR).EQ.NC (square matrix),
C                    only the upper triangular portion is stored in the
C                    input file.  This routine will read the upper triangular
C                    portion and unpack it.]
C
C          NC    -- actual number of columns in matrix A
C                   [used to determine if A is square]
C
C          LFN   -- input file
C
C  Output: JOB   -- INTEGER array containing the job title
C                   [closed shell or alpha spin only]
C
C          ERROR -- set to .true. if the end-of-file was encountered while
C                   reading
C
      IF(ALPHA.OR..NOT.OPEN) READ(LFN,1000,END=800) JOB
      IF(.NOT.OPEN) ISTR = IDASH
      IF(ALPHA)     ISTR = IALFA
      IF(BETA)      ISTR = IBETA
C
   10 READ(LFN,1000,END=800) ITEMP
      IF(ITEMP(1).NE.ISTR) GOTO 10
C
C  If this is a square matrix and NR is negative, only read the upper
C  triangular portion.  Otherwise, read the full matrix:
C
      IF(ABS(NR).EQ.ABS(NC).AND.NR.LT.0) THEN
        READ(LFN,900,END=800) ((A(I,J),I=1,J),J=1,ABS(NR))
        DO 30 J = 1,ABS(NR)-1
          DO 20 I = J+1,ABS(NR)
            A(I,J) = A(J,I)
   20     CONTINUE
   30   CONTINUE
      ELSE
        DO 40 J = 1,ABS(NC)
          READ(LFN,900,END=800) (A(I,J),I=1,ABS(NR))
   40   CONTINUE
      END IF
      ERROR = .FALSE.
      RETURN
C
  800 ERROR = .TRUE.
      RETURN
C
  900 FORMAT(1X,5F15.9)
 1000 FORMAT(1X,20A4)
      END
C*****************************************************************************
      SUBROUTINE ALTOUT(A,MR,MC,NR,NC)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      DIMENSION A(MR,MC)
C
C  FOR 80 COLUMN OUTPUT:
C  LIST ELEMENTS OF ARRAY A (MATRIX OR VECTOR).
C     MR,MC DECLARED ROW AND COLUMN DIMENSIONALITY,
C     NR,NC ACTUAL ROW AND COLUMN DIMENSIONALITY,
C
      NCL=1
      NCU=6
      NLOOPS=NC/6+1
      DO 20 L=1,NLOOPS
        IF(NCU.GT.NC) NCU=NC
        WRITE(LFNPR,1100) (J,J=NCL,NCU)
        DO 10 I=1,NR
   10     WRITE(LFNPR,1200) I,(A(I,J),J=NCL,NCU)
        IF(NCU.GE.NC) RETURN
        NCL=NCU+1
   20   NCU=NCU+6
      RETURN
 1100 FORMAT(/11X,10(I3,9X))
 1200 FORMAT(1X,I3,10F12.5)
      END
C*****************************************************************************
      SUBROUTINE KEYPAR(STRING,LEN,IFLG,LFN,READ,ERROR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER STRING(LEN)
      LOGICAL READ,ERROR
C
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      SAVE IW,IR,IP,IC,IV,IL,KFULL,KVAL,KLEW
      DATA IW,IR,IP,IC,IV,IL/1HW,1HR,1HP,1HC,1HV,1HL/
      DATA KFULL,KVAL,KLEW/4HFULL,3HVAL,3HLEW/
C
C  Interpret the KEYword PARameter STRING, storing the result in IFLG.
C  (The default IFLG should be passed to this routine through IFLG)
C
C  The following STRINGs are acceptable:
C
C    STRING = Wnnn     means write to the external file nnn (IFLG = -nnn)
C                      (if nnn is omitted, IFLG = -LFN)
C
C    STRING = Rnnn     means read from the external file nnn (IFLG = -nnn*1000)
C                      (if nnn is omitted, IFLG = -LFN)
C                      (READ must be true to allow reading)
C
C    STRING = PnnnC    means print nnn columns to the output file (IFLG = nnn)
C                      (if nnn is omitted, print full matrix, IFLG = 'FULL')
C                      (the C is optional, it means columns)
C
C    STRING = PVAL     means print val columns to output file (IFLG = 'VAL')
C                      (val is the number of core + valence orbitals)
C                      (only the V is necessary)
C
C
C    STRING = PLEW     means print lew columns to output file (IFLG = 'LEW'
C                      (lew is the number of occupied orbitals)
C                      (only the L is necessary)
C
C    STRING = other    IFLG is left untouched
C
      ERROR = .FALSE.
C
C  Process STRING = W..:
C
      IF(STRING(1).EQ.IW) THEN
        IF(LEN.EQ.1) THEN
          IFLG = -LFN
          RETURN
        END IF
        IF(LEN.GT.1) THEN
          CALL CONVIN(STRING(2),LEN-1,IFLG,ERROR)
          IF(ERROR) RETURN
          IF(IFLG.GT.1000) THEN
            WRITE(LFNPR,900)
            WRITE(LFNPR,910) IFLG
            STOP
          END IF
          IFLG = -IFLG
        END IF
C
C  Process STRING = R..:
C
      ELSE IF(STRING(1).EQ.IR) THEN
        IF(.NOT.READ) THEN
          ERROR = .TRUE.
          RETURN
        END IF
        IF(LEN.EQ.1) THEN
          IFLG = -LFN * 1000
          RETURN
        END IF
        IF(LEN.GT.1) THEN
          CALL CONVIN(STRING(2),LEN-1,IFLG,ERROR)
          IF(ERROR) RETURN
          IF(IFLG.GT.1000) THEN
            WRITE(LFNPR,900)
            WRITE(LFNPR,920) IFLG
            STOP
          END IF
          IFLG = -IFLG * 1000
        END IF
C
C  Process STRING = P..:
C
      ELSE IF(STRING(1).EQ.IP) THEN
        IF(STRING(2).EQ.IV) THEN
          IFLG = KVAL
          RETURN
        END IF
        IF(STRING(2).EQ.IL) THEN
          IFLG = KLEW
          RETURN
        END IF
        IF(LEN.EQ.1) THEN
          IFLG = KFULL
          RETURN
        END IF
        IF(LEN.GT.1) THEN
          IF(STRING(LEN).NE.IC) THEN
            CALL CONVIN(STRING(2),LEN-1,IFLG,ERROR)
          ELSE
            CALL CONVIN(STRING(2),LEN-2,IFLG,ERROR)
          END IF
        END IF
      ELSE
        ERROR = .TRUE.
      END IF
      RETURN
C
  900 FORMAT(/1X,'The NBO program will only communicate with external ',
     + 'files 0 thru 999.')
  910 FORMAT(1X,'You''re attempting to write to file ',I6,'.')
  920 FORMAT(1X,'You''re attempting to read from file ',I6,'.')
      END
C*****************************************************************************
      FUNCTION IOINQR(IFLG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      SAVE KFULL,KVAL,KLEW
      SAVE KBLNK,KPRNT,KWRIT,KREAD
      DATA KFULL,KVAL,KLEW/4HFULL,3HVAL,3HLEW/
      DATA KBLNK,KPRNT,KWRIT,KREAD/4H    ,4HPRNT,4HWRIT,4HREAD/
C
C  Interpret IFLG, determining whether the corresponding matrix should be
C  printed, written out, or read:
C
      IF(IFLG.EQ.KFULL) THEN
        IOINQR = KPRNT
      ELSE IF(IFLG.EQ.KVAL) THEN
        IOINQR = KPRNT
      ELSE IF(IFLG.EQ.KLEW) THEN
        IOINQR = KPRNT
      ELSE IF(IFLG.GT.0) THEN
        IOINQR = KPRNT
      ELSE IF(IFLG.LT.0.AND.IFLG.GT.-1000) THEN
        IOINQR = KWRIT
      ELSE IF(IFLG.LT.0) THEN
        IOINQR = KREAD
      ELSE
        IOINQR = KBLNK
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE LBLAO
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER(MAXD = 2)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBAO/LCTR(MAXBAS),LANG(MAXBAS)
      COMMON/NBLBL/NLEW,NVAL,IAOLBL(10,MAXBAS),NAOLBL(10,MAXBAS),
     +                       NHOLBL(10,MAXBAS),NBOLBL(10,MAXBAS)
C
      DIMENSION ISTR(MAXD),IANG(5),IXYZ(3),IBYTE(4),NUM(10)
C
      SAVE IBLNK,IANG,IXYZ,ILEFT,IRIGHT,NUM
      DATA IBLNK/1H /
      DATA IANG/1Hs,1Hp,1Hd,1Hf,1Hg/
      DATA IXYZ/1Hx,1Hy,1Hz/
      DATA ILEFT,IRIGHT/1H(,1H)/
      DATA NUM/1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
C
      DO 20 IAO = 1,NBAS
        DO 10 I = 1,10
          IAOLBL(I,IAO) = IBLNK
   10   CONTINUE
        LBL = NAMEAT(IATNO(LCTR(IAO)))
        CALL DEBYTE(LBL,IBYTE)
        IAOLBL(1,IAO) = IBYTE(1)
        IAOLBL(2,IAO) = IBYTE(2)
        CALL IDIGIT(LCTR(IAO),ISTR,ND,MAXD)
        IF(ND.EQ.1) THEN
          IAOLBL(4,IAO) = ISTR(1)
        ELSE
          IAOLBL(3,IAO) = ISTR(1)
          IAOLBL(4,IAO) = ISTR(2)
        END IF
        IAOLBL(6,IAO) = ILEFT
        L = LANG(IAO)/100
        IAOLBL(7,IAO) = IANG(L+1)
        IF(L.EQ.0) THEN
          IAOLBL(8,IAO) = IRIGHT
        ELSE IF(L.EQ.1) THEN
          M = MOD(LANG(IAO),10)
          IAOLBL(8,IAO) = IXYZ(M)
          IAOLBL(9,IAO) = IRIGHT
        ELSE IF(L.EQ.2.OR.L.EQ.3) THEN
          IAOLBL(8,IAO) = NUM(MOD(LANG(IAO),10)+1)
          IAOLBL(9,IAO) = IRIGHT
        END IF
   20 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE LBLNAO
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER(MAXD = 2)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBNAO/NAOCTR(MAXBAS),NAOL(MAXBAS),LTYP(MAXBAS),
     +       IPRIN(MAXBAS)
      COMMON/NBLBL/NLEW,NVAL,IAOLBL(10,MAXBAS),NAOLBL(10,MAXBAS),
     +                       NHOLBL(10,MAXBAS),NBOLBL(10,MAXBAS)
C
      DIMENSION ISTR(MAXD),IANG(5),IXYZ(3),IBYTE(4),NUM(10)
C
      SAVE IBLNK,IANG,IXYZ,ILEFT,IRIGHT,NUM
      DATA IBLNK/1H /
      DATA IANG/1Hs,1Hp,1Hd,1Hf,1Hg/
      DATA IXYZ/1Hx,1Hy,1Hz/
      DATA ILEFT,IRIGHT/1H(,1H)/
      DATA NUM/1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
C
      DO 20 INAO = 1,NBAS
        DO 10 I = 1,10
          NAOLBL(I,INAO) = IBLNK
   10   CONTINUE
        LBL = NAMEAT(IATNO(NAOCTR(INAO)))
        CALL DEBYTE(LBL,IBYTE)
        NAOLBL(1,INAO) = IBYTE(1)
        NAOLBL(2,INAO) = IBYTE(2)
        CALL IDIGIT(NAOCTR(INAO),ISTR,ND,MAXD)
        IF(ND.EQ.1) THEN
          NAOLBL(4,INAO) = ISTR(1)
        ELSE
          NAOLBL(3,INAO) = ISTR(1)
          NAOLBL(4,INAO) = ISTR(2)
        END IF
        NAOLBL(5,INAO) = ILEFT
        CALL IDIGIT(IPRIN(INAO),ISTR,ND,MAXD)
        IF(ND.EQ.1) THEN
          NAOLBL(7,INAO) = ISTR(1)
        ELSE
          NAOLBL(6,INAO) = ISTR(1)
          NAOLBL(7,INAO) = ISTR(2)
        END IF
        L = NAOL(INAO)/100
        NAOLBL(8,INAO) = IANG(L+1)
        IF(L.EQ.1) THEN
          M = MOD(NAOL(INAO),10)
          NAOLBL(9,INAO) = IXYZ(M)
        ELSE IF(L.EQ.2.OR.L.EQ.3) THEN
          NAOLBL(9,INAO) = NUM(MOD(NAOL(INAO),10)+1)
        END IF
        NAOLBL(10,INAO) = IRIGHT
   20 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE LBLNBO
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER(MAXD = 2)
      INTEGER ISTR(MAXD),IBYTE(4)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),LBL1(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBLBL/NLEW,NVAL,IAOLBL(10,MAXBAS),NAOLBL(10,MAXBAS),
     +                       NHOLBL(10,MAXBAS),NBOLBL(10,MAXBAS)
C
      SAVE IBLNK,IC,IL,IP,IR,IY,ISTAR,IHYP
      SAVE ICR,ILP,ILEFT,IRIGHT
      DATA IBLNK,IC,IL,IP,IR,IY,ISTAR,IHYP/1H ,1Hc,1Hl,1Hp,1Hr,1Hy,1H*,
     +                                     1H-/
      DATA ICR,ILP/2HCR,2HLP/
      DATA ILEFT,IRIGHT/1H(,1H)/
C
      DO 20 INBO = 1,NBAS
        DO 10 I = 1,10
          NBOLBL(I,INBO) = IBLNK
   10   CONTINUE
        IB = IBXM(INBO)
        NCTR = 1
        IF(LABEL(IB,5).NE.0) NCTR = 2
        IF(LABEL(IB,6).NE.0) NCTR = 3
C
C  One-center labels:
C
        IF(NCTR.EQ.1) THEN
          LBL = NAMEAT(IATNO(LABEL(IB,4)))
          CALL DEBYTE(LBL,IBYTE)
          NBOLBL(1,INBO) = IBYTE(1)
          NBOLBL(2,INBO) = IBYTE(2)
          CALL IDIGIT(LABEL(IB,4),ISTR,ND,MAXD)
          IF(ND.EQ.1) THEN
            NBOLBL(4,INBO) = ISTR(1)
          ELSE
            NBOLBL(3,INBO) = ISTR(1)
            NBOLBL(4,INBO) = ISTR(2)
          END IF
          NBOLBL(5,INBO) = ILEFT
          IF(LABEL(IB,1).EQ.ICR) THEN
            NBOLBL(6,INBO) = IC
            NBOLBL(7,INBO) = IR
            NBOLBL(8,INBO) = IRIGHT
          ELSE IF(LABEL(IB,1).EQ.ILP) THEN
            NBOLBL(6,INBO) = IL
            NBOLBL(7,INBO) = IP
            IF(LABEL(IB,2).EQ.ISTAR) THEN
              NBOLBL(8,INBO) = ISTAR
              NBOLBL(9,INBO) = IRIGHT
            ELSE
              NBOLBL(8,INBO) = IRIGHT
            END IF
          ELSE
            NBOLBL(6,INBO) = IR
            NBOLBL(7,INBO) = IY
            NBOLBL(8,INBO) = ISTAR
            NBOLBL(9,INBO) = IRIGHT
          END IF
C
C  Two-center labels:
C
        ELSE IF(NCTR.EQ.2) THEN
          LBL = NAMEAT(IATNO(LABEL(IB,4)))
          CALL DEBYTE(LBL,IBYTE)
          NBOLBL(1,INBO) = IBYTE(1)
          NBOLBL(2,INBO) = IBYTE(2)
          CALL IDIGIT(LABEL(IB,4),ISTR,ND,MAXD)
          IF(ND.EQ.1) THEN
            NBOLBL(4,INBO) = ISTR(1)
          ELSE
            NBOLBL(3,INBO) = ISTR(1)
            NBOLBL(4,INBO) = ISTR(2)
          END IF
          NBOLBL(5,INBO) = IHYP
          LBL = NAMEAT(IATNO(LABEL(IB,5)))
          CALL DEBYTE(LBL,IBYTE)
          NBOLBL(6,INBO) = IBYTE(1)
          NBOLBL(7,INBO) = IBYTE(2)
          CALL IDIGIT(LABEL(IB,5),ISTR,ND,MAXD)
          IF(ND.EQ.1) THEN
            NBOLBL(9,INBO) = ISTR(1)
          ELSE
            NBOLBL(8,INBO) = ISTR(1)
            NBOLBL(9,INBO) = ISTR(2)
          END IF
          NBOLBL(10,INBO) = LABEL(IB,2)
C
C  Three-center labels:
C
        ELSE
          CALL IDIGIT(LABEL(IB,4),ISTR,ND,MAXD)
          IF(ND.EQ.1) THEN
            NBOLBL(2,INBO) = ISTR(1)
          ELSE
            NBOLBL(1,INBO) = ISTR(1)
            NBOLBL(2,INBO) = ISTR(2)
          END IF
          NBOLBL(3,INBO) = IHYP
          CALL IDIGIT(LABEL(IB,5),ISTR,ND,MAXD)
          IF(ND.EQ.1) THEN
            NBOLBL(5,INBO) = ISTR(1)
          ELSE
            NBOLBL(4,INBO) = ISTR(1)
            NBOLBL(5,INBO) = ISTR(2)
          END IF
          NBOLBL(6,INBO) = IHYP
          CALL IDIGIT(LABEL(IB,6),ISTR,ND,MAXD)
          IF(ND.EQ.1) THEN
            NBOLBL(8,INBO) = ISTR(1)
          ELSE
            NBOLBL(7,INBO) = ISTR(1)
            NBOLBL(8,INBO) = ISTR(2)
          END IF
          NBOLBL(9,INBO) = LABEL(IB,2)
        END IF
   20 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE LBLNHO(INHO,INBO,ICTR,NCTR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER(MAXD = 2)
      INTEGER ISTR(MAXD),IBYTE(4)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),LBL1(MAXBAS),
     +       LORBC(MAXBAS),LORB(MAXBAS)
      COMMON/NBLBL/NLEW,NVAL,IAOLBL(10,MAXBAS),NAOLBL(10,MAXBAS),
     +                       NHOLBL(10,MAXBAS),NBOLBL(10,MAXBAS)
C
      SAVE IBLNK,IC,IL,IP,IR,IY,I3,ISTAR,IHYP
      SAVE ICR,ILP,ILEFT,IRIGHT
      DATA IBLNK,IC,IL,IP,IR,IY,I3,ISTAR,IHYP/1H ,1Hc,1Hl,1Hp,1Hr,1Hy,
     +                                        1H3,1H*,1H-/
      DATA ICR,ILP/2HCR,2HLP/
      DATA ILEFT,IRIGHT/1H(,1H)/
C
      DO 10 I = 1,10
        NHOLBL(I,INHO) = IBLNK
   10 CONTINUE
      IB = IBXM(INBO)
C
C  One-center labels:
C
      IF(NCTR.EQ.1) THEN
        LBL = NAMEAT(IATNO(LABEL(IB,4)))
        CALL DEBYTE(LBL,IBYTE)
        NHOLBL(1,INHO) = IBYTE(1)
        NHOLBL(2,INHO) = IBYTE(2)
        CALL IDIGIT(LABEL(IB,4),ISTR,ND,MAXD)
        IF(ND.EQ.1) THEN
          NHOLBL(4,INHO) = ISTR(1)
        ELSE
          NHOLBL(3,INHO) = ISTR(1)
          NHOLBL(4,INHO) = ISTR(2)
        END IF
        NHOLBL(5,INHO) = ILEFT
        IF(LABEL(IB,1).EQ.ICR) THEN
          NHOLBL(6,INHO) = IC
          NHOLBL(7,INHO) = IR
          NHOLBL(8,INHO) = IRIGHT
        ELSE IF(LABEL(IB,1).EQ.ILP) THEN
          NHOLBL(6,INHO) = IL
          NHOLBL(7,INHO) = IP
          IF(LABEL(IB,2).EQ.ISTAR) THEN
            NHOLBL(8,INHO) = ISTAR
            NHOLBL(9,INHO) = IRIGHT
          ELSE
            NHOLBL(8,INHO) = IRIGHT
          END IF
        ELSE
          NHOLBL(6,INHO) = IR
          NHOLBL(7,INHO) = IY
          NHOLBL(8,INHO) = ISTAR
          NHOLBL(9,INHO) = IRIGHT
        END IF
C
C  Two-center and three-center labels:
C
      ELSE
        LBL = NAMEAT(IATNO(LABEL(IB,3+ICTR)))
        CALL DEBYTE(LBL,IBYTE)
        NHOLBL(1,INHO) = IBYTE(1)
        NHOLBL(2,INHO) = IBYTE(2)
        CALL IDIGIT(LABEL(IB,3+ICTR),ISTR,ND,MAXD)
        IF(ND.EQ.1) THEN
          NHOLBL(4,INHO) = ISTR(1)
        ELSE
          NHOLBL(3,INHO) = ISTR(1)
          NHOLBL(4,INHO) = ISTR(2)
        END IF
        NHOLBL(5,INHO) = ILEFT
        IF(NCTR.EQ.2) THEN
          LBL = NAMEAT(IATNO(LABEL(IB,6-ICTR)))
          CALL DEBYTE(LBL,IBYTE)
          NHOLBL(6,INHO) = IBYTE(1)
          NHOLBL(7,INHO) = IBYTE(2)
          CALL IDIGIT(LABEL(IB,6-ICTR),ISTR,ND,MAXD)
          IF(ND.EQ.1) THEN
            NHOLBL(9,INHO) = ISTR(1)
          ELSE
            NHOLBL(8,INHO) = ISTR(1)
            NHOLBL(9,INHO) = ISTR(2)
          END IF
          NHOLBL(10,INHO) = IRIGHT
        ELSE
          NHOLBL(6,INHO) = I3
          NHOLBL(7,INHO) = IHYP
          NHOLBL(8,INHO) = IC
          NHOLBL(9,INHO) = IRIGHT
        END IF
      END IF
      RETURN
      END
C*****************************************************************************
C
C  GENERAL UTILITY ROUTINES:
C
C      SUBROUTINE ANGLES(X,Y,Z,THETA,PHI)
C      FUNCTION BDFIND(IAT,JAT)
C      SUBROUTINE CHEM(NAT,NATOMS,LISTA,NL,ISTR)
C      SUBROUTINE CONSOL(AUT,ALT,NDIM,N)
C      SUBROUTINE CONVIN(IJ,LEN,IK,ERROR)
C      SUBROUTINE CONVRT(N,NC1,NC2)
C      SUBROUTINE COPY(A,B,NDIM,NR,NC)
C      SUBROUTINE CORTBL(IAT,ICORE,IECP)
C      SUBROUTINE DEBYTE(I,IBYTE)
C      SUBROUTINE HALT(WORD)
C      SUBROUTINE IDIGIT(KINT,IK,ND,MAXD)
C      FUNCTION IHTYP(IBO,JBO)
C      SUBROUTINE JACOBI(N,A,EIVU,EIVR,NDIM,NVDIM,ICONTR)
C      SUBROUTINE LIMTRN(T,M,A,B,NDIM,NBAS,NCDIM,NC,IOPT)
C      SUBROUTINE MATMLT(A,B,V,NDIM,N)
C      SUBROUTINE MATML2(A,B,V,NDIM,N)
C      FUNCTION NAMEAT(IZ)
C      SUBROUTINE NORMLZ(A,S,M,N)
C      SUBROUTINE ORDER(RANK,LIST,N,NDIM,ARCRNK)
C      SUBROUTINE PACK(T,NDIM,NBAS,L2)
C      SUBROUTINE RANK(EIG,N,NDIM,ARCRNK)
C      SUBROUTINE SIMTRN(A,T,V,NDIM,N)
C      SUBROUTINE SIMTRS(A,S,V,NDIM,N)
C      SUBROUTINE TRANSP(A,NDIM,N)
C      SUBROUTINE UNPACK(T,NDIM,NBAS,L2)
C      SUBROUTINE VALTBL(IAT,IVAL)
C      FUNCTION VECLEN(X,N,NDIM)
C
C      SUBROUTINE LINEQ(A,X,B,SCR,N,M,NDIM,MDIM,ZERTOL,EPS,MAXIT,LFNPR,
C     +                 IERR)
C      SUBROUTINE FACTOR(A,W,D,IPIVOT,N,NDIM,ZERTOL,IFLAG)
C      SUBROUTINE FNDSOL(A,X,B,W,R,E,IPIVOT,N,NDIM,EPS,MAXIT,LFNPR,IERR)
C      SUBROUTINE SUBST(X,W,B,IPIVOT,N,NDIM)
C
C*****************************************************************************
      SUBROUTINE ANGLES(X,Y,Z,THETA,PHI)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      SAVE ZERO,CUTOFF,ONE
      DATA ZERO,CUTOFF,ONE/0.0D0,1.0D-8,1.0D0/
C
      CONV = 180.0/(4.0*ATAN(ONE))
      IF(X.EQ.ZERO.AND.Y.EQ.ZERO) THEN
        IF(Z.GE.ZERO) THEN
          THETA = ZERO
        ELSE
          THETA = 180.0
        END IF
        PHI = ZERO
      ELSE
        IF(ABS(Z-ONE).LT.CUTOFF) THEN
          THETA = ZERO
        ELSE IF(ABS(Z+ONE).LT.CUTOFF) THEN
          THETA = 180.0
        ELSE IF(Z.LT.ONE.AND.Z.GT.-ONE) THEN
          THETA = ACOS(Z) * CONV
          IF(THETA.GT.180.0) THETA = 360.0 - THETA
        ELSE
          STOP 'ArcCosine out of bounds in SR ANGLES'
        END IF
        PHI   = ATAN2(Y,X) * CONV
        IF(PHI.LT.ZERO) PHI = PHI + 360.0
        IF(ABS(PHI-360.0).LT.0.05) PHI = ZERO
        IF(ABS(THETA).LT.0.05) PHI = ZERO
        IF(ABS(THETA-180.0).LT.0.05) PHI = ZERO
      END IF
      RETURN
      END
C*****************************************************************************
      FUNCTION BDFIND(IAT,JAT)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL BDFIND,IFOUND,JFOUND
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBBAS/LABEL(MAXBAS,6),NAOCTR(MAXBAS),NAOL(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),IATHY(MAXBAS,3)
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
C
      SAVE LSTAR
      DATA LSTAR/1H*/
C
C  SET BDFIND=.TRUE. IF THERE IS AT LEAST ONE BOND BETWEEN ATOMS IAT AND JAT
C
      DO 100 IBAS = 1,NBAS
        IB = IBXM(IBAS)
        IF(LABEL(IB,2).EQ.LSTAR) GO TO 100
        IF(LABEL(IB,3).NE.1) GO TO 100
        IFOUND = .FALSE.
        JFOUND = .FALSE.
        DO 50 K = 4,6
          IF(LABEL(IB,K).EQ.IAT) IFOUND = .TRUE.
          IF(LABEL(IB,K).EQ.JAT) JFOUND = .TRUE.
   50   CONTINUE
        IF(IFOUND.AND.JFOUND) GO TO 200
  100 CONTINUE
      BDFIND = .FALSE.
      RETURN
  200 BDFIND = .TRUE.
      RETURN
      END
C*****************************************************************************
      SUBROUTINE CHEM(NAT,NATOMS,LISTA,NL,ISTR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION LISTA(NATOMS,2),ISTR(80)
C
      PARAMETER (MAXD = 4)
      DIMENSION INUM(MAXD),IBYTE(4)
C
      SAVE IC,IH,IBLNK,ILEFT,IRIGHT
      DATA IC,IH,IBLNK,ILEFT,IRIGHT/1HC,1HH,1H ,1H(,1H)/
C
C  Build the chemical formula from the list of atoms in LISTA:
C
C  Get chemical symbols:
C
      DO 10 IAT = 1,NAT
        LISTA(IAT,1) = NAMEAT(LISTA(IAT,1))
   10 CONTINUE
C
C  Alphabetize these symbols:
C
      DO 30 IAT = 1,NAT-1
        DO 20 JAT = 1,NAT-IAT
          IF(LISTA(JAT,1).GT.LISTA(JAT+1,1)) THEN
            ITEMP = LISTA(JAT,1)
            LISTA(JAT,1) = LISTA(JAT+1,1)
            LISTA(JAT+1,1) = ITEMP
            ITEMP = LISTA(JAT,2)
            LISTA(JAT,2) = LISTA(JAT+1,2)
            LISTA(JAT+1,2) = ITEMP
          END IF
   20   CONTINUE
   30 CONTINUE
C
C  Build chemical formula in ISTR:
C
C  First carbon...
C
      NL = 1
      ISTR(NL) = ILEFT
      DO 50 IAT = 1,NAT
        CALL DEBYTE(LISTA(IAT,1),IBYTE)
        IF(IBYTE(1).EQ.IBLNK.AND.IBYTE(2).EQ.IC) THEN
          NL = NL + 1
          ISTR(NL) = IC
          IF(LISTA(IAT,2).NE.1) THEN
            CALL IDIGIT(LISTA(IAT,2),INUM,ND,MAXD)
            DO 40 IL = 1,ND
              NL = NL + 1
              ISTR(NL) = INUM(IL)
   40       CONTINUE
          END IF
          LISTA(IAT,2) = 0
        END IF
   50 CONTINUE
C
C  then hydrogen...
C
      DO 70 IAT = 1,NAT
        CALL DEBYTE(LISTA(IAT,1),IBYTE)
        IF(IBYTE(1).EQ.IBLNK.AND.IBYTE(2).EQ.IH) THEN
          NL = NL + 1
          ISTR(NL) = IH
          IF(LISTA(IAT,2).NE.1) THEN
            CALL IDIGIT(LISTA(IAT,2),INUM,ND,MAXD)
            DO 60 IL = 1,ND
              NL = NL + 1
              ISTR(NL) = INUM(IL)
   60       CONTINUE
          END IF
          LISTA(IAT,2) = 0
        END IF
   70 CONTINUE
C
C  and now the rest...
C
      DO 90 IAT = 1,NAT
        IF(LISTA(IAT,2).NE.0) THEN
          CALL DEBYTE(LISTA(IAT,1),IBYTE)
          IF(IBYTE(1).NE.IBLNK) THEN
            NL = NL + 1
            ISTR(NL) = IBYTE(1)
          END IF
          IF(IBYTE(2).NE.IBLNK) THEN
            NL = NL + 1
            ISTR(NL) = IBYTE(2)
          END IF
          IF(LISTA(IAT,2).NE.1) THEN
            CALL IDIGIT(LISTA(IAT,2),INUM,ND,MAXD)
            DO 80 IL = 1,ND
              NL = NL + 1
              ISTR(NL) = INUM(IL)
   80       CONTINUE
          END IF
          LISTA(IAT,2) = 0
        END IF
   90 CONTINUE
      NL = NL + 1
      ISTR(NL) = IRIGHT
      RETURN
      END
C*****************************************************************************
      SUBROUTINE CONSOL(AUT,ALT,NDIM,N)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  CONSOLIDATE AUT, ALT TO A SINGLE MATRIX, WITH AUT AS UPPER TRIANGLE
C  (INCLUDING DIAGONAL) AND ALT AS LOWER TRIANGLE.  STORE RESULT IN AUT.
C
      DIMENSION AUT(NDIM,NDIM),ALT(NDIM,NDIM)
      NM1=N-1
      DO 10 J=1,NM1
        JP1=J+1
        DO 10 I=JP1,N
   10     AUT(I,J)=ALT(I,J)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE CONVIN(IJ,LEN,IK,ERROR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION IJ(1)
      DIMENSION INT(10)
      SAVE INT
      LOGICAL ERROR
C
      DATA INT/1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
C
C  Convert the array IJ(LEN) into an integer IK:
C
      ERROR = .FALSE.
      IF(LEN.LE.0) THEN
        ERROR = .TRUE.
        RETURN
      END IF
C
C  Make sure all elements of IJ are integers:
C
      IL   = 0
      MULT = 1
      DO 30 I = LEN,1,-1
        DO 10 J = 1,10
          JJ = J - 1
          IF(IJ(I).EQ.INT(J)) GOTO 20
   10   CONTINUE
        ERROR = .TRUE.
        RETURN
C
   20   IL = IL + JJ * MULT
        MULT = MULT * 10
   30 CONTINUE
      IK = IL
      RETURN
      END
C*****************************************************************************
      SUBROUTINE CONVRT(N,NC1,NC2)
C*****************************************************************************
C
C  CONVERT 2-DIGIT INTEGER 'N' TO TWO LITERAL CHARACTERS 'NC1','NC2'.
C
      DIMENSION INT(10)
      SAVE ISP,INT
      DATA ISP,INT/1H ,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9,1H0/
C
      NC1=ISP
      NC2=ISP
      IF(N.LE.0) RETURN
       IF(N.GE.10) GO TO 10
        NC2=INT(N)
        RETURN
   10 N1=N/10
       IF(N1.GT.9) STOP 'ROUTINE CONVRT'
       NC1=INT(N1)
       N2=N-N1*10
       IF(N2.EQ.0) N2=10
       NC2=INT(N2)
       RETURN
      END
C*****************************************************************************
      SUBROUTINE COPY(A,B,NDIM,NR,NC)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(NDIM,1),B(NDIM,1)
C
C  COPY A TO B:
C
      DO 20 J = 1,NC
        DO 10 I = 1,NR
          B(I,J) = A(I,J)
   10   CONTINUE
   20 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE CORTBL(IAT,ICORE,IECP)
C*****************************************************************************
C
C   CORE TABLE:
C
C     Determine the number of subshells of core orbitals of each angular
C     symmetry for atom number IAT.  ICORE is an integer array LMAX+1
C     long which returns the number of subshells to the calling subroutine:
C     the number of `s' subshells in ICORE(1), the number of `p' subshells
C     in ICORE(2), etc...
C
C     If the CORE option has been used, the core orbitals stored in the array
C     IATCR are used rather than the core orbitals of the nominal core table.
C
C     If IECP = 0 return the number of subshells, excluding subshells of
C                 an effective core potential.
C     IF IECP = 1 return the number of subshells, including subshells of
C                 an effective core potential.
C
C     Note: It is possible for a negative number of core orbitals be found
C     if effective core potentials are employed.  This happens when the
C     number of core electrons in the effective core potential is either
C     greater than the nominal number of core electrons or is greater than the
C     number of core electrons requested when using the CORE option.
C
C------------------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (LMAX = 3)
      INTEGER NCORE(57),ICORE(4),ITEMP(4),IORD(16),JORD(20),KORD(20)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
C
      SAVE IORD,JORD,KORD,NCORE
      DATA IORD/1,1,3,1,3,5,1,3,5,1,3,7,5,1,3,7/
      DATA JORD/1,1,3,1,3,1,5,3,1,5,3,1,7,5,3,1,7,5,3,1/
      DATA KORD/1,2,1,3,2,4,1,3,5,2,4,6,1,3,5,7,2,4,6,8/
      DATA NCORE/2,0,8,1,1,8,2,2,1,12,2,3,2,6,3,3,2,1,12,3,4,3,1,6,3,4,
     +3,2,16,3,5,4,2,10,4,5,4,2,1,6,4,5,4,3,1,16,4,6,5,3,1,10,4,6,5,3,2/
C
C  Initialize arrays.  If there is no nuclear charge at this center,
C  return to calling routine:
C
      DO 10 L = 0,LMAX
        ICORE(L+1) = 0
        ITEMP(L+1) = 0
   10 CONTINUE
      IF(IATNO(IAT).LE.0) RETURN
C
C  If the CORE option has not been used for this atom, use the nominal
C  set of core orbitals:
C
      IF(JCORE.NE.1.OR.IATCR(IAT).LT.0) THEN
        JAT = IATNO(IAT)
        II  = 0
   20   II  = II + 1
          JAT = JAT - NCORE(II)
          II = II + 1
          IF(JAT.LE.0) THEN
            DO 30 L = 1,NCORE(II)
              ICORE(L) = NCORE(II+L)
   30       CONTINUE
          ELSE
            II = II + NCORE(II)
          END IF
        IF(JAT.GT.0) GOTO 20
      ELSE
C
C  If the CORE option has been used, determine the number of core
C  orbitals on this atom:
C
        II = IATCR(IAT)
        IF(II.GT.0) THEN
          ICT = 0
   40     ICT = ICT + 1
          L = IORD(ICT)/2
          ICORE(L+1) = ICORE(L+1) + 1
          II = II - IORD(ICT)
          IF(II.GT.0) GOTO 40
        END IF
      END IF
C
C  If effective core potentials were used and IECP = 0, remove
C  the core orbitals of the ECP:
C
      IF(IPSEUD.NE.0.AND.IECP.EQ.0) THEN
        II = IATNO(IAT)
        ICT = 0
   50   ICT = ICT + 1
          II = II - 2 * JORD(ICT)
        IF(II.GT.0) GOTO 50
        II = IZNUC(IAT) - II
        IF(II.LE.0) STOP 'Zero or negative IZNUC entry?'
        ICT = ICT + 1
   60   ICT = ICT - 1
          IF(ICT.LE.0) STOP 'Error in SR CORTBL'
          II = II - 2 * JORD(ICT)
          IF(II.GE.0) THEN
            L = JORD(ICT)/2
            IF(ICORE(L+1).GE.KORD(ICT)) ITEMP(L+1) = ITEMP(L+1) + 1
          ELSE
            II = II + 2 * JORD(ICT)
          END IF
        IF(II.NE.0) GOTO 60
        DO 70 L = 0,LMAX
          ICORE(L+1) = ITEMP(L+1)
   70   CONTINUE
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE DEBYTE(I,IBYTE)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION IBYTE(4),KB(4)
C
      SAVE KB,KPAD,KSW,KTMP
C
      DATA KSW/0/
      DATA KTMP/4HABCD/
C
C  Extract four Hollerith characters from I, store in IBTYE:
C
C  If this is the first time that this routine is called, determine
C  in which bytes of an integer word the Hollerith characters reside:
C
      IF(KSW.EQ.0) THEN
        KSW   = 1
        DO 10 K = 1,4
          KB(K) = 0
   10   CONTINUE
        KBYTE = 0
   20   KBYTE = KBYTE + 1
          IF(KBYTE.GT.8) STOP 'Routine DEBYTE is limited to INTEGER*8'
          KTEST = MOD(KTMP,256)
          IF(KTEST.EQ.65) KB(1) = KBYTE
          IF(KTEST.EQ.66) KB(2) = KBYTE
          IF(KTEST.EQ.67) KB(3) = KBYTE
          IF(KTEST.EQ.68) KB(4) = KBYTE
          KTMP = KTMP/256
        IF(KTMP.NE.0) GOTO 20
        DO 30 K = 1,4
          IF(KB(K).EQ.0) STOP 'Error in routine DEBYTE'
   30   CONTINUE
C
C  Determine the bit padding:
C
        KPAD = 0
        KMLT = 1
        DO 40 K = 1,KBYTE
          IF(K.NE.KB(1)) KPAD = KPAD + 32 * KMLT
          IF(K.NE.KBYTE) KMLT = KMLT * 256
   40   CONTINUE
C
        DO 60 K = 1,4
          KMAX  = KB(K) - 1
          KB(K) = 1
          DO 50 L = 1,KMAX
            KB(K) = KB(K) * 256
   50     CONTINUE
   60   CONTINUE
      END IF
C
C  Extract four Hollerith characters from I:
C
      DO 100 K = 1,4
        IBYTE(K) = MOD(I/KB(K),256)*KB(1) + KPAD
  100 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE HALT(WORD)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      CHARACTER*(*) WORD
C
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +            LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +            LFNDAF,LFNDEF
C
      WRITE(LFNPR,1000) WORD
      STOP
C
 1000 FORMAT(' Non-integer encountered when trying to read variable ',
     + '/',A,'/')
      END
C*****************************************************************************
      SUBROUTINE IDIGIT(KINT,IK,ND,MAXD)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION IK(MAXD),INT(10)
C
      SAVE IBLNK,INT
      DATA IBLNK,INT/1H ,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9,1H0/
C
C  CONVERTS THE INTEGER KINT INTO THE FIRST ND ELEMENTS OF HOLLERITH ARRAY
C  IK(MAXD):
C
      JINT = KINT
      ND   = MAXD
      DO 10 ID = MAXD,1,-1
        II = MOD(JINT,10)
        IF(II.EQ.0) II = 10
        IK(ID) = INT(II)
        IF(II.NE.10) ND = ID
        JINT = JINT/10
   10 CONTINUE
      ND = MAXD - ND + 1
C
C  SHIFT INTEGER REP IN IK SO THAT THE NUMBER OCCUPIES THE FIRST ND
C  ELEMENTS:
C
      DO 20 ID = 1,ND
        IK(ID) = IK(ID+MAXD-ND)
   20 CONTINUE
      DO 30 ID = ND+1,MAXD
        IK(ID) = IBLNK
   30 CONTINUE
      RETURN
      END
C*****************************************************************************
      FUNCTION IHTYP(IBO,JBO)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL BDFIND
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBBAS/LABEL(MAXBAS,6),NBOUNI(MAXBAS),NBOTYP(MAXBAS),
     +       LSTOCC(MAXBAS),IBXM(MAXBAS),LARC(MAXBAS),IATHY(MAXBAS,3)
C
      SAVE IV,IG,IR
      DATA IV,IG,IR/1Hv,1Hg,1Hr/
C
C  Determine whether the IBO->JBO delocalization is vicinal (IHTYP='v'),
C  geminal (IHTYP='g'), or remote (IHTYP='r'):
C
      IHTYP = IR
      IF(NBOUNI(IBO).EQ.NBOUNI(JBO)) THEN
        ICTR = MOD(NBOTYP(IBO),10)
        IB   = IBXM(IBO)
        JCTR = MOD(NBOTYP(JBO),10)
        JB   = IBXM(JBO)
        DO 20 I = 1,ICTR
          IAT = LABEL(IB,I+3)
          DO 10 J = 1,JCTR
            JAT = LABEL(JB,J+3)
            IF(IAT.EQ.JAT) THEN
              IHTYP = IG
              RETURN
            ELSE IF(BDFIND(IAT,JAT)) THEN
              IHTYP = IV
            END IF
   10     CONTINUE
   20   CONTINUE
      END IF
      RETURN
      END
C*****************************************************************************
      SUBROUTINE JACOBI(N,A,EIVU,EIVR,NDIM,NVDIM,ICONTR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  DIAGONALIZE REAL SYMMETRIC MATRIX A BY JACOBI ROTATIONS:
C        N: ACTUAL DIMENSION OF A,EIVR
C     NDIM: DECLARED DIMENSION OF A,EIVR
C   ICONTR: CONTROL OPTION
C
C
C       ********  MODIFIED VERSION, MARCH 1986  *************
C
C
C     ICONTR = 0: REDUCE ALL OFF-DIAGONAL ELEMENTS TO "DONE" OR SMALLER
C                                       -- THIS SETS FULMIX=.TRUE.
C
C     ICONTR = 1: DO THE SAME AS FOR ICONTR=0 EXCEPT DO NOT MIX ORBITALS THAT
C       ARE DEGENERATE TO WITHIN "DIFFER" IF THE OFFDIAGONAL ELEMENT CONNECTING
C       THEM IS LESS THAN "DIFFER".
C                                       -- THIS SETS FULMIX=.FALSE.
C
C  FOR THE PURPOSES OF THE NAO AND NBO PROGRAMS, THESE VALUES ARE SET:
C
C     DIFFER = 1.0D-5
C          THRESHOLD FOR CONSIDERING TWO VECTORS NONDEGENERATE IF
C                         ICONTR=1
C     DONE   = 1.0D-13
C          THIS IS THE PARAMETER FOR CONVERGENCE OF THE OFF-DIAGONAL
C             MATRIX ELEMENTS.  (ABSOLUTE)  --- Reduced from 1.0D-10
C             on 8/31/88.  A more converged Fock matrix was required
C             for the NBO deletions with symmetry to work properly
C             (EDG) ---
C
C     EPS    = 0.5D-13
C          THIS PARAMETER HAS TO DO WITH THE MACHINE PRECISION AND SHOULD
C             BE SET TO A VALUE BETWEEN "DONE" AND THE MACHINE PRECISION.
C             --- Reduced from 1.0D-11.  8/31/88 (EDG) ---
C
      LOGICAL FULMIX
      DIMENSION A(NDIM,1),EIVR(NVDIM,1),EIVU(1)
C
C  IMPORTANT PARAMETERS:
C
      SAVE DIFFER,DONE,EPS,PT99,ZERO,ONE,FIVE
      DATA DIFFER,DONE,EPS,PT99/1.0D-5,1.0D-13,0.5D-13,0.99D0/
      DATA ZERO,ONE,FIVE/0.0D0,1.0D0,5.0D0/
C
      FULMIX=.TRUE.
      IF(ICONTR.EQ.1) FULMIX=.FALSE.
      IF(N.GT.1) GO TO 10
       EIVR(1,1)=ONE
       EIVU(1)=A(1,1)
       RETURN
   10 CONTINUE
      DO 30 J=1,N
        DO 20 I=1,N
   20     EIVR(I,J)=ZERO
   30   EIVR(J,J)=ONE
C
C        FIND THE ABSOLUTELY LARGEST ELEMENT OF A
C
C  FIRST CHECK THE OFF-DIAGONAL ELEMENTS:
      ATOP=ZERO
      DO 50 J=2,N
        JM1=J-1
        DO 50 I=1,JM1
          IF(ATOP.GT.ABS(A(I,J))) GO TO 50
          ATOP= ABS(A(I,J))
   50     CONTINUE
      OFFTOP=ATOP
C  NOW CHECK THE DIAGONAL ELEMENTS:
      DO 60 J=1,N
          IF(ATOP.GT.ABS(A(J,J))) GO TO 60
          ATOP= ABS(A(J,J))
   60     CONTINUE
C  IF MATRIX IS ALREADY EFFECTIVELY DIAGONAL,
C              PUT DIAGONAL ELEMENTS IN EIVU AND RETURN
      IF(ATOP.LT.DONE) GO TO 260
      IF(OFFTOP.LT.DONE) GO TO 260
C
C        CALCULATE THE STOPPING CRITERION -- DSTOP
C
      AVGF= FLOAT(N*(N-1)/2)
      D=0.0D0
      DO 80 JJ=2,N
        DO 80 II=2,JJ
          S=A(II-1,JJ)/ATOP
   80     D=S*S+D
      DSTOP=(1.D-7)*D
C
C        CALCULATE THE THRESHOLD, THRSH
C
      THRSH= SQRT(D/AVGF)*ATOP
C  TO MAKE THRSH DIFFERENT THAN ANY MATRIX ELEMENT OF A, MULTIPLY BY 0.99
      THRSH=THRSH*PT99
      IF(THRSH.LT.DONE) THRSH=DONE
C
C        START A SWEEP
C
   90 IFLAG=0
      DO 250 JCOL=2,N
        JCOL1=JCOL-1
        DO 250 IROW=1,JCOL1
          AIJ=A(IROW,JCOL)
C
C        COMPARE THE OFF-DIAGONAL ELEMENT WITH THRSH
C
          ABSAIJ=ABS(AIJ)
          IF (ABSAIJ.LT.THRSH) GO TO 250
          AII=A(IROW,IROW)
          AJJ=A(JCOL,JCOL)
          S=AJJ-AII
          ABSS=ABS(S)
C  DON'T ROTATE THE VECTORS IROW AND JCOL IF IROW AND JCOL WOULD STILL
C     BE DEGENERATE WITHIN "DIFFER":
          IF(FULMIX) GO TO 100
            IF((ABSS.LT.DIFFER).AND.(ABSAIJ.LT.DIFFER)) GO TO 250
  100     CONTINUE
C
C        CHECK TO SEE IF THE CHOSEN ROTATION IS LESS THAN THE ROUNDING ERROR
C        IF SO , THEN DO NOT ROTATE.
C
          TEST=EPS*ABSS
          IF (ABSAIJ.LT.TEST) GO TO 250
          IFLAG=1
C
C        IF THE ROTATION IS VERY CLOSE TO 45 DEGREES, SET SIN AND COS
C        TO 1/(ROOT 2).
C
          TEST=EPS*ABSAIJ
          IF (ABSS.GT.TEST) GO TO 130
          S=.707106781D0
          C=S
          GO TO 140
C
C        CALCULATION OF SIN AND COS FOR ROTATION THAT IS NOT VERY CLOSE
C        TO 45 DEGREES
C
  130     T=AIJ/S
          S=0.25D0/ SQRT(0.25D0+T*T)
C
C        COS=C ,  SIN=S
C
          C= SQRT(0.5D0+S)
          S=2.D0*T*S/C
C
C        CALCULATION OF THE NEW ELEMENTS OF MATRIX A
C
  140     DO 150 I=1,IROW
            T=A(I,IROW)
            U=A(I,JCOL)
            A(I,IROW)=C*T-S*U
  150       A(I,JCOL)=S*T+C*U
          I2=IROW+2
          IF (I2.GT.JCOL) GO TO 180
          DO 170 I=I2,JCOL
            T=A(I-1,JCOL)
            U=A(IROW,I-1)
            A(I-1,JCOL)=S*U+C*T
  170       A(IROW,I-1)=C*U-S*T
  180     A(JCOL,JCOL)=S*AIJ+C*AJJ
          A(IROW,IROW)=C*A(IROW,IROW)-S*(C*AIJ-S*AJJ)
          DO 190 J=JCOL,N
            T=A(IROW,J)
            U=A(JCOL,J)
            A(IROW,J)=C*T-S*U
  190       A(JCOL,J)=S*T+C*U
C
C        ROTATION COMPLETED
C
          DO 210 I=1,N
            T=EIVR(I,IROW)
            EIVR(I,IROW)=C*T-EIVR(I,JCOL)*S
  210       EIVR(I,JCOL)=S*T+EIVR(I,JCOL)*C
C
C        CALCULATE THE NEW NORM D AND COMPARE WITH DSTOP
C
          S=AIJ/ATOP
          D=D-S*S
          IF (D.GT.DSTOP) GO TO 240
C
C        RECALCULATE DSTOP AND THRSH TO DISCARD ROUNDING ERRORS
C
          D=ZERO
          DO 230 JJ=2,N
            DO 230 II=2,JJ
              S=A(II-1,JJ)/ATOP
  230         D=S*S+D
          DSTOP=(1.D-7)*D
  240     CONTINUE
          OLDTHR=THRSH
          THRSH= SQRT(D/AVGF)*ATOP*PT99
          IF(THRSH.LT.DONE) THRSH=DONE*PT99
          IF(THRSH.GT.OLDTHR) THRSH=OLDTHR
  250     CONTINUE
      IF(THRSH.LT.DONE) GO TO 260
      IF(IFLAG.EQ.1) GO TO 90
      THRSH=THRSH/FIVE
      GO TO 90
C
C        PLACE EIGENVALUES IN EIVU
C
  260 CONTINUE
      DO 270 J=1,N
        EIVU(J)=A(J,J)
  270   CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE LIMTRN(T,M,A,B,NDIM,NBAS,NCDIM,NC,IOPT)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION T(NDIM,NDIM),M(NCDIM),A(NCDIM,NCDIM),B(NCDIM)
C...DO A LIMITED TRANSFORMATION OF T, INCLUDING ONLY THE "NC" ROWS AND
C    COLUMNS SPECIFIED IN THE VECTOR "M":
C
C   IOPT= 1 :  TAKE T=T*A
C   IOPT= 0 :  TAKE T=A(TRANSPOSE)*T*A
C   IOPT=-1 :  TAKE T=A(TRANSPOSE)*T
C
C
      IF(IOPT.EQ.1) GO TO 100
C   FIRST, TAKE T=A(TRANSPOSE)*T, WHERE T=S,DM
        DO 30 J=1,NBAS
          DO 10 K=1,NC
   10     B(K)=T(M(K),J)
          DO 30 I=1,NC
            SUM=0.0D0
            DO 20 K=1,NC
   20         SUM=SUM+A(K,I)*B(K)
   30       T(M(I),J)=SUM
      IF(IOPT.EQ.-1) RETURN
C   NOW, TAKE T=T*A
  100 CONTINUE
        DO 160 I=1,NBAS
          DO 140 K=1,NC
  140       B(K)=T(I,M(K))
          DO 160 J=1,NC
            SUM=0.0D0
            DO 150 K=1,NC
  150         SUM=SUM+B(K)*A(K,J)
  160       T(I,M(J))=SUM
      RETURN
      END
C*****************************************************************************
      SUBROUTINE MATMLT(A,B,V,NDIM,N)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(1),B(1),V(NDIM)
      SAVE ZERO
      DATA ZERO/0.0D0/
C
C  MULTIPLY A*B (USING SCRATCH VECTOR V), STORE RESULT IN A:
C
      NDIF=NDIM-N
      DO 30 I=1,N
        KJ=0
        IKK=I-NDIM
        DO 20 J=1,N
          IK=IKK
          TEMP=ZERO
          DO 10 K=1,N
            IK=IK+NDIM
            KJ=KJ+1
   10       TEMP=TEMP+A(IK)*B(KJ)
          KJ=KJ+NDIF
   20   V(J)=TEMP
        IJ=I-NDIM
        DO 30 J=1,N
          IJ=IJ+NDIM
   30     A(IJ)=V(J)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE MATML2(A,B,V,NDIM,N)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(1),B(1),V(NDIM)
      SAVE ZERO
      DATA ZERO/0.0D0/
C                       B=A(TRANSPOSE)*B
C  MULTIPLY A(TRANSPOSE)*B (USING SCRATCH VECTOR V), STORE RESULT IN B:
C    ASSUME A*B IS A SYMMETRIC MATRIX, SO ALMOST HALF THE WORK IS SAVED.
C    THIS CAN BE THE SECOND STEP IN A SIMILARITY TRANSFORMATION OF B BY A.
C
      IJ=0
      IJJ=-NDIM
      KJJ=-NDIM
      DO 50 J=1,N
        KII=-NDIM
        KJJ=KJJ+NDIM
        DO 20 I=1,J
          KII=KII+NDIM
          KI=KII
          KJ=KJJ
          TEMP=ZERO
          DO 10 K=1,N
            KI=KI+1
            KJ=KJ+1
   10       TEMP=TEMP+A(KI)*B(KJ)
   20   V(I)=TEMP
        IJJ=IJJ+NDIM
        IJ=IJJ
        JI=J-NDIM
        JM1=J-1
        DO 30 I=1,JM1
          IJ=IJ+1
          JI=JI+NDIM
          VV=V(I)
          B(IJ)=VV
   30     B(JI)=VV
        IJ=IJ+1
   50   B(IJ)=V(J)
      RETURN
      END
C*****************************************************************************
      FUNCTION NAMEAT(IZ)
C*****************************************************************************
C
C  RETURN ATOMIC SYMBOL FOR NUCLEAR CHARGE IZ (.LE. 103):
C
      DIMENSION NAME(103)
C
      SAVE IGHOST,IBLANK,NAME
C
      DATA IGHOST/2Hgh/,IBLANK/2H  /
      DATA NAME/2H H,2HHe,2HLi,2HBe,2H B,2H C,2H N,2H O,2H F,2HNe,
     + 2HNa,2HMg,2HAl,2HSi,2H P,2H S,2HCl,2HAr,2H K,2HCa,2HSc,2HTi,
     + 2H V,2HCr,2HMn,2HFe,2HCo,2HNi,2HCu,2HZn,2HGa,2HGe,2HAs,
     + 2HSe,2HBr,2HKr,2HRb,2HSr,2H Y,2HZr,2HNb,2HMo,2HTc,2HRu,
     + 2HRh,2HPd,2HAg,2HCd,2HIn,2HSn,2HSb,2HTe,2H I,2HXe,2HCs,
     + 2HBa,2HLa,2HCe,2HPr,2HNd,2HPm,2HSm,2HEu,2HGd,2HTb,2HDy,
     + 2HHo,2HEr,2HTm,2HYb,2HLu,2HHf,2HTa,2H W,2HRe,2HOs,2HIr,
     + 2HPt,2HAu,2HHg,2HTl,2HPb,2HBi,2HPo,2HAt,2HRn,2HFr,2HRa,
     + 2HAc,2HTh,2HPa,2H U,2HNp,2HPu,2HAm,2HCm,2HBk,2HCf,2HEs,
     + 2HFm,2HMd,2HNo,2HLr/
C
      IF(IZ.LT.0.OR.IZ.GT.103) NAMEAT = IBLANK
      IF(IZ.GT.0) NAMEAT = NAME(IZ)
      IF(IZ.EQ.0) NAMEAT = IGHOST
      RETURN
      END
C*****************************************************************************
      SUBROUTINE NORMLZ(A,S,M,N)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(M,M),S(M,M)
C
      SAVE ZERO,ONE
      DATA ZERO,ONE /0.0D0,1.0D0/
C
C NORMALIZE COLUMNS OF A
C
      DO 40 I = 1,N
        TEMP = ZERO
        DO 20 J = 1,N
          DO 10 K = 1,N
            TEMP = TEMP + A(J,I)*A(K,I)*S(J,K)
   10     CONTINUE
   20   CONTINUE
        FACTOR = ONE/SQRT(TEMP)
        DO 30 J = 1,N
          A(J,I) = FACTOR * A(J,I)
   30   CONTINUE
   40 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE ORDER(RANK,LIST,N,NDIM,ARCRNK)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  RANK POSITIVE ELEMENTS OF INTEGER 'LIST', LOWEST VALUES FIRST.
C
      INTEGER RANK,ARCRNK,TEMP
      DIMENSION RANK(NDIM),LIST(NDIM),ARCRNK(NDIM)
      DO 10 I=1,N
   10   ARCRNK(I)=I
      DO 40 I=1,N
        IF(I.EQ.N)GO TO 30
        I1=I+1
        DO 20 J=I1,N
          IF(LIST(J).GE.LIST(I))GO TO 20
          TEMP=LIST(I)
          LIST(I)=LIST(J)
          LIST(J)=TEMP
          TEMP=ARCRNK(I)
          ARCRNK(I)=ARCRNK(J)
          ARCRNK(J)=TEMP
   20     CONTINUE
   30   RANK(ARCRNK(I))=I
        IF(LIST(I).LE.0) GO TO 50
   40   CONTINUE
      RETURN
   50 DO 60 K=I,N
        RANK(ARCRNK(K))=0
   60   CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE PACK(T,NDIM,NBAS,L2)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION T(1)
C
      SAVE ZERO
      DATA ZERO/0.0D0/
C
C  PACK:  PACKS A SYMMETRIC MATRIX T INTO AN UPPER TRIANGULAR MATRIX.
C         T SHOULD BE DIMENSIONED (NDIM,NDIM) IN THE CALLING ROUTINE:
C
      IF(NBAS.GT.NDIM) STOP 'NBAS IS GREATER THAN NDIM'
      II = 0
      DO 200 J = 1,NBAS
        JPTR = (J-1) * NDIM
        DO 100 I = 1,J
          IPTR = JPTR + I
          II = II + 1
          T(II) = T(IPTR)
  100   CONTINUE
  200 CONTINUE
      IF(II.NE.L2) STOP 'ERROR IN ROUTINE PACK'
C
      DO 300 I = II+1,NDIM*NDIM
        T(I) = ZERO
  300 CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE RANK(EIG,N,NDIM,ARCRNK)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  ORDER NUMBERS IN 'EIG', HIGHEST VALUES FIRST,
C    AND CONSTRUCT 'ARCRNK':
C     ARCRNK(I) IS THE OLD LOCATION OF THE I-TH HIGHEST VALUE IN EIG
C      NOTE: UPON RETURN, EIG(I) IS THE I-TH HIGHEST VALUE IN EIG
C      IMPORTANT: NUMBERS IN EIG ARE NOT SWITCHED UNLESS THEY DIFFER
C       BY MORE THAN "DIFFER":  5.0D-8
C
      INTEGER ARCRNK
      DIMENSION ARCRNK(NDIM),EIG(NDIM)
C
      SAVE DIFFER
      DATA DIFFER/5.0D-8/
C
      DO 10 I=1,N
   10   ARCRNK(I)=I
      DO 40 I=1,N
        IF(I.EQ.N)GO TO 40
        I1=I+1
        DO 20 J=I1,N
          IF((EIG(J)-EIG(I)).LT.DIFFER) GO TO 20
          TEMP=EIG(I)
          EIG(I)=EIG(J)
          EIG(J)=TEMP
          ITEMP=ARCRNK(I)
          ARCRNK(I)=ARCRNK(J)
          ARCRNK(J)=ITEMP
   20     CONTINUE
   40   CONTINUE
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SIMTRN(A,T,V,NDIM,N)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  SIMILARITY TRANSFORM A ==> T(TRANSPOSE)*A*T, USING SCRATCH VECTOR V.
C
      DIMENSION A(NDIM,NDIM),T(NDIM,NDIM),V(NDIM)
      CALL MATMLT(A,T,V,NDIM,N)
      CALL TRANSP(A,NDIM,N)
      CALL MATMLT(A,T,V,NDIM,N)
      CALL TRANSP(A,NDIM,N)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE SIMTRS(A,S,V,NDIM,N)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
C  SIMILARITY TRANSFORM A ==> S(TRANSPOSE)*A*S, USING SCRATCH VECTOR V.
C    FAST VERSION --- ASSUMES RESULT IS A SYMMETRIC MATRIX
C
      DIMENSION A(NDIM,NDIM),S(NDIM,NDIM),V(NDIM)
      CALL MATMLT(A,S,V,NDIM,N)
      CALL MATML2(S,A,V,NDIM,N)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE TRANSP(A,NDIM,N)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(NDIM,NDIM)
C
C  TRANSPOSE MATRIX A, STORE RESULT IN A.
C
      DO 10 I=1,N
        DO 10 J=1,I
          TEMP=A(I,J)
          A(I,J)=A(J,I)
   10     A(J,I)=TEMP
      RETURN
      END
C*****************************************************************************
      SUBROUTINE UNPACK(T,NDIM,NBAS,L2)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION T(1)
C
C  UNPACK:  UNPACKS AN UPPER TRIANGULAR MATRIX (VECTOR L2 LONG) INTO A
C           SYMMETRIC MATRIX T(NBAS,NBAS).  NOTE: T SHOULD BE DIMENSIONED
C           (NDIM,NDIM) IN THE CALLING ROUTINE.
C
C  FIRST SPREAD OUT THE L2 NUMBERS INTO THE UPPER PART OF THE WHOLE ARRAY.
C
      J = 0
      K = 1
      IPTR = (NDIM + 1)*(NBAS - K) + 1
      DO 200 I = L2,1,-1
        T(IPTR-J) = T(I)
        IF(J.LT.NBAS-K) THEN
          J = J + 1
        ELSE
          J = 0
          K = K + 1
          IPTR = (NDIM + 1)*(NBAS - K) + 1
        END IF
  200 CONTINUE
C
C  NOW FILL IN THE HOLES IN THE OUTPUT ARRAY.
C
      DO 400 J = 1,NBAS-1
        ICOL = (J-1)*NDIM
        DO 300 I = J+1,NBAS
          IPTR = ICOL + I
          JPTR = (I-1)*NDIM + J
          T(IPTR) = T(JPTR)
  300   CONTINUE
  400 CONTINUE
C
      RETURN
      END
C*****************************************************************************
      SUBROUTINE VALTBL(IAT,IVAL)
C*****************************************************************************
C
C   VALENCE TABLE:
C
C     Determine the number of sets of valence orbitals of each angular
C     symmetry for atom number IAT.  IVAL is an integer array LMAX+1
C     long which returns the number of sets to the calling subroutine:
C     the number of `s' subshells in IVAL(1), the number of `p' subshells
C     in IVAL(2), etc...
C
C------------------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (LMAX = 3)
      DIMENSION IVAL(4),ICORE(4),IORD(20)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
C
      SAVE IORD
      DATA IORD/1,1,3,1,3,1,5,3,1,5,3,1,7,5,3,1,7,5,3,1/
C
      DO 10 L = 0,LMAX
        IVAL(L+1) = 0
   10 CONTINUE
C
C  Count the number of filled or partially filled subshells:
C
      II = IATNO(IAT)
      IF(II.GT.0) THEN
        ICT = 0
   20   ICT = ICT + 1
        L = IORD(ICT)/2
        IVAL(L+1) = IVAL(L+1) + 1
        II = II - 2*IORD(ICT)
        IF(II.GT.0) GOTO 20
      END IF
C
C  Remove the core subshells.  Note: if there are more core orbitals
C  in the effective core potential than in the nominal core table or
C  from the CORE option, remove these extra core orbitals from the
C  set of valence orbitals:
C
      IECP = 1
      CALL CORTBL(IAT,ICORE,IECP)
      DO 50 L = 0,LMAX
        IVAL(L+1) = IVAL(L+1) - ICORE(L+1)
   50 CONTINUE
      IECP = 0
      CALL CORTBL(IAT,ICORE,IECP)
      DO 60 L = 0,LMAX
        IF(ICORE(L+1).LT.0) THEN
          IVAL(L+1) = IVAL(L+1) + ICORE(L+1)
        END IF
   60 CONTINUE
      RETURN
      END
C*****************************************************************************
      FUNCTION VECLEN(X,N,NDIM)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(NDIM)
C
      SAVE ZERO
      DATA ZERO/0.0D0/
C
      SUM = ZERO
      DO 10 I = 1,N
        SUM = SUM + X(I)*X(I)
   10 CONTINUE
      VECLEN = SQRT(SUM)
      RETURN
      END
C*****************************************************************************
      SUBROUTINE LINEQ(A,X,B,SCR,N,M,NDIM,MDIM,ZERTOL,EPS,MAXIT,LFNPR,
     +                 IERR)
C*****************************************************************************
C
C  Solve the system of linear equations  A * X  =  B  for matrix X
C                                        ~   ~     ~             ~
C  Input
C -------
C  * Coefficient matrix A of dimension (N,N) with actual
C    dimension (NDIM,NDIM).
C  * Matrix B of dimension (N,M) with actual dimension
C    (NDIM,MDIM)
C  * Working space SCR dimensioned (NDIM,NDIM+5).
C  * Zero tolerance ZERTOL.
C  * Threshold on Euclidean norm (vector length) of the
C    error vector relative to the norm of a column of X.
C  * Maximum number of iterations MAXIT allowed during
C    iterative improvement.
C  * Logical file number LFNPR for printing during iterative
C    improvement.  Set to zero to no printing is desired.
C
C  Output
C --------
C  * Solution X of dimension (N,M) with actual dimension
C    (NDIM,MDIM).
C  * Euclidean norm of the final error vector, EPS.
C  * Number of iterations taken during interative improvement,
C    MAXIT.
C  * Error flag :    IERR = -1   Iterative improvement did not
C                                converge
C                    IERR =  0   No errors encountered
C                    IERR =  1   A matrix is not invertible
C
C------------------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(NDIM,NDIM),X(NDIM,MDIM),B(NDIM,MDIM),
     +          SCR(NDIM*(NDIM+5))
C
      SAVE ZERO
      DATA ZERO/0.0/
C
      IF(N.LT.1) STOP 'Dimension N is not positive'
C
C  Partition scratch space:
C
      I1 = 1
      I2 = I1 + NDIM*NDIM
      I3 = I2 + NDIM
      I4 = I3 + NDIM
      I5 = I4 + NDIM
      I6 = I5 + NDIM
C
C  Perform Gauss elimination with scaled partial pivoting:
C
      CALL FACTOR(A,SCR(I1),SCR(I2),SCR(I6),N,NDIM,ZERTOL,IFLAG)
      IF(IFLAG.EQ.0) THEN
        IERR = 1
        RETURN
      ELSE
        IERR = 0
      END IF
C
C  Loop over columns of X and B:
C
      EPSMAX = ZERO
      ITSMAX = 0
      DO 30 KCOL = 1,M
        DO 10 JROW = 1,N
          SCR(I4+JROW-1) = X(JROW,KCOL)
          SCR(I5+JROW-1) = B(JROW,KCOL)
   10   CONTINUE
        ITS = MAXIT
        DEL = EPS
C
C  Use back-substitution and iterative improvement to determine
C  the solution X:
C
        CALL FNDSOL(A,SCR(I4),SCR(I5),SCR(I1),SCR(I2),SCR(I3),SCR(I6),
     +              N,NDIM,DEL,ITS,LFNPR,IERR)
        IF(IERR.NE.0) RETURN
C
C  Copy solution into X:
C
        DO 20 JROW = 1,N
          X(JROW,KCOL) = SCR(I4+JROW-1)
   20   CONTINUE
        IF(DEL.GT.EPSMAX) EPSMAX = DEL
        IF(ITS.GT.ITSMAX) ITSMAX = ITS
   30 CONTINUE
C
      EPS = EPSMAX
      MAXIT = ITSMAX
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FACTOR(A,W,D,IPIVOT,N,NDIM,ZERTOL,IFLAG)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(NDIM,NDIM),W(NDIM,NDIM),D(NDIM),IPIVOT(NDIM)
C
      SAVE ZERO,ONE
      DATA ZERO,ONE/0.0D0,1.0D0/
C
C  Initial IFLAG.  If IFLAG is 1, then an even number of interchanges
C  has been carried out.  If equal to -1, then an odd number of inter-
C  changes have taken place.  If IFLAG is set to zero on return to the
C  calling routine, then the matrix is not invertible:
C
      IFLAG = 1
C
C  Copy coefficient matrix A to W:
C
      CALL COPY(A,W,NDIM,N,N)
C
C  Initialize D and IPIVOT:
C
      DO 20 I = 1,N
        IPIVOT(I) = I
        ROWMAX = ZERO
        DO 10 J = 1,N
          IF(ABS(W(I,J)).GT.ROWMAX) ROWMAX = ABS(W(I,J))
   10   CONTINUE
        IF(ROWMAX.LE.ZERTOL) THEN
          IFLAG = 0
          ROWMAX = ONE
        END IF
        D(I) = ROWMAX
   20 CONTINUE
      IF(N.EQ.1) RETURN
C
C  Loop over rows, factorizing matrix W:
C
      DO 100 K = 1,N-1
C
C  Determine the pivot row ISTAR:
C
        COLMAX = ABS(W(K,K))/D(K)
        ISTAR = K
        DO 30 I = K+1,N
          TEMP = ABS(W(I,K))/D(K)
          IF(TEMP.GT.COLMAX) THEN
            COLMAX = TEMP
            ISTAR = I
          END IF
   30   CONTINUE
        IF(COLMAX.EQ.ZERO) THEN
          IFLAG = 0
        ELSE
          IF(ISTAR.GT.K) THEN
            IFLAG = -IFLAG
            ITEMP = IPIVOT(ISTAR)
            IPIVOT(ISTAR) = IPIVOT(K)
            IPIVOT(K) = ITEMP
            TEMP = D(ISTAR)
            D(ISTAR) = D(K)
            D(K) = TEMP
            DO 40 J = 1,N
              TEMP = W(ISTAR,J)
              W(ISTAR,J) = W(K,J)
              W(K,J) = TEMP
   40       CONTINUE
          END IF
C
C  Eliminate X(K) from rows K+1,...,N:
C
          DO 60 I = K+1,N
            W(I,K) = W(I,K)/W(K,K)
            DO 50 J = K+1,N
              W(I,J) = W(I,J) - W(I,K)*W(K,J)
   50       CONTINUE
   60     CONTINUE
        END IF
  100 CONTINUE
      IF(ABS(W(N,N)).LE.ZERTOL) IFLAG = 0
      RETURN
      END
C*****************************************************************************
      SUBROUTINE FNDSOL(A,X,B,W,R,E,IPIVOT,N,NDIM,EPS,MAXIT,LFNPR,IERR)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(NDIM,NDIM),X(NDIM),B(NDIM),W(NDIM,NDIM),R(NDIM),
     +          E(NDIM),IPIVOT(NDIM)
C
      SAVE ZERO
      DATA ZERO/0.0D0/
C
C  Find initial guess for X by back substitution:
C
      CALL COPY(B,E,NDIM,N,1)
      CALL SUBST(X,W,E,IPIVOT,N,NDIM)
      IF(MAXIT.EQ.0) RETURN
C
C  Iterate until the vector length of the error vector relative to
C  X is less than EPS:
C
      RELLEN = ZERO
      ITER = 0
   10 IF(RELLEN.GT.EPS) THEN
        ITER = ITER + 1
        DO 30 I = 1,N
          R(I) = B(I)
          DO 20 J = 1,N
            R(I) = R(I) - A(I,J)*X(J)
   20     CONTINUE
   30   CONTINUE
        CALL SUBST(E,W,R,IPIVOT,N,NDIM)
        ELEN = VECLEN(E,N,NDIM)
        XLEN = VECLEN(X,N,NDIM)
        RELLEN = ELEN/XLEN
        DO 40 I = 1,N
          X(I) = X(I) + E(I)
   40   CONTINUE
C
C  Print out iterative improvement info:
C
        IF(LFNPR.GT.0) THEN
          WRITE(LFNPR,900) ITER,RELLEN
        END IF
C
C  If too many iterations have taken place, halt furthur iterations:
C
        IF(ITER.EQ.MAXIT) THEN
          IF(RELLEN.GT.EPS) IERR = -1
          IF(LFNPR.GT.0) THEN
            IF(IERR.LT.0) THEN
              WRITE(LFNPR,910)
            ELSE
              WRITE(LFNPR,920)
            END IF
          END IF
          EPS = RELLEN
          RETURN
        END IF
C
C  Error vector is converged:
C
      ELSE
        IF(LFNPR.GT.0) WRITE(LFNPR,920)
        EPS = RELLEN
        MAXIT = ITER
        RETURN
      END IF
      GOTO 10
C
  900 FORMAT(1X,'Iter = ',I3,'    relative length = ',F10.7)
  910 FORMAT(1X,'No convergence within the specified number of ',
     + 'iterations')
  920 FORMAT(1X,'The error vector is converged')
      END
C*****************************************************************************
      SUBROUTINE SUBST(X,W,B,IPIVOT,N,NDIM)
C*****************************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(NDIM),W(NDIM,NDIM),B(NDIM),IPIVOT(NDIM)
C
      SAVE ZERO
      DATA ZERO/0.0D0/
C
      IF(N.EQ.1) THEN
        X(1) = B(1)/W(1,1)
        RETURN
      END IF
C
C  Use multipliers stored in W and back substitution to find X:
C
      IP = IPIVOT(1)
      X(1) = B(IP)
      DO 20 I = 2,N
        SUM = ZERO
        DO 10 J = 1,I-1
          SUM = W(I,J)*X(J) + SUM
   10   CONTINUE
        IP = IPIVOT(I)
        X(I) = B(IP) - SUM
   20 CONTINUE
      X(N) = X(N)/W(N,N)
      DO 40 I = N-1,1,-1
        SUM = ZERO
        DO 30 J = I+1,N
          SUM = W(I,J)*X(J) + SUM
   30   CONTINUE
        X(I) = (X(I) - SUM)/W(I,I)
   40 CONTINUE
      RETURN
      END
C*****************************************************************************
C
C                 E N D    O F    N B O    P R O G R A M
C
C*****************************************************************************
C***********************************************************************
C
C
C                          A  M  P  N  B  O
C
C
C                    AMPAC VERSION OF NBO PROGRAM
C
C
C  DRIVER ROUTINES:
C
C      SUBROUTINE RUNNBO
C      SUBROUTINE FEAOIN(CORE,ICORE,NBOOPT)
C      SUBROUTINE DELSCF(CORE,ICORE)
C
C***********************************************************************
      SUBROUTINE RUNNBO
C***********************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      PARAMETER(MEMORY = 4*MAXBAS*MAXBAS)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +           LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +           LFNDAF,LFNDEF
C
      DIMENSION CORE(MEMORY),NBOOPT(10)
C
      LFNIN = 5
      LFNPR = 6
C
C  Set NBO options.
C
      NBOOPT(1)  =  0
      NBOOPT(2)  =  0
      NBOOPT(3)  =  0
      NBOOPT(4)  =  0
      NBOOPT(5)  =  0
      NBOOPT(6)  =  0
      NBOOPT(7)  =  0
      NBOOPT(8)  =  0
      NBOOPT(9)  =  0
      NBOOPT(10) =  1
C
C  Perform the NPA/NBO/NLMO analyses.
C
      CALL NBO(CORE,MEMORY,NBOOPT)
      IF(NBOOPT(10).LT.0) RETURN
C
C  Perform the energetic analysis.
C
   10 NBOOPT(1) = 2
      CALL NBOEAN(CORE,MEMORY,NBOOPT,IDONE)
      IF(IDONE.NE.0) GOTO 20
      CALL DELSCF(CORE,CORE)
      NBOOPT(1) = 3
      CALL NBOEAN(CORE,MEMORY,NBOOPT,IDONE)
      GOTO 10
C
   20 RETURN
      END
C***********************************************************************
      SUBROUTINE FEAOIN(CORE,ICORE,NBOOPT)
C***********************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION CORE(1),ICORE(1),NBOOPT(10)
      DIMENSION LIST(9),NCORE(12)
C
      INCLUDE 'SIZES'
C
C  NBO COMMON BLOCKS
C
      PARAMETER(MAXATM = 99,MAXBAS = 500)
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBOPT/IWDM,IW3C,IWAPOL,IWHYBS,IWPNAO,IWTNAO,IWTNAB,
     + IWTNBO,IWFOCK,IWCUBF,IPSEUD,KOPT,IPRINT,IWDETL,IWMULP,ICHOOS,
     + JCORE,JPRINT(60)
      COMMON/NBAO/LCTR(MAXBAS),LANG(MAXBAS)
      COMMON/NBATOM/IATNO(MAXATM),INO(MAXATM),NORBS(MAXATM),LL(MAXATM),
     +       LU(MAXATM),IZNUC(MAXATM),IATCR(MAXATM)
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +           LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +           LFNDAF,LFNDEF
C
C  AMPAC COMMON BLOCKS:
C
      COMMON /NATORB/ NATORB(107)
      COMMON /TITLES/ COMENT(10),TITLE(10)
      COMMON /DENSTY/ P(MPACK),PA(MPACK),PB(MPACK)
      COMMON /VECTOR/ C(MORB2),EIGS(MAXORB),CBETA(MORB2),EIGB(MAXORB)
      COMMON /FOKMAT/ F(MPACK), FB(MPACK)
      COMMON /GEOM  / GEO(3,NUMATM)
      COMMON /GEOKST/ NATOM,LABELS(NUMATM),
     *                NA(NUMATM), NB(NUMATM), NC(NUMATM)
      COMMON /KEYWRD/ KEYWRD
      CHARACTER*80 KEYWRD
C
      DATA LIST/51,151,152,153,254,251,255,253,252/
      DATA NCORE/2,10,18,28,36,46,54,68,78,86,100,110/
C
C  FEAOIN:   (FETCH AO BASIS AND WAVE FUNCTION TYPE INFORMATION)
C
C   OBTAIN THE FOLLOWING INFORMATION:
C
C    ROHF        =.TRUE. IF RHF OPEN SHELL WAVE FUNCTION
C                =.FALSE. OTHERWISE
C
C    UHF         =.TRUE. IF UHF WAVE FUNCTION
C                =.FALSE. OTHERWISE
C
C    CI          =.TRUE. IF UHF WAVE FUNCTION
C                =.FALSE. OTHERWISE
C
C    OPEN        =.TRUE. IF OPEN SHELL WAVE FUNCTION
C                =.FALSE. OTHERWISE
C
C    COMPLX      =.TRUE. IF COMPLEX WAVE FUNCTION
C                =.FALSE. OTHERWISE
C                (NOTE: THE PROGRAM IS NOT SET UP TO HANDLE THIS CASE)
C
C    ORTHO       =.TRUE. ORTHOGONAL AO BASIS SET
C
C    NATOMS      NUMBER OF ATOMIC CENTERS
C
C    NDIM        DIMENSION OF MATRICES (OVERLAP AND DENSITY)
C
C    NBAS        NUMBER OF BASIS FUNCTIONS (.LE.NDIM)
C
C    IPSEUD      SET TO ZERO IF NO PSEUDOPOTENTIALS ARE USED,
C                SET TO ONE IF PSEUDOPOTENTIALS ARE USED.
C                (THE ONLY EFFECT OF THIS IS TO SUPRESS THE LABELLING OF
C                ORBITALS WHEN ONE OR MORE ATOMS HAS A PSEUDOPOTENTIAL)
C
C    IWCUBF      THIS PERTAINS ONLY TO BASIS SETS WITH F FUNCTIONS.
C
C                 IF CARTESIAN F FUNCTIONS ARE INPUT, SET IWCUBF TO:
C                    0,  IF THESE ARE TO BE TRANSFORMED TO THE STANDARD
C                        OF PURE F FUNCTIONS
C                    1,  IF THESE ARE TO BE TRANSFORMED TO THE CUBIC
C                        SET OF PURE F FUNCTIONS
C
C                 IF PURE F FUNCTIONS ARE INPUT, SET TO IWCUBF TO:
C                    0,  IF THESE ARE STANDARD F FUNCTIONS
C                    1,  IF THESE ARE CUBIC F FUNCTIONS
C
C
C    IATNO(I),I=1,NATOMS
C                LIST OF ATOMIC NUMBERS
C
C    LCTR(I),I=1,NBAS
C                LIST OF ATOMIC CENTERS OF THE BASIS FUNCTIONS
C                    (LCTR(3)=2 IF BASIS FUNCT. 3 IS ON ATOM 2)
C
C    LANG(I),I=1,NBAS
C                LIST OF ANGULAR SYMMETRY INFORMATION FOR THE BASIS
C                FUNCTIONS
C
      IWCUBF = 0
      IPSEUD = 0
C
C  CONSTRUCT ATOM AND AO BASIS INFORMATION LISTS:
C     IATNO(I) = ATOMIC NUMBER OF ATOM "I"
C     IZNUC(I) = NUCLEAR CHARGE ON ATOM "I" (IATNO(I)-# OF CORE ELECTRON
C     LCTR(I) = ATOMIC CENTER FOR BASIS FUNCTION "I"
C     LANG(I) = ANGULAR SYMMETRY LABEL FOR BASIS FUNCTION "I"
C
      IBAS = 0
      NAT  = 0
      DO 200 I = 1,NATOM
        IF(LABELS(I).EQ.99) GOTO 200
        NAT = NAT + 1
        IATNO(NAT) = LABELS(I)
        DO 100 J = 1,12
          JJ = J
          IF(IATNO(NAT)-NCORE(JJ).LT.0) GOTO 110
  100   CONTINUE
        STOP 'UNKNOWN ATOM'
C
  110   JJ = JJ - 1
        IF(JJ.EQ.0) THEN
          IZNUC(NAT) = IATNO(NAT)
        ELSE
          IZNUC(NAT) = IATNO(NAT) - NCORE(JJ)
          IPSEUD = 1
        END IF
        DO 150 J = 1,NATORB(LABELS(I))
          IBAS = IBAS + 1
          LCTR(IBAS)  = NAT
          LANG(IBAS)  = LIST(J)
  150   CONTINUE
  200 CONTINUE
C
C  PUT INFO INTO COMMON/NBINFO/:
C
      NATOMS = NAT
      NDIM   = IBAS
      NBAS   = IBAS
C
C  EXPECTATION VALUES OF THE FOCK OPERATOR ARE IN ELECTRON VOLTS:
C
      MUNIT = 1
C
C  DETERMINE TYPE OF WAVE FUNCTION DENSITY MATRIX IS FROM:
C
      ORTHO = .TRUE.
      IF(INDEX(KEYWRD,'C.I.').NE.0)    CI   = .TRUE.
      IF(INDEX(KEYWRD,'UHF').NE.0)     UHF  = .TRUE.
      IF(INDEX(KEYWRD,'OPEN').NE.0)    OPEN = .TRUE.
      IF(INDEX(KEYWRD,'DOUBLE').NE.0)  OPEN = .TRUE.
      IF(INDEX(KEYWRD,'TRIPLET').NE.0) OPEN = .TRUE.
      IF(INDEX(KEYWRD,'QUARTET').NE.0) OPEN = .TRUE.
      IF(INDEX(KEYWRD,'QUINTET').NE.0) OPEN = .TRUE.
      IF(INDEX(KEYWRD,'SEXTET').NE.0)  OPEN = .TRUE.
      IF(UHF) OPEN = .TRUE.
      IF(OPEN) UHF = .TRUE.
C
      IF(ROHF.OR.CI) IWFOCK = 0
C
C  STORE THE JOB TITLE ON THE NBO DAF:
C
      DO 210 I = 1,10
        CORE(I) = TITLE(I)
  210 CONTINUE
      NFILE = 2
      CALL NBWRIT(CORE,10,NFILE)
C
C  STORE NATOMS, NDIM, NBAS, MUNIT, WAVEFUNCTION FLAGS, ISWEAN:
C
      ICORE(1)  = NATOMS
      ICORE(2)  = NDIM
      ICORE(3)  = NBAS
      ICORE(4)  = MUNIT
      ICORE(5)  = 0
      IF(ROHF)  ICORE(5)  = 1
      ICORE(6)  = 0
      IF(UHF)   ICORE(6)  = 1
      ICORE(7)  = 0
      IF(CI)    ICORE(7)  = 1
      ICORE(8)  = 0
      IF(OPEN)  ICORE(8)  = 1
      ICORE(9)  = 0
      IF(MCSCF) ICORE(9)  = 1
      ICORE(10) = 0
      IF(AUHF)  ICORE(10) = 1
      ICORE(11) = 0
      IF(ORTHO) ICORE(11) = 1
      ICORE(12) = 1
      NFILE = 3
      CALL NBWRIT(ICORE,12,NFILE)
C
C  STORE IATNO, IZNUC, LCTR, AND LANG ON NBO DAF:
C
      II = 0
      DO 220 I = 1,NATOMS
        II = II + 1
        ICORE(II) = IATNO(I)
  220 CONTINUE
      DO 230 I = 1,NATOMS
        II = II + 1
        ICORE(II) = IZNUC(I)
  230 CONTINUE
      DO 240 I = 1,NBAS
        II = II + 1
        ICORE(II) = LCTR(I)
  240 CONTINUE
      DO 250 I = 1,NBAS
        II = II + 1
        ICORE(II) = LANG(I)
  250 CONTINUE
      NFILE = 4
      CALL NBWRIT(ICORE,2*NATOMS+2*NBAS,NFILE)
C
C  STORE ATOMIC COORDINATES ON THE NBO DAF:
C
      CALL GMETRY(GEO,CORE)
      NFILE = 9
      CALL NBWRIT(CORE,3*NATOMS,NFILE)
C
C  STORE THE DENSITY MATRICES ON THE NBO DAF:
C
      IWDM = 0
      L2 = NDIM*(NDIM+1)/2
      IF(OPEN) THEN
        NFILE = 20
        CALL NBWRIT(PA,L2,NFILE)
        NFILE = 21
        CALL NBWRIT(PB,L2,NFILE)
      ELSE
        NFILE = 20
        CALL NBWRIT(P,L2,NFILE)
      END IF
C
C  STORE THE FOCK MATRICES ON THE NBO DAF:
C
      IF(.NOT.ROHF.AND..NOT.CI) THEN
        NFILE = 30
        CALL NBWRIT(F,L2,NFILE)
        IF(OPEN) THEN
          NFILE = 31
          CALL NBWRIT(FB,L2,NFILE)
        END IF
      END IF
C
C  STORE THE AO TO MO TRANSFORMATIONS ON THE NBO DAF:
C
      L3 = NDIM*NDIM
      NFILE = 40
      CALL NBWRIT(C,L3,NFILE)
      IF(OPEN) THEN
        NFILE = 41
        CALL NBWRIT(CBETA,L3,NFILE)
      END IF
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE DELSCF(CORE,ICORE)
C***********************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      LOGICAL NEW,ERROR,SEQ
C
C  NBO common blocks:
C
      COMMON/NBINFO/ISPIN,NATOMS,NDIM,NBAS,MXBO,MXAO,MXAOLM,MUNIT
      COMMON/NBFLAG/ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      LOGICAL ROHF,UHF,CI,OPEN,COMPLX,ALPHA,BETA,MCSCF,AUHF,ORTHO
      COMMON/NBIO/LFNIN,LFNPR,LFNAO,LFNPNA,LFNNAO,LFNPNH,LFNNHO,LFNPNB,
     +           LFNNBO,LFNPNL,LFNNLM,LFNMO,LFNDM,LFNNAB,LFNPPA,LFNARC,
     +           LFNDAF,LFNDEF
C
C  AMPAC COMMON blocks:
C
      INCLUDE 'SIZES'
C
      COMMON /MOLKST/ NUMAT,NAT(NUMATM),NFIRST(NUMATM),NMIDLE(NUMATM),
     +                NLAST(NUMATM), NORBS, NELECS,
     +                NALPHA, NBETA, NCLOSE, NOPEN, NDUMY, FRACT
      COMMON /HMATRX/ H(MPACK)
      COMMON /WMATRX/ WJ(N2ELEC), WK(N2ELEC)
      COMMON /FOKMAT/ F(MPACK), FB(MPACK)
      COMMON /DENSTY/ P(MPACK), PA(MPACK), PB(MPACK)
      COMMON /ATHEAT/ ATHEAT
      COMMON /ENUCLR/ ENUCLR
      COMMON /GEOM  / GEO(3,NUMATM)
C
      DIMENSION CORE(1),ICORE(1),W(N2ELEC)
      EQUIVALENCE (W(1),WJ(1))
C
      DATA TWO,TOKCAL/2.0D0,23.061D0/
C
C  Open the NBO direct access file:
C
      NEW = .FALSE.
      CALL NBOPEN(NEW,ERROR)
      IF(ERROR) THEN
        WRITE(LFNPR,900)
        STOP
      END IF
C
C  Compute the one-electron and two-electron integrals, given the atomic
C  coordinates.  Also compute the nuclear repulsion contribution to the
C  SCF energy:
C
      CALL GMETRY(GEO,CORE)
      CALL HCORE(CORE,H,W,WJ,WK,ENUCLR)
C
C  Compute the SCF and deletion energies for UHF wavefunctions:
C
      LEN = NBAS * (NBAS + 1) / 2
      IF(UHF) THEN
C
C  Read the spin densities from the NBO direct access file and calculate
C  to total density:
C
        ALPHA = .TRUE.
        BETA  = .FALSE.
        CALL FEDRAW(PA,CORE)
        CALL PACK(PA,NDIM,NBAS,LEN)
        ALPHA = .FALSE.
        BETA  = .TRUE.
        CALL FEDRAW(PB,CORE)
        CALL PACK(PB,NDIM,NBAS,LEN)
        DO 10 I = 1,LEN
          P(I) = PA(I) + PB(I)
   10   CONTINUE
C
C  Alpha spin: construct the alpha Fock matrix:
C
        CALL COPY(H,F,LEN,LEN,1)
        CALL FOCK2(F,P,PA,W,WJ,WK,NUMAT,NFIRST,NMIDLE,NLAST)
        CALL FOCK1(F,P,PA,PB)
C
C  Alpha spin: construct the alpha Fock matrix:
C
        CALL COPY(H,FB,LEN,LEN,1)
        CALL FOCK2(FB,P,PB,W,WJ,WK,NUMAT,NFIRST,NMIDLE,NLAST)
        CALL FOCK1(FB,P,PB,PA)
C
C  Determine the SCF energy:
C
        EE   = HELECT(NBAS,PA,H,F) + HELECT(NBAS,PB,H,FB)
        ESCF = (EE + ENUCLR) * TOKCAL + ATHEAT
C
C  Repeat process for the deletion energy:
C
        ALPHA = .TRUE.
        BETA  = .FALSE.
        CALL FENEWD(PA)
        ALPHA = .FALSE.
        BETA  = .TRUE.
        CALL FENEWD(PB)
        DO 20 I = 1,LEN
          P(I) = PA(I) + PB(I)
   20   CONTINUE
        CALL COPY(H,F,LEN,LEN,1)
        CALL FOCK2(F,P,PA,W,WJ,WK,NUMAT,NFIRST,NMIDLE,NLAST)
        CALL FOCK1(F,P,PA,PB)
        CALL COPY(H,FB,LEN,LEN,1)
        CALL FOCK2(FB,P,PB,W,WJ,WK,NUMAT,NFIRST,NMIDLE,NLAST)
        CALL FOCK1(FB,P,PB,PA)
        EE   = HELECT(NBAS,PA,H,F) + HELECT(NBAS,PB,H,FB)
        EDEL = (EE + ENUCLR) * TOKCAL + ATHEAT
C
C  Compute the SCF and deletion energies for RHF wavefunctions:
C
      ELSE
        ALPHA = .FALSE.
        BETA  = .FALSE.
        CALL FEDRAW(P,CORE)
        CALL PACK(P,NDIM,NBAS,LEN)
        DO 30 I = 1,LEN
          PA(I) = P(I) / TWO
          PB(I) = P(I) / TWO
   30   CONTINUE
C
C  Construct the Fock matrix:
C
        CALL COPY(H,F,LEN,LEN,1)
        CALL FOCK2(F,P,PA,W,WJ,WK,NUMAT,NFIRST,NMIDLE,NLAST)
        CALL FOCK1(F,P,PA,PB)
C
C  Determine the SCF energy:
C
        EE   = HELECT(NBAS,PA,H,F) * TWO
        ESCF = (EE + ENUCLR) * TOKCAL + ATHEAT
C
C  Repeat process for the deletion energy:
C
        CALL FENEWD(P)
        DO 40 I = 1,LEN
          PA(I) = P(I) / TWO
          PB(I) = P(I) / TWO
   40   CONTINUE
        CALL COPY(H,F,LEN,LEN,1)
        CALL FOCK2(F,P,PA,W,WJ,WK,NUMAT,NFIRST,NMIDLE,NLAST)
        CALL FOCK1(F,P,PA,PB)
        EE   = HELECT(NBAS,PA,H,F) * TWO
        EDEL = (EE + ENUCLR) * TOKCAL + ATHEAT
      END IF
C
C  Save these energies on the direct access file:
C
      CORE(1) = EDEL
      CORE(2) = ESCF
      NFILE = 8
      CALL NBWRIT(CORE,2,NFILE)
C
C  Note that these energies are in units of kcal/mol!!
C
      MUNIT = 2
      NFILE = 3
      CALL NBREAD(ICORE,12,NFILE)
      ICORE(4) = MUNIT
      CALL NBWRIT(ICORE,12,NFILE)
C
C  Close the NBO direct access file:
C
      SEQ = .FALSE.
      CALL NBCLOS(SEQ)
      RETURN
C
  900 FORMAT(/1X,'Error opening the NBO direct access file in ',
     + 'subroutine DELSCF.')
      END
C***********************************************************************
C
C           E N D    O F    A M P N B O    R O U T I N E S
C
C***********************************************************************
 
