/* Part of PVTool - Copyright 1996 Richard W.E. Furse */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef EXCLUDE_EXTERNALS
extern int bins;
extern float *input_buffer[2];
extern int input_buffer_frames[2];
extern float *output_buffer;
extern int output_buffer_frames;
extern int resize (int frames);
extern char *parameter[];
extern float fparameter[];
extern int parameter_count;
#endif

#define MAX_NUMBER_OF_PARAMETERS 500
#define MAX_ERROR_LENGTH 500

int pvaction (void);
void usage_message (void);
float input_mag (int input_number, int frame, int channel);
float input_phidot (int input_number, int frame, int channel);
float *output_mag (int frame, int channel);
float *output_phidot (int frame, int channel);
float spectral_envelope_component (int input_number,
				   int frame,
				   int bin,
				   float threshold_scalar);
float spectral_envelope_independent_component (int input_number,
					       int frame,
					       int bin,
					       float threshold_scalar);
int pvtool_error (char *message);
int pvtool_warning (char *message);
float sampling_rate (void);
char *input_filename (int input_number);
float sound_length (int input_number);
float bin_to_freq (int bin);

#define INPUT1_FRAMES input_buffer_frames[0]
#define INPUT2_FRAMES input_buffer_frames[1]
#define OUTPUT_FRAMES output_buffer_frames

#ifdef FAST_AND_NASTY
#define INPUT1_MAG(frame,channel) (*(input_buffer[0]+((bins+1)*(frame)+channel)*2))
#define INPUT1_PHIDOT(frame,channel) (*(input_buffer[0]+((bins+1)*(frame)+channel)*2+1))
#define INPUT2_MAG(frame,channel) (*(input_buffer[1]+((bins+1)*(frame)+channel)*2))
#define INPUT2_PHIDOT(frame,channel) (*(input_buffer[1]+((bins+1)*(frame)+channel)*2+1))
#define INPUT_PHIDOT(input_number,frame,channel) (*(input_buffer[input_number-1]+((bins+1)*(frame)+channel)*2))
#define INPUT_MAG(input_number,frame,channel) (*(input_buffer[input_number-1]+((bins+1)*(frame)+channel)*2+1))
#define OUTPUT_MAG(frame,channel) (*(output_buffer+((bins+1)*(frame)+channel)*2))
#define OUTPUT_PHIDOT(frame,channel) (*(output_buffer+((bins+1)*(frame)+channel)*2+1))
#else
#define INPUT1_MAG(frame,channel) input_mag (1, frame, channel)
#define INPUT1_PHIDOT(frame,channel) input_phidot (1, frame, channel)
#define INPUT2_MAG(frame,channel) input_mag (2, frame, channel)
#define INPUT2_PHIDOT(frame,channel) input_phidot (2, frame, channel)
#define INPUT_MAG(input_number, frame,channel) input_mag (input_number, frame, channel)
#define INPUT_PHIDOT(input_number, frame,channel) input_phidot (input_number, frame, channel)
#define OUTPUT_MAG(frame,channel) (*(output_mag (frame, channel)))
#define OUTPUT_PHIDOT(frame,channel) (*(output_phidot (frame, channel)))
#endif

/*===========================================================================*/

/* Custom code: */
