/* PVTool - Copyright 1996 Richard W.E. Furse */

#include <stdio.h>
#include <stdlib.h>

#include "top.x"

float *spectral_envelope_data[2] = {NULL, NULL};
int *maxima_data = NULL;
int spen_current_frame[2] = {-2, -2};
float spen_current_thresh[2] = {-2, -2};

void
join_spectrum_dots (int input_number,
		    int first_bin, float first_bin_level,
		    int last_bin, float last_bin_level)
{
  int bin;
  float scalar;

  scalar = (last_bin_level - first_bin_level) / (float) (last_bin - first_bin);
  for (bin = first_bin; bin <= last_bin; bin++)
    *(spectral_envelope_data[input_number - 1] + bin) =
      first_bin_level + scalar * (float) (bin - first_bin);
}

int
calculate_spectral_envelope (int input_number,
			     int frame,
			     float threshold_scalar)
     /* This function operates by finding a collection of local
        maxima, tidying (in case of noise) and then 'joining the dots'
        between the maxima. */
     /* WARNING: Because I was feeling lazy, this function contains
        some very bad duplicate code. */
{
  int err = 0;
  int next_maxima_space = 0, i, j;
  int found, tmp;
  float bin_threshold;
  float this_mag, next_mag;

  /* If used for the first time then allocate memory: */
  if (!spectral_envelope_data[input_number - 1])
    {
      spectral_envelope_data[input_number - 1] =
	malloc (bins * sizeof (float));
      maxima_data = malloc (bins * sizeof (int));
      if (spectral_envelope_data[input_number - 1] == NULL
	  || maxima_data == NULL)
	err = pvtool_error
	  ("Failed to allocate sufficient memory");
    }

  for (i = 2; i + 2 < bins; i++)
    /* Miss some bins: first two and last two. */
    {
      if ((INPUT_MAG (input_number, frame, i) >=
	   INPUT_MAG (input_number, frame, i - 2)) &&
	  (INPUT_MAG (input_number, frame, i) >=
	   INPUT_MAG (input_number, frame, i - 1)) &&
	  (INPUT_MAG (input_number, frame, i) >=
	   INPUT_MAG (input_number, frame, i + 1)) &&
	  (INPUT_MAG (input_number, frame, i) >=
	   INPUT_MAG (input_number, frame, i + 2)))
	{
	  *(maxima_data + next_maxima_space) = i;
	  next_maxima_space++;
	}
    }

  /* Simple bubblesort of bins by magnitude: */
  j = next_maxima_space;
  do
    {
      found = 0;
      j--;
      for (i = 0; i < j; i++)
	if (INPUT_MAG (input_number, frame, *(maxima_data + i + 1))
	    > INPUT_MAG (input_number, frame, *(maxima_data + i)))
	  {
	    tmp = *(maxima_data + i);
	    *(maxima_data + i) = *(maxima_data + i + 1);
	    *(maxima_data + i + 1) = tmp;
	    found++;
	  }
    }
  while (found != 0);

  /* Only worry about break points of significant level compared to
     highest level. Resize buffer: */
  bin_threshold =
    threshold_scalar * INPUT_MAG (input_number, frame, *maxima_data);

  for (j = 0;
       (j < next_maxima_space &&
	(INPUT_MAG (input_number, frame, *(maxima_data + j)) >=
	 bin_threshold));
       j++)
    ;
  next_maxima_space = j;

  /* Simple bubblesort bins remaining back into increasing numerical
     order: */
  j = next_maxima_space;
  do
    {
      found = 0;
      j--;
      for (i = 0; i < j; i++)
	if (*(maxima_data + i + 1) < *(maxima_data + i))
	  {
	    tmp = *(maxima_data + i);
	    *(maxima_data + i) = *(maxima_data + i + 1);
	    *(maxima_data + i + 1) = tmp;
	    found++;
	  }
    }
  while (found != 0);

  /* For each maxima, interpolate to the next one. */
  for (j = 0; j < next_maxima_space; j++)
    {
      this_mag = INPUT_MAG (input_number, frame, *(maxima_data + j));

      if (j + 1 < next_maxima_space)	/* ie not last one */
	next_mag = INPUT_MAG (input_number, frame, *(maxima_data + j + 1));
      else			/* ie last one */
	next_mag = bin_threshold;

      if (j == 0)		/* Need to do an extra one at start */
	join_spectrum_dots (input_number,
			    0, bin_threshold,
			    *(maxima_data + j), this_mag);

      if (j + 1 == next_maxima_space)	/* ie last one */
	join_spectrum_dots (input_number,
			    *(maxima_data + j), this_mag,
			    bins - 1, next_mag);
      else			/* ie all but last */
	join_spectrum_dots (input_number,
			    *(maxima_data + j), this_mag,
			    *(maxima_data + j + 1), next_mag);
    }

  return (err);
}

/* Here's the API: */
float
spectral_envelope_component (int input_number,
			     int frame,
			     int bin,
			     float threshold_scalar)
{
  /* If this frame isn't in storage, put it there. */
  if (frame != spen_current_frame[input_number - 1] ||
      threshold_scalar != spen_current_thresh[input_number - 1])
    {
      calculate_spectral_envelope (input_number,
				   frame,
				   threshold_scalar);
      spen_current_frame[input_number - 1] = frame;
      spen_current_thresh[input_number - 1] = threshold_scalar;
    }

  return (*(spectral_envelope_data[input_number - 1] + bin));
}

float
spectral_envelope_independent_component (int input_number,
					 int frame,
					 int bin,
					 float threshold_scalar)
{
  float sc, out;

  sc = spectral_envelope_component
    (input_number, frame, bin, threshold_scalar);

  if (sc > 0)
    out = input_mag (input_number, frame, bin) / sc;
  else
    out = 0;

  return (out);
}
