/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  double VRfMin (const float x[], int N)

Purpose:
  Return the minimum value in a float array

Description:
  This routine finds the minimum of the values in a float array.

Parameters:
  <-  double VRfMin
      Minimum of the values in x
   -> const float x[]
      Input array (N elements)
   -> int N
      Number of elements in the array (must be greater than zero)

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.4 $  $Date: 1996/04/17 19:37:44 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: VRfMin.c 1.4 1996/04/17 libtsp-V2R7a $";

#include <libtsp.h>

double
VRfMin (x, N)

     const float x[];
     int N;

{
  int i;
  float xmin;

  if (N <= 0)
    UThalt ("VRfMin: Invalid number of elements");

  xmin = x[0];
  for (i = 1; i < N; ++i) {
    if (x[i] < xmin)
      xmin = x[i];
  }

  return (double) xmin;
}
