/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  double VRfDiffSq (const float x1[], const float x2[], int N)

Purpose:
  Find the sum of squares of the differences for two float arrays

Description:
  This routine calculates the sum of the squares of the differences between
  corresponding elements of two float arrays,
         N-1                2
    e2 = SUM (x1[i] * x2[i]) .
         i=0

Parameters:
  <-  double VRfDiffSq
      Sum of the squares of the element differences
   -> const float x1[]
      Input array (N elements)
   -> const float x2[]
      Input array (N elements)
   -> int N
      Number of elements in the arrays (may be zero)

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.5 $  $Date: 1995/02/09 21:06:38 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: VRfDiffSq.c 1.5 1995/02/09 libtsp-V2R7a $";

#include <libtsp.h>

double
VRfDiffSq (x1, x2, N)

     const float x1[];
     const float x2[];
     int N;

{
  int i;
  double d, e2;

  e2 = 0.0;
  for (i = 0; i < N; ++i) {
    d = (double) x1[i] - x2[i];
    e2 += d * d;
  }

  return e2;
}
