/*
   Test UTxIEEE80

   $Id: tUTxIEEE80.c 1.5 1995/09/22 libtsp-V2R7a $
*/

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/UTtypes.h>

#ifndef HUGE_VAL
#  define HUGE_VAL	HUGE
#endif

#define TNAN(x)		(!(x <= 1.) && !(x > 1.))

int
main (argc, argv)

     int argc;
     const char *argv[];

{
  int i;
  double dv, yv, dmant1, dmant2;
  unsigned char b[10];
  int test, exp1, exp2, exp, error;

  test = 0;
  if (strcmp (argv[1], "HUGE_VAL") == 0)
    dv = HUGE_VAL;
  else if (strcmp (argv[1], "-HUGE_VAL") == 0)
    dv = -HUGE_VAL;
  else if (strcmp (argv[1], "infinity") == 0)
    dv = sqrt (1.) / 0.0;
  else if (strcmp (argv[1], "-infinity") == 0)
    dv = -sqrt (1.) / 0.0;
  else if (strcmp (argv[1], "NaN") == 0)
    dv = sqrt (-1.);
  else if (strcmp (argv[1], "test") == 0)
    test = 1;
  else
    sscanf (argv[1], "%lg", &dv);

  if (test != 0) {

    error = 0;

    /* Check unsigned to double conversion */
    dv = (uint4_t) 0xFFFFFFFF;
    yv = (uint4_t) 0x7FFFFFFF;
    if (yv + 2147483648.  != dv) {
      error = 1;
      UTwarn ("tUTxIEEE80 - Error in uint4_t to double conversion");
    }

    /* Check frexp for small values */
    dv = 4e-308;
    dmant1 = frexp (dv, &exp1);
    dmant2 = frexp (0.5*dv, &exp2);
    if (dmant1 != dmant2 && exp1 - exp2 != 1) {
      error = 1;
      UTwarn ("tUTxIEEE80 - Error in frexp for input %g", 0.5*dv);
    }

    /* Check if inf - inf generates NaN */
    dv = HUGE_VAL;
    yv = -HUGE_VAL;
    printf ("%g + %g = %g\n", dv, yv, dv + yv);

    /* Check tests with NaN */
    dv = sqrt (-1.0);		/* NaN */
    printf ("Value = %g\n", dv);
    printf ("%g  < 1.: %d, %g <= 1.: %d,  %g == 1.: %d\n",
	    dv, (dv  < 1.), dv, (dv <= 1.), dv, (dv == 1.));
    printf ("%g >= 1.: %d, %g  > 1.: %d\n", dv, (dv >= 1.), dv, (dv > 1.));
    printf ("%g == %g: %d\n", dv, dv, (dv == dv));

    yv = frexp (dv, &exp);
    printf ("frexp (%g): mantissa = %g, exponent = %d\n", dv, yv, exp);

    /* Check tests with infinity */
    dv = HUGE_VAL;
    printf ("Value = %g\n", dv);
    printf ("%g  < 1.: %d, %g <= 1.: %d,  %g == 1.: %d\n",
	    dv, (dv  < 1.), dv, (dv <= 1.), dv, (dv == 1.));
    printf ("%g >= 1.: %d, %g  > 1.: %d\n", dv, (dv >= 1.), dv, (dv > 1.));
    printf ("%g == %g: %d\n", dv, dv, (dv == dv));

    yv = frexp (dv, &exp);
    printf ("frexp (%g): mantissa = %g, exponent = %d\n", dv, yv, exp);

    return error;
  }


/* Test double to extended-double and back again */
  UTeIEEE80 (dv, b);
  yv = UTdIEEE80 (b);

  printf ("Input value: %g, IEEE80: ", dv);
  for (i = 0; i < 10; ++i)
    printf ("%02x", b[i]);
  printf ("\n");
  if (! (dv == yv) && ! (TNAN (dv) && TNAN (yv)))
    UThalt ("Value mismatch: converted value: %g", yv);

  return 0;
}
