/*
   Test UTgetOption

   $Id: tUTgetOption.c 1.3 1995/05/26 libtsp-V2R7a $
*/

#include <stdlib.h>		/* prototype for exit */
#include <stdio.h>
#include <libtsp.h>

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS	1	/* Normally in stdlib.h */
#endif

#define PROGRAM	"tUTgetOption"
#define VERSION	"V1R3 1995/01/07"

#define LOPT	((sizeof OptTable) / (2 * (sizeof OptTable[0])))

/* Option tables and usage message */
static const char *nullTable[] = { NULL };
static const char *OptTable[] = {
  "-d#", "--d*elay=",
  "-a", "--a*arg",
  "-h", "--h*elp",
  "-v", "--v*ersion",
  "--",
  NULL
  };
static const char Usage[] = "\
Usage: %s [options] argA argB\n\
Options:\n\
  -d D1:D2, --delay=D1:D2  Specify a delay range.\n\
  -a, --aarg               Test option.\n\
  -h, --help               Print a list of options and exit.\n\
  -v, --version            Print the version number and exit.";

int
main (argc, argv)
     int argc;
     const char *argv[];
{
  int Index;
  const char *OptArg;
  const char **optt;

  int n, nn;
  int ip;

/* Decode options */
  Index = 1;
  optt = OptTable;
  while (Index < argc) {
    ip = Index;
    n = UTgetOption (&Index, argc, argv, optt, &OptArg);
    nn = ((n + 3) / 2) - 1;	/* n = -2 ==> nn = -1 */
    switch (nn) {
    case 0:
      /* Ordinary argument */
      printf ("Ordinary argument: %s\n", OptArg);
      break;
    case 1:
    case 2:
      if (OptArg != NULL)
	printf ("String: %-12s, Option %-3d: %-12s, value: %-6s\n",
		argv[ip], n, optt[n-1], OptArg);
      else
	printf ("String: %-12s, Option %-3d: %-12s \n", argv[ip],
		n, optt[n-1]);
      break;
    case LOPT-2:
      /* Usage message */
      UTwarn (Usage, PROGRAM);
      exit (EXIT_SUCCESS);
      break;
    case LOPT-1:
      /* Version */
      printf ("%s, %s\n", PROGRAM, VERSION);
      exit (EXIT_SUCCESS);
      break;
    case LOPT:
      /* Stop interpreting options */
      printf ("Stop option scan, arguments follow\n");
      optt = nullTable;
      break;
    default:
      /* Option error */
      UThalt (Usage, PROGRAM);
      break;
    }
  }
  return 0;
}
