/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *UTgetUser (void)

Purpose:
  Get the user name

Description:
  This routine returns the user name.  The user name is determined by using
  the user id to find the name in the password database with this uid.  For
  MS-DOS, the user name is taken from the environment variables USER or
  LOGNAME.

Parameters:
  <-  char UTgetUser[]
      Pointer to a character string containing the user name.  This string is
      null terminated.  This is a pointer to an internal static storage area;
      each call to this routine overlays this storage.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.3 $  $Date: 1995/05/26 00:32:58 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTgetUser.c 1.3 1995/05/26 libtsp-V2R7a $";

#include <libtsp.h>
#include <libtsp/nucleus.h>

#ifdef _MSDOS
#  ifndef MSDOS
#    define MSDOS 1	/* For MSVC with /Za option */
#  endif
#endif

#ifdef MSDOS
#  ifdef unix
#    define PWD_USERNAME
#  endif
#endif

#ifdef PWD_USERNAME
#  include <unistd.h>		/* getuid definitions */
#  include <pwd.h>		/* password entry definitions */
#else
#  include <stdlib.h>		/* getenv */
#endif

/* The user name is at most 8 characters long on many Unix systems */
#define MAXLEN	16

char *
UTgetUser ()

{
  static char User[MAXLEN+1];

#ifdef PWD_USERNAME
  struct passwd *pwd;

/*
   Find the password entry associated with the uid.  Using environment
   variables such as USER or LOGNAME does not work consistently since not all
   shells set these environment variables for the user.
*/
  pwd = getpwuid (getuid ());
  if (pwd != NULL) {
    STcopyMax (pwd->pw_name, User, MAXLEN);
  }
  else {
    UTwarn ("UTgetUser - Error return from getpwuid");
    User[0] = '\0';
  }

#else
  char * p;

  p = getenv ("USER");
  if (p != NULL)
    STcopyMax (p, User, MAXLEN);
  else {
    p = getenv ("LOGNAME");
    if (p != NULL)
      STcopyMax (p, User, MAXLEN);
    else
      User[0] = '\0';
  }

#endif

  return User;
}
