/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void UTfree (void *ptr)

Purpose:
  Deallocate a block of memory

Description:
  This routine deallocates a block of memory allocated by UTmalloc (or malloc).

Parameters:
   -> void *ptr
      Pointer to the memory to be deallocated.  If ptr is NULL, no action is
      taken.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.12 $  $Date: 1996/05/06 20:45:02 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTfree.c 1.12 1996/05/06 libtsp-V2R7a $";

#include <errno.h>
#include <stdlib.h>		/* free */
#include <libtsp.h>

void
UTfree (ptr)

     void *ptr;

{
  if (ptr != NULL) {		/* For non-ANSI compliant versions of free() */
    errno = 0;
    free ((char *) ptr);	/* Sun CC needs cast */
    if (errno != 0)
      UTerror ("UTfree: Error detected in free()");
  }
  return;
}
