/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdecNint (const char String[], int Nmin, int Nmax, int Ival[],
                 int *N)

Purpose:
  Decode integer values (variable number)

Description:
  This routine decodes a string containing numeric data.  Multiple data items
  data items in the string are separated by commas or white-space (as defined
  by the sscanf routine).  The decoded data is stored as integer values.  If
  the number of data values in the string is less than a given minimum number
  or a decoding error is detected, an error message is printed and an error
  indication is returned.  A warning messages is printed if extra data follows
  the requested values (this data is ignored).

Parameters:
  <-  int STdecNint
      Returned value,
        0 - no error
        1 - error, too few values or data format error.
   -> const char String[]
      Input string
   -> int Nmin
      Minimum number of values to be read (may be zero)
   -> int Nmax
      Maximum number of values to be read
  <-  int Ival[]
      Array of Nmax elements used to store the decoded values.  Only the first
      N values are modified.
  <-  int *N
      Actual number of values decoded.  In the case of an error, N indicates
      the number of values successfully decoded.  In that case, N may be less
      than Nmin.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.21 $  $Date: 1996/05/31 19:07:22 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecNint.c 1.21 1996/05/31 libtsp-V2R7a $";

#include <libtsp.h>
#include <libtsp/nucleus.h>

int
STdecNint (String, Nmin, Nmax, Ival, N)

     const char String[];
     int Nmin;
     int Nmax;
     int Ival[];
     int *N;

{
  return (STdecNval (String, Nmin, Nmax, 'I', (void *) Ival, N));
}
