/*
   Test SPrFFT

   $Id: tSPrFFT.c 1.1 1995/01/26 libtsp-V2R7a $
*/

#include <stdio.h>
#include <libtsp.h>

#define NMAX	128

int
main (argc, argv)

     int argc;
     char *argv[];

{
  int i;
  int N;
  float x[NMAX];
  float xd[NMAX];
  float yd[NMAX];
  float xs[NMAX];

  N = argc - 1;
  if (N >= NMAX)
    return 1;

  for (i = 0; i < N; ++i)
    sscanf (argv[i+1], "%g", &xs[i]);
  VRfCopy (xs, x, N);
  VRfCopy (xs, xd, N);
  VRfZero (yd, N);

  VRfPrint (stdout, "x input:", x, N);
  SPrFFT (x, N, 1);
  VRfPrint (stdout, "x output:", x, N);
  SPcFFT42 (xd, yd, N, 1);
  for (i = 1; i < N/2; ++i)
    xd[i+N/2] = yd[i];
  VRfPrint (stdout, "x output (direct computation):", xd, N);
  SPrFFT (x, N, -1);
  VRfPrint (stdout, "x input (reprise):", x, N);

  return 0;
}
