/*
   Test SPfDCT

   $Id: tSPfDCT.c 1.2 1995/05/26 libtsp-V2R7a $
*/

#include <math.h>
#include <stdio.h>
#include <libtsp.h>

#define NMAX		128
#ifndef PI		/* Sometimes in math.h */
#  define PI		3.14159265358979323846
#endif
#define SQRT2		1.41421356237309504880

int
main (argc, argv)

     int argc;
     char *argv[];

{
  int i, n, k;
  int N;
  float x[NMAX];
  float xd[NMAX];
  float xs[NMAX];

  N = argc - 1;
  if (N >= NMAX)
    return 1;

  for (i = 0; i < N; ++i)
    sscanf (argv[i+1], "%g", &xs[i]);
  VRfCopy (xs, x, N);
  VRfCopy (xs, xd, N);

  VRfPrint (stdout, "x input:", x, N);
  SPfDCT (x, N, 1);
  VRfPrint (stdout, "x output:", x, N);

/* direct computation */
  for (k = 0; k < N; ++k) {
    xd[k] = 0.0;
    for (n = 0; n < N; ++n)
      xd[k] += xs[n] * cos ((PI * ((2*n+1)*k)) / (2*N));
    if (k != 0)
      xd[k] *= SQRT2;
  }
  VRfPrint (stdout, "x output (direct computation):", xd, N);
  SPfDCT (x, N, -1);
  VRfPrint (stdout, "x input (reprise):", x, N);

  return 0;
}
