/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  double MSslopeMC (int k, const float x[], const float y[], int N)

Purpose:
  Calculate a slope at a point (for fitting a cubic))


Description:
  This routine finds a slope value that can be used to generate piecewise
  monotone cubic interpolants to the given data values.

  The derivatives at the reference points are determined by averaging the
  inverse slopes of the straight line segments joining the reference points to
  the left and right of a given reference point.  These slope values are
  changed if necessary to guarantee that the cubic interpolants are monotonic
  between reference points.  For instance a reference point is a local extremum
  (the slopes of the straight line segments joining reference points on either
  side of it are of different sign), the slope at that reference point is set
  to zero.  The slope of end points is determined from the slopes of the two
  straight lines joining the reference points beside the end point.

Parameters:
  <-  double MSslopeMC
      Slope at point k
   -> int k
      Reference point at which the derivative is to be determined (0 to N-1)
   -> const float x[]
      Abscissa values for the reference points.  These values must be in
      increasing order.
   -> const float y[]
      Ordinate values for the reference points
   -> int N
      Number of reference points.  Only values in the neighborhood of
      reference point k will be used to determine the derivative.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.7 $  $Date: 1996/04/17 19:04:18 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: MSslopeMC.c 1.7 1996/04/17 libtsp-V2R7a $";

#include <libtsp.h>
#include <libtsp/nucleus.h>

double
MSslopeMC (k, x, y, N)

     int k;
     const float x[];
     const float y[];
     int N;

{
  double val;

/* Middle point */
  if (k > 0 && k < N - 1)
    val = MSslMidMC ((double) (x[k] - x[k-1]), (double) (x[k+1] - x[k]),
                     (double) (y[k] - y[k-1]), (double) (y[k+1] - y[k]));

/* End point: beginning */
  else if (k == 0 && N > 2)
    val = MSslEndMC ((double) (x[1] - x[0]), (double) (x[2] - x[1]),
		     (double) (y[1] - y[0]), (double) (y[2] - y[1]));

/* End point: end */
  else if (k == N - 1 && N > 2)
    val = MSslEndMC ((double) (x[k] - x[k-1]), (double) (x[k-1] - x[k-2]),
		     (double) (y[k] - y[k-1]), (double) (y[k-1] - y[k-2]));

/* Special case: linear interpolation */
  else if (N == 2 && (k == 0 || k == 1))
    val = MSslMidMC ((double) (x[1] - x[0]), (double) (x[1] - x[0]),
		     (double) (y[1] - y[0]), (double) (y[1] - y[0]));

/* Single reference point */
  else if (k == 0 && N == 1)
    val = 0.0;

  else
    UThalt ("MSslopeMC: Invalid input index %d, not in range [0, %d]",
		 k, N - 1);

  return val;
}
