/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void MSconvCof (float x, int Nx, float y, int Ny, float z)

Purpose:
  Convolve the coefficients of two arrays

Description:
  This routine convolves the coefficients of two arrays.  If the coefficients
  are considered to be polynomial coefficients, this operation is equivalent to
  polynomial multiplication.  The operation can be summarized as follows.
            Nx
    z[i] = SUM x[k] y[k-i]
           k=0
  This simple form of the sum assumes that y[i] is zero for i < 0 and i >= Ny.
  In the implementation, the sum is modified to include only terms involving
  y[i] for the proper interval of i.  The number of coefficients in the array z
  is Nx+Ny-1.  The computation is arranged such that the input array x and the
  output array z can be the same, i.e. the output values can overlay the input
  values.

Parameters:
   -> float x
      Input array of float coefficients (Nx values)\
   -> int Nx
      Number of coefficients in x
   -> float y
      Input array of float coefficients (Ny values)
   -> int Ny
      Number of coefficients in y
  <-  float z
      Output array of Nx+Ny-1 coefficients representing the covolution of the
      coefficients of x and y.  The arrya x and the array z can be the same
      array.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.4 $  $Date: 1996/07/05 14:46:11 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: MSconvCof.c 1.4 1996/07/05 libtsp-V2R7a $";

#include <libtsp.h>

#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define MAXV(a, b)	(((a) > (b)) ? (a) : (b))

void
MSconvCof (x, Nx, y, Ny, z)

     const float x[];
     int Nx;
     const float y[];
     int Ny;
     float z[];

{
  int m;
  int k, kl, ku, kll;
  int Nz;
  double sum;

  Nz = Nx + Ny - 1;
  kll = Ny - 1;
  for (m = Nz - 1; m >= 0; --m) {
    sum = 0.0;
    kl = MAXV (0, kll);		/* max (0, m-Nx+1) */
    ku = MINV (Ny - 1, m);
    for (k = kl; k <= ku; ++k)
      sum = sum + (double) y[k] * x[m-k];
    z[m] = sum;
    --kll;
  }
  return;
}
