/*------------ Telecommunications & Signal Processing Lab -------------
                         McGill University

Routine:
  int FLexist (const char Fname[])

Purpose:
  Determine if a file exists

Description:
  This subroutine determines if a file specified by its filename exists and is
  a regular file (not a directory or a device).

Parameters:
  <-  int FLexist
      Return value, 1 for an existing regular file, 0 otherwise
   -> const char Fname[]
      File name

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.2 $  $Date: 1995/05/20 10:10:31 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLexist.c 1.2 1995/05/20 libtsp-V2R7a $";

#include <sys/types.h>
#include <sys/stat.h>
#include <libtsp/nucleus.h>

#ifdef _MSDOS
#  ifndef MSDOS
#    define MSDOS	1	/* For MSVC with /Za option */
#  endif
#endif

#ifdef MSDOS
#  ifndef unix
#    define USE__NAME
#  endif
#endif

#ifdef USE__NAME
#  define STAT	_stat
#  ifndef S_IFREG
#    define S_IFREG	_S_IFREG
#  endif
#  ifndef S_IFMT
#    define S_IFMT	_S_IFMT
#  endif
#else
#  define STAT	stat
#endif

int
FLexist (Fname)

     const char Fname[];

{
  struct STAT Fstat;
  int status;

  status = STAT (Fname, &Fstat);
  if (status == 0 && (Fstat.st_mode & S_IFMT) == S_IFREG)
    return 1;
  else
    return 0;
}
