/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  char *FLfileDate (FILE *fp, int format)

Purpose:
  Find the last modification time for an open file

Description:
  This routine finds the last modified time for a file specified by the file
  pointer to an open file.  This time is returned as a date/time string in one
  of a number of standard formats.

   Format  Example                      time zone    length
     0    Sun Sep 16 01:03:52 1973      local time   24 + null
     1    Sun Sep 16 01:03:52 EST 1973  local time   28* + null
     2    1994/01/23 09:59:53 EST       local time   23* + null
     3    1994/01/23 14:59:53 UTC       GMT          23 + null
               (*) the time zone length can vary

Parameters:
  <-  char *FLfileDate
      Pointer to a character string for the date and time.  This string is null
      terminated.  This string is at most 29 characters long, not including the
      terminating null character.  This is a pointer to an internal static
      storage area; each call to this routine overlays this storage.
   -> FILE *fp
      File pointer for the file
   -> int format
      Date / time format code, taking on values from 0 to 3

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.10 $  $Date: 1995/05/20 09:59:00 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLfileDate.c 1.10 1995/05/20 libtsp-V2R7a $";

#include <stdio.h>		/* #define for fileno */
#include <sys/types.h>
#include <sys/stat.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

#ifdef _MSDOS
#  ifndef MSDOS
#    define MSDOS 1	/* For MSVC with /Za option */
#  endif
#endif

#ifdef MSDOS
#  ifndef unix
#    define USE__NAME
#  endif
#endif

#ifdef USE__NAME
#  define FILENO	_fileno
#  define FSTAT		_fstat
#  define STAT		_stat
#else
#  define FILENO	fileno
#  define FSTAT		fstat
#  define STAT		stat
#endif

#define MAXDATE	29

char *
FLfileDate (fp, format)

     FILE *fp;
     int format;

{
  struct STAT Fstat;
  int status;
  static char Datetime[MAXDATE+1];

  status = FSTAT (FILENO (fp), &Fstat);
  if (status == 0)
    STcopyMax (UTctime (&Fstat.st_mtime, format), Datetime, MAXDATE);
  else
    Datetime[0] = '\0';

  return Datetime;
}
