/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void FIwinHamm (float win[], int N, double a)

Purpose:
  Generate a Hamming window

Description:
  A Hamming window is specified by the following equation,
                            2 pi i
    win[i] = (1-a) - a cos (------) , i = 0, ..., N-1
                              N-1

  The parameter a is 0.46 for a conventional Hamming window, 0.5 for a full
  raised-cosine window, and 0 for a rectangular window.  Note that for the
  full raised-cosine window, the two end points of the window are zero.

  Define the effective window length as the length of a rectangular window
  which has the same energy as the Hamming window.  Then the effective length
  of the Hamming window is
    L = N - 2a(N+1) + a^2 (3N+5)/2, for N > 3.

Parameters:
  <-  float win[]
      Array containing the window values
   -> int N
      Number of window values
   -> double a
      Window parameter; a=0.46 for a conventional Hamming window, a=0.5 for a
      full raised-cosine window, a=0 for a rectangular window.  The window is
      non-negative for 0 <= a <= 0.5.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.13 $  $Date: 1996/05/30 13:19:49 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: FIwinHamm.c 1.13 1996/05/30 libtsp-V2R7a $";

#include <math.h>
#include <libtsp.h>

#ifndef PI		/* Sometimes in math.h */
#define PI		3.14159265358979323846
#endif

void
FIwinHamm (win, N, a)

     float win[];
     int N;
     double a;

{
  int i, k;
  double w;

  if (N > 1)
    w = PI / (N - 1);
  else
    w = 0.0;

  for (i = 0, k = N-1; i <= k; ++i, --k) {
    win[i] = (1.0 - a) + a * cos (w * (2 * i - (N - 1)));
    win[k] = win[i];
  }

  return;
}
