/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void AFwriteTA (AFILE *AFp, float Fbuff[], int Nval)

Purpose:
  Write text data to an audio file (float input values)

Description:
  This routine writes a specified number of samples to an audio file.  The
  input to this routine is a buffer of float values. The output file contains
  the text represenation of the data values, one value to a line.  The file
  must have been opened using subroutine AFopenWrite.

Parameters:
   -> AFILE *AFp
      Audio file pointer for an audio file opened by AFopenWrite
   -> float Fbuff[]
      Array of floats with the samples to be written
   -> int Nval
      Number of samples to be written

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.2 $  $Date: 1996/05/07 11:56:10 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFwriteTA.c 1.2 1996/05/07 libtsp-V2R7a $";

#include <stdio.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>

void
AFwriteTA (AFp, Fbuff, Nval)

     AFILE *AFp;
     const float Fbuff[];
     int Nval;

{
  int i;

  for (i = 0; i < Nval; ++i)
    fprintf (AFp->fp, "%g\n", AFp->ScaleF * Fbuff[i]);

  AFp->Isamp += Nval;
  AFp->Nsamp += Nval;

  return;
}
