/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void AFwriteData (AFILE *AFp, float Fbuff[], int Nval)

Purpose:
  Write data to an audio file (float input values)

Description:
  This routine writes a specified number of samples to an audio file.  The
  float input data is converted to the audio file data representation.  The
  file data representation is set on opening the file with routine AFopenWrite.
  This routine writes data sequentially to the file.

Parameters:
   -> AFILE *AFp
      Audio file pointer for an audio file opened by AFopenWrite
   -> float Fbuff[]
      Array of floats with Nval samples
   -> int Nval
      Number of samples to be written

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.11 $  $Date: 1996/08/13 17:54:55 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFwriteData.c 1.11 1996/08/13 libtsp-V2R7a $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>

/* Writing routines */
static void
(*AF_Write[NFD])p_((AFILE *AFp, const float Fbuff[], int Nval)) =
  {
    NULL,
    AFwriteMulaw,
    AFwriteAlaw,
    AFwriteU1,
    AFwriteI1,
    AFwriteI2,
    AFwriteF4,
    AFwriteTA
  };

void
AFwriteData (AFp, Fbuff, Nval)

     AFILE *AFp;
     float Fbuff[];
     int Nval;

{
/* Check the operation  */
  if (AFp->Op != FO_WO)
    UThalt ("AFwriteData: File not opened for write");

/* Transfer data to the audio file */
  (*AF_Write[AFp->Format]) (AFp, Fbuff, Nval);

  return;
}
