/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void AFclose (AFILE *AFp)

Purpose:
  Close an audio file

Description:
  This routine closes an audio file opened with AFopenRead or AFopenWrite.  If
  the file was opened for write, the file header is updated with the number of
  samples in the file.  For both read and write operations, the file format
  parameters associated with the file pointer are deallocated and the file is
  closed.

  If the file was opened for write, the number of overloads detected during
  write operations is reported.

Parameters:
   -> AFILE *AFp
      Audio file pointer for the audio file

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.24 $  $Date: 1996/08/13 18:00:00 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFclose.c 1.24 1996/08/13 libtsp-V2R7a $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>

static const int Lenb[NFD] = {
  0,
  FDL_MULAW8,
  FDL_ALAW8,
  FDL_UINT8,
  FDL_INT8,
  FDL_INT16,
  FDL_FLOAT32,
  FDL_TEXT
};

void
AFclose (AFp)

     AFILE *AFp;

{
/* Update the header for output files */
  if (AFp->Op == FO_WO) {
    switch (AFp->Ftype) {
    case FT_AFSP:
      AFupdAUhead (AFp);
      break;
    case FT_WAVE:
      AFupdWVhead (AFp);
      break;
    case FT_AIFF_C:
      AFupdAIhead (AFp);
      break;
    case FT_NH:
      break;
    default:
      UThalt ("AFclose: Invalid file type");
      break;
    }

    /* Check for Nsamp / Nchan / sample size consistency */
    if (AFp->Format <= 0 || AFp->Format >= NFD)
      UThalt ("AFclose: Invalid data format code");
    if (Lenb[AFp->Format] > 0 &&
	(AFp->End - AFp->Start) % (Lenb[AFp->Format] * AFp->Nchan) != 0)
      UTwarn ("AFclose - No. samples inconsistent with no. channels");
  }

  else if (AFp->Op != FO_RO)
    UThalt ("AFclose: File not open");

/* Report the number of overloads */
  if (AFp->Novld > 0L)
    UTwarn ("AFclose - %ld data values clipped", AFp->Novld);

/* Close the file */
  fclose (AFp->fp);

/* Reset some AFILE structure values */
  AFp->fp = NULL;
  AFp->Op = FO_NONE;

/* Deallocate the AFILE structure */
  UTfree ((void *) AFp);

  return;
}
