/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  WVpar.h

Description:
  Declarations for RIFF WAVE file headers

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.7 $  $Date: 1996/09/04 21:50:34 $

----------------------------------------------------------------------*/

#ifndef WVpar_h_
#define WVpar_h_

#include <libtsp/UTtypes.h>		/* typedef for uint2_t, etc */


#define WV_FMT_CKSIZE	16
#define WV_LHMIN	(8 + 4 + 8 + WV_FMT_CKSIZE + 8)

/* File magic in file byte order */
#define FM_RIFF		"\122\111\106\106"	/* "RIFF" */
#define FM_WAVE		"\127\101\126\105"	/* "WAVE" */

#define WAVE_FORMAT_UNKNOWN		(0x0000)
#define WAVE_FORMAT_PCM			(0x0001) 
#define WAVE_FORMAT_ADPCM		(0x0002)
#define WAVE_FORMAT_IBM_CVSD		(0x0005)
#define WAVE_FORMAT_ALAW		(0x0006)
#define WAVE_FORMAT_MULAW		(0x0007)
#define WAVE_FORMAT_OKI_ADPCM		(0x0010)
#define WAVE_FORMAT_DVI_ADPCM		(0x0011)
#define WAVE_FORMAT_IMA_ADPCM		(WAVE_FORMAT_DVI_ADPCM)
#define WAVE_FORMAT_DIGISTD		(0x0015)
#define WAVE_FORMAT_DIGIFIX		(0x0016)
#define WAVE_FORMAT_YAMAHA_ADPCM	(0x0020)
#define WAVE_FORMAT_SONARC		(0x0021)
#define WAVE_FORMAT_DSPGROUP_TRUESPEECH	(0x0022)
#define WAVE_FORMAT_ECHOSC1		(0x0023)
#define WAVE_FORMAT_AUDIOFILE_AF36	(0x0024)
#define WAVE_FORMAT_APTX		(0x0025)
#define WAVE_FORMAT_AUDIOFILE_AF10	(0x0026)
#define WAVE_FORMAT_DOLBY_AC2		(0x0030)
#define IBM_FORMAT_MULAW		(0x0101)
#define IBM_FORMAT_ALAW			(0x0102)
#define IBM_FORMAT_ADPCM		(0x0103)
#define WAVE_FORMAT_CREATIVE_ADPCM	(0x0200)

#define WV_SF_MULAW	(1.)
#define WV_SF_ALAW	(1.)
#define WV_SF_PCM8	(128.)
#define WV_SF_PCM16	(1.)

struct WV_CkPreamb {
  char ckid[4];
  uint4_t cksize;
};

struct WV_PCMformat {
  uint2_t FormatTag;
  uint2_t Channels;
  uint4_t SamplesPerSec;
  uint4_t AvgBytesPerSec;
  uint2_t BlockAlign;
  uint2_t BitsPerSample;
};

#endif	/* WVpar_h_ */
