/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  libtsp.h

Description:
  Function prototypes and declarations for the TSP library routines

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 2.60 $  $Date: 1996/07/16 14:00:26 $

----------------------------------------------------------------------*/

#ifndef libtsp_h_
#define libtsp_h_

#include <stdio.h>	/* typedef for FILE */
			/* defines FILENAME_MAX */
			/* stdio.h also defines NULL, size_t */

/* For non-ANSI headers */
#ifndef FILENAME_MAX	/* normally in stdio.h */
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

/* For HPUX */
#ifdef hpux
#  undef FILENAME_MAX	/* defined in stdio.h as 14 */
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

/* Audio file parameter structure */
#ifndef	AFILE_t_
#  define AFILE_t_
typedef struct AF_filepar AFILE;	/* Audio file parameters */
#endif

#ifdef __STDC__
#  define p_(params)	params
#else
#  define p_(params)	()
#  define const				/* Define const for K&R C */
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ----- AF Prototypes ----- */
void
AFclose p_((AFILE *AFp));
char *
AFgetHinfo p_((void));
AFILE *
AFopenRead p_((const char Fname[], long int *Nsamp, long int *Nchan,
	       float *Sfreq, FILE *fpout));
AFILE *
AFopenWrite p_((const char Fname[], int Fformat, long int Nchan,
		double Sfreq, FILE *fpout));
int
AFreadData p_((AFILE *AFp, long int offs, float Fbuff[], int Nreq));
char *
AFreadHinfo p_((AFILE *AFp, int *Ninfo));
void
AFsetHinfo p_((const char String[]));
void
AFsetNH p_((const char String[]));
void
AFwriteData p_((AFILE *AFp, float Fbuff[], int Nval));

/* ----- FI Prototypes ----- */
void
FIKaiserLPF p_((float h[], int N, double Fc, double alpha));
void
FIbiquad p_((const float x[], float y[], int Nout, const float h[]));
void
FIconvSI p_((const float x[], float y[], int Nout, const float h[], int Ncof,
	     int mr, int Nsub, int Ir));
void
FIconvol p_((const float x[], float y[], int Nout, const float h[], int Ncof));
void
FIdeem p_((double a, float *Fmem, const float x[], float y[], int Nout));
void
FIfiltAP p_((const float x[], float y[], int Nout, const float p[], int Np));
void
FIfiltIIR p_((const float x[], float y[], int Nout, const float h[][5],
	      int Nsec));
void
FIpreem p_((double a, float *Fmem, const float x[], float y[], int Nout));
int
FIreadFilt p_((const char Fname[], int MaxNcof, float h[], int *Ncof,
	       FILE *fpout));
void
FIwinHCos p_((float win[], double T1, double T2, double T3, double a));
void
FIwinHamm p_((float win[], int N, double a));
void
FIwinKaiser p_((float win[], int N, double alpha));
void
FIwinRCos p_((float win[], int N, int Nadv));

/* ----- FL Prototypes ----- */
void
FLbackup p_((const char Fname[]));
int
FLbaseName p_((const char Fname[], char Bname[]));
char *
FLdate p_((const char Fname[], int format));
int
FLdefName p_((const char Fi[], const char Fd[], char Fo[]));
int
FLdirName p_((const char Fname[], char Bname[]));
int
FLexpHome p_((const char Fname[], char Ename[]));
int
FLextName p_((const char Fname[], char Ext[]));
int
FLfReadData p_((const char Fname[], int MaxNval, float x[]));
void
FLfWriteData p_((const char Fname[], const float x[], int N));
char *
FLfileDate p_((FILE *fp, int format));
int
FLfullName p_((const char Fname[], char Fullname[]));
char *
FLgetLine p_((FILE *fp));
char *
FLgetRec p_((FILE *fp, const char cc[], int echo));
int
FLhomeDir p_((const char User[], char Home[]));
int
FLpathList p_((const char Fi[], const char Dlist[], char Fo[]));
int
FLpreName p_((const char Fname[], char Pname[]));
void
FLprompt p_((const char Prompt[]));
char *
FLreadLine p_((const char Prompt[]));

/* ----- FN Prototypes ----- */
double
FNbessI0 p_((double x));
double
FNevChebP p_((double x, const float c[], int N));
long int
FNgcd p_((long int u, long int v));
int
FNiLog2 p_((int a));
double
FNsinc p_((double x));

/* ----- MA Prototypes ----- */
double **
MAdAllocMat p_((int Nrow, int Ncol));
void
MAdFreeMat p_((double *A[]));
void
MAdPrint p_((FILE *fp, const char Header[], const double *A[], int Nrow,
	     int Ncol));
float **
MAfAllocMat p_((int Nrow, int Ncol));
int
MAfChSolve p_((const float *A[], const float b[], float x[], int N));
void
MAfFreeMat p_((float *A[]));
void
MAfPrint p_((FILE *fp, const char Header[], const float *A[], int Nrow,
	     int Ncol));
float **
MAfSubMat p_((const float *A[], int n, int m, int Nrow));
double
MAfSyBilin p_((const float *A[], const float x[], const float y[], int N));
double
MAfSyQuad p_((const float *A[], const float x[], int N));
double
MAfTpQuad p_((const float R[], const float x[], int N));
int
MAfTpSolve p_((const float R[], const float g[], float c[], int N));
void
MAiPrint p_((FILE *fp, const char Header[], const int *A[], int Nrow,
	     int Ncol));
void
MAlPrint p_((FILE *fp, const char Header[], const long int *A[], int Nrow,
	     int Ncol));


/* ----- MS Prototypes ----- */
void
MSconvCof p_((const float x[], int Nx, const float y[], int Ny, float z[]));
double
MSdNint p_((double x));
double
MSfGaussRand p_((double rms));
double
MSfUnifRand p_((void));
int
MSiCeil p_((int n, int m));
int
MSiFloor p_((int n, int m));
int
MSiPower p_((int i, int n));
void
MSintLin p_((const float x[], const float y[], int N, const float xi[],
	     float yi[], int Ni));
void
MSintMC p_((const float x[], const float y[], int N, const float xi[],
	    float yi[], int Ni));
long int
MSlCeil p_((long int n, long int m));
long int
MSlFloor p_((long int n, long int m));
void
MSrandSeed p_((int seed));
void
MSratio p_((double Val, long int *N, long int *D, double tol, long int MaxN,
	    long int MaxD));

/* ----- SP Prototypes ----- */
void
SPautoc p_((const float x[], int Nx, float cor[], int Nt));
void
SPcFFT42 p_((float x[], float y[], int N, int Ifn));
void
SPcepXpc p_((const float cep[], float pc[], int Np));
void
SPcorBWexp p_((double bwexp, const float rxx[], float rxxb[], int Nc));
double
SPcorFilt p_((double Ed, const float rxx[], const float r[], float h[],
              int N));
double
SPcorFmse p_((const float h[], double Ed, const float rxx[], const float r[],
	      int N));
double
SPcorPmse p_((const float pc[], const float rxx[], int Np));
double
SPcorXpc p_((const float rxx[], float pc[], int Np));
double
SPcovCXpc p_((const float *Cov[], float pc[], int Np));
double
SPcovFilt p_((double Ed, const float *R[], const float r[], float h[], int N));
double
SPcovFmse p_((const float h[], double Ed, const float *R[], const float r[],
	      int N));
double
SPcovLXpc p_((const float *Cov[], float pc[], int Np));
double
SPcovMXpc p_((const float *Cov[], float pc[], int Np));
double
SPcovPmse p_((const float pc[], const float *Cov[], int Np));
double
SPcovXpc p_((const float *Cov[], float pc[], int Np));
void
SPcovar p_((const float x[], int Nx, float *Cov[], int Np));
void
SPecXpc p_((const float ec[], float pc[], int Np));
void
SPfDCT p_((float x[], int N, int Ifn));
double
SPlpcISdist p_((const float pc1[], const float pc2[], int Np));
double
SPlpcLSdist p_((const float pc1[], const float pc2[], int Np, int Ncep));
void
SPlsfXpc p_((const float lsf[], float pc[], int Np));
void
SPpcBWexp p_((double bwexp, const float pc[], float pcb[], int Np));
void
SPpcXcep p_((const float pc[], int Np, float cep[], int Ncep));
double
SPpcXcor p_((const float pc[], int Np, float rxx[], int Ncor));
void
SPpcXec p_((const float pc[], float ec[], int Np));
void
SPpcXlsf p_((const float pc[], float lsf[], int Np));
double
SPpcXrc p_((const float pc[], float rc[], int Np));
int
SPquant p_((double x, const float Xq[], int Nreg));
void
SPrFFT p_((float x[], int N, int Ifn));
double
SPrcXpc p_((const float rc[], float pc[], int Np));

/* ----- ST Prototypes ----- */
int
STcatMax p_((const char Si[], char So[], int Maxchar));
int
STcopyMax p_((const char Si[], char So[], int Maxchar));
int
STcopyNMax p_((const char Si[], char So[], int N, int Maxchar));
int
STdec1double p_((const char String[], double *Dval));
int
STdec1float p_((const char String[], float *Fval));
int
STdec1int p_((const char String[], int *Ival));
int
STdec1long p_((const char String[], long int *Lval));
int
STdecDfrac p_((const char String[], double *Dval1, double *Dval2));
int
STdecIfrac p_((const char String[], int *Ival1, int *Ival2));
int
STdecIrange p_((const char String[], int *Ival1, int *Ival2));
int
STdecLrange p_((const char String[], long int *Lval1, long int *Lval2));
int
STdecNdouble p_((const char String[], int Nmin, int Nmax, double Dval[],
		 int *N));
int
STdecNfloat p_((const char String[], int Nmin, int Nmax, float Fval[],
		int *N));
int
STdecNint p_((const char String[], int Nmin, int Nmax, int Ival[],
	      int *N));
int
STdecNlong p_((const char String[], int Nmin, int Nmax, long int Lval[],
	       int *N));
char *
STfindToken p_((const char String[], const char Delims[],
		const char Quotes[], char Token[], int WSFlag,
		int Maxchar));
int
STkeyMatch p_((const char String[], const char *KeyTable[]));
int
STkeyXpar p_((const char Line[], const char Delims[], const char Quotes[],
	      const char *Keytable[], char Par[]));
int
STunQuote p_((const char Si[], const char Quotes[], char So[]));

/* ----- UT Prototypes ----- */
char *
UTdate p_((int format));
void
UTerror p_((const char Errmsg[], ...));
void
UTfree p_((void *ptr));
int
UTgetOption p_((int *Index, const int argc, const char *argv[],
		const char *OptTable[], const char **OptArg));
char *
UTgetProg p_((void));
void
UThalt p_((const char Errmsg[], ...));
void *
UTmalloc p_((int size));
void *
UTrealloc p_((void *ptr, int size));
void
UTsetProg p_((const char Program[]));
char *
UTuserName p_((void));
void
UTwarn p_((const char Warnmsg[], ...));

/* ----- VR Prototypes ----- */
void
VRdPrint p_((FILE *fp, const char Header[], const double x[], int N));
void
VRdZero p_((double y[], int N));
void
VRfAdd p_((const float x1[], const float x2[], float y[], int N));
void
VRfAmpldB p_((const float ampl[], float dB[], int N));
int
VRfCheckSym p_((const float x[], int N));
void
VRfCopy p_((const float x[], float y[], int N));
double
VRfDiffSq p_((const float x1[], const float x2[], int N));
double
VRfDotProd p_((const float x1[], const float x2[], int N));
void
VRfLog10 p_((const float x[], float y[], int N));
double
VRfMax p_((const float x[], int N));
double
VRfMin p_((const float x[], int N));
void
VRfMult p_((const float x1[], const float x2[], float y[], int N));
void
VRfPow10 p_((const float x[], float y[], int N));
void
VRfPrint p_((FILE *fp, const char Header[], const float x[], int N));
void
VRfRev p_((const float x[], float y[], int N));
void
VRfScale p_((double a, const float x[], float y[], int N));
void
VRfSet p_((double a, float y[], int N));
void
VRfShift p_((float x[], int Nkeep, int Nshift));
void
VRfSubt p_((const float x1[], const float x2[], float y[], int N));
double
VRfSum p_((const float x[], int N));
void
VRfZero p_((float y[], int N));
void
VRiPrint p_((FILE *fp, const char Header[], const int x[], int N));
void
VRiZero p_((int y[], int N));
void
VRlPrint p_((FILE *fp, const char Header[], const long int x[], int N));

#ifdef __cplusplus
}
#endif

#endif /* libtsp_h_ */
