*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE WRTMPH (NAMEFL, H, NTAP, NN, NF, FRSTP, WTSTP)
*
*
* Purpose:
*     Write a Nyquist filter file (factored filter)
*
*
* Description:
*     This subroutine writes a coefficient file for a minimum phase
*     factor of a Nyquist filter. The coefficient file is created and
*     written to as unit number 3.  The data written to the file
*     includes a header containing the design specification.  This is
*     followed by the filter coefficients.  The file is then closed.
*     The file name is also printed.
*
*
* Parameters:
* C ->  NAMEFL - File name for the coefficient file.  If the name is
*                all blank, no file is written.
* R ->  H      - Array of coefficients (NTAP values)
* I ->  NTAP   - Number of filter coefficients
* I ->  NN     - Zero crossing interval
* I ->  NF     - Number of stopband points
* R ->  FRSTP  - Array of normalized stopband frequencies. These values
*                must be in increasing order.
* R ->  WTSTP  - Array of desired stopband weightings
*
*
* Routines required:
*     LENSTR - Find the length of a whitespace terminated string
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:38:57 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE WRTMPH (NAMEFL, H, NTAP, NN, NF, FRSTP, WTSTP)


      INTEGER ICFF
      PARAMETER (ICFF=3)

      CHARACTER*(*) NAMEFL,FULLNM*255

      INTEGER NTAP,NN,NF
      INTEGER NC,I,NCHR
      INTEGER LENSTR

      REAL H(0:NTAP-1),FRSTP(NF),WTSTP(NF)


      NC=LENSTR(NAMEFL)
      IF (NC.GT.0) THEN
        OPEN (UNIT=ICFF,FILE=NAMEFL(1:NC),STATUS='NEW')
        INQUIRE (UNIT=ICFF,NAME=FULLNM)

        WRITE (UNIT=ICFF,FMT=3000)
     -    'Minimum Phase Factor of a Nyquist Filter'
        WRITE (UNIT=ICFF,FMT=3100) NN
        WRITE (UNIT=ICFF,FMT=3200)
        DO 120 I=1,NF
          WRITE (UNIT=ICFF,FMT=3300) FRSTP(I),WTSTP(I)
 120    CONTINUE
        WRITE (UNIT=ICFF,FMT=3400) (H(I),I=0,NTAP-1)

        CLOSE (UNIT=ICFF)
        NCHR=LENSTR(FULLNM)
        WRITE (UNIT=*,FMT=2000) FULLNM(1:NCHR)
      END IF


      RETURN

 2000 FORMAT (/' Coefficient file: ',A)
 3000 FORMAT ('!FIR - ',A)
 3100 FORMAT ('! Zero crossing interval:',I4)
 3200 FORMAT ('! Stopband:  Frequency  Weight')
 3300 FORMAT ('!',F20.5,1PG12.4)
 3400 FORMAT (1PE15.6,1PE15.6,1PE15.6,1PE15.6,1PE15.6)

      END
