*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*       SUBROUTINE RDLINE (PROMPT, LINE, NCHR, ISRC)
*
*
* PURPOSE:
*       This subroutine retrieves a line of input.
*
*
* DESCRIPTION:
*       This subroutine reads lines of input. It first tries to
*	retrieve input from the command line invoking the program.
*	If unsuccessful it retrieves input from the standard input.
*	If the input is a terminal, prompt strings are printed on
*	the terminal.
*
*       An end-of-file condition is returned when control-Z is entered
*       for terminal input. If the standard input has been redirected to
*       a file, an end-of-file occurs at the end of the file.
*
*
* PARAMETERS:
* C ->  PROMPT - Character string used as a prompt
* C <-  LINE   - Character string for the input line. If the length of
*                line is insufficient for input line, the input line
*                is truncated. For input lines shorter than the length
*                of line, line is padded out with blanks.
* C <-  NCHR   - Number of characters in line not including any blanks
*                used to pad out LINE. NCHR can be zero. NCHR is set
*                to 0 for an end-of-file.
* I <-  ISRC   - Source of the input line.
*                  1 - command line
*                  2 - standard input (terminal)
*                A negative value for ISRC indicates an end-of-file.
*                 -1 - end-of-file
*
*
* ROUTINES REQUIRED:
*       LIB$GET_FOREIGN - System routine to read a foreign command line
*       LINEIN - Read a line of input
*       PSYMSG - Print a system message
*
*
* AUTHOR / MAINTAINED BY:
*       P. Kabal
*
*
* DATE CREATED:
*       1981/06/16  GTLINE / GETCML
*
*
* UPDATES:
*       1989/02/03
*
*
*---------------------------INRS-Telecommunications---------------------------

        SUBROUTINE RDLINE (PROMPT, LINE, NCHR, ISRC)


        INTEGER COML,TERM
        PARAMETER (COML=1,TERM=2)

        CHARACTER*(*) PROMPT,LINE

	INTEGER NCHR,ISRC
	INTEGER ISRCI,ISTAT,IEOF
        INTEGER*2 LLEN
	INTEGER LIB$GET_FOREIGN

        SAVE ISRCI
        DATA ISRCI/0/


100     IF (ISRCI.EQ.0) THEN

* Get a foreign command line
          ISRCI=COML
          ISTAT=LIB$GET_FOREIGN(LINE,,LLEN)
          NCHR=LLEN
          IF (.NOT.ISTAT) CALL PSYMSG(ISTAT)
          IF (NCHR.EQ.0) GO TO 100

        ELSE

* Get an input line from the standard input
          ISRCI=TERM
          CALL LINEIN(PROMPT,LINE,NCHR,IEOF)
          IF (IEOF.LT.0) THEN
            ISRCI=-1
            NCHR=0
          END IF

        END IF

* Return the source of the line
        ISRC=ISRCI


        RETURN

        END
