*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*	SUBROUTINE GETIMG (IMAGNM, NC)
*
*
* PURPOSE:
*	This routine returns the image name.
*
*
* DESCRIPTION:
*	This routine returns a string containing the image name that
*	is currently running. This string contains only the name
*	portion of the full image name.
*
*
* PARAMETERS:
* C <-	IMAGNM - Output string
* I <-	NC     - Number of characters set in IMAGNM
*
*
* ROUTINES REQUIRED:
*	FNSCAN - Return file name components
*	LIB$GETJPI - Get job process information
*
*
* AUTHOR / MAINTAINED BY:
*	P. Kabal
*
*
* DATE CREATED:
*	1980/04/04
*
*
* UPDATES:
*
*
*---------------------------INRS-Telecommunications---------------------------

	SUBROUTINE GETIMG (IMAGNM, NC)


	CHARACTER*(*) IMAGNM
	CHARACTER*255 IMAGE_FILE


	INCLUDE '($JPIDEF)'


* Get the image name
	CALL LIB$GETJPI(JPI$_IMAGNAME,,,,IMAGE_FILE,NCF)
	CALL FNSCAN(IMAGE_FILE(1:NCF),'NAME',IMAGNM,NC)


	RETURN

	END
