*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     DOUBLE PRECISION FUNCTION VLGINT (XARG, AD, X, Y, N)
*
*
* Purpose:
*     Perform Lagrange interpolation
*
*
* Description:
*     This function calculates the interpolated value of a polynomial
*     using the Lagrange interpolation formula in barycentric form.
*     The interpolation formula is as follows.
*
*                  N  a(m) y(m)
*                 SUM ---------
*                 m=1  x-x(m)                   N        c
*        Val(x) = ------------- , where a(m) = PROD  --------- ,
*                    N   a(k)                  i=1   x(m)-x(i)
*                   SUM ------               (omit m)
*                   k=1 x-x(k)
*
*     This formula is equivalent to the conventional Lagrange
*     interpolation formula which can be expressed as the sum of N
*     polynomials,
*
*                  N                               a(m)  N
*        Val(x) = SUM y(m) L(m,x), where L(m,x) = ---- PROD  (x-x(i))
*                 m=1                               c   i=1
*                                                     (omit m)
*
*     The equivalence of the two forms can be demonstrated by
*     multiplying numerator and denominator of the first formulation
*     by PROD (x-x(i)).  The numerator is then in the form of the
*     conventional Lagrange interpolation formula, while the
*     denominator is the Lagrange interpolation of a constant.
*
*
* Parameters:
* D <-  VLGINT - Returned double precision function value
*
* R ->  XARG   - Argument value.  The polynomial is evaluated at this
*                point.  This value should not correspond to any of the
*                abscissa values, lest a divide by zero be encountered.
* D ->  AD     - Double precision array of Lagrange interpolation
*                coefficients
* D ->  X      - Double precision array of abscissa values
* D ->  Y      - Double precision array of function values at the
*                abscissa points
* I ->  N      - Number of elements in each of the arrays AD, X and Y
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:38:29 $
*
*
*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION VLGINT (XARG, AD, X, Y, N)


      INTEGER N
      INTEGER M

      REAL XARG

      DOUBLE PRECISION AD(N),X(N),Y(N)
      DOUBLE PRECISION C,DNUM,DDEN


      DNUM=0D0
      DDEN=0D0
      DO 100 M=1,N
        C=AD(M)/(XARG-X(M))
        DDEN=DDEN+C
        DNUM=DNUM+C*Y(M)
 100  CONTINUE
      VLGINT=DNUM/DDEN


      RETURN

      END
