*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PRTMPH (DEVS, NN, NF, FRSTP, WTSTP)
*
*
* Purpose:
*     Print Nyquist filter parameters (factored filter)
*
*
* Description:
*     This subroutine prints the specifications and approximation error
*     for each specified stopband point for a minimum phase factor of a
*     Nyquist filter.
*
*
* Parameters:
* R ->  DEVS   - Deviation corresponding to unit weight
* I ->  NN     - Zero crossing interval
* I ->  NF     - Number of stopband points
* R ->  FRSTP  - Array of normalized stopband frequencies. These values
*                must be in increasing order.
* R ->  WTSTP  - Array of desired stopband weightings
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:26:40 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PRTMPH (DEVS, NN, NF, FRSTP, WTSTP)


      INTEGER NN,NF
      INTEGER I

      REAL DEVS
      REAL DEV,DEVDB
      REAL DBV,X
      REAL FRSTP(NF),WTSTP(NF)


* Statement function to convert to decibels
      DBV(X)=20.0*LOG10(X)


* Title
      WRITE (UNIT=*,FMT=2000) 'Minimum Phase Factor of a '//
     -                        'Nyquist Filter:'
      WRITE (UNIT=*,FMT=2100) NN
      WRITE (UNIT=*,FMT=2200)

* Stopband values
      DO 120 I=1,NF

* Calculate the weighted deviation
        DEV=DEVS/WTSTP(I)
        IF (DEV.GT.0.0) THEN
          DEVDB=DBV(DEV)
        ELSE
          DEVDB=-1E20
        END IF

        WRITE (UNIT=*,FMT=2300) FRSTP(I),WTSTP(I),DEV,DEVDB

 120  CONTINUE


      RETURN

 2000 FORMAT (/1X,A)
 2100 FORMAT (' Zero Crossing Interval:',I4)
 2200 FORMAT (' Stopband:  Frequency  Weight  Deviation  Dev. dB')
 2300 FORMAT (' ',F18.4,1PG12.2,1PG9.2,0PF8.2)

      END
