*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE RDIVA1 (LINE, IVAL, IER)
*
*
* Purpose:
*     Decode an integer value
*
*
* Description:
*     This routine decodes a string containing a numeric value.  The
*     decoded datum is stored as an integer value.  If an error is
*     detected (decoding error, too few values, or too many values),
*     an error flag is set.
*
*
* Parameters:
* C ->  LINE   - Input string.  Blanks in the string are ignored.
* I <-  IVAL   - Output integer value.  This value is not set in case
*                of an error.
* I <-  IER    - Error code,
*                0 - No error
*                1 - Error
*
*
* Routines required:
*     RDIVAL - Decode integer values (variable number)
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/24 23:46:30 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE RDIVA1 (LINE, IVAL, IER)


      INTEGER IVAL,IER
      INTEGER NV
      INTEGER IVT(1)

      CHARACTER*(*) LINE


* Use RDIVAL to decode the value
      CALL RDIVAL(LINE,1,1,IVT,NV)
      IF (NV.EQ.1) THEN
        IVAL=IVT(1)
        IER=0
      ELSE
        IER=1
      END IF


      RETURN

      END
