*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE GTPSTR (STRING, CSEP, IOPT, IS1, IE1, ISEP)
*
*
* Purpose:
*     Parse a string with a separator (with white space)
*
*
* Description:
*     This routine finds the first occurrence of a separator string in
*     an input string.  A separator string occurs between substrings in
*     the original string and consists of either white space separator
*     or an ordinary  separator.  A white space separator consists
*     entirely of white space (blanks, tabs or null characters).  An
*     ordinary separator consists of a given character, optionally
*     surrounded by white space.  A white space separator cannot occur
*     at the beginning or end of the input string, while an ordinary
*     separator can occur at the beginning or end of the input string.
*
*     Optionally paired double quote characters (") or paired
*     parentheses can be used to allow white space and the separator
*     character to appear in the string without acting as separators.
*
*     The non-blank extent of the string before the separator is
*     STRING(IS1:IE1), with the possibility that the substring has a
*     zero length (IE1=IS1-1).  The last character in the separator
*     is STRING(ISEP:ISEP).  If a separator is not found, ISEP is set
*     to LEN(STRING)+1.  If a separator is found, the non-blank portion
*     of the string following the separator starts with
*     STRING(ISEP+1:ISEP+1).
*     Summarizing,
*     1 (a) non-blank string before a separator: IS1 <= IE1,
*       (b) blank string before a separator: IS1=1, IE1=0,
*     2 (a) separator: 1 <= ISEP <= LEN(STRING),
*       (b) no separator: ISEP = LEN(STRING)+1.
*
*
* Parameters:
* C ->  STRING - Input character string
* C ->  CSEP   - Separator character
* I ->  IOPT   - Integer option value.  The option value is the sum of
*                the following flags
*                0 - normal operation
*                1 - quoted strings: treat characters within paired
*                    double quote characters (") as non-separators.
*                    Parentheses within quotes are treated in the same
*                    way as ordinaray characters.
*                2 - parenthesized strings: treat characters within
*                    paired parentheses as non-separators
* I <-  IS1    - Pointer to the characters that starts the non-blank
*                portion of the input string before the first
*                separator.  IS1 will be equal to 1 in the case of no
*                non-blank characters being found in front of a
*                separator.
* I <-  IE1    - Pointer to the character that terminates the portion
*                of the input string before the first separator.
*                Normally IE1 will point to a non-blank character.
*                However, in the case of no non-blank characters being
*                found in front of the separator, IE1 will be set to
*                zero.
* I <-  ISEP   - Pointer to the character that ends the separator.  In
*                the case of a separator with trailing white space,
*                ISEP points to the last white space character in the
*                separator.  In the case of no separator being found,
*                ISEP is equal to LEN(STRING)+1.
*
*
* Routines required:
*     WARN   - Print a warning message on the standard error unit
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 00:27:21 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE GTPSTR (STRING, CSEP, IOPT, IS1, IE1, ISEP)


      INTEGER SIWS,SNBC,SWSA,SSEP,SFIN
      PARAMETER (SIWS=1,SNBC=2,SWSA=3,SSEP=4,SFIN=5)
      INTEGER WSC,SEP,OTH
      PARAMETER (WSC=1,SEP=2,OTH=3)

      INTEGER IOPT,IS1,IE1,ISEP
      INTEGER LENS,ISTATE,LEVBR,I

      CHARACTER*(*) STRING
      CHARACTER*1 CSEP
      CHARACTER*1 CH

      LOGICAL INQUOT,CHKQ,CHKP,ERRBR

      INTEGER ITRANS(OTH,SFIN-1),IPTR(SFIN)
      DATA ITRANS/SIWS,SSEP,SNBC, SWSA,SSEP,SNBC, SWSA,SSEP,SFIN,
     -            SSEP,SFIN,SFIN/


* The presence of a separator is identified using a state driven
* parser.  The next state is given by  ITRANS(char, state).  The
* position in the string of the end of a given state is given
* by IPTR(state).
* Character Description
*   WSC     White space
*   SEP     Separator
*   OTH     Other
* State   Description
*  SIWS   Initial white space
*  SNBC   Non-blank character before a separator
*  SWSA   White space after non-blank characters
*  SSEP   Separator character, or white space after a separator
*  SFIN   Finished

      LENS=LEN(STRING)
      ISTATE=SIWS
      IPTR(SIWS)=0
      IPTR(SNBC)=0
      IPTR(SWSA)=0
      IPTR(SSEP)=0
      IPTR(SFIN)=LENS+1
      INQUOT=.FALSE.
      LEVBR=0
      CHKQ=MOD(IOPT,2).EQ.1
      CHKP=MOD(IOPT/2,2).EQ.1
      ERRBR=.FALSE.

* Main loop to check each character in the string
* The search is terminated when the string is
* exhausted or the first non-blank character is
* found after a separator
      DO 100 I=1,LENS

        CH=STRING(I:I)
        IF (CHKQ .AND. CH.EQ.'"') THEN
          ISTATE=ITRANS(OTH,ISTATE)
          IF (ISTATE.NE.SFIN) INQUOT=.NOT.INQUOT
        ELSE IF (INQUOT) THEN
          ISTATE=ITRANS(OTH,ISTATE)
        ELSE IF (CHKP .AND. CH.EQ.'(') THEN
          ISTATE=ITRANS(OTH,ISTATE)
          IF (ISTATE.NE.SFIN) LEVBR=LEVBR+1
        ELSE IF (CHKP .AND. CH.EQ.')') THEN
          IF (LEVBR.EQ.0) THEN
            ERRBR=.TRUE.
          ELSE
            LEVBR=LEVBR-1
          END IF
          ISTATE=ITRANS(OTH,ISTATE)
        ELSE IF (LEVBR.GT.0) THEN
          ISTATE=ITRANS(OTH,ISTATE)
        ELSE IF (CH.EQ.' ' .OR. CH.EQ.CHAR(9) .OR.
     -      CH.EQ.CHAR(0)) THEN
          ISTATE=ITRANS(WSC,ISTATE)
        ELSE IF (CH.EQ.CSEP) THEN
          ISTATE=ITRANS(SEP,ISTATE)
        ELSE
          ISTATE=ITRANS(OTH,ISTATE)
        END IF

        IPTR(ISTATE)=I
        IF (ISTATE.GE.SFIN) GO TO 200

 100  CONTINUE

* Return the pointers
 200  CONTINUE

* Let the string be A , B
* Find the limts of A, see if passed through state SNBC
      IF (IPTR(SNBC).GT.0) THEN
        IS1=IPTR(SIWS)+1
        IE1=IPTR(SNBC)
      ELSE
        IS1=1
        IE1=IS1-1
      END IF

* Find the end of the separator
      IF (ISTATE.EQ.SSEP .OR. ISTATE.EQ.SFIN) THEN
        ISEP=IPTR(SFIN)-1
      ELSE
        ISEP=LENS+1
      END IF

* Error checks
      IF (ERRBR .OR. LEVBR.NE.0)
     -  CALL WARN('GTPSTR - Unpaired parenthesis')
      IF (INQUOT)
     -  CALL WARN('GTPSTR - Unpaired quote')


      RETURN

      END
