*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION LQUANT (X, XQ, NLEV)
*
*
* Purpose:
*     Binary search for a bounding interval
*
*
* Description:
*     This subroutine returns the index of the quantizer output region
*     corresponding to a given input value.  The quantizer is specified
*     by an array of quantizer decision levels.  A binary search is
*     used to determine the quantizer region.
*
*
* Parameters:
* I <-  LQUANT - Output index of the quantizer output region
*                corresponding to X.  LQUANT takes on values from 1 to
*                NLEV.  If NLEV is one, LQUANT is set to one.
*                Otherwise, LQUANT is determined as follows,
*                   LQUANT = 1,       x =< XQ(1)
*                   LQUANT = 2,       XQ(1) < x =< XQ(2)
*                    ...           ...
*                   LQUANT = NLEV,    XQ(NLEV-1) < x .
*
* R ->  X      - Value to be quantized
* R ->  XQ     - Input array of NLEV-1 quantizer decision levels which
*                delimit the NLEV quantizer regions.  These must be in
*                ascending order (non-decreasing order).
* I ->  NLEV   - Number of quantizer regions
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/24 23:11:38 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION LQUANT (X, XQ, NLEV)


      INTEGER NLEV
      INTEGER IL,IU,I

      REAL X
      REAL XQ(*)


* Binary search for the interval ( XQ(IL),XQ(IU) ) which brackets
* the value X.
      IL=0
      IU=NLEV

* Check if the interval has been isolated
 100  IF (IU.LE.IL+1) GO TO 200

      I=(IL+IU)/2
      IF (X.LE.XQ(I)) THEN
        IU=I
      ELSE
        IL=I
      END IF
      GO TO 100

* Return the index of the region
 200  LQUANT=IU


      RETURN

      END
