*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION IFLOOR (K, L)
*
*
* Purpose:
*     Calculate the floor function of a ratio of integers
*
*
* Description:
*     This function calculate the floor function of K/L.  It returns
*     the largest integer that is less than or equal to the quotient.
*
*
* Parameters:
* I <-  IFLOOR - Resultant value
*
* I ->  K      - Numerator integer value
* I ->  L      - Denominator integer value
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/24 20:49:58 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION IFLOOR (K, L)


      INTEGER K,L
      INTEGER LA,KA

* Find the signs of the input
* Find KA and LA, such that KA/LA=K/L and  LA is positive
      IF (L.GT.0) THEN
        LA=L
        KA=K
      ELSE
        LA=-L
        KA=-K
      END IF

* Integer division forms the correct result for positive numbers
      IF (KA.GE.0) THEN
        IFLOOR=KA/LA
      ELSE
        IFLOOR=(KA+1)/LA -1
      END IF


      RETURN

      END
