*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE RDLINE (PROMPT, LINE, NCHR, ISRC)
*
*
* Purpose:
*     Read a line of input from standard input
*
*
* Description:
*     This subroutine reads lines of input.  It first tries to
*     retrieve input from the command line invoking the program.  If
*     unsuccessful it retrieves input from the standard input.  If the
*     input is a terminal, prompt strings are printed on the terminal.
*
*     More details: For command lines, the arguments, each with
*     trailing blanks removed, are concatenated with a single blank
*     separating arguments.  For terminal input, NCHR reflects any
*     trailing blanks on the input line.  For input redirected to a
*     file, NCHR reflects the length of the non-blank portion of the
*     line.
*
*
* Parameters:
* C ->  PROMPT - Character string used as a prompt
* C <-  LINE   - Character string for the input line.  If the length of
*                line is insufficient for input line, the input line
*                is truncated.  For input lines shorter than the length
*                of line, line is padded out with blanks.
* C <-  NCHR   - Number of characters in line not including any blanks
*                used to pad out LINE.  NCHR can be zero.  NCHR is set
*                to 0 for an end-of-file.
* I <-  ISRC   - Source of the input line.
*                  1 - command line
*                  2 - standard input (terminal)
*                A negative value for ISRC indicates an end-of-file.
*                 -1 - end-of-file
*
*
* Routines required:
*     GETARG - System routine, return command line parameters
*     IARGC  - System routine, get the number of command arguments
*     LENBLK - Find the length of a blank terminated string
*     LINEIN - Read a line of input
*     WARN   - Print a warning message on the standard error unit
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.5 $  $Date: 1993/01/30 20:29:21 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE RDLINE (PROMPT, LINE, NCHR, ISRC)


      INTEGER COML,TERM
      PARAMETER (COML=1,TERM=2)

      CHARACTER*(*) PROMPT,LINE
      CHARACTER*255 ARG

      INTEGER NCHR,ISRC
      INTEGER ISRCI
      INTEGER NOARG,NC,NL,I,IEOF
      INTEGER IARGC
      INTEGER LENBLK

      SAVE ISRCI
      DATA ISRCI/0/


 100  IF (ISRCI.EQ.0) THEN

* Get the arguments from the command line
* The command line is reconstructed by concatenating the arguments,
* separated by blanks
        ISRCI=COML
        NCHR=0
        NOARG=IARGC()
        IF (NOARG.GT.0) THEN
          CALL GETARG(1,ARG)
          NC=LENBLK(ARG)
          NL=LEN(LINE)
          LINE=ARG(1:NC)
          NCHR=NC
          DO 120 I=2,NOARG
            CALL GETARG(I,ARG)
            NC=LENBLK(ARG)
            LINE=LINE(1:MIN(NCHR,NL))//' '//ARG(1:NC)
            NCHR=NCHR+1+NC
 120      CONTINUE
          IF (NCHR.GT.LEN(LINE)) THEN
            CALL WARN('RDLINE - Command line arguments truncated')
            NCHR=LEN(LINE)
          END IF

        END IF
        IF (NCHR.EQ.0) GO TO 100

      ELSE

* Get an input line from the standard input
        ISRCI=TERM
        CALL LINEIN(PROMPT,LINE,NCHR,IEOF)
        IF (IEOF.LT.0) THEN
          ISRCI=-1
          NCHR=0
        END IF

      END IF

* Return the source of the line
      ISRC=ISRCI


      RETURN

      END
