*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE LINEIN (PROMPT, LINE, NCHR, IEOF)
*
*
* Purpose:
*     Read a line of input
*
*
* Description:
*     This subroutine reads lines of input.  A prompt message is also
*     printed if the standard input (Fortran unit 5) is associated with
*     a terminal.
*
*
* Parameters:
* C ->  PROMPT - Character string used as a prompt
* C <-  LINE   - Character string for the input line.  The behaviour
*                is different for input from terminals and for input
*                for input that has been redirected to a file.  For
*                terminal input, if the length of LINE is insufficient,
*                the input line is truncated with a warning.  For input
*                from a file, the input line is truncated silently.  If
*                NCHR is less than the length of LINE, LINE is padded
*                out with blanks.
* I <-  NCHR   - Number of characters in the line.  NCHR is set to 0 on
*                reaching end-of-file.  For terminal input, NCHR is
*                set to the length of the input line, including any
*                trailing blanks.  For input redirected to a file, NCHR
*                is determined from the last non-blank character in
*                LINE.
* I <-  IEOF   - End-of-file flag,
*                 0  - Normal value
*                -1  - End-of-file
*
*
* Routines required:
*     LENBLK - Find the length of a blank terminated string
*     TTYFUN - Determine if a Fortran unit is connected to a terminal
*     WARN   - Print a warning message on the standard error unit
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.5 $  $Date: 1993/01/30 14:10:02 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE LINEIN (PROMPT, LINE, NCHR, IEOF)


      INTEGER ISTDIN
      PARAMETER (ISTDIN=5)

      INTEGER NCHR,IEOF
      INTEGER LENBLK

      CHARACTER*(*) PROMPT,LINE

      LOGICAL TTYFUN


* Write a prompt if the input is from a terminal
      IF (TTYFUN(ISTDIN)) THEN
        WRITE (UNIT=*,FMT=1000) PROMPT
        READ (UNIT=*,FMT=2000,END=200) NCHR,LINE

        IF (NCHR.GT.LEN(LINE)) THEN
          CALL WARN('LINEIN: Input line truncated')
          NCHR=LEN(LINE)
        END IF

      ELSE
* Non-terminal input
* Note:
*   With SunOS Fortran 4.1, the Q format is not valid for in-line
*   data in a script (requires seek ability).  Tt is not possible to
*   distinguish redirection to a file from redirection to in-line data
*   in a script.  For all non-terminal inputs, the read is done without
*   the Q format and the length of the line is determined by finding
*   the last non-blank character.
        READ (UNIT=*,FMT=2100,END=200) LINE
        NCHR=LENBLK(LINE)

      END IF
      IEOF=0
      GO TO 900

* End-of-file found
 200  NCHR=0
      LINE=' '
      IEOF=-1

 900  RETURN

 1000 FORMAT (A,$)
 2000 FORMAT (Q,A)
 2100 FORMAT (A)

      END
