*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DREV (X, Y, N)
*
*
* Purpose:
*     Reverse the order of a DOUBLE PRECISION array
*
*
* Description:
*     This routine reverses the order of a double precision vector.
*
*       Y(i) = X(N-i+1)  for i from 1 to N.
*
*
* Parameters:
* D ->  X      - Input double precision vector
* D <-  Y      - Output double precision vector (the output vector may
*                be the same as the input vector)
* D ->  N      - Number of elements in each of X and Y.  N may be zero.
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.4 $  $Date: 1993/01/24 18:49:59 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DREV (X, Y, N)


      INTEGER N
      INTEGER K,I

      DOUBLE PRECISION X(*),Y(*)
      DOUBLE PRECISION TEMP


      K=N
      DO 100 I=1,N/2
        TEMP=X(K)
        Y(K)=X(I)
        Y(I)=TEMP
        K=K-1
 100  CONTINUE
      IF (K.NE.N/2) Y(K)=X(K)


      RETURN

      END
